/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: idb.h,v 1.1.1.1 2005/11/04 07:19:34 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _IDB_H
#define _IDB_H

#include <db.h>

#include "idbdata.h"

typedef struct {
  DB_ENV *dbenv;
  DB *pdb;
  DB *sdb;
} idb_t;

typedef int (*idb_traverse_callback_t)(idb_data_t *);
typedef int (*idb_modify_callback_t)(idb_data_t *);

void idb_set_errfunc(void (*func)(int, char *, ...));
int idb_close(idb_t *idb);
int idb_open(idb_t *idb, char *progname, char *dbhome, char *dbname,
	     char *mode, int perm);
int idb_get(idb_t *idb, idb_data_t *d, unsigned int ip);
int idb_put(idb_t *idb, idb_data_t *d);
int idb_del(idb_t *idb, unsigned int ip);
int idb_modify(idb_t *idb, idb_data_t *d, unsigned int ip,
	       idb_modify_callback_t callback);
int idb_expire(idb_t *idb, unsigned int t);
int idb_traverse(idb_t *idb, idb_traverse_callback_t callback);

#endif
