#ifndef __vsprintf_h
#define __vsprintf_h

#include <stdarg.h>

extern "C" {
int snprintf (char *str, size_t count, const char *fmt, ...);
int vsnprintf (char *str, size_t count, const char *fmt, va_list arg);
}

#ifdef NO_VSPRINTF
#define VSPRINTF(buf, size, fmt, arg) vsprintf((buf),(fmt),(arg))
#else
#define VSPRINTF(buf, size, fmt, arg) vsnprintf((buf),(size),(fmt),(args))
#endif

#endif
