#ifndef __debug_h
#define __debug_h

#include <fstream>
#include <string>
using namespace std;

#define LOG_FILE "sms.log"
#define MAX_LOG_LINE_LEN 32768

#define LOG_INFO 1
#define LOG_WARN 2

class Debug
{
      ofstream str;
      string name;

      void Open();
public:
      Debug(const string &file) : name(file) {};

      void Log(int level, const char *msg, ...);
};

class Exception
{
      string what;
public:
      Exception(const string &str) : what(str) {};
      const string &Info() const { return what; };
};

#endif
