#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "debug.h"
#include "vsprintf.h"

Debug::Debug(const char *file)
{
     name = strdup(file);
     str = NULL;
}

Debug::~Debug()
{
     if (str) delete str;
     if (name) free(name);
}

void Debug::Open()
{
#ifdef DEBUG
     if (!str) str = new ofstream(name);
#endif
}

void Debug::Log(int level, const char *msg, ...)
{
    if (!str) Open();
    if (!str) return;
    
    char buf[MAX_LOG_LINE_LEN];
    va_list args;
    ofstream &stream = *str;

    va_start(args, msg);
    VSPRINTF(buf, sizeof(buf)-1, msg, args);
    va_end(args);

    stream << buf << endl;
}

Exception::Exception(const char *str)
{
        what = strdup(str);
}

Exception::~Exception()
{
        if (what) free(what);
}

const char *Exception::Info()
{
        return what;
}
