#ifndef __SMBITEM_H__
#define __SMBITEM_H__

#include <time.h>
#include "list.h"
#include "buffer.h"
#include "array.h"

#define USERPATH	0x01
#define AUTOPATH	0x02

typedef enum{
    SMBITEM_LINK,
    SMBITEM_COMP,
    SMBITEM_GROUP
} smbitem_type;

typedef enum{
    PATH_UNKNOWN,
    SMBNETFS_DIR,
    SMBNETFS_LINK,
    SMBNAME,
    SMBSHARE,
    SMBFILE
} file_type;

typedef struct{
    char	  reserved[sizeof(LIST)];
    int		  ref_count;	// the number of item references
    time_t	  change_time;	// item modification time
    smbitem_type  type;		// item type: comp/link/group
    hstring	  name;		// pointer to item name and its hash
    hstring	  link;		// pointer to link and its hash
    char	  data[0];	// internal data
} smbitem;

extern BUFFERMANAGER   ConvertBuffer;

int    isTimeForRescanSambaTree(time_t time);
int    SetSmbItemUpdateInterval(int interval);
int    SetSmbItemTime2Live(int ttl);
int    SetQueryBrowserFlag(int flag);
int    GetQueryBrowserFlag(void);

int  mkgroup(const char *path, int flag);
int  mkhost(const char *path, int flag);
int  mklink(const char *path, const char *link, int flag);

int  getdir(ARRAY *array, const char *path, int flag);
void DeleteSmbItemArray(ARRAY *array);
void RequestSmbItem(smbitem *item);
void ReleaseSmbItem(smbitem* item);
void DeleteOldSmbItem(time_t change_time, int flag);
void UpdateSambaTree(void);

file_type GetPathType(const char *path, BUFFER *buf);

#endif /* __SMBITEM_H__ */
