/***************************************************************************
    smb4ksystemtray.cpp - The widget that handles the docking
              to the system tray.
                             -------------------
    begin                : Mon Jan 12 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2004 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qiconset.h>
#include <qvaluelist.h>
#include <qtooltip.h>
 
// KDE includes
#include <kactionclasses.h> 
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kaction.h>
 
// application specific includes
#include "smb4ksystemtray.h"
#include "../smb4k.h"
#include "smb4kbookmarkmenuwidget.h"
#include "../core/smb4kshare.h"

Smb4KSystemTray::Smb4KSystemTray( bool dock_now, QWidget *parent, const char *name )
: KSystemTray( parent, name ), m_docked( false )
{
  setPixmap( loadIcon( "smb4k" ) );
  setupContextMenu();
  
  QToolTip::add( this, sapp->caption() );
  
  if ( dock_now )
    dock();

  connect( this,                    SIGNAL( quitSelected() ),   sapp, SLOT( slotQuit() ) );
  connect( sapp->core()->mounter(), SIGNAL( importedShares() ), this, SLOT( slotUpdatedShareList() ) );
  connect( m_shares->popupMenu(),   SIGNAL( activated( int ) ), this, SLOT( slotActivated( int ) ) );
}


Smb4KSystemTray::~Smb4KSystemTray()
{
}


void Smb4KSystemTray::setupContextMenu()
{
  m_shares = new KActionMenu( this, "SystemTrayShares" );
  contextMenu()->insertItem( QIconSet( SmallIcon( "hdd_unmount" ), QIconSet::Automatic ), i18n( "Mounted &Shares" ), m_shares->popupMenu() );
  
  Smb4KBookmarkMenuWidget *bookmarks = new Smb4KBookmarkMenuWidget( Smb4KBookmarkMenuWidget::Tray, this, "SystemTrayBookmarks" );
  contextMenu()->insertItem( QIconSet( SmallIcon( "folder_green" ), QIconSet::Automatic ), i18n( "Bookmarks" ), bookmarks->popupMenu() );
  
  sapp->actionCollection()->action( "shares_manual_mount" )->plug( contextMenu() );
  contextMenu()->insertSeparator();
  sapp->actionCollection()->action( "configure_smb4k" )->plug( contextMenu() );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSystemTray::dock()
{
  if ( !m_docked )
  {
    m_docked = true;
    this->show();
  }
}


void Smb4KSystemTray::undock()
{
  if ( m_docked )
  {
    m_docked = false;
    this->hide();
  }
}


void Smb4KSystemTray::slotUpdatedShareList()
{
  KActionPtrList list = sapp->actionCollection()->actions( "MountedShares" );
  QStringList shareNames;
  
  // Sorting problems with the action list. Thus:
  for ( KActionPtrList::ConstIterator it = list.begin(); it != list.end(); ++it )
  {
    shareNames.append( (*it)->text().stripWhiteSpace() );
  }
  
  shareNames.sort();
  
  if ( m_shares->popupMenu()->count() == 0 )
  {
    for ( QStringList::ConstIterator it = shareNames.begin(); it != shareNames.end(); ++it )
    {
      m_shares->insert( sapp->actionCollection()->action( *it ) );
    }
  }
  else
  {
    uint index = 0;
    
    for ( QStringList::ConstIterator it = shareNames.begin(); it != shareNames.end(); ++it )
    {
      for ( KActionPtrList::ConstIterator i = list.begin(); i != list.end(); ++i )
      {
        if ( *it == (*i)->text().stripWhiteSpace() )
        {
          QString itemText = m_shares->popupMenu()->text( m_shares->popupMenu()->idAt( index ) ).stripWhiteSpace();
          
          if ( itemText != *it )
          {
            m_shares->insert( *i, index );
          }
          
          index++;
        }
      }
    }
    
    if ( index < m_shares->popupMenu()->count() )
    {
      while ( index < m_shares->popupMenu()->count() )
      {
        m_shares->popupMenu()->removeItemAt( index );
      }
    }
  }
}


void Smb4KSystemTray::slotActivated( int id )
{
  QString name = m_shares->popupMenu()->text( id ).stripWhiteSpace();
  Smb4KShare *s = sapp->core()->mounter()->findShareByName( name );
  
  sapp->core()->open( s );
}

#include "smb4ksystemtray.moc"
