#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmallEiffel The GNU Eiffel Compiler
Release -0.74 Beta #18 (??? February ??th 2002)
Copyright (C), 1994-2002 - LORIA - UHP - INRIA - FRANCE
Dominique COLNET and Suzanne COLLIN - SmallEiffel@loria.fr
http://SmallEiffel.loria.fr
C Compiler options used: -pipe
*/
#ifdef __cplusplus
}
#endif
#include "install.h"
#ifdef __cplusplus
extern "C" {
#endif
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmallEiffel@loria.fr
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/base.c) is included for _all_ modes of
  compilation (-boost, -no_check, ... -all_check, -debug_check).
*/

/*
  The wrapper for `malloc' (generated C code is supposed to use
  only `se_malloc' instead of direct `malloc').
*/
void* se_malloc(size_t size) {
  void *result = malloc(size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif SE_NO_CHECK
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}

/*
  The wrapper for `calloc' (generated C code is supposed to use
  only `se_calloc' instead of direct `calloc').
*/
void* se_calloc(size_t nmemb, size_t size) {
  void *result = calloc(nmemb,size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif SE_NO_CHECK
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}

int se_cmpT38(T38 o1,T38 o2){
return memcmp(&o1,&o2,sizeof(o1));}
T47 M47=0;
T49 M49=0;
T30 M30={0,0};
T54 M54={NULL,NULL};
T16 M16={0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,{NULL,NULL},NULL};
T36 M36=0;
T51 M51={51,NULL,0,0};
T35 M35={0};
T39 M39={0,NULL,NULL,0};
T37 M37={NULL,NULL,NULL,0,{NULL,NULL},NULL};
T7 M7={NULL,0,0};
T38 M38={NULL,NULL};
T48 M48={NULL,0,{NULL,NULL},NULL};
T44 M44={44,NULL,0,0,0};
T58 M58=NULL;
T53 M53={NULL,NULL};
T33 M33=NULL;
T46 M46=NULL;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmallEiffel@loria.fr
--                       http://SmallEiffel.loria.fr
--
*/

/*
  This file (SmallEiffel/sys/runtime/boost.c) is automatically included when
  `run_control.boost' is true (ie. only for mode -boost).
*/

void se_print_run_time_stack (void) {
  fprintf(SE_ERR,"Eiffel program crash at run time.\n");
  fprintf(SE_ERR,"No trace when using option \"-boost\"\n");
}

void se_signal_handler(int sig) {
  printf("Received signal %d (man signal).\n",sig);
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
}
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmallEiffel@loria.fr
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/basic_directory.c) is automatically
  included when some external "SmallEiffel" feature of class BASIC_DIRECTORY
  is live.
*/

#ifdef WIN32
#define SIMULATED_MODE
/* The simulated mode for WIN32.
*/
typedef struct _SIMULATED_DIR {
  HANDLE handle;
  WIN32_FIND_DATA data;
  int entry_used;
} SIMULATED_DIR;

static SIMULATED_DIR* simulated_opendir(char* path) {
  int len = strlen((char*)path);
  char* pattern = se_malloc(len + 5);
  SIMULATED_DIR* result = se_malloc(sizeof(SIMULATED_DIR));

  pattern = strcpy(pattern,(char*)path);
  if (pattern[len - 1] != '\\') pattern[len++] = '\\';
  pattern[len++] = '*';
  pattern[len++] = '.';
  pattern[len++] = '*';
  pattern[len++] = 0;
  result->handle = FindFirstFile(pattern,&(result->data));
  if (result->handle == INVALID_HANDLE_VALUE) {
    free(pattern);
    free(result);
    return NULL;
  }
  result->entry_used = 0;
  return result;
}

static void* simulated_readdir(SIMULATED_DIR* dirstream) {
  if (dirstream->entry_used) {
    if (FindNextFile(dirstream->handle,&(dirstream->data))) {
      dirstream->entry_used = 1;
      return dirstream;
    }
    else {
      return NULL;
    }
  }
  else {
    dirstream->entry_used = 1;
    return dirstream;
  }
}

#define simulated_get_entry_name(x) ((x)->data.cFileName)

static int simulated_closedir(SIMULATED_DIR* dirstream) {
  FindClose(dirstream->handle);
  free(dirstream);
  return 0;
}


/* GCC(MingW32) doesn't need these prototypes; whereas, LCC needs them. */
char * getcwd(char* buffer, int maxlen);
int chdir(const char* buffer);
int mkdir(const char* directory_path);
int rmdir(const char* directory_path);


#define simulated_getcwd(x, y) getcwd(x, y)
#define simulated_chdir(x) chdir(x)
#define simulated_rmdir(x) rmdir(x)

int simulated_mkdir(const char* directory_path, int perm) {

  mkdir(directory_path);
  return 0;
}

#endif  /* WIN32 */

#ifdef AMIGA
#define SIMULATED_MODE
/* The simulated mode for AmigaOS 2.04+
   Author: Thomas Aglassinger <agi@rieska.oulu.fi>

   Normally this shouldn't be necessary as all compilers include a
   simulation of the Un*x directory API. However, they differ in
   certain details, often resulting into compiler errors. Thus a
   implementation using native AmigaDOS calls seems preferable.

   Note that many of the happenings below have to deal with the
   various idiosyncracies of the "dos.library", which are not all
   documented clearly in the Autodocs. The biggest surprises should
   be reflected in comments. But consider reading chapter 17 of
   Ralph Babel's "Amiga Guru Book" before changing anything.
*/
#include <exec/types.h>
#include <dos/dos.h>
#include <dos/dostags.h>

#include <proto/exec.h>
#include <proto/dos.h>

typedef struct _SIMULATED_DIR {
  struct FileInfoBlock *info;
  BPTR lock;
} SIMULATED_DIR;


/* Release all resources allocated during `simulated_opendir'; also
   works correctly if structure was only partially initialized.
*/
static void free_simulated_dir(SIMULATED_DIR * dir) {
  if (dir != NULL) {
    if (dir->lock != NULL) {
      UnLock(dir->lock);
    }
    if (dir->info != NULL) {
      FreeDosObject(DOS_FIB, dir->info);
    }
    free(dir);
  }
}

static SIMULATED_DIR * simulated_opendir(char *path) {
  BOOL ok = FALSE;
  SIMULATED_DIR *result = se_malloc(sizeof(SIMULATED_DIR));

  if (result != NULL) {
    result->lock = NULL;
    result->info = (struct FileInfoBlock *) AllocDosObject(DOS_FIB, NULL);
    if (result->info != NULL) {
      result->lock = Lock(path, ACCESS_READ);
      if (result->lock != NULL) {
	ok = (Examine(result->lock, result->info) != DOSFALSE);
	if (ok) {
	  /* Ensure we are scanning a directory, not a file */
	  ok = (result->info->fib_DirEntryType >= 0)
	    && (result->info->fib_DirEntryType != ST_SOFTLINK);
	}
      }
    }
  }
  if (!ok) {
    free_simulated_dir(result);
    result = NULL;
  }
  return result;
}

static void * simulated_readdir(SIMULATED_DIR * dirstream) {
  BOOL ok;
  SIMULATED_DIR *result = NULL;

  ok = (ExNext(dirstream->lock, dirstream->info) != DOSFALSE);

  if (ok) {
    result = dirstream;
  }
  return (void *) result;
}

#define simulated_get_entry_name(entry) ((entry)->info->fib_FileName)

static int simulated_closedir(SIMULATED_DIR * dirstream) {
  free_simulated_dir(dirstream);
  return 0;
}


static EIF_POINTER simulated_getcwd(char *buffer, size_t maximum_length) {
     EIF_POINTER result = NULL;
     BPTR lock = Lock("", ACCESS_READ);
     if (lock != NULL) {
       if (NameFromLock(lock, buffer, maximum_length) != DOSFALSE) {
         result = (EIF_POINTER) buffer;
       }
       UnLock(lock);
     }
     return result;
   }

static int simulated_chdir(char *name) {
  int result = -1;
  BPTR lock = Lock(name, ACCESS_READ);
  if (lock != NULL) {
    /* Change the current working directory (CWD) of the task
     */
    BPTR old_lock = CurrentDir(lock);

    /* Attempt to update internal buffer of the process.
       If we are not running in a process, but a plain task, this
       call does not cause any harm.
    */
    /* FIXME: What's the result of SetCurrentDirName() in a plain
       task? If it is FALSE, the below code won't work.
    */
    if (SetCurrentDirName(name)) {
      /* If this was successful, unlock `old_lock' because we
	 are not going to restore it later; this routine is one
	 of the few cases where such behavior is appropriate.
      */
      UnLock(old_lock);
      result = 0;
    }
    else {
      /* If it fails, restore the previous CWD and make the
	 whole routine fail.
      */
      CurrentDir(old_lock);
    }
  }
  return result;
}

static void strip_trailing_slash(char *path, size_t *length,
				 BOOL * stripped) {
  /* Used in `simulated_mkdir' and `simulated_rmdir' to temporarily
     blank out a possible traling slash (/) in the directory path.
     `restore_trailing_slash' puts it back in place afterwards.
  */
  *length = strlen(path);
  if ((*length > 0) && (path[*length - 1] == '/')) {
    *stripped = TRUE;
    path[*length - 1] = '\0';
  } else {
    *stripped = FALSE;
  }
}

static void restore_trailing_slash(char *path, size_t *length,
				   BOOL * stripped) {
  if (*stripped) {
    path[*length - 1] = '/';
  }
}

static int simulated_mkdir(char *directory_path, int permission) {
  BPTR lock;
  int result = -1;
  size_t path_length;
  BOOL slash_stripped;

  strip_trailing_slash(directory_path, &path_length, &slash_stripped);
  lock = CreateDir(directory_path);
  if (lock != NULL) {
    UnLock(lock);
    result = 0;
  }
  restore_trailing_slash(directory_path, &path_length, &slash_stripped);
  return result;
}

static int simulated_rmdir(char *directory_path) {
  int result = -1;
  size_t path_length;
  BOOL slash_stripped;

  strip_trailing_slash(directory_path, &path_length, &slash_stripped);
  if (DeleteFile(directory_path)) {
    result = 0;
  }
  restore_trailing_slash(directory_path, &path_length, &slash_stripped);
  return result;
}
#endif /* AMIGA */

/*--------------------------------------------------------------------
  At his point, either this is a Linux/POSIX platform or some
  SIMULATED_MODE is defined. Unsupported platform should add their own
  SIMULATED_MODE before.
*/

EIF_POINTER basic_directory_open(EIF_POINTER path) {
  /*
     This is the implementation of the Eiffel external feature
     `basic_directory_open' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
#ifndef SIMULATED_MODE
  return (opendir(((char*) path)));
#else
  return (simulated_opendir(((char*) path)));
#endif
}

EIF_POINTER basic_directory_read_entry(EIF_POINTER dirstream) {
  /*
     This is the implementation of the Eiffel external feature
     `basic_directory_read_entry' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
#ifndef SIMULATED_MODE
  return readdir((DIR*)dirstream);
#else
  return simulated_readdir((SIMULATED_DIR*)dirstream);
#endif
}

EIF_POINTER basic_directory_get_entry_name(EIF_POINTER entry) {
  /*
     This is the implementation of the Eiffel external feature
     `basic_directory_get_entry_name' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
#ifndef SIMULATED_MODE
  return (((struct dirent*)entry)->d_name);
#else
  return simulated_get_entry_name((SIMULATED_DIR*)entry);
#endif
}

EIF_BOOLEAN basic_directory_close(EIF_POINTER dirstream) {
  /*
     This is the implementation of the Eiffel external feature
     `basic_directory_close' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  int status;
#ifndef SIMULATED_MODE
  status = (closedir((DIR*)dirstream) == 0);
#else
  status = (simulated_closedir((SIMULATED_DIR*)dirstream) == 0);
#endif
  return ((EIF_BOOLEAN)(status ? 1 : 0));
}

EIF_POINTER basic_directory_cwd(void) {
  /*
     This is the implementation of the Eiffel external feature
     `basic_directory_current_working_directory' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  static char* buf = NULL;
#ifdef WIN32
  /* MS Windows requires size to be an int; whereas in non-windows systems,
     it needs to be size_t
  */
  static int size = 0;
#else
  static size_t size = 0;
#endif
  int status;
  if (buf == NULL) {
    size = 256;
    buf = (char*)se_malloc(size);
  }


#ifndef SIMULATED_MODE
  status = (getcwd(buf,size) != NULL);
#else
  status = (simulated_getcwd(buf,size) != NULL);
#endif


  if (status) {
    return buf;
  }
  else {
    free(buf);
    size = size * 2;
    buf = (char*)se_malloc(size);
    return basic_directory_cwd();
  }
}

EIF_BOOLEAN basic_directory_chdir(EIF_POINTER destination) {
  /*
     This is the implementation of the Eiffel external feature
     `basic_directory_chdir' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  int status;
#ifndef SIMULATED_MODE
  status = (chdir((char*)destination));
#else
  status = simulated_chdir((char*)destination);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

EIF_BOOLEAN basic_directory_mkdir(EIF_POINTER directory_path){
  /*
     This is the implementation of the Eiffel external feature
     `basic_directory_mkdir' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  int status;
#ifndef SIMULATED_MODE
  status = (mkdir((char*)directory_path,0777));
#else
  status = simulated_mkdir((char*)directory_path,0777);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

EIF_BOOLEAN basic_directory_rmdir(EIF_POINTER directory_path){
  /*
     This is the implementation of the Eiffel external feature
     `basic_directory_rmdir' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  int status;
#ifndef SIMULATED_MODE
  status = rmdir((char*)directory_path);
#else
  status = simulated_rmdir((char*)directory_path);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}


T6 r8is_null(T8 C){
T6 R=0;
R=!((NULL!=C));
return R;
}

T6 r6_ix_not(T6 C){
T6 R=0;
/*[IF*/
if(C){
}
else{
R=1;
}
/*FI]*/
return R;
}

T6 r3_px_6061(T3 C,T3 a1){
T6 R=0;
R=(T3code(C))<=(T3code(a1));
return R;
}

T6 r3is_separator(T3 C){
T6 R=0;
/*[INSPECT*/
{int z1=C;
switch(z1){
case 0:
case 9:
case 10:
case 12:
case 13:
case 32:
R=1;
break;
}
}/*INSPECT]*/
return R;
}

T6 r3is_decimal_digit(T3 C){
T6 R=0;
/*[IF*/
if((((unsigned)(C))>=((unsigned)(((T3)'0'))))){
R=(((unsigned)(C))<=((unsigned)(((T3)'9'))));
}
/*FI]*/
return R;
}

T6 r3_px_6261(T3 C,T3 a1){
T6 R=0;
R=(T3code(C))>=(T3code(a1));
return R;
}

T6 r3same_as(T3 C,T3 a1){
T6 R=0;
/*[IF*/
if((C)==(a1)){
R=1;
}
else{
/*[INSPECT*/
{int z1=T3code(C);
switch(z1){
case 65:
case 66:
case 67:
case 68:
case 69:
case 70:
case 71:
case 72:
case 73:
case 74:
case 75:
case 76:
case 77:
case 78:
case 79:
case 80:
case 81:
case 82:
case 83:
case 84:
case 85:
case 86:
case 87:
case 88:
case 89:
case 90:
R=(T3code(C))==((T3code(a1))-(32));
break;
case 97:
case 98:
case 99:
case 100:
case 101:
case 102:
case 103:
case 104:
case 105:
case 106:
case 107:
case 108:
case 109:
case 110:
case 111:
case 112:
case 113:
case 114:
case 115:
case 116:
case 117:
case 118:
case 119:
case 120:
case 121:
case 122:
R=(T3code(C))==((T3code(a1))+(32));
break;
}
}/*INSPECT]*/
}
/*FI]*/
return R;
}

T3 r3to_upper(T3 C){
T3 R=0;
/*[IF*/
if((T3code(C))<(97)){
R=C;
}
 else if((T3code(C))>(122)){
R=C;
}
else{
R=((T3)((T3code(C))-(32)));
}
/*FI]*/
return R;
}

T3 r3to_lower(T3 C){
T3 R=0;
/*[IF*/
if((T3code(C))<(65)){
R=C;
}
 else if((T3code(C))>(90)){
R=C;
}
else{
R=((T3)((T3code(C))+(32)));
}
/*FI]*/
return R;
}

T6 r2in_range(T2 C,T2 a1,T2 a2){
T6 R=0;
R=((C)>=(a1))&&((C)<=(a2));
return R;
}

T2 r2min(T2 C,T2 a1){
T2 R=0;
/*[IF*/
if((C)<=(a1)){
R=C;
}
else{
R=a1;
}
/*FI]*/
return R;
}

T3 r2digit(T2 C){
T3 R=0;
R=((T3)((C)+(T3code(((T3)'0')))));
return R;
}

void r2append_in(T2 C,T0* a1){
T2 _val=0;
T2 _i=0;
/*[IF*/
if((C)==(0)){
r7extend(((T7*)a1),((T3)'0'));
}
else{
/*[IF*/
if((C)>(0)){
_i=((/*RF2*/(((T7*)a1))->_count/*4*/))+(1);
_val=C;
while (!((_val)==(0)))
{
r7extend(((T7*)a1),r2digit((_val)%(10)));
_val=(_val)/(10);
}
}
else{
r7extend(((T7*)a1),((T3)'\55'));
_i=((/*RF2*/(((T7*)a1))->_count/*4*/))+(1);
_val=C;
while (!((_val)==(0)))
{
r7extend(((T7*)a1),r2digit(-((_val)%(10))));
_val=(_val)/(10);
}
}
/*FI]*/
_val=(/*RF2*/(((T7*)a1))->_count/*4*/);
while (!((_i)>=(_val)))
{
r7swap(((T7*)a1),_i,_val);
_val=(_val)-(1);
_i=(_i)+(1);
}
}
/*FI]*/
}

T6 r45safe_equal(T0* a1,T0* a2){
T6 R=0;
/*[IF*/
/*AF*//*AF*/if((a1)==((void*)(a2))){
R=1;
}
 else if(((a1)==((void*)(NULL)))||((a2)==((void*)(NULL)))){
}
 else if(((T0*)(t[7]))==((void*)((T0*)(t[7])))){
R=r7is_equal(((T7*)a1),a2);
}
/*FI]*/
return R;
}

T45 r45realloc(T45 C,T2 a1,T2 a2){
T45 R=NULL;
R=((T45)(se_calloc(a2,sizeof(T0*))));
r45copy_from(R,C,(a1)-(1));
return R;
}

T2 r45index_of(T45 C,T0* a1,T2 a2){
T2 R=0;
while (!(((R)>(a2))||(r45safe_equal(a1,(C)[R]))))
{
R=(R)+(1);
}
return R;
}

void r45clear(T45 C,T2 a1,T2 a2){
T0* _v=NULL;
T2 _i=0;
_i=a1;
while (!((_i)>(a2)))
{
(C)[_i]=(_v);
_i=(_i)+(1);
}
}

void r45copy_from(T45 C,T45 a1,T2 a2){
T2 _i=0;
_i=a2;
while (!((_i)<(0)))
{
(C)[_i]=((a1)[_i]);
_i=(_i)-(1);
}
}

void r9copy_slice(T9 C,T2 a1,T9 a2,T2 a3,T2 a4){
T2 _i1=0;
T2 _i2=0;
_i1=a1;
_i2=a3;
while (!((_i2)>(a4)))
{
(C)[_i1]=((a2)[_i2]);
_i2=(_i2)+(1);
_i1=(_i1)+(1);
}
}

T9 r9realloc(T9 C,T2 a1,T2 a2){
T9 R=NULL;
R=((T9)(se_calloc(a2,sizeof(T3))));
r9copy_from(R,C,(a1)-(1));
return R;
}

T6 r9fast_memcmp(T9 C,T9 a1,T2 a2){
T6 R=0;
T2 _i=0;
_i=(a2)-(1);
while (!(((_i)<(0))||(((C)[_i])!=((a1)[_i]))))
{
_i=(_i)-(1);
}
R=(_i)<(0);
return R;
}

T6 r9fast_has(T9 C,T3 a1,T2 a2){
T6 R=0;
T2 _i=0;
_i=a2;
while (!(((_i)<(0))||((a1)==((C)[_i]))))
{
_i=(_i)-(1);
}
R=(_i)>=(0);
return R;
}

void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3){
T2 _at_idx=0;
T2 _src_idx=0;
_src_idx=(a3)-(1);
_at_idx=(a1)+(_src_idx);
while (!((_src_idx)<(0)))
{
(C)[_at_idx]=((a2)[_src_idx]);
_src_idx=(_src_idx)-(1);
_at_idx=(_at_idx)-(1);
}
}

void r9copy_from(T9 C,T9 a1,T2 a2){
T2 _i=0;
_i=a2;
while (!((_i)<(0)))
{
(C)[_i]=((a1)[_i]);
_i=(_i)-(1);
}
}

T2 r7first_index_of(T7* C,T3 a1){
T2 R=0;
R=r7index_of(C,a1,1);
return R;
}

void r7copy(T7* C,T0* a1){
T2 _c=0;
_c=(/*RF2*/(((T7*)a1))->_count/*4*/);
/*[IF*/
if((_c)>(0)){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(_c)){
(/*SFN*/C->_storage/*0*/)=((T9)(se_calloc(_c,sizeof(T3))));
(/*SFN*/C->_capacity/*8*/)=_c;
}
/*FI]*/
r9copy_from((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),(_c)-(1));
}
/*FI]*/
(/*SFN*/C->_count/*4*/)=_c;
}

T0* r7substring(T7* C,T2 a1,T2 a2){
T0* R=NULL;
T2 _c=0;
_c=((a2)-(a1))+(1);
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
r7make(n,_c);
R=((T0*)n);
}
/*[IRF3.3set_count*/((((T7*)(((T7*)R))))->_count/*4*/)=(_c);
/*]*/
r9copy_slice((/*RF2*/(((T7*)R))->_storage/*0*/),0,(/*RF2*/(C)->_storage/*0*/),(a1)-(1),(a2)-(1));
return R;
}

void r7remove_first(T7* C,T2 a1){
/*[IF*/
if((a1)>((/*RF2*/(C)->_count/*4*/))){
(/*SFN*/C->_count/*4*/)=0;
}
else{
/*[IF*/
if((a1)>(0)){
r7remove_between(C,1,a1);
}
/*FI]*/
}
/*FI]*/
}

T3 r7last(T7* C){
T3 R=0;
R=((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(1)];
return R;
}

void r7remove_between(T7* C,T2 a1,T2 a2){
T2 _i=0;
T2 _len=0;
_len=((a2)-(a1))+(1);
/*[IF*/
if((_len)>(0)){
_i=(a2)+(1);
while (!((_i)>((/*RF2*/(C)->_count/*4*/))))
{
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[((_i)-(_len))-(1)]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/);
/*]*/
_i=(_i)+(1);
}
(/*SFN*/C->_count/*4*/)=((/*RF2*/(C)->_count/*4*/))-(_len);
}
/*FI]*/
}

T6 r7is_equal(T7* C,T0* a1){
T6 R=0;
/*[IF*/
if(((/*RF2*/(C)->_count/*4*/))==((/*RF2*/(((T7*)a1))->_count/*4*/))){
R=r9fast_memcmp((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),(/*RF2*/(C)->_count/*4*/));
}
/*FI]*/
return R;
}
T0*oBC7string_buffer=NULL;
T0*oBC7split_buffer=NULL;

T0* r7split(T7* C){
T0* R=NULL;
/*[IF*/
if(((/*RF2*/(C)->_count/*4*/))>(0)){
r44clear((T44*)(oBC7split_buffer));
r7split_in(C,oBC7split_buffer);
/*[IF*/
if(!(r44is_empty((T44*)(oBC7split_buffer)))){
R=r44twin((T44*)(oBC7split_buffer));
}
/*FI]*/
}
/*FI]*/
return R;
}

void r7append(T7* C,T0* a1){
T2 _s_count=0;
T2 _needed_capacity=0;
T2 _new_capacity=0;
_s_count=(/*RF2*/(((T7*)a1))->_count/*4*/);
_needed_capacity=((/*RF2*/(C)->_count/*4*/))+(_s_count);
/*[IF*/
if((_needed_capacity)>((/*RF2*/(C)->_capacity/*8*/))){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
(/*SFN*/C->_storage/*0*/)=((T9)(se_calloc(_needed_capacity,sizeof(T3))));
(/*SFN*/C->_capacity/*8*/)=_needed_capacity;
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
/*[IF*/
if((_needed_capacity)>(_new_capacity)){
(/*SFN*/C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_needed_capacity);
(/*SFN*/C->_capacity/*8*/)=_needed_capacity;
}
else{
(/*SFN*/C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
r9copy_at((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_count/*4*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),_s_count);
(/*SFN*/C->_count/*4*/)=_needed_capacity;
}

T6 r7has_substring(T7* C,T0* a1){
T6 R=0;
R=(r7substring_index(C,a1,1))!=(0);
return R;
}

T2 r7index_of(T7* C,T3 a1,T2 a2){
T2 R=0;
R=a2;
while (!(((R)>((/*RF2*/(C)->_count/*4*/)))||((a1)==(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(R)-(1)]/*)*/))))
{
R=(R)+(1);
}
/*[IF*/
if((R)>((/*RF2*/(C)->_count/*4*/))){
R=0;
}
/*FI]*/
return R;
}

T6 r7has_suffix(T7* C,T0* a1){
T6 R=0;
T2 _i1=0;
T2 _i2=0;
/*[IF*/
if(((/*RF2*/(((T7*)a1))->_count/*4*/))<=((/*RF2*/(C)->_count/*4*/))){
_i1=(((/*RF2*/(C)->_count/*4*/))-((/*RF2*/(((T7*)a1))->_count/*4*/)))+(1);
_i2=1;
while (!((((_i1)>((/*RF2*/(C)->_count/*4*/)))||((_i2)>((/*RF2*/(((T7*)a1))->_count/*4*/))))||((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i1)-(1)]/*)*/)!=(/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i2)-(1)]/*)*/))))
{
_i1=(_i1)+(1);
_i2=(_i2)+(1);
}
R=(_i1)>((/*RF2*/(C)->_count/*4*/));
}
/*FI]*/
return R;
}

void r7make(T7* C,T2 a1){
/*[IF*/
if((a1)>(0)){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(a1)){
(/*SFN*/C->_storage/*0*/)=((T9)(se_calloc(a1,sizeof(T3))));
(/*SFN*/C->_capacity/*8*/)=a1;
}
/*FI]*/
}
/*FI]*/
(/*SFN*/C->_count/*4*/)=0;
}

T6 r7has_prefix(T7* C,T0* a1){
T6 R=0;
T2 _i=0;
/*[IF*/
if(((/*RF2*/(((T7*)a1))->_count/*4*/))<=((/*RF2*/(C)->_count/*4*/))){
_i=(/*RF2*/(((T7*)a1))->_count/*4*/);
while (!(((_i)==(0))||((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/)!=(/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/))))
{
_i=(_i)-(1);
}
R=(_i)==(0);
}
/*FI]*/
return R;
}

T0* r7_px_43(T7* C,T0* a1){
T0* R=NULL;
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
r7make(n,((/*RF2*/(C)->_count/*4*/))+((/*RF2*/(((T7*)a1))->_count/*4*/)));
R=((T0*)n);
}
r7append(((T7*)R),(T0*)C);
r7append(((T7*)R),a1);
return R;
}

void r7extend(T7* C,T3 a1){
T2 _new_capacity=0;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/))){
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
_new_capacity=32;
(/*SFN*/C->_storage/*0*/)=((T9)(se_calloc(_new_capacity,sizeof(T3))));
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_count/*4*/)]=(a1);
(/*SFN*/C->_count/*4*/)=((/*RF2*/(C)->_count/*4*/))+(1);
}

void r7remove_last(T7* C,T2 a1){
/*[IF*/
if((a1)>((/*RF2*/(C)->_count/*4*/))){
(/*SFN*/C->_count/*4*/)=0;
}
else{
(/*SFN*/C->_count/*4*/)=((/*RF2*/(C)->_count/*4*/))-(a1);
}
/*FI]*/
}

T6 r7has(T7* C,T3 a1){
T6 R=0;
R=r9fast_has((/*RF2*/(C)->_storage/*0*/),a1,((/*RF2*/(C)->_count/*4*/))-(1));
return R;
}

void r7append_character(T7* C,T3 a1){
T2 _new_capacity=0;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/))){
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
_new_capacity=32;
(/*SFN*/C->_storage/*0*/)=((T9)(se_calloc(_new_capacity,sizeof(T3))));
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_count/*4*/)]=(a1);
(/*SFN*/C->_count/*4*/)=((/*RF2*/(C)->_count/*4*/))+(1);
}

void r7extend_unless(T7* C,T3 a1){
/*[IF*/
if((((/*RF2*/(C)->_count/*4*/))==(0))||((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(1)]/*)*/)!=(a1))){
r7append_character(C,a1);
}
/*FI]*/
}

T6 r7same_as(T7* C,T0* a1){
T6 R=0;
T9 _s1=NULL;
T9 _s2=NULL;
T2 _i=0;
_i=(/*RF2*/(C)->_count/*4*/);
/*[IF*/
if((_i)==((/*RF2*/(((T7*)a1))->_count/*4*/))){
/*[IF*/
if(r9fast_memcmp((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),_i)){
R=1;
}
else{
_i=(_i)-(1);
_s1=(/*RF2*/(C)->_storage/*0*/);
_s2=(/*RF2*/(((T7*)a1))->_storage/*0*/);
R=1;
while (!((_i)<(0)))
{
/*[IF*/
if(r3same_as((_s1)[_i],(_s2)[_i])){
_i=(_i)-(1);
}
else{
_i=-(1);
R=0;
}
/*FI]*/
}
}
/*FI]*/
}
/*FI]*/
return R;
}

void r7add_last(T7* C,T3 a1){
T2 _new_capacity=0;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/))){
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
_new_capacity=32;
(/*SFN*/C->_storage/*0*/)=((T9)(se_calloc(_new_capacity,sizeof(T3))));
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_count/*4*/)]=(a1);
(/*SFN*/C->_count/*4*/)=((/*RF2*/(C)->_count/*4*/))+(1);
}

void r7to_upper(T7* C){
T2 _i=0;
_i=(/*RF2*/(C)->_count/*4*/);
while (!((_i)==(0)))
{
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]=(r3to_upper(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/));
/*]*/
_i=(_i)-(1);
}
}

T2 r7substring_index(T7* C,T0* a1,T2 a2){
T2 R=0;
T2 _i=0;
T2 _s=0;
_s=a2;
while (!(((R)!=(0))||((((_s)+((/*RF2*/(((T7*)a1))->_count/*4*/)))-(1))>((/*RF2*/(C)->_count/*4*/)))))
{
_i=1;
while (!(((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/)))||((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(((_s)+(_i))-(1))-(1)]/*)*/)!=(/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/))))
{
_i=(_i)+(1);
}
/*[IF*/
if((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/))){
R=_s;
}
else{
_s=(_s)+(1);
}
/*FI]*/
}
return R;
}

void r7from_external_copy(T7* C,T8 a1){
T9 _s=NULL;
T2 _i=0;
_s=a1;
(/*SFN*/C->_count/*4*/)=0;
while (!(((_s)[_i])==(((T3)'\0'))))
{
r7append_character(C,(_s)[_i]);
_i=(_i)+(1);
}
}

T8 r7to_external(T7* C){
T8 R=NULL;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/))){
(/*SFN*/C->_count/*4*/)=((/*RF2*/(C)->_count/*4*/))+(1);
/*[IF*/
if((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(1)]/*)*/)!=(((T3)'\0'))){
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(1)]=(((T3)'\0'));
/*]*/
}
/*FI]*/
}
else{
r7append_character(C,((T3)'\0'));
}
/*FI]*/
(/*SFN*/C->_count/*4*/)=((/*RF2*/(C)->_count/*4*/))-(1);
R=((void*)((/*RF2*/(C)->_storage/*0*/)));
return R;
}

void r7to_lower(T7* C){
T2 _i=0;
_i=(/*RF2*/(C)->_count/*4*/);
while (!((_i)==(0)))
{
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]=(r3to_lower(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/));
/*]*/
_i=(_i)-(1);
}
}

T0* r7twin(T7* C){
T0* R=NULL;
R=se_malloc(sizeof(*C));
*((T7*)R)=M7;
r7copy(((T7*)R),((T0*)C));
return R;
}

void r7split_in(T7* C,T0* a1){
T2 _state=0;
T2 _i=0;
T3 _c=0;
/*[IF*/
if(((/*RF2*/(C)->_count/*4*/))>(0)){
_i=1;
while (!((_i)>((/*RF2*/(C)->_count/*4*/))))
{
_c=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/;
/*[IF*/
if((_state)==(0)){
/*[IF*/
if(!(r3is_separator(_c))){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC7string_buffer))))->_count/*4*/)=(0);
/*]*/
r7append_character((T7*)(oBC7string_buffer),_c);
_state=1;
}
/*FI]*/
}
else{
/*[IF*/
if(!(r3is_separator(_c))){
r7append_character((T7*)(oBC7string_buffer),_c);
}
else{
X57add_last(a1,r7twin((T7*)(oBC7string_buffer)));
_state=0;
}
/*FI]*/
}
/*FI]*/
_i=(_i)+(1);
}
/*[IF*/
if((_state)==(1)){
X57add_last(a1,r7twin((T7*)(oBC7string_buffer)));
}
/*FI]*/
}
/*FI]*/
}

void r7swap(T7* C,T2 a1,T2 a2){
T3 _tmp=0;
_tmp=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(a1)-(1)]/*)*/;
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(a1)-(1)]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(a2)-(1)]/*)*/);
/*]*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(a2)-(1)]=(_tmp);
/*]*/
}

void r51make(T51* C,T2 a1){
/*[IF*/
if((a1)>((/*RF2*/(C)->_capacity/*8*/))){
(/*SFN*/C->_storage/*4*/)=((T45)(se_calloc(a1,sizeof(T0*))));
(/*SFN*/C->_capacity/*8*/)=a1;
}
 else if((((/*RF2*/(C)->_capacity/*8*/))>(0))&&(((/*RF2*/(C)->_upper/*12*/))>=(0))){
r45clear((/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
/*FI]*/
(/*SFN*/C->_upper/*12*/)=(a1)-(1);
}

void r51add_last(T51* C,T0* a1){
T2 _new_capacity=0;
/*[IF*/
if((((/*RF2*/(C)->_upper/*12*/))+(1))<=(((/*RF2*/(C)->_capacity/*8*/))-(1))){
(/*SFN*/C->_upper/*12*/)=((/*RF2*/(C)->_upper/*12*/))+(1);
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
(/*SFN*/C->_storage/*4*/)=((T45)(se_calloc(2,sizeof(T0*))));
(/*SFN*/C->_capacity/*8*/)=2;
(/*SFN*/C->_upper/*12*/)=0;
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage/*4*/)=r45realloc((/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
(/*SFN*/C->_upper/*12*/)=((/*RF2*/(C)->_upper/*12*/))+(1);
}
/*FI]*/
((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_upper/*12*/)]=(a1);
}

void r51with_capacity(T51* C,T2 a1){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(a1)){
(/*SFN*/C->_storage/*4*/)=((T45)(se_calloc(a1,sizeof(T0*))));
(/*SFN*/C->_capacity/*8*/)=a1;
}
 else if(((/*RF2*/(C)->_capacity/*8*/))>(a1)){
r45clear((/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
/*FI]*/
(/*SFN*/C->_upper/*12*/)=-(1);
}

void r44copy(T44* C,T0* a1){
T2 _needed_capacity=0;
(/*SFN*/C->_lower/*16*/)=(/*RF2*/(((T44*)a1))->_lower/*16*/);
(/*SFN*/C->_upper/*12*/)=(/*RF2*/(((T44*)a1))->_upper/*12*/);
_needed_capacity=(((/*RF2*/(C)->_upper/*12*/))-((/*RF2*/(C)->_lower/*16*/)))+(1);
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(_needed_capacity)){
(/*SFN*/C->_storage/*4*/)=((T45)(se_calloc(_needed_capacity,sizeof(T0*))));
(/*SFN*/C->_capacity/*8*/)=_needed_capacity;
}
/*FI]*/
/*[IF*/
if((_needed_capacity)>(0)){
r45copy_from((/*RF2*/(C)->_storage/*4*/),(/*RF2*/(((T44*)a1))->_storage/*4*/),(_needed_capacity)-(1));
}
/*FI]*/
}

T2 r44count(T44* C){
T2 R=0;
R=(((/*RF2*/(C)->_upper/*12*/))-((/*RF2*/(C)->_lower/*16*/)))+(1);
return R;
}

T0* r44item(T44* C,T2 a1){
T0* R=NULL;
R=((/*RF2*/(C)->_storage/*4*/))[(a1)-((/*RF2*/(C)->_lower/*16*/))];
return R;
}

T2 r44index_of(T44* C,T0* a1){
T2 R=0;
R=((/*RF2*/(C)->_lower/*16*/))+(r45index_of((/*RF2*/(C)->_storage/*4*/),a1,((/*RF2*/(C)->_upper/*12*/))-((/*RF2*/(C)->_lower/*16*/))));
return R;
}

T6 r44is_empty(T44* C){
T6 R=0;
R=((/*RF2*/(C)->_upper/*12*/))<((/*RF2*/(C)->_lower/*16*/));
return R;
}

void r44add_last(T44* C,T0* a1){
T2 _new_capacity=0;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<((r44count(C))+(1))){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
_new_capacity=16;
(/*SFN*/C->_storage/*4*/)=((T45)(se_calloc(_new_capacity,sizeof(T0*))));
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage/*4*/)=r45realloc((/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
}
/*FI]*/
(/*SFN*/C->_upper/*12*/)=((/*RF2*/(C)->_upper/*12*/))+(1);
/*[IRF3.6put*/{T44* C1=C;
T0* b1=a1;
T2 b2=(/*RF2*/(C)->_upper/*12*/);
((/*RF2*/(C1)->_storage/*4*/))[(b2)-((/*RF2*/(C1)->_lower/*16*/))]=(b1);
}/*]*/
}

void r44clear(T44* C){
(/*SFN*/C->_upper/*12*/)=((/*RF2*/(C)->_lower/*16*/))-(1);
}

T0* r44twin(T44* C){
T0* R=NULL;
R=se_malloc(sizeof(*C));
*((T44*)R)=M44;
r44copy(((T44*)R),((T0*)C));
return R;
}

void r44with_capacity(T44* C,T2 a1,T2 a2){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(a1)){
(/*SFN*/C->_storage/*4*/)=((T45)(se_calloc(a1,sizeof(T0*))));
(/*SFN*/C->_capacity/*8*/)=a1;
}
/*FI]*/
(/*SFN*/C->_lower/*16*/)=a2;
(/*SFN*/C->_upper/*12*/)=(a2)-(1);
}

void r30read_character(T30* C){
/*[IF*/
if((/*RF2*/(C)->_push_back_flag/*0*/)){
(/*SFN*/C->_push_back_flag/*0*/)=0;
}
else{
(/*SFN*/C->_memory/*1*/)=basic_io_getc(basic_io_stdin);
}
/*FI]*/
}

void r30skip_separators(T30* C){
while (!((r30end_of_input(C))||(!(r3is_separator(/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*1*/)))/*)*/)))))
{
r30read_character(C);
}
/*[IF*/
if((!(r30end_of_input(C)))&&(!((/*RF2*/(C)->_push_back_flag/*0*/)))){
/*[IRF3.3unread_character*/((((T30*)(C)))->_push_back_flag/*0*/)=(1);
/*]*/
}
/*FI]*/
}

void r30read_line_in(T30* C,T0* a1){
T2 _mem=0;
r30read_character(C);
/*[IF*/
if(((/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*1*/)))/*)*/)!=(((T3)'\n')))&&(((/*RF2*/(C)->_memory/*1*/))!=(basic_io_eof))){
r7extend(((T7*)a1),((T3)((/*RF2*/(C)->_memory/*1*/))));
_mem=basic_io_getc(basic_io_stdin);
while (!(((_mem)==(basic_io_eof))||((_mem)==(T3code(((T3)'\n'))))))
{
r7extend(((T7*)a1),((T3)(_mem)));
_mem=basic_io_getc(basic_io_stdin);
}
(/*SFN*/C->_memory/*1*/)=_mem;
}
/*FI]*/
}

T6 r30end_of_input(T30* C){
T6 R=0;
/*[IF*/
if(!((/*RF2*/(C)->_push_back_flag/*0*/))){
R=((/*RF2*/(C)->_memory/*1*/))==(basic_io_eof);
}
/*FI]*/
return R;
}

void r30read_word(T30* C){
r30skip_separators(C);
/*[IF*/
if(!(r30end_of_input(C))){
r30read_character(C);
}
/*FI]*/
/*[IRF3.3clear*/((((T7*)((T7*)(oBC31last_string))))->_count/*4*/)=(0);
/*]*/
while (!((r30end_of_input(C))||(r3is_separator(/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*1*/)))/*)*/))))
{
r7extend((T7*)(oBC31last_string),/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*1*/)))/*)*/);
r30read_character(C);
}
}

void r30read_line(T30* C){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC31last_string))))->_count/*4*/)=(0);
/*]*/
r30read_line_in(C,oBC31last_string);
}
T0*oBC31last_string=NULL;

void r35file_removing(T35* C,T0* a1){
/*[IF*/
if(r35file_exists(a1)){
r35put_string(C,((T0*)ms35_210310269));
r35put_string(C,a1);
r35put_string(C,((T0*)ms19_1090));
/*[IRF3.6remove_file*/{T0* b1=a1;
r49delete(b1);
}/*]*/
}
/*FI]*/
}

T6 r35file_exists(T0* a1){
T6 R=0;
R=r49is_readable(a1);
return R;
}

void r35file_renaming(T35* C,T0* a1,T0* a2){
r35put_string(C,((T0*)ms35_210141519));
r35put_string(C,a1);
r35put_string(C,((T0*)ms35_141444));
r35put_string(C,a2);
r35put_string(C,((T0*)ms19_1090));
/*[IRF3.6rename_file*/{T0* b1=a1;
T0* b2=a2;
r49rename_to(b1,b2);
}/*]*/
}
T0*oBC18system_tools=NULL;
int fBC18system_tools=0;

T0* r35system_tools(void){
if(fBC18system_tools==0){fBC18system_tools=1;{
{T37*n=((T37*)se_malloc(sizeof(*n))/*25*/);
*n=M37;
oBC18system_tools=((T0*)n);
r37make(n);
}
}}
return oBC18system_tools;
}

void r35tfw_connect(T35* C,T0* a1,T0* a2){
r53connect_to(((T53*)a1),a2);
/*[IF*/
if(/*(IRF4.7is_connected*/((/*RF2*/(((T53*)a1))->_path/*0*/))!=(NULL)/*)*/){
r35put_string(C,((T0*)ms35_44975894));
r35put_string(C,a2);
r35put_string(C,((T0*)ms35_3556890));
}
else{
r35w_put_string(((T0*)ms35_1711985232));
r35w_put_string(a2);
r35w_put_string(((T0*)ms19_1090));
exit(1);
}
/*FI]*/
}

void r35w_put_character(T3 a1){
/*[IRF3.6put_character*/{T3 b1=a1;
basic_io_putc(b1,basic_io_stderr);
}/*]*/
/*[IRF3.2flush*/basic_io_flush(basic_io_stderr);
/*]*/
}

void r35tfr_connect(T35* C,T0* a1,T0* a2){
r35put_string(C,((T0*)ms35_27561173));
r35put_string(C,a2);
r35put_string(C,((T0*)ms19_1090));
r39connect_to(((T39*)a1),a2);
}

T0* r35getenv(T35* C,T0* a1,T0* a2){
T0* R=NULL;
int _s=0;
R=r36get_environment_variable(a1);
/*[IF*/
if(((R)==((void*)(NULL)))&&(r7same_as(ms35_1662662954,a1))){
R=r36get_environment_variable(((T0*)ms19_1071750288));
/*[IF*/
if(((R)!=((void*)(NULL)))&&(((/*RF2*/(((T7*)R))->_count/*4*/))>(9))){
r7remove_last(((T7*)R),9);
/*[IF*/
if(((/*RF2*/(((T7*)R))->_count/*4*/))>(3)){
r37parent_directory((T37*)(r35system_tools()),R);
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if((R)==((void*)(NULL))){
r35put_string(C,((T0*)ms35_354654986));
r35put_string(C,a1);
r35put_character(C,((T3)'\175'));
/*[IF*/
if((a2)!=((void*)(NULL))){
r35put_string(C,((T0*)ms35_1430004157));
r35put_string(C,a2);
r35put_character(C,((T3)'\42'));
}
/*FI]*/
r35put_string(C,((T0*)ms35_1293738877));
}
/*FI]*/
return R;
}

T0* r35read_word_in(T35* C,T0* a1){
T0* R=NULL;
r35put_string(C,((T0*)ms35_136264778));
r35put_string(C,(/*RF2*/(((T39*)a1))->_path/*1*/));
r35put_string(C,((T0*)ms19_1090));
/*[IF*/
if(r39end_of_input(((T39*)a1))){
r35w_put_string(((T0*)ms35_1520107011));
r35w_put_string((/*RF2*/(((T39*)a1))->_path/*1*/));
r35w_put_string(((T0*)ms19_1090));
exit(1);
}
else{
r39read_word(((T39*)a1));
R=r7twin((T7*)(oBC31last_string));
}
/*FI]*/
return R;
}

void r35tfr_connect_or_exit(T35* C,T0* a1,T0* a2){
r35tfr_connect(C,a1,a2);
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/(((T39*)a1))->_path/*1*/))!=(NULL)/*)*/)){
r35w_put_string(((T0*)ms19_300594));
r35w_put_string(a2);
r35w_put_string(((T0*)se_ms(13,"\" not found.\n")));
exit(1);
}
/*FI]*/
}
T49 oBC1file_tools=0;
T0*oBC1std_output=NULL;

void r35w_put_string(T0* a1){
r46put_string(a1);
/*[IRF3.2flush*/basic_io_flush(basic_io_stderr);
/*]*/
}

void r35system_call(T35* C,T0* a1){
T2 _i=0;
T0* _cmd2=NULL;
int _s=0;
/*[IF*/
if((r7last(((T7*)a1)))==(((T3)'\n'))){
r7remove_last(((T7*)a1),1);
r35system_call(C,a1);
}
 else if(r7has(((T7*)a1),((T3)'\n'))){
_i=r7first_index_of(((T7*)a1),((T3)'\n'));
_cmd2=r7substring(((T7*)a1),(_i)+(1),(/*RF2*/(((T7*)a1))->_count/*4*/));
r7remove_last(((T7*)a1),(((/*RF2*/(((T7*)a1))->_count/*4*/))-(_i))+(1));
r35system_call(C,a1);
r35system_call(C,_cmd2);
}
else{
r35put_string(C,((T0*)ms35_1800535743));
r35put_string(C,a1);
r35put_string(C,((T0*)ms19_1090));
r36execute_command_line(a1);
}
/*FI]*/
}

void r35put_character(T35* C,T3 a1){
/*[IF*/
if((/*RF2*/(C)->_verbose/*0*/)){
/*[IRF3.6put_character*/{T3 b1=a1;
basic_io_putc(b1,basic_io_stdout);
}/*]*/
/*[IRF3.2flush*/basic_io_flush(basic_io_stdout);
/*]*/
}
/*FI]*/
}

void r35put_string(T35* C,T0* a1){
/*[IF*/
if((/*RF2*/(C)->_verbose/*0*/)){
r33put_string(a1);
/*[IRF3.2flush*/basic_io_flush(basic_io_stdout);
/*]*/
}
/*FI]*/
}
T0*oBC1std_error=NULL;

void r39disconnect(T39* C){
basic_io_fclose((/*RF2*/(C)->_input_stream/*5*/));
(/*SFN*/C->_path/*1*/)=NULL;
}

void r39read_character(T39* C){
/*[IF*/
if((/*RF2*/(C)->_push_back_flag/*0*/)){
(/*SFN*/C->_push_back_flag/*0*/)=0;
}
else{
(/*SFN*/C->_memory/*9*/)=basic_io_getc((/*RF2*/(C)->_input_stream/*5*/));
}
/*FI]*/
}

void r39skip_separators(T39* C){
while (!((r39end_of_input(C))||(!(r3is_separator(/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*9*/)))/*)*/)))))
{
r39read_character(C);
}
/*[IF*/
if((!(r39end_of_input(C)))&&(!((/*RF2*/(C)->_push_back_flag/*0*/)))){
/*[IRF3.3unread_character*/((((T39*)(C)))->_push_back_flag/*0*/)=(1);
/*]*/
}
/*FI]*/
}

void r39read_line_in(T39* C,T0* a1){
T2 _idx=0;
T2 _remainder=0;
T9 _storage=NULL;
T2 _m=0;
_storage=(/*RF2*/(((T7*)a1))->_storage/*0*/);
_idx=(/*RF2*/(((T7*)a1))->_count/*4*/);
_remainder=((/*RF2*/(((T7*)a1))->_capacity/*8*/))-(_idx);
r39read_character(C);
_m=(/*RF2*/(C)->_memory/*9*/);
while (!((((_m)==(basic_io_eof))||((_m)==(T3code(((T3)'\n')))))||((_m)==(T3code(((T3)'\15'))))))
{
/*[IF*/
if((_remainder)>(0)){
(_storage)[_idx]=(((T3)(_m)));
_idx=(_idx)+(1);
_remainder=(_remainder)-(1);
}
else{
/*[IRF3.3set_count*/((((T7*)(((T7*)a1))))->_count/*4*/)=(_idx);
/*]*/
r7extend(((T7*)a1),((T3)(_m)));
_storage=(/*RF2*/(((T7*)a1))->_storage/*0*/);
_idx=(/*RF2*/(((T7*)a1))->_count/*4*/);
_remainder=((/*RF2*/(((T7*)a1))->_capacity/*8*/))-(_idx);
}
/*FI]*/
_m=basic_io_getc((/*RF2*/(C)->_input_stream/*5*/));
}
/*[IRF3.3set_count*/((((T7*)(((T7*)a1))))->_count/*4*/)=(_idx);
/*]*/
(/*SFN*/C->_memory/*9*/)=_m;
/*[IF*/
if((_m)==(T3code(((T3)'\15')))){
r39read_character(C);
/*[IF*/
if(((/*RF2*/(C)->_memory/*9*/))!=(T3code(((T3)'\n')))){
(/*SFN*/C->_push_back_flag/*0*/)=1;
}
/*FI]*/
}
/*FI]*/
}

T6 r39end_of_input(T39* C){
T6 R=0;
/*[IF*/
if(!((/*RF2*/(C)->_push_back_flag/*0*/))){
R=((/*RF2*/(C)->_memory/*9*/))==(basic_io_eof);
}
/*FI]*/
return R;
}

void r39connect_to(T39* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
(/*SFN*/C->_input_stream/*5*/)=basic_io_text_file_read_open(_p);
/*[IF*/
if((NULL!=(/*RF2*/(C)->_input_stream/*5*/))){
(/*SFN*/C->_push_back_flag/*0*/)=0;
(/*SFN*/C->_memory/*9*/)=T3code(((T3)'\40'));
(/*SFN*/C->_path/*1*/)=a1;
}
/*FI]*/
}

void r39read_word(T39* C){
r39skip_separators(C);
/*[IF*/
if(!(r39end_of_input(C))){
r39read_character(C);
}
/*FI]*/
/*[IRF3.3clear*/((((T7*)((T7*)(oBC31last_string))))->_count/*4*/)=(0);
/*]*/
while (!((r39end_of_input(C))||(r3is_separator(/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*9*/)))/*)*/))))
{
r7extend((T7*)(oBC31last_string),/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*9*/)))/*)*/);
r39read_character(C);
}
}

void r39read_line(T39* C){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC31last_string))))->_count/*4*/)=(0);
/*]*/
r39read_line_in(C,oBC31last_string);
}

void r37append_token(T0* a1,T0* a2){
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a2))->_count/*4*/))==(0)/*)*/)){
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)!=(((T3)'\40'))){
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a1))->_count/*4*/))==(0)/*)*/)){
r7extend_unless(((T7*)a1),((T3)'\40'));
}
/*FI]*/
}
/*FI]*/
r7append(((T7*)a1),a2);
}
/*FI]*/
}

void r37set_c_compiler(T37* C,T0* a1){
T2 _i=0;
T0* _sd=NULL;
T3 _c=0;
/*[IF*/
if((a1)!=((void*)(NULL))){
_i=r44index_of((T44*)(oBC37compiler_list),a1);
/*[IF*/
if((_i)>((/*RF2*/((T44*)(oBC37compiler_list))->_upper/*12*/))){
r35w_put_string(((T0*)ms37_17494489));
r35w_put_string(a1);
r35w_put_string(((T0*)ms37_561720547));
r37show_compiler_list_then_exit(C);
}
/*FI]*/
(/*SFN*/C->_c_compiler/*21*/)=r44item((T44*)(oBC37compiler_list),_i);
}
else{
_sd=(/*RF2*/(C)->_sys_directory/*4*/);
r7copy((T7*)(oBC18tmp_path),_sd);
r7append((T7*)(oBC18tmp_path),((T0*)ms37_1236979201));
r35tfr_connect_or_exit((T35*)(oBC18echo),oBC18tmp_file_read,oBC18tmp_path);
(/*SFN*/C->_c_compiler/*21*/)=r35read_word_in((T35*)(oBC18echo),oBC18tmp_file_read);
_i=r44index_of((T44*)(oBC37compiler_list),(/*RF2*/(C)->_c_compiler/*21*/));
/*[IF*/
if((_i)>((/*RF2*/((T44*)(oBC37compiler_list))->_upper/*12*/))){
r35w_put_string(((T0*)ms37_876917780));
r35w_put_string((/*RF2*/((T39*)(oBC18tmp_file_read))->_path/*1*/));
r35w_put_string(((T0*)ms19_1090));
r37show_compiler_list_then_exit(C);
}
/*FI]*/
(/*SFN*/C->_c_compiler/*21*/)=r44item((T44*)(oBC37compiler_list),_i);
/*[IF*/
if(!(r39end_of_input((T39*)(oBC18tmp_file_read)))){
_c=/*(IRF4.6last_character*/((T3)((/*RF2*/((T39*)(oBC18tmp_file_read))->_memory/*9*/)))/*)*/;
while (!(((_c)==(((T3)'\n')))||((_c)==(((T3)'\15')))))
{
r7extend((T7*)(((T0*)ms37_0aaaaaa)),_c);
r39read_character((T39*)(oBC18tmp_file_read));
/*[IF*/
if(!(r39end_of_input((T39*)(oBC18tmp_file_read)))){
_c=/*(IRF4.6last_character*/((T3)((/*RF2*/((T39*)(oBC18tmp_file_read))->_memory/*9*/)))/*)*/;
}
/*FI]*/
}
}
/*FI]*/
r39disconnect((T39*)(oBC18tmp_file_read));
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms37_0aaaaaa)))->_count/*4*/))==(0)/*)*/)||(!(r3is_separator(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms37_0aaaaaa)))->_storage/*0*/))[0]/*)*/)))))
{
r7remove_first((T7*)(((T0*)ms37_0aaaaaa)),1);
}
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms37_0aaaaaa)))->_count/*4*/))==(0)/*)*/){
/*[IF*/
if((((T0*)ms37_3169))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_1570));
}
 else if((((T0*)ms37_51699930))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_304a));
}
 else if((((T0*)ms37_594))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_304aa));
}
 else if((((T0*)ms37_448859))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
}
 else if((((T0*)ms37_76405))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_836475934));
}
 else if((((T0*)ms37_382130))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_1826831355));
}
 else if((((T0*)ms37_603))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_137550186));
}
 else if((((T0*)ms37_674))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
/*[IRF3.3clear*/((((T7*)((T7*)(((T0*)ms37_0aaaaaa)))))->_count/*4*/)=(0);
/*]*/
r7copy((T7*)(((T0*)ms37_0aaaaa)),((T0*)ms37_12782));
/*[IF*/
if(!(r37Scoptions_exists())){
r37append_token(((T0*)ms37_0aaaaa),((T0*)ms37_698995372));
}
/*FI]*/
}
 else if((((T0*)ms37_15721))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_1091987));
}
 else if((((T0*)ms37_17794))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
/*[IF*/
if((((T0*)ms37_57487))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_968120));
}
/*FI]*/
}
 else if((((T0*)ms37_3069))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
r7copy((T7*)(((T0*)ms37_0aaaaaa)),((T0*)ms37_1570));
}
 else if((((T0*)ms37_18144))==((void*)((/*RF2*/(C)->_c_compiler/*21*/)))){
}
else{
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
}

void r37install_extra_options(T37* C){
/*[IF*/
if((((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3169))))||(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_2833))))){
/*[IF*/
if(!(r7has((T7*)(((T0*)ms37_0aaaaaa)),((T3)'O')))){
r37append_token(((T0*)ms37_0aaaaaa),((T0*)ms37_1570));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_51699930)))){
/*[IF*/
if(!(r7has((T7*)(((T0*)ms37_0aaaaaa)),((T3)'O')))){
r37append_token(((T0*)ms37_0aaaaaa),((T0*)ms37_304));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674)))){
/*[IF*/
if(!(r37Scoptions_exists())){
r37append_token(((T0*)ms37_0aaaaaa),((T0*)ms37_426884100));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_15721)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_17794)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3069)))){
/*[IF*/
if(!(r7has((T7*)(((T0*)ms37_0aaaaaa)),((T3)'O')))){
r37append_token(((T0*)ms37_0aaaaaa),((T0*)ms37_1570));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_18144)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_207986277)))){
}
/*FI]*/
}
T0*oBC37system_list=NULL;
T0*oBC18tmp_file_read=NULL;
T6 oBC37Scoptions_exists=0;
int fBC37Scoptions_exists=0;

T6 r37Scoptions_exists(void){
if(fBC37Scoptions_exists==0){fBC37Scoptions_exists=1;{
oBC37Scoptions_exists=r49is_readable(((T0*)ms37_39204698));
}}
return oBC37Scoptions_exists;
}

void r37no_split_mode_command(T37* C,T0* a1,T0* a2){
/*[IRF3.3clear*/((((T7*)(((T7*)a1))))->_count/*4*/)=(0);
/*]*/
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3169)))){
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms37_0aa)))->_count/*4*/))==(0)/*)*/){
r7append(((T7*)a1),((T0*)ms37_3169));
}
else{
r7append(((T7*)a1),((T0*)ms37_2833));
}
/*FI]*/
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_51699930)))){
r7append(((T7*)a1),((T0*)ms37_3294));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,a2);
r7extend(((T7*)a1),((T3)'\n'));
r37external_c_files_for_lcc_win32(C,a1);
r7append(((T7*)a1),((T0*)ms37_415107));
/*[IF*/
if(!((/*RF2*/(C)->_no_strip/*12*/))){
r37append_token(a1,((T0*)ms37_340));
}
/*FI]*/
r37append_token(a1,((T0*)ms37_0aaaaa));
r37add_executable_name(C,a1);
/*[IRF3.6remove_suffix*/{T7* C1=((T7*)a2);
T0* b1=((T0*)ms18_329);
r7remove_last(C1,(/*RF2*/(((T7*)b1))->_count/*4*/));
}/*]*/
r7append(((T7*)a2),r37object_suffix(C));
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_594)))){
r7append(((T7*)a1),((T0*)ms37_594));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_448859)))){
r7append(((T7*)a1),((T0*)ms37_448859));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_76405)))){
r7append(((T7*)a1),((T0*)ms37_76405));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_382130)))){
r7append(((T7*)a1),((T0*)ms37_382130));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_603)))){
r7append(((T7*)a1),((T0*)ms37_603));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674)))){
r7append(((T7*)a1),((T0*)ms37_674));
r37append_token(a1,r37sas_c_compiler_options(0));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_lib_math(C);
r37add_executable_name(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_15721)))){
r7append(((T7*)a1),((T0*)ms37_3094));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_lib_math(C);
/*[IF*/
if((/*RF2*/(C)->_no_strip/*12*/)){
r37append_token(a1,((T0*)ms37_340a));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_17794)))){
r7append(((T7*)a1),((T0*)ms37_689));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_lib_math(C);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3069)))){
r7append(((T7*)a1),((T0*)ms37_3069));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_18144)))){
r7append(((T7*)a1),((T0*)ms37_18144));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37append_token(a1,a2);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_207986277)))){
r7append(((T7*)a1),((T0*)ms37_683870135a));
r7append(((T7*)a1),a2);
r7remove_last(((T7*)a1),2);
r7append(((T7*)a1),((T0*)ms37_72020566));
r37add_executable_name(C,a1);
r7extend(((T7*)a1),((T3)'\40'));
r7append(((T7*)a1),a2);
r7remove_last(((T7*)a1),2);
}
/*FI]*/
}

void r37add_executable_name(T37* C,T0* a1){
T0* _executable_name=NULL;
_executable_name=(/*RF2*/((T54*)(oBC18ace))->_executable_name/*0*/);
/*[IF*/
if((_executable_name)==((void*)(NULL))){
_executable_name=r7twin((T7*)((/*RF2*/((T54*)(oBC18ace))->_root_class_name/*4*/)));
r7to_lower(((T7*)_executable_name));
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_51699930)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_76405)))){
r37append_token(a1,((T0*)ms37_326));
r7append(((T7*)a1),_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_382130)))){
r37append_token(a1,((T0*)ms37_326));
r7append(((T7*)a1),_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_448859)))){
r37append_token(a1,((T0*)ms37_336));
r7append(((T7*)a1),_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674)))){
_executable_name=r7twin((T7*)((/*RF2*/((T54*)(oBC18ace))->_root_class_name/*4*/)));
r7to_lower(((T7*)_executable_name));
r7append(((T7*)a1),((T0*)ms37_6687));
r7append(((T7*)a1),_executable_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_15721)))){
r37append_token(a1,((T0*)ms37_336));
r7append(((T7*)a1),_executable_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_17794)))){
r37append_token(a1,((T0*)ms37_336));
r7append(((T7*)a1),_executable_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_18144)))){
r37append_token(a1,((T0*)ms37_336));
r7append(((T7*)a1),_executable_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_207986277)))){
r7append(((T7*)a1),_executable_name);
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3169)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_51699930)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_594)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_448859)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_76405)))){
r37append_token(a1,((T0*)ms37_326));
r7append(((T7*)a1),_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_382130)))){
r37append_token(a1,((T0*)ms37_326));
r7append(((T7*)a1),_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_603)))){
r37append_token(a1,((T0*)ms37_336));
r7append(((T7*)a1),_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674)))){
r7append(((T7*)a1),((T0*)ms37_6687));
r37append_token(a1,_executable_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_15721)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_17794)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3069)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_18144)))){
r37append_token(a1,((T0*)ms37_336));
r37append_token(a1,_executable_name);
r37add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_207986277)))){
r7append(((T7*)a1),_executable_name);
}
/*FI]*/
}

void r37add_x_suffix(T37* C,T0* a1){
T0* _suffix=NULL;
_suffix=r37x_suffix(C);
/*[IF*/
if(!(r7has_suffix(((T7*)a1),_suffix))){
r7append(((T7*)a1),_suffix);
}
/*FI]*/
}

void r37external_c_files_for_lcc_win32(T37* C,T0* a1){
T0* _c_files=NULL;
T0* _c_file=NULL;
T2 _i=0;
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms37_0aaa)))->_count/*4*/))==(0)/*)*/)){
_c_files=r7split((T7*)(((T0*)ms37_0aaa)));
/*[IRF3.3clear*/((((T7*)((T7*)(((T0*)ms37_0aaa)))))->_count/*4*/)=(0);
/*]*/
/*[IF*/
if((_c_files)!=((void*)(NULL))){
_i=(/*RF2*/(((T44*)_c_files))->_lower/*16*/);
while (!((_i)>((/*RF2*/(((T44*)_c_files))->_upper/*12*/))))
{
_c_file=r44item(((T44*)_c_files),_i);
r7append(((T7*)a1),((T0*)ms37_3294));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,_c_file);
r7extend(((T7*)a1),((T3)'\n'));
/*[IRF3.6remove_suffix*/{T7* C1=((T7*)_c_file);
T0* b1=((T0*)ms18_329);
r7remove_last(C1,(/*RF2*/(((T7*)b1))->_count/*4*/));
}/*]*/
r7append(((T7*)_c_file),r37object_suffix(C));
r37append_token(((T0*)ms37_0a),_c_file);
_i=(_i)+(1);
}
}
/*FI]*/
}
/*FI]*/
}
T0*oBC18tmp_path=NULL;
T0*oBC37token_buffer=NULL;

void r37split_mode_c_compiler_command(T37* C,T0* a1,T0* a2){
/*[IRF3.3clear*/((((T7*)(((T7*)a1))))->_count/*4*/)=(0);
/*]*/
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3169)))){
/*[IF*/
if(r37is_c_plus_plus_file_path(a2)){
r7append(((T7*)a1),((T0*)ms37_2833));
}
else{
r7append(((T7*)a1),((T0*)ms37_3169));
}
/*FI]*/
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_51699930)))){
r7append(((T7*)a1),((T0*)ms37_3294));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_594)))){
r7append(((T7*)a1),((T0*)ms37_594));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_448859)))){
r7append(((T7*)a1),((T0*)ms37_447734));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_76405)))){
r7append(((T7*)a1),((T0*)ms37_76405));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_382130)))){
r7append(((T7*)a1),((T0*)ms37_382130));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_603)))){
r7append(((T7*)a1),((T0*)ms37_603));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674)))){
r7append(((T7*)a1),((T0*)ms37_674));
r37append_token(a1,r37sas_c_compiler_options(1));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_15721)))){
r7append(((T7*)a1),((T0*)ms37_3094));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_17794)))){
r7append(((T7*)a1),((T0*)ms37_689));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3069)))){
r7append(((T7*)a1),((T0*)ms37_3069));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_18144)))){
r7append(((T7*)a1),((T0*)ms37_18144));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_324));
r37append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_207986277)))){
r7append(((T7*)a1),((T0*)ms37_683870135));
r7append(((T7*)a1),a2);
r7remove_last(((T7*)a1),2);
}
/*FI]*/
}

void r37add_objects_(T37* C,T0* a1,T0* a2,T2 a3,T2 a4){
T2 _c=0;
T2 _i1=0;
T2 _i2=0;
T2 _new_min=0;
/*[IF*/
if((a3)>(a4)){
}
 else if((a3)<(9)){
r37append_token(a1,a2);
r7append(((T7*)a1),((T0*)ms37_2565));
_i1=r2min(9,a4);
r2append_in(_i1,a1);
r7extend(((T7*)a1),((T3)'\135'));
r7append(((T7*)a1),r37object_suffix(C));
r37add_objects_(C,a1,a2,(_i1)+(1),a4);
}
 else if((a3)==(a4)){
r37append_token(a1,a2);
r2append_in(a3,a1);
r7append(((T7*)a1),r37object_suffix(C));
}
else{
_c=((a4)-(a3))+(1);
/*[IF*/
if((_c)<=(10)){
_i1=(a3)/(10);
_i2=(a4)%(10);
r37append_token(a1,a2);
r2append_in(_i1,a1);
r7extend(((T7*)a1),((T3)'\133'));
r7extend(((T7*)a1),((T3)'0'));
r7extend(((T7*)a1),((T3)'\55'));
r2append_in(_i2,a1);
r7extend(((T7*)a1),((T3)'\135'));
r7append(((T7*)a1),r37object_suffix(C));
}
 else if((_c)<(20)){
r37add_objects_(C,a1,a2,a3,(a3)+(9));
r37add_objects_(C,a1,a2,(a3)+(10),a4);
}
else{
_i1=(a3)/(10);
_i2=((a4)-(9))/(10);
r37append_token(a1,a2);
r7extend(((T7*)a1),((T3)'\133'));
r2append_in(_i1,a1);
r7extend(((T7*)a1),((T3)'\55'));
r2append_in(_i2,a1);
r7append(((T7*)a1),((T0*)ms37_355003));
r7append(((T7*)a1),r37object_suffix(C));
_new_min=((_i2)*(10))+(10);
r37add_objects_(C,a1,a2,_new_min,a4);
}
/*FI]*/
}
/*FI]*/
}
T0*oBC37object_suffix=NULL;
int fBC37object_suffix=0;

T0* r37object_suffix(T37* C){
if(fBC37object_suffix==0){fBC37object_suffix=1;{
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3169)))){
oBC37object_suffix=((T0*)ms37_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_51699930)))){
oBC37object_suffix=((T0*)ms37_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_594)))){
oBC37object_suffix=((T0*)ms37_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_448859)))){
oBC37object_suffix=((T0*)ms37_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_76405)))){
oBC37object_suffix=((T0*)ms37_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_382130)))){
oBC37object_suffix=((T0*)ms37_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_603)))){
oBC37object_suffix=((T0*)ms37_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674)))){
oBC37object_suffix=((T0*)ms37_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_15721)))){
oBC37object_suffix=((T0*)ms37_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_17794)))){
oBC37object_suffix=((T0*)ms37_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3069)))){
oBC37object_suffix=((T0*)ms37_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_18144)))){
oBC37object_suffix=((T0*)ms37_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_207986277)))){
oBC37object_suffix=((T0*)ms37_9121);
r7to_upper(((T7*)oBC37object_suffix));
}
/*FI]*/
}}
return oBC37object_suffix;
}

void r37subdirectory(T37* C,T0* a1,T0* a2){
r37set_basic_directory_notation(C);
r38compute_subdirectory_with(a1,a2);
r7copy(((T7*)a1),oBC38last_entry);
}

void r37make(T37* C){
T0* _system_se_path=NULL;
T2 _i=0;
_system_se_path=r35getenv((T35*)(oBC18echo),((T0*)ms19_1071750288),NULL);
/*[IF*/
if((_system_se_path)==((void*)(NULL))){
_system_se_path=r7twin((T7*)(((T0*)ms19_1071750288)));
r7to_upper(((T7*)_system_se_path));
_system_se_path=r35getenv((T35*)(oBC18echo),_system_se_path,NULL);
/*[IF*/
if((_system_se_path)==((void*)(NULL))){
r35put_string((T35*)(oBC18echo),((T0*)ms37_860169684));
_system_se_path=((T0*)se_ms(34,"/usr/lib/SmallEiffel/sys/system.se"));
r35put_string((T35*)(oBC18echo),_system_se_path);
r35put_string((T35*)(oBC18echo),((T0*)ms19_216));
}
/*FI]*/
}
else{
r35put_string((T35*)(oBC18echo),((T0*)ms37_1023953763));
r35put_string((T35*)(oBC18echo),_system_se_path);
r35put_string((T35*)(oBC18echo),((T0*)ms19_1090));
}
/*FI]*/
/*[IF*/
if(r7has_suffix(((T7*)_system_se_path),((T0*)ms19_56612951))){
r35tfr_connect((T35*)(oBC18echo),oBC18tmp_file_read,_system_se_path);
}
else{
r35put_string((T35*)(oBC18echo),((T0*)se_ms(269,"You should update the value of the \"SmallEiffel\" system environment variable.\nSince release -0.79, the \"SmallEiffel\" system environment variable must be the absolute path of the \"system.se\" file.\nFor example \"/usr/lib/SmallEiffel/sys/system.se\" under Unix like system.\n")));
/*[IF*/
if(r7has(((T7*)_system_se_path),((T3)'\57'))){
r35put_string((T35*)(oBC18echo),((T0*)ms37_467476687));
r7copy((T7*)(oBC18tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC18tmp_path),((T3)'\57'));
r7append((T7*)(oBC18tmp_path),((T0*)ms19_3595));
r7extend((T7*)(oBC18tmp_path),((T3)'\57'));
r7append((T7*)(oBC18tmp_path),((T0*)ms19_56612951));
r35tfr_connect((T35*)(oBC18echo),oBC18tmp_file_read,oBC18tmp_path);
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T39*)(oBC18tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
/*[IF*/
if(r7has(((T7*)_system_se_path),((T3)'\134'))){
r35put_string((T35*)(oBC18echo),((T0*)ms37_581585530));
r7copy((T7*)(oBC18tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC18tmp_path),((T3)'\134'));
r7append((T7*)(oBC18tmp_path),((T0*)ms19_3595));
r7extend((T7*)(oBC18tmp_path),((T3)'\134'));
r7append((T7*)(oBC18tmp_path),((T0*)ms19_56612951));
r35tfr_connect((T35*)(oBC18echo),oBC18tmp_file_read,oBC18tmp_path);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T39*)(oBC18tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
/*[IF*/
if(r7has(((T7*)_system_se_path),((T3)'\72'))){
r35put_string((T35*)(oBC18echo),((T0*)ms37_1631212670));
r7copy((T7*)(oBC18tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC18tmp_path),((T3)'\72'));
r7append((T7*)(oBC18tmp_path),((T0*)ms19_3595));
r7extend((T7*)(oBC18tmp_path),((T3)'\72'));
r7append((T7*)(oBC18tmp_path),((T0*)ms19_56612951));
r35tfr_connect((T35*)(oBC18echo),oBC18tmp_file_read,oBC18tmp_path);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T39*)(oBC18tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
/*[IF*/
if(r7has(((T7*)_system_se_path),((T3)'\135'))){
r35put_string((T35*)(oBC18echo),((T0*)ms37_128214728));
r7copy((T7*)(oBC18tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC18tmp_path),((T3)'\135'));
r7remove_last((T7*)(oBC18tmp_path),1);
r7extend((T7*)(oBC18tmp_path),((T3)'\56'));
r7append((T7*)(oBC18tmp_path),((T0*)ms19_3595));
r7extend((T7*)(oBC18tmp_path),((T3)'\135'));
r7append((T7*)(oBC18tmp_path),((T0*)ms19_56612951));
r35tfr_connect((T35*)(oBC18echo),oBC18tmp_file_read,oBC18tmp_path);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T39*)(oBC18tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
r35put_string((T35*)(oBC18echo),((T0*)ms37_1106932385));
r7copy((T7*)(oBC18tmp_path),_system_se_path);
r7append((T7*)(oBC18tmp_path),((T0*)ms19_56612951));
r35tfr_connect((T35*)(oBC18echo),oBC18tmp_file_read,oBC18tmp_path);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T39*)(oBC18tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
r35w_put_string(((T0*)se_ms(244,"Unable to find file \"system.se\".\nPlease, set the environment variable \"SmallEiffel\" with the appropriate absolute path to this file.\nExample for Unix: \"/usr/lib/SmallEiffel/sys/system.se\"\nExample for DOS/Windows: \"C:\\SmallEiffel\\sys\\system.se\"\n")));
exit(1);
}
/*FI]*/
r39read_line((T39*)(oBC18tmp_file_read));
(/*SFN*/C->_system_name/*0*/)=oBC31last_string;
_i=r44index_of((T44*)(oBC37system_list),(/*RF2*/(C)->_system_name/*0*/));
/*[IF*/
if((_i)>((/*RF2*/((T44*)(oBC37system_list))->_upper/*12*/))){
r35w_put_string(((T0*)ms37_179868158));
r35w_put_string((/*RF2*/((T39*)(oBC18tmp_file_read))->_path/*1*/));
r35w_put_string(((T0*)ms37_1866433364));
_i=1;
while (!((_i)>((/*RF2*/((T44*)(oBC37system_list))->_upper/*12*/))))
{
r35w_put_string(r44item((T44*)(oBC37system_list),_i));
r35w_put_character(((T3)'\n'));
_i=(_i)+(1);
}
exit(1);
}
else{
(/*SFN*/C->_system_name/*0*/)=r44item((T44*)(oBC37system_list),_i);
r35put_string((T35*)(oBC18echo),((T0*)ms37_1102814319));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_name/*0*/));
r35put_string((T35*)(oBC18echo),((T0*)ms19_1090));
}
/*FI]*/
(/*SFN*/C->_sys_directory/*4*/)=r7twin((T7*)((/*RF2*/((T39*)(oBC18tmp_file_read))->_path/*1*/)));
/*[IRF3.6remove_suffix*/{T7* C1=(T7*)((/*RF2*/(C)->_sys_directory/*4*/));
T0* b1=((T0*)ms19_56612951);
r7remove_last(C1,(/*RF2*/(((T7*)b1))->_count/*4*/));
}/*]*/
r39disconnect((T39*)(oBC18tmp_file_read));
(/*SFN*/C->_bin_directory/*8*/)=r7twin((T7*)((/*RF2*/(C)->_sys_directory/*4*/)));
r37parent_directory(C,(/*RF2*/(C)->_bin_directory/*8*/));
r37subdirectory(C,(/*RF2*/(C)->_bin_directory/*8*/),((T0*)ms19_3085));
}

void r37parent_directory(T37* C,T0* a1){
r37set_basic_directory_notation(C);
r38compute_parent_directory_of(a1);
r7copy(((T7*)a1),oBC38last_entry);
}

void r37show_compiler_list_then_exit(T37* C){
T2 _i=0;
r35w_put_string(((T0*)ms37_270309168));
_i=1;
while (!((_i)>((/*RF2*/((T44*)(oBC37compiler_list))->_upper/*12*/))))
{
r35w_put_string(r44item((T44*)(oBC37compiler_list),_i));
r35w_put_character(((T3)'\n'));
_i=(_i)+(1);
}
exit(1);
}
T0*oBC18echo=NULL;

void r37add_external_lib(T0* a1){
r7copy((T7*)(oBC37token_buffer),a1);
r7extend_unless((T7*)(oBC37token_buffer),((T3)'\40'));
/*[IF*/
if(!(r7has_substring((T7*)(((T0*)ms37_0)),oBC37token_buffer))){
r37append_token(((T0*)ms37_0),oBC37token_buffer);
}
/*FI]*/
}

void r37command_path_in(T37* C,T0* a1,T0* a2){
/*[IF*/
if(((/*RF2*/(C)->_system_name/*0*/))==((void*)(((T0*)ms37_1663868)))){
r7append(((T7*)a1),((T0*)ms37_16702));
}
/*FI]*/
r7append(((T7*)a1),(/*RF2*/(C)->_bin_directory/*8*/));
r7append(((T7*)a1),a2);
r7append(((T7*)a1),r37x_suffix(C));
}

T6 r37is_c_plus_plus_file_path(T0* a1){
T6 R=0;
/*[IF*/
if(r7has_suffix(((T7*)a1),((T0*)ms18_8897))){
R=1;
}
 else if(r7has_suffix(((T7*)a1),((T0*)ms37_1744))){
R=1;
}
 else if(r7has_suffix(((T7*)a1),((T0*)ms37_297))){
R=1;
}
/*FI]*/
return R;
}
T0*oBC18ace=NULL;
T0*oBC37x_suffix=NULL;
int fBC37x_suffix=0;

T0* r37x_suffix(T37* C){
if(fBC37x_suffix==0){fBC37x_suffix=1;{
/*[IF*/
if((((T0*)ms37_2178))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC37x_suffix=((T0*)ms37_8976);
r7to_upper(((T7*)oBC37x_suffix));
}
 else if((((T0*)ms37_1663868))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC37x_suffix=((T0*)ms37_8976);
r7to_upper(((T7*)oBC37x_suffix));
}
 else if((((T0*)ms37_2440))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC37x_suffix=((T0*)ms37_8976);
}
 else if((((T0*)ms37_1772235))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC37x_suffix=((T0*)ms37_8976);
}
 else if((((T0*)ms37_301485))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC37x_suffix=((T0*)ms37_8976);
}
 else if((((T0*)ms37_59731))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC37x_suffix=((T0*)ms37_1438);
}
else{
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC37x_suffix=((T0*)n);
r7make(n,4);
}
}
/*FI]*/
}}
return oBC37x_suffix;
}
T0*oBC37compiler_list=NULL;
int fBC37add_lib_math=0;

void r37add_lib_math(T37* C){
if(fBC37add_lib_math==0){fBC37add_lib_math=1;{
/*[IF*/
if((((T0*)ms37_11253))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3169)))){
r37add_external_lib(((T0*)ms37_1774));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_76405)))){
r37add_external_lib(((T0*)ms37_1774));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_382130)))){
r37add_external_lib(((T0*)ms37_1774));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_603)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_15721)))){
r37add_external_lib(((T0*)ms37_1774));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_17794)))){
/*[IF*/
if((((T0*)ms37_57487))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r37add_external_lib(((T0*)ms37_1125006));
}
else{
r37add_external_lib(((T0*)ms37_1774));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3069)))){
r37add_external_lib(((T0*)ms37_223953));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_18144)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_207986277)))){
}
/*FI]*/
}}}

void r37add_objects(T37* C,T0* a1,T0* a2,T2 a3){
T2 _i=0;
T6 _short_command=0;
/*[IF*/
if(r2in_range(a3,3,99)){
/*[IF*/
if((((T0*)ms37_13028))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
_short_command=1;
}
 else if((((T0*)ms37_301485))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
_short_command=1;
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(_short_command){
r37add_objects_(C,a1,a2,1,a3);
}
else{
_i=1;
while (!((_i)>(a3)))
{
r37append_token(a1,a2);
r2append_in(_i,a1);
r7append(((T7*)a1),r37object_suffix(C));
_i=(_i)+(1);
}
}
/*FI]*/
}
int fBC37set_basic_directory_notation=0;

void r37set_basic_directory_notation(T37* C){
if(fBC37set_basic_directory_notation==0){fBC37set_basic_directory_notation=1;{
T0* _s=NULL;
T3 _letter_code=0;
_s=(/*RF2*/(C)->_system_name/*0*/);
/*[IF*/
if((_s)==((void*)(NULL))){
}
 else if((_s)==((void*)(((T0*)ms37_13028)))){
_letter_code=((T3)'U');
}
 else if((((_s)==((void*)(((T0*)ms37_1772235))))||((_s)==((void*)(((T0*)ms37_2178)))))||((_s)==((void*)(((T0*)ms37_2440))))){
_letter_code=((T3)'W');
}
 else if((_s)==((void*)(((T0*)ms37_11253)))){
_letter_code=((T3)'U');
}
 else if((_s)==((void*)(((T0*)ms37_39617954)))){
_letter_code=((T3)'M');
}
 else if((_s)==((void*)(((T0*)ms37_57487)))){
_letter_code=((T3)'A');
}
 else if((_s)==((void*)(((T0*)ms37_1663868)))){
_letter_code=((T3)'V');
}
 else if((_s)==((void*)(((T0*)ms37_301485)))){
_letter_code=((T3)'C');
}
 else if((_s)==((void*)(((T0*)ms37_59731)))){
_letter_code=((T3)'U');
}
else{
}
/*FI]*/
/*[IF*/
if((_s)!=((void*)(NULL))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(_letter_code);
/*]*/
}
/*FI]*/
}}}

T0* r37sas_c_compiler_options(T6 a1){
T0* R=NULL;
/*[IF*/
if(r37Scoptions_exists()){
R=((T0*)se_ms(0,""));
}
else{
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
r7make(n,0);
R=((T0*)n);
}
r7append(((T7*)R),((T0*)ms37_1721407046));
/*[IF*/
if(a1){
r7append(((T7*)R),((T0*)ms37_19761224));
}
else{
r7append(((T7*)R),((T0*)ms37_98806116));
}
/*FI]*/
r7append(((T7*)R),((T0*)ms37_1494914262));
r7append(((T7*)R),((T0*)ms37_721564652));
}
/*FI]*/
return R;
}

void r37split_mode_linker_command(T37* C,T0* a1,T0* a2,T2 a3){
T0* _script=NULL;
T0* _lst=NULL;
T2 _i=0;
T0* _name=NULL;
/*[IRF3.3clear*/((((T7*)(((T7*)a1))))->_count/*4*/)=(0);
/*]*/
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3169)))){
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms37_0aa)))->_count/*4*/))==(0)/*)*/){
r7append(((T7*)a1),((T0*)ms37_3169));
}
else{
r7append(((T7*)a1),((T0*)ms37_2833));
}
/*FI]*/
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_51699930)))){
r37external_c_files_for_lcc_win32(C,a1);
r7append(((T7*)a1),((T0*)ms37_415107));
/*[IF*/
if(!((/*RF2*/(C)->_no_strip/*12*/))){
r37append_token(a1,((T0*)ms37_340));
}
/*FI]*/
r37append_token(a1,((T0*)ms37_0aaaaa));
r37add_executable_name(C,a1);
/*[IF*/
if((a3)<(4)){
r37add_objects(C,a1,a2,a3);
}
else{
_name=a2;
r7append(((T7*)_name),((T0*)ms37_9107));
r37append_token(a1,r7_px_43(se_ms(1,"@"),_name));
{T53*n=((T53*)se_malloc(sizeof(*n))/*8*/);
*n=M53;
/*[IRF3.1make*//*]*/
_lst=((T0*)n);
}
r35tfw_connect((T35*)(oBC18echo),_lst,_name);
r7remove_last(((T7*)_name),4);
_i=1;
while (!((_i)>(a3)))
{
r53put_string(((T53*)_lst),_name);
r53put_integer(((T53*)_lst),_i);
r53put_string(((T53*)_lst),((T0*)ms37_9121));
/*[IRF3.4put_new_line*//*[IRF3.6put_character*/{T53* C1=((T53*)_lst);
T3 b1=((T3)'\n');
basic_io_putc(b1,(/*RF2*/(C1)->_output_stream/*4*/));
}/*]*/
/*]*/
_i=(_i)+(1);
}
r53disconnect(((T53*)_lst));
}
/*FI]*/
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_594)))){
r7append(((T7*)a1),((T0*)ms37_594));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_448859)))){
r7append(((T7*)a1),((T0*)ms37_91157));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_76405)))){
r7append(((T7*)a1),((T0*)ms37_76405));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_382130)))){
r7append(((T7*)a1),((T0*)ms37_382130));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_603)))){
r7append(((T7*)a1),((T0*)ms37_603));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674)))){
r7append(((T7*)a1),((T0*)ms37_674));
r37append_token(a1,r37sas_c_compiler_options(1));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,a2);
r7append(((T7*)a1),((T0*)ms37_2075119688));
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
r37add_executable_name(C,a1);
/*[IF*/
if(!((/*RF2*/(C)->_no_strip/*12*/))){
r7append(((T7*)a1),((T0*)ms37_530877013));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_15721)))){
r7append(((T7*)a1),((T0*)ms37_3094));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
/*[IF*/
if((/*RF2*/(C)->_no_strip/*12*/)){
r37append_token(a1,((T0*)ms37_218174));
}
/*FI]*/
r37add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_17794)))){
r7append(((T7*)a1),((T0*)ms37_689));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_lib_math(C);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_3069)))){
r7append(((T7*)a1),((T0*)ms37_3069));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_18144)))){
r7append(((T7*)a1),((T0*)ms37_18144));
r37append_token(a1,((T0*)ms37_0aaaaaa));
r37append_token(a1,((T0*)ms37_0aaaaa));
r37append_token(a1,((T0*)ms37_0aaaa));
r37add_executable_name(C,a1);
r37add_objects(C,a1,a2,a3);
r37append_token(a1,((T0*)ms37_0aaa));
r37append_token(a1,((T0*)ms37_0aa));
r37append_token(a1,((T0*)ms37_0a));
r37append_token(a1,((T0*)ms37_0));
}
 else if(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_207986277)))){
{T53*n=((T53*)se_malloc(sizeof(*n))/*8*/);
*n=M53;
/*[IRF3.1make*//*]*/
_script=((T0*)n);
}
r35tfw_connect((T35*)(oBC18echo),_script,((T0*)ms37_262628264));
r53put_string(((T53*)_script),((T0*)ms37_466551816));
/*[IRF3.3clear*/((((T7*)(((T7*)a1))))->_count/*4*/)=(0);
/*]*/
r37add_executable_name(C,a1);
r53put_string(((T53*)_script),a1);
/*[IRF3.6put_character*/{T53* C1=((T53*)_script);
T3 b1=((T3)'\40');
basic_io_putc(b1,(/*RF2*/(C1)->_output_stream/*4*/));
}/*]*/
_i=1;
while (!((_i)>=(a3)))
{
r53put_string(((T53*)_script),a2);
r53put_integer(((T53*)_script),_i);
r53put_string(((T53*)_script),((T0*)ms37_1335));
_i=(_i)+(1);
}
r53put_string(((T53*)_script),a2);
r53put_integer(((T53*)_script),_i);
/*[IRF3.6put_character*/{T53* C1=((T53*)_script);
T3 b1=((T3)'\n');
basic_io_putc(b1,(/*RF2*/(C1)->_output_stream/*4*/));
}/*]*/
r53disconnect(((T53*)_script));
/*[IRF3.3clear*/((((T7*)(((T7*)a1))))->_count/*4*/)=(0);
/*]*/
r7append(((T7*)a1),((T0*)ms37_1361085152));
}
/*FI]*/
}

void r37remove_other_extra_files(T37* C,T0* a1){
T0* _n=NULL;
/*[IF*/
if((((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_51699930))))||(((/*RF2*/(C)->_c_compiler/*21*/))==((void*)(((T0*)ms37_674))))){
_n=r7_px_43(((T7*)a1),((T0*)ms37_9107));
r35file_removing((T35*)(oBC18echo),_n);
}
/*FI]*/
}

T2 r48upper(T48* C){
T2 R=0;
R=((/*RF2*/((T51*)((/*RF2*/(C)->_name_list/*13*/)))->_upper/*12*/))+(1);
return R;
}

void r48make(T48* C){
/*[IF*/
if(((/*RF2*/(C)->_name_list/*13*/))==((void*)(NULL))){
{T51*n=((T51*)se_malloc(sizeof(*n))/*16*/);
*n=M51;
r51with_capacity(n,32);
(/*SFN*/C->_name_list/*13*/)=((T0*)n);
}
}
else{
/*[IRF3.3clear*/((((T51*)((T51*)((/*RF2*/(C)->_name_list/*13*/)))))->_upper/*12*/)=(-(1));
/*]*/
}
/*FI]*/
}

void r48scan_current_working_directory(T48* C){
T0* _entry=NULL;
r48make(C);
r38connect_to_current_working_directory(&((/*RF2*/(C)->_basic_directory/*5*/)));
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*5*/))._directory_stream/*0*/))/*)*/){
(/*SFN*/C->_path/*0*/)=r7twin((T7*)(oBC38last_entry));
r38read_entry(&((/*RF2*/(C)->_basic_directory/*5*/)));
while (!(/*(IRF4.6end_of_input*/r8is_null(((T8)((/*RF2*/((/*RF2*/(C)->_basic_directory/*5*/))._current_entry/*4*/))))/*)*/))
{
_entry=r7twin((T7*)(oBC38last_entry));
r51add_last((T51*)((/*RF2*/(C)->_name_list/*13*/)),_entry);
r38read_entry(&((/*RF2*/(C)->_basic_directory/*5*/)));
}
r38disconnect(&((/*RF2*/(C)->_basic_directory/*5*/)));
(/*SFN*/C->_last_scan_status/*4*/)=1;
}
else{
(/*SFN*/C->_last_scan_status/*4*/)=0;
}
/*FI]*/
}

void r53disconnect(T53* C){
basic_io_fclose((/*RF2*/(C)->_output_stream/*4*/));
(/*SFN*/C->_path/*0*/)=NULL;
}
T0*oBC34tmp_string=NULL;

void r53connect_to(T53* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
(/*SFN*/C->_output_stream/*4*/)=basic_io_text_file_write_open(_p);
/*[IF*/
if((NULL!=(/*RF2*/(C)->_output_stream/*4*/))){
(/*SFN*/C->_path/*0*/)=a1;
}
/*FI]*/
}

void r53put_integer(T53* C,T2 a1){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC34tmp_string))))->_count/*4*/)=(0);
/*]*/
r2append_in(a1,oBC34tmp_string);
r53put_string(C,oBC34tmp_string);
}

void r53put_string(T53* C,T0* a1){
T2 _i=0;
_i=1;
while (!((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/))))
{
/*[IRF3.6put_character*/{T53* C1=C;
T3 b1=/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/;
basic_io_putc(b1,(/*RF2*/(C1)->_output_stream/*4*/));
}/*]*/
_i=(_i)+(1);
}
}

void r33put_string(T0* a1){
T2 _i=0;
_i=1;
while (!((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/))))
{
/*[IRF3.6put_character*/{T3 b1=/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/;
basic_io_putc(b1,basic_io_stdout);
}/*]*/
_i=(_i)+(1);
}
}

void r46put_string(T0* a1){
T2 _i=0;
_i=1;
while (!((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/))))
{
/*[IRF3.6put_character*/{T3 b1=/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/;
basic_io_putc(b1,basic_io_stderr);
}/*]*/
_i=(_i)+(1);
}
}

T6 r49file_exists(T0* a1){
T6 R=0;
R=r49is_readable(a1);
return R;
}

void r49rename_to(T0* a1,T0* a2){
T8 _p1=NULL;
T8 _p2=NULL;
/*[IF*/
if(r49file_exists(a2)){
r49delete(a2);
}
/*FI]*/
_p1=r7to_external(((T7*)a1));
_p2=r7to_external(((T7*)a2));
basic_io_rename(_p1,_p2);
}
T0*oBC49tfr1=NULL;

void r49delete(T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
basic_io_remove(_p);
}

T6 r49is_readable(T0* a1){
T6 R=0;
r39connect_to((T39*)(oBC49tfr1),a1);
R=/*(IRF4.7is_connected*/((/*RF2*/((T39*)(oBC49tfr1))->_path/*1*/))!=(NULL)/*)*/;
/*[IF*/
if(R){
r39disconnect((T39*)(oBC49tfr1));
}
/*FI]*/
return R;
}

void r16prepare_bin_c_directory(T16* C){
T2 _i=0;
T0* _args=NULL;
T0* _item=NULL;
_i=1;
while (!((_i)>(r44count((T44*)(oBC16no_split_command_list)))))
{
_item=r44item((T44*)(oBC16no_split_command_list),_i);
/*[IF*/
if(r7same_as(se_ms(9,"lcc-win32"),(/*RF2*/(C)->_c_compiler_name/*28*/))){
_args=((T0*)se_ms(16,"-boost -no_split"));
}
else{
_args=((T0*)se_ms(23,"-boost -no_split -no_gc"));
}
/*FI]*/
r16call_compile_to_c(_args,_item);
_i=(_i)+(1);
}
_i=1;
while (!((_i)>(r44count((T44*)(oBC16splitted_command_list)))))
{
_item=r44item((T44*)(oBC16splitted_command_list),_i);
/*[IF*/
if(r7same_as(se_ms(9,"lcc-win32"),(/*RF2*/(C)->_c_compiler_name/*28*/))){
_args=((T0*)se_ms(6,"-boost"));
}
else{
_args=((T0*)se_ms(13,"-boost -no_gc"));
}
/*FI]*/
r16call_compile_to_c(_args,_item);
_i=(_i)+(1);
}
}

T6 r16is_version_flag(T16* C,T0* a1){
T6 R=0;
/*[IF*/
if((r16flag_match(((T0*)ms19_2248290),a1))||(r16flag_match(((T0*)ms17_118),a1))){
/*[IF*/
if(!((/*RF2*/(C)->_version_flag/*1*/))){
r33put_string(((T0*)ms17_1042405932));
r33put_string(((T0*)ms16_2073823));
r33put_string(((T0*)ms17_142550));
r33put_string(((T0*)ms58_1126833709));
}
/*FI]*/
/*[INSPECT*/
{int z1=/*(IRF4.9argument_count*/(/*RF2*/((T51*)(r16command_arguments()))->_upper/*12*/)/*)*/;
switch(z1){
case 1:
exit(0);
break;
case 2:
/*[IF*/
if((/*RF2*/(C)->_help_flag/*0*/)){
exit(0);
}
/*FI]*/
break;
}
}/*INSPECT]*/
(/*SFN*/C->_version_flag/*1*/)=1;
R=1;
}
/*FI]*/
return R;
}

void r16echo_variable(T0* a1,T0* a2){
r35put_string((T35*)(oBC18echo),a1);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(4," = \"")));
r35put_string((T35*)(oBC18echo),a2);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
}

void r16gathered_information_summary(T16* C){
r33put_string(((T0*)se_ms(64,"-----\nSummary of gathered information :\n   installation_path = \"")));
r33put_string((/*RF2*/(C)->_installation_path/*8*/));
r33put_string(((T0*)se_ms(20,"\"\n   system_name = \"")));
r33put_string((/*RF2*/(C)->_system_name/*12*/));
r33put_string(((T0*)se_ms(24,"\"\n   c_compiler_name = \"")));
r33put_string((/*RF2*/(C)->_c_compiler_name/*28*/));
r33put_string(((T0*)se_ms(2,"\"\n")));
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms16_0)))->_count/*4*/))==(0)/*)*/)){
r33put_string(((T0*)se_ms(32,"   c_compiler_linker_options = \"")));
r33put_string(((T0*)ms16_0));
r33put_string(((T0*)se_ms(2,"\"\n")));
}
/*FI]*/
r33put_string(((T0*)se_ms(24,"   garbage_collector = \"")));
r33put_string((/*RF2*/(C)->_garbage_collector/*24*/));
r33put_string(((T0*)se_ms(2,"\"\n")));
/*[IF*/
if((/*RF2*/(C)->_interactive/*2*/)){
/*[IF*/
if(!(r16yes_or_no(((T0*)se_ms(21,"Continue installation")),1))){
r33put_string(((T0*)se_ms(34,"SmallEiffel installation aborted.\n")));
r16install_exit(C,0);
}
/*FI]*/
}
/*FI]*/
r33put_string(((T0*)se_ms(40,"---\nSmallEiffel\'s bootstrap started ...\n")));
}

T6 r16yes_or_no(T0* a1,T6 a2){
T6 R=0;
T0* _answer=NULL;
r33put_string(a1);
r33put_string(((T0*)se_ms(10," (yes/no)?")));
/*[IF*/
if(a2){
r33put_string(((T0*)se_ms(5,"[yes]")));
}
else{
r33put_string(((T0*)se_ms(4,"[no]")));
}
/*FI]*/
/*[IRF3.2flush*/basic_io_flush(basic_io_stdout);
/*]*/
r30read_line((T30*)(oBC1std_input));
_answer=oBC31last_string;
r7to_lower(((T7*)_answer));
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/(((T7*)_answer))->_count/*4*/))==(0)/*)*/){
R=a2;
}
 else if((((r7is_equal(se_ms(1,"y"),_answer))||(r7is_equal(se_ms(3,"yes"),_answer)))||(r7is_equal(se_ms(1,"o"),_answer)))||(r7is_equal(se_ms(3,"oui"),_answer))){
R=1;
}
 else if(((r7is_equal(se_ms(1,"n"),_answer))||(r7is_equal(se_ms(2,"no"),_answer)))||(r7is_equal(se_ms(3,"non"),_answer))){
}
else{
r33put_string(((T0*)se_ms(31,"yes or no ?\nThis is not clear.\n")));
R=r16yes_or_no(a1,a2);
}
/*FI]*/
return R;
}

T6 r16file_exists(T0* a1){
T6 R=0;
R=r49is_readable(a1);
return R;
}

void r16set_bin_c_directory_path(T16* C){
(/*SFN*/C->_bin_c_directory_path/*36*/)=r7twin((T7*)((/*RF2*/(C)->_installation_path/*8*/)));
r38compute_subdirectory_with((/*RF2*/(C)->_bin_c_directory_path/*36*/),((T0*)se_ms(5,"bin_c")));
(/*SFN*/C->_bin_c_directory_path/*36*/)=r7twin((T7*)(oBC38last_entry));
}
T0*oBC16system_tools=NULL;

void r16call_compile_to_c(T0* a1,T0* a2){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC16command))))->_count/*4*/)=(0);
/*]*/
r37command_path_in((T37*)(oBC16system_tools),oBC16command,((T0*)se_ms(12,"compile_to_c")));
r7extend((T7*)(oBC16command),((T3)'\40'));
r7append((T7*)(oBC16command),a1);
r7append((T7*)(oBC16command),((T0*)se_ms(4," -o ")));
r7append((T7*)(oBC16command),a2);
r7extend((T7*)(oBC16command),((T3)'\40'));
r7append((T7*)(oBC16command),a2);
r33put_string(oBC16command);
r33put_string(((T0*)se_ms(1,"\n")));
r35system_call((T35*)(oBC18echo),oBC16command);
}
T0*oBC1command_arguments=NULL;
int fBC1command_arguments=0;

T0* r16command_arguments(void){
if(fBC1command_arguments==0){fBC1command_arguments=1;{
T2 _i=0;
T0* _arg=NULL;
_i=se_argc;
{T51*n=((T51*)se_malloc(sizeof(*n))/*16*/);
*n=M51;
oBC1command_arguments=((T0*)n);
r51make(n,_i);
}
while (!((_i)==(0)))
{
_i=(_i)-(1);
_arg=((T0*)se_string(se_argv[_i]));
/*[IRF3.5put*/((/*RF2*/(((T51*)oBC1command_arguments))->_storage/*4*/))[_i]=(_arg);
/*]*/
}
}}
return oBC1command_arguments;
}

void r16interactive_c_compiler_linker_options(T16* C){
r33put_string(((T0*)se_ms(90,"-----\nIt is possible to add some default option(s) to be passed\nto the C compiler/linker.\n")));
/*[IF*/
if(r7same_as(se_ms(3,"gcc"),(/*RF2*/(C)->_c_compiler_name/*28*/))){
r33put_string(((T0*)se_ms(152,"With gcc the -pipe option is recommended (unfortunately\nthis is not supported for all platforms).\nThe -pipe option is supported on all Linux platforms.\n")));
}
/*FI]*/
r33put_string(((T0*)se_ms(64,"Enter now one single line for extra option(s) or an empty line:\n")));
r30read_line((T30*)(oBC1std_input));
r7copy((T7*)(((T0*)ms16_0)),oBC31last_string);
}

void r16set_installation_path(T16* C){
T0* _string=NULL;
r35put_string((T35*)(oBC18echo),((T0*)se_ms(48,"Checking that the SmallEiffel directory exists:\n")));
_string=r7twin((T7*)((/*RF2*/(C)->_system_se_path/*4*/)));
r38compute_parent_directory_of(_string);
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(40,"Unable to compute parent directory \nof \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_se_path/*4*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
_string=r7twin((T7*)(oBC38last_entry));
r38compute_parent_directory_of(_string);
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(40,"Unable to compute parent directory \nof \"")));
r35put_string((T35*)(oBC18echo),_string);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
(/*SFN*/C->_installation_path/*8*/)=r7twin((T7*)(oBC38last_entry));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(31,"SmallEiffel directory path is \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_installation_path/*8*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
}
T0*oBC16tfr=NULL;

void r16c_compile_no_split_command_list(T16* C){
T0* _item=NULL;
T2 _i=0;
_i=1;
while (!((_i)>(r44count((T44*)(oBC16no_split_command_list)))))
{
_item=r44item((T44*)(oBC16no_split_command_list),_i);
r16no_split_mode_c_compile(C,_item);
_i=(_i)+(1);
}
}
T0*oBC1std_input=NULL;
T0*oBC16tfw=NULL;
T0*oBC18small_eiffel=NULL;

T6 r16flag_match(T0* a1,T0* a2){
T6 R=0;
T2 _i_flag=0;
T2 _i_arg=0;
_i_arg=(/*RF2*/(((T7*)a2))->_count/*4*/);
/*[IF*/
if((_i_arg)>=(2)){
_i_flag=(/*RF2*/(((T7*)a1))->_count/*4*/);
/*[INSPECT*/
{int z1=/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/;
switch(z1){
case 45:
/*[IF*/
if((/*(IRF4.6item*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[(2)-(1)]/*)*/)==(((T3)'\55'))){
R=((_i_flag)+(2))==(_i_arg);
}
else{
R=((_i_flag)+(1))==(_i_arg);
}
/*FI]*/
break;
case 47:
R=((_i_flag)+(1))==(_i_arg);
break;
}
}/*INSPECT]*/
while (!((!(R))||((_i_flag)==(0))))
{
/*[IF*/
if(r3same_as(/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i_flag)-(1)]/*)*/,/*(IRF4.6item*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[(_i_arg)-(1)]/*)*/)){
_i_arg=(_i_arg)-(1);
_i_flag=(_i_flag)-(1);
}
else{
R=0;
}
/*FI]*/
}
}
/*FI]*/
return R;
}

void r16set_garbage_collector_file_path(T16* C){
T0* _path=NULL;
r35put_string((T35*)(oBC18echo),((T0*)se_ms(24,"Computing GC file path:\n")));
_path=r7twin((T7*)((/*RF2*/(C)->_installation_path/*8*/)));
r38compute_subdirectory_with(_path,((T0*)se_ms(3,"sys")));
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(39,"Unable to compute directory path with \"")));
r35put_string((T35*)(oBC18echo),_path);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(13,"\" and \"sys\".\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
_path=r7twin((T7*)(oBC38last_entry));
r38compute_file_path_with(_path,((T0*)se_ms(2,"gc")));
_path=r7twin((T7*)(oBC38last_entry));
(/*SFN*/C->_garbage_collector_file_path/*20*/)=_path;
r35put_string((T35*)(oBC18echo),((T0*)se_ms(17,"GC file path is \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_garbage_collector_file_path/*20*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(13,"\" and \"sys\".\n")));
}

void r16open_vms_entry_patch(T16* C,T0* a1){
T6 _stop=0;
T0* _s=NULL;
/*[IF*/
if(r7same_as(se_ms(7,"OpenVMS"),(/*RF2*/(C)->_system_name/*12*/))){
r7to_lower(((T7*)a1));
_s=r7twin(((T7*)a1));
while (!(_stop))
{
/*[IF*/
if(((/*RF2*/(((T7*)_s))->_count/*4*/))==(0)){
_stop=1;
}
 else if((r7last(((T7*)_s)))==(((T3)'\73'))){
r7remove_last(((T7*)_s),1);
r7copy(((T7*)a1),_s);
_stop=1;
}
 else if(r3is_decimal_digit(r7last(((T7*)_s)))){
r7remove_last(((T7*)_s),1);
}
else{
_stop=1;
}
/*FI]*/
}
r16echo_variable(((T0*)se_ms(7,"OpenVMS")),a1);
}
/*FI]*/
}
T0*oBC16splitted_command_list=NULL;

void r16set_bin_directory_path(T16* C){
(/*SFN*/C->_bin_directory_path/*32*/)=r7twin((T7*)((/*RF2*/(C)->_installation_path/*8*/)));
r38compute_subdirectory_with((/*RF2*/(C)->_bin_directory_path/*32*/),((T0*)se_ms(3,"bin")));
(/*SFN*/C->_bin_directory_path/*32*/)=r7twin((T7*)(oBC38last_entry));
r38connect_to(&((/*RF2*/(C)->_basic_directory/*40*/)),(/*RF2*/(C)->_bin_directory_path/*32*/));
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*40*/))._directory_stream/*0*/))/*)*/){
r38disconnect(&((/*RF2*/(C)->_basic_directory/*40*/)));
}
 else if(r38create_new_directory((/*RF2*/(C)->_bin_directory_path/*32*/))){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(11,"Directory \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_bin_directory_path/*32*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(11,"\" created.\n")));
}
else{
r35put_string((T35*)(oBC18echo),((T0*)se_ms(11,"Directory \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_bin_directory_path/*32*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(13,"\" not found.\n")));
}
/*FI]*/
}

void r16make(T16* C){
T2 _i=0;
T0* _arg=NULL;
T6 _b=0;
_i=1;
while (!((_i)>(/*(IRF4.9argument_count*/(/*RF2*/((T51*)(r16command_arguments()))->_upper/*12*/)/*)*/)))
{
_arg=r16argument(_i);
/*[IF*/
if(r16is_version_flag(C,_arg)){
}
 else if(r16flag_match(((T0*)se_ms(5,"debug")),_arg)){
/*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
}
 else if(r16flag_match(((T0*)se_ms(11,"interactive")),_arg)){
(/*SFN*/C->_interactive/*2*/)=1;
}
 else if(r16flag_match(((T0*)se_ms(18,"skip_c_compilation")),_arg)){
(/*SFN*/C->_skip_c_compilation/*3*/)=1;
}
 else if(r16flag_match(((T0*)se_ms(2,"cc")),_arg)){
/*[IF*/
if((_i)<(/*(IRF4.9argument_count*/(/*RF2*/((T51*)(r16command_arguments()))->_upper/*12*/)/*)*/)){
_i=(_i)+(1);
(/*SFN*/C->_c_compiler_name/*28*/)=r16argument(_i);
}
else{
r33put_string(((T0*)se_ms(44,"compiler name must be specified after \"-cc\"\n")));
r16echo_usage_exit(C);
}
/*FI]*/
}
else{
r16echo_usage_exit(C);
}
/*FI]*/
_i=(_i)+(1);
}
r33put_string(((T0*)se_ms(32,"Install of SmallEiffel started.\n")));
/*[IF*/
if((/*RF2*/(C)->_interactive/*2*/)){
(/*SFN*/C->_interactive/*2*/)=r16yes_or_no(((T0*)se_ms(223,"Do you want to continue the installation of SmallEiffel with\nthe -interactive mode activated?\nActually, there are just a few questions to answer and then\nall the process is automatic.\nContinue the with the -interactive mode")),1);
}
/*FI]*/
/*[IF*/
if(((/*RF2*/(C)->_interactive/*2*/))&&(!((/*RF2*/((T35*)(oBC18echo))->_verbose/*0*/)))){
_b=r16yes_or_no(((T0*)se_ms(279,"Do you want to see all what\'s done during the installation (i.e. to switch\non the -debug mode)?\nActually, the -debug mode is really verbose and is really useful only in\ncase of problem. Also note that you can always rerun this install procedure.\nAdd the -debug verbose option now")),0);
/*[IF*/
if(_b){
/*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!((/*RF2*/(C)->_interactive/*2*/))){
r33put_string(((T0*)se_ms(38,"Automatic installation in progress...\n")));
}
/*FI]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(20,"Version of command \"")));
r35put_string((T35*)(oBC18echo),((T0*)ms16_2073823));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(6,"\" is:\n")));
r35put_string((T35*)(oBC18echo),((T0*)ms58_1126833709));
r38connect_to_current_working_directory(&((/*RF2*/(C)->_basic_directory/*40*/)));
(/*SFN*/C->_cwd/*48*/)=r7twin((T7*)(oBC38last_entry));
r16echo_variable(((T0*)se_ms(23,"CurrentWorkingDirectory")),(/*RF2*/(C)->_cwd/*48*/));
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*40*/))._directory_stream/*0*/))/*)*/){
r38disconnect(&((/*RF2*/(C)->_basic_directory/*40*/)));
}
/*FI]*/
r16set_system_se_path(C);
r16set_installation_path(C);
r16set_system_name(C);
r16write_default_loadpath_se_file(C);
r16set_compiler_se_path(C);
r16set_garbage_collector_file_path(C);
r16garbage_collector_selection(C);
r16set_c_compiler_name(C);
r16set_bin_directory_path(C);
r16set_bin_c_directory_path(C);
r38change_current_working_directory(&((/*RF2*/(C)->_basic_directory/*40*/)),(/*RF2*/(C)->_bin_c_directory_path/*36*/));
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(48,"Unable to change current working directory \nto \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_bin_c_directory_path/*36*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
r16gathered_information_summary(C);
/*[IF*/
if((/*RF2*/(C)->_skip_c_compilation/*3*/)){
}
else{
r33put_string(((T0*)se_ms(16,"C Compiling in \"")));
r33put_string(oBC38last_entry);
r33put_string(((T0*)se_ms(3,"\".\n")));
r16split_mode_c_compile(C,((T0*)se_ms(12,"compile_to_c")));
r16prepare_bin_c_directory(C);
r16c_compile_no_split_command_list(C);
r16c_compile_splitted_command_list(C);
r16clean_bin_c_directory_path(C);
}
/*FI]*/
r16restore_current_working_directory(C);
r33put_string(((T0*)se_ms(31,"SmallEiffel installation done.\n")));
r16check_system_path_variable_warning(C);
r16install_exit(C,0);
}

void r16set_c_compiler_name(T16* C){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(22,"C compiler selection:\n")));
/*[IF*/
if(((/*RF2*/(C)->_c_compiler_name/*28*/))==((void*)(NULL))){
/*[IF*/
if(r7same_as(se_ms(6,"Cygwin"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_c_compiler_name/*28*/)=((T0*)se_ms(3,"gcc"));
r7copy((T7*)(((T0*)ms16_0)),((T0*)se_ms(3,"-O2")));
}
 else if(r7same_as(se_ms(5,"Elate"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_c_compiler_name/*28*/)=((T0*)se_ms(4,"vpcc"));
}
 else if(r7same_as(se_ms(7,"OpenVMS"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_c_compiler_name/*28*/)=((T0*)se_ms(10,"OpenVMS_CC"));
}
 else if(!((/*RF2*/(C)->_interactive/*2*/))){
/*[IF*/
if(r7same_as(se_ms(4,"UNIX"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_c_compiler_name/*28*/)=((T0*)se_ms(3,"gcc"));
/*[IF*/
if(r7same_as(se_ms(7,"linux.c"),(/*RF2*/(C)->_garbage_collector/*24*/))){
r7copy((T7*)(((T0*)ms16_0)),((T0*)se_ms(5,"-pipe")));
}
 else if(r7same_as(se_ms(7,"sparc.c"),(/*RF2*/(C)->_garbage_collector/*24*/))){
r7copy((T7*)(((T0*)ms16_0)),((T0*)se_ms(5,"-pipe")));
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(((/*RF2*/(C)->_c_compiler_name/*28*/))==((void*)(NULL))){
(/*SFN*/C->_c_compiler_name/*28*/)=r16choice_in(((T0*)se_ms(20,"C compiler selection")),oBC37compiler_list);
}
/*FI]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(24,"Selected C compiler is \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_c_compiler_name/*28*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(15,"Try to update \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_compiler_se_path/*16*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r35tfw_connect((T35*)(oBC18echo),oBC16tfw,(/*RF2*/(C)->_compiler_se_path/*16*/));
r16tfw_check_is_connected(C,(/*RF2*/(C)->_compiler_se_path/*16*/));
r53put_string((T53*)(oBC16tfw),(/*RF2*/(C)->_c_compiler_name/*28*/));
/*[IF*/
if((/*RF2*/(C)->_interactive/*2*/)){
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms16_0)))->_count/*4*/))==(0)/*)*/){
r16interactive_c_compiler_linker_options(C);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms16_0)))->_count/*4*/))==(0)/*)*/)){
/*[IRF3.6put_character*/{T53* C1=(T53*)(oBC16tfw);
T3 b1=((T3)'\40');
basic_io_putc(b1,(/*RF2*/(C1)->_output_stream/*4*/));
}/*]*/
r53put_string((T53*)(oBC16tfw),((T0*)ms16_0));
}
/*FI]*/
/*[IRF3.6put_character*/{T53* C1=(T53*)(oBC16tfw);
T3 b1=((T3)'\n');
basic_io_putc(b1,(/*RF2*/(C1)->_output_stream/*4*/));
}/*]*/
r53disconnect((T53*)(oBC16tfw));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(11,"Update of \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_compiler_se_path/*16*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(8,"\" done.\n")));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(138,"Hint: It is possible to change some default option(s) for the C compiler\njust after the compiler name in the very first line of the\nfile \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_compiler_se_path/*16*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(122,"\".\nFor example, the very first line can be \"gcc -pipe -O3\".\nIf you are no an expert of C compilation, do not add options.\n")));
r37set_c_compiler((T37*)(oBC16system_tools),NULL);
r37install_extra_options((T37*)(oBC16system_tools));
}

void r16set_system_se_path(T16* C){
T0* _string=NULL;
r35put_string((T35*)(oBC18echo),((T0*)se_ms(45,"Checking \"SmallEiffel\" environment variable:\n")));
(/*SFN*/C->_system_se_path/*4*/)=r35getenv((T35*)(oBC18echo),((T0*)ms19_1071750288),NULL);
/*[IF*/
if((((/*RF2*/(C)->_system_se_path/*4*/))==((void*)(NULL)))||(((/*RF2*/((T7*)((/*RF2*/(C)->_system_se_path/*4*/)))->_count/*4*/))==(0))){
_string=r7twin((T7*)(((T0*)ms19_1071750288)));
r7to_upper(((T7*)_string));
(/*SFN*/C->_system_se_path/*4*/)=r35getenv((T35*)(oBC18echo),_string,NULL);
}
/*FI]*/
/*[IF*/
if((((/*RF2*/(C)->_system_se_path/*4*/))==((void*)(NULL)))||(((/*RF2*/((T7*)((/*RF2*/(C)->_system_se_path/*4*/)))->_count/*4*/))==(0))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(138,"Environment variable \"SmallEiffel\" is not set.\nPlease, set this variable with the absolute path of \nthe \"SmallEiffel/sys/system.se\" file.\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
/*[IF*/
if(!(r7has_suffix((T7*)((/*RF2*/(C)->_system_se_path/*4*/)),((T0*)se_ms(9,"system.se"))))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(52,"Value of the Environment variable \"SmallEiffel\"\nis \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_se_path/*4*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(298,"Please, set this variable with the absolute path of\nthe \"SmallEiffel/sys/system.se\" file.\nFor example, on Linux, the value is\noften \"/usr/lib/SmallEiffel/sys/system.se\".\nOn Windows, \"C:\\SmallEiffel\\sys\\system.se\" is a correct value\nwhen the SmallEiffel directory is at toplevel of the C hard disk.\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
/*[IF*/
if(!(r16file_exists((/*RF2*/(C)->_system_se_path/*4*/)))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(58,"Value of the Environment variable \"SmallEiffel\" value\nis \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_se_path/*4*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(30,"\".\nThere is no readable file \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_se_path/*4*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(56,"\".\nCheck this absolute path as well as read permission.\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(94,"Value of the Environment variable \"SmallEiffel\" is correctly set\nto some existing file\npath (\"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_se_path/*4*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(4,"\").\n")));
r38reset_notation_using((/*RF2*/(C)->_system_se_path/*4*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(36,"File/directory path handling with a ")));
/*[IF*/
if(r38unix_notation()){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(4,"UNIX")));
}
 else if(r38windows_notation()){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(7,"Windows")));
}
 else if(r38cygwin_notation()){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(14,"Cygwin/Windows")));
}
 else if(r38amiga_notation()){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(5,"Amiga")));
}
 else if(r38macintosh_notation()){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(9,"Macintosh")));
}
 else if(r38openvms_notation()){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(7,"OpenVMS")));
}
else{
r35put_string((T35*)(oBC18echo),((T0*)se_ms(15,"?not_yet_known?")));
}
/*FI]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(11," notation.\n")));
}

void r16call_clean(T0* a1){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC16command))))->_count/*4*/)=(0);
/*]*/
r37command_path_in((T37*)(oBC16system_tools),oBC16command,((T0*)se_ms(5,"clean")));
r7extend((T7*)(oBC16command),((T3)'\40'));
r7append((T7*)(oBC16command),a1);
r33put_string(oBC16command);
r33put_string(((T0*)se_ms(1,"\n")));
r35system_call((T35*)(oBC18echo),oBC16command);
}

void r16fatal_problem_description_end(T16* C){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(129,"***************************************************************\nFix the previously described problem and launch again `install\'.\n")));
r16restore_current_working_directory(C);
r16install_exit(C,1);
}

void r16restore_current_working_directory(T16* C){
/*[IF*/
if(((/*RF2*/(C)->_cwd/*48*/))!=((void*)(NULL))){
r38change_current_working_directory(&((/*RF2*/(C)->_basic_directory/*40*/)),(/*RF2*/(C)->_cwd/*48*/));
}
/*FI]*/
}

void r16garbage_collector_selection(T16* C){
T0* _cmd=NULL;
int _s=0;
r35put_string((T35*)(oBC18echo),((T0*)se_ms(29,"Garbage collector selection:\n")));
/*[IF*/
if(r7same_as(se_ms(4,"UNIX"),(/*RF2*/(C)->_system_name/*12*/))){
_cmd=r7twin((T7*)((/*RF2*/(C)->_system_se_path/*4*/)));
/*[IRF3.6remove_suffix*/{T7* C1=((T7*)_cmd);
T0* b1=((T0*)se_ms(13,"sys/system.se"));
r7remove_last(C1,(/*RF2*/(((T7*)b1))->_count/*4*/));
}/*]*/
r7append(((T7*)_cmd),((T0*)se_ms(10,"misc/GC.SH")));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(18,"Launching script \"")));
r35put_string((T35*)(oBC18echo),_cmd);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r36execute_command_line(_cmd);
}
 else if(r7same_as(se_ms(5,"Amiga"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(14,"m68k-amigaos.c"));
}
 else if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*12*/)),((T0*)se_ms(5,"Elate")))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(7,"elate.c"));
}
 else if(r7same_as(se_ms(7,"Windows"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(9,"windows.c"));
}
 else if(r7same_as(se_ms(4,"BeOS"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(10,"beos_x86.c"));
}
 else if(r7same_as(se_ms(3,"DOS"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(9,"windows.c"));
}
 else if(r7same_as(se_ms(9,"Macintosh"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(14,"MacintoshPPC.c"));
}
 else if(r7same_as(se_ms(3,"OS2"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(9,"windows.c"));
}
 else if(r7same_as(se_ms(7,"OpenVMS"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(9,"generic.c"));
}
 else if(r7same_as(se_ms(6,"Cygwin"),(/*RF2*/(C)->_system_name/*12*/))){
(/*SFN*/C->_garbage_collector/*24*/)=((T0*)se_ms(9,"windows.c"));
}
/*FI]*/
/*[IF*/
if(((/*RF2*/(C)->_garbage_collector/*24*/))==((void*)(NULL))){
r35tfr_connect((T35*)(oBC18echo),oBC16tfr,(/*RF2*/(C)->_garbage_collector_file_path/*20*/));
(/*SFN*/C->_garbage_collector/*24*/)=r35read_word_in((T35*)(oBC18echo),oBC16tfr);
r39disconnect((T39*)(oBC16tfr));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(17,"Selected GC for \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_garbage_collector/*24*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
}
else{
r35put_string((T35*)(oBC18echo),((T0*)se_ms(17,"Selected GC for \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_garbage_collector/*24*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r35tfw_connect((T35*)(oBC18echo),oBC16tfw,(/*RF2*/(C)->_garbage_collector_file_path/*20*/));
r16tfw_check_is_connected(C,(/*RF2*/(C)->_garbage_collector_file_path/*20*/));
r53put_string((T53*)(oBC16tfw),(/*RF2*/(C)->_garbage_collector/*24*/));
/*[IRF3.6put_character*/{T53* C1=(T53*)(oBC16tfw);
T3 b1=((T3)'\n');
basic_io_putc(b1,(/*RF2*/(C1)->_output_stream/*4*/));
}/*]*/
r53disconnect((T53*)(oBC16tfw));
}
/*FI]*/
}
T0*oBC16command=NULL;

void r16c_compile_splitted_command_list(T16* C){
T0* _item=NULL;
T2 _i=0;
_i=1;
while (!((_i)>(r44count((T44*)(oBC16splitted_command_list)))))
{
_item=r44item((T44*)(oBC16splitted_command_list),_i);
r16split_mode_c_compile(C,_item);
_i=(_i)+(1);
}
}

void r16set_system_name(T16* C){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(23,"System name detection:\n")));
/*[IF*/
if((/*RF2*/(C)->_interactive/*2*/)){
(/*SFN*/C->_system_name/*12*/)=r16choice_in(((T0*)se_ms(21,"System name selection")),oBC37system_list);
}
 else if(r16file_exists(((T0*)se_ms(7,"/sys/rc")))){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(43,"System seems to be an Amiga on Taos Elate.\n")));
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(5,"Elate"));
}
 else if(r16file_exists(((T0*)se_ms(18,"s:startup-sequence")))){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(29,"System seems to be an Amiga.\n")));
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(5,"Amiga"));
}
 else if(r16file_exists(((T0*)se_ms(25,"/boot/beos/system/Tracker")))){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(25,"System seems to be BeOS.\n")));
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(4,"BeOS"));
}
 else if(r16file_exists(((T0*)se_ms(7,"/bin/ls")))){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(25,"System seems to be UNIX.\n")));
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(4,"UNIX"));
}
else{
/*[IF*/
if(r38system_notation_detected()){
/*[IF*/
if(r38unix_notation()){
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(4,"UNIX"));
}
 else if(r38windows_notation()){
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(7,"Windows"));
}
 else if(r38cygwin_notation()){
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(6,"Cygwin"));
}
 else if(r38amiga_notation()){
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(5,"Amiga"));
}
 else if(r38macintosh_notation()){
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(9,"Macintosh"));
}
 else if(r38openvms_notation()){
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(7,"OpenVMS"));
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(((/*RF2*/(C)->_system_name/*12*/))==((void*)(NULL))){
r38connect_to(&((/*RF2*/(C)->_basic_directory/*40*/)),((T0*)se_ms(3,"C:\\")));
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*40*/))._directory_stream/*0*/))/*)*/){
(/*SFN*/C->_system_name/*12*/)=((T0*)se_ms(7,"Windows"));
r38disconnect(&((/*RF2*/(C)->_basic_directory/*40*/)));
}
else{
r33put_string(((T0*)se_ms(43,"Automatic system detection failed (sorry).\n")));
(/*SFN*/C->_system_name/*12*/)=r16choice_in(((T0*)se_ms(21,"System name selection")),oBC37system_list);
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(11,"System is \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_name/*12*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(23,"\".\nTry to update file \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_se_path/*4*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r35tfw_connect((T35*)(oBC18echo),oBC16tfw,(/*RF2*/(C)->_system_se_path/*4*/));
r16tfw_check_is_connected(C,(/*RF2*/(C)->_system_se_path/*4*/));
r53put_string((T53*)(oBC16tfw),(/*RF2*/(C)->_system_name/*12*/));
/*[IRF3.6put_character*/{T53* C1=(T53*)(oBC16tfw);
T3 b1=((T3)'\n');
basic_io_putc(b1,(/*RF2*/(C1)->_output_stream/*4*/));
}/*]*/
r53disconnect((T53*)(oBC16tfw));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(11,"Update of \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_se_path/*4*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(8,"\" done.\n")));
r37make((T37*)(oBC16system_tools));
/*[IF*/
if(!(r7same_as((T7*)((/*RF2*/(C)->_system_name/*12*/)),(/*RF2*/((T37*)(oBC16system_tools))->_system_name/*0*/)))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(33,"Unkown SYSTEM_TOOLS.system_name \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_system_name/*12*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
}

void r16no_split_mode_c_compile(T16* C,T0* a1){
T0* _c_name=NULL;
_c_name=r7twin(((T7*)a1));
r7append(((T7*)_c_name),((T0*)se_ms(2,".c")));
/*[IRF3.3set_executable_name*/((((T54*)((T54*)(oBC18ace))))->_executable_name/*0*/)=(a1);
/*]*/
r37no_split_mode_command((T37*)(oBC16system_tools),oBC16command,_c_name);
r33put_string(oBC16command);
/*[IRF3.6put_character*/{T3 b1=((T3)'\n');
basic_io_putc(b1,basic_io_stdout);
}/*]*/
r35system_call((T35*)(oBC18echo),oBC16command);
r16move_executable_for(C,a1);
}
T0*oBC16no_split_command_list=NULL;

void r16set_compiler_se_path(T16* C){
T0* _path=NULL;
_path=r7twin((T7*)((/*RF2*/(C)->_installation_path/*8*/)));
r38compute_subdirectory_with(_path,((T0*)se_ms(3,"sys")));
_path=r7twin((T7*)(oBC38last_entry));
r38compute_file_path_with(_path,((T0*)se_ms(11,"compiler.se")));
(/*SFN*/C->_compiler_se_path/*16*/)=r7twin((T7*)(oBC38last_entry));
}

void r16split_mode_c_compile(T16* C,T0* a1){
T0* _entry=NULL;
T2 _i=0;
T2 _max=0;
T0* _directory=NULL;
r35put_string((T35*)(oBC18echo),((T0*)se_ms(13,"C compiling \"")));
r35put_string((T35*)(oBC18echo),a1);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(12,"*.c\" files.\n")));
/*[IRF3.3set_executable_name*/((((T54*)((T54*)(oBC18ace))))->_executable_name/*0*/)=(a1);
/*]*/
{T48*n=((T48*)se_malloc(sizeof(*n))/*17*/);
*n=M48;
r48scan_current_working_directory(n);
_directory=((T0*)n);
}
/*[IF*/
if(!((/*RF2*/(((T48*)_directory))->_last_scan_status/*4*/))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(42,"Unable to open current working directory.\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
_i=1;
while (!((_i)>(r48upper(((T48*)_directory)))))
{
_entry=r7twin((T7*)(/*(IRF4.6item*//*(IRF4.6item*/((/*RF2*/(((T51*)((/*RF2*/(((T48*)_directory))->_name_list/*13*/))))->_storage/*4*/))[(_i)-(1)]/*)*//*)*/));
r16echo_variable(((T0*)se_ms(5,"entry")),_entry);
r16open_vms_entry_patch(C,_entry);
/*[IF*/
if(!(r7has_prefix(((T7*)_entry),a1))){
}
 else if(!(r7has_suffix(((T7*)_entry),((T0*)se_ms(2,".c"))))){
}
else{
_max=(_max)+(1);
r37split_mode_c_compiler_command((T37*)(oBC16system_tools),oBC16command,_entry);
r33put_string(oBC16command);
r33put_string(((T0*)se_ms(1,"\n")));
r35system_call((T35*)(oBC18echo),oBC16command);
}
/*FI]*/
_i=(_i)+(1);
}
r37split_mode_linker_command((T37*)(oBC16system_tools),oBC16command,a1,_max);
r33put_string(oBC16command);
r33put_string(((T0*)se_ms(1,"\n")));
r35system_call((T35*)(oBC18echo),oBC16command);
r37remove_other_extra_files((T37*)(oBC16system_tools),a1);
r16move_executable_for(C,a1);
}

void r16install_exit(T16* C,T2 a1){
/*[IF*/
if((((/*RF2*/(C)->_system_name/*12*/))==((void*)(NULL)))||(r7same_as(se_ms(7,"Windows"),(/*RF2*/(C)->_system_name/*12*/)))){
r33put_string(((T0*)se_ms(26,"Type <Enter> to continue.\n")));
r30read_character((T30*)(oBC1std_input));
}
/*FI]*/
exit(a1);
}

void r16echo_usage_exit(T16* C){
/*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(7,"usage: ")));
r35put_string((T35*)(oBC18echo),((T0*)ms16_2073823));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(60," [-interactive] [-skip_c_compilation] [-cc <name>] [-debug]\n")));
r16restore_current_working_directory(C);
r16install_exit(C,1);
}

void r16echo_tfw_put_string(T0* a1){
r35put_string((T35*)(oBC18echo),a1);
r53put_string((T53*)(oBC16tfw),a1);
}

void r16write_default_loadpath_se_file(T16* C){
T0* _path=NULL;
T0* _directory=NULL;
T0* _tools_directory=NULL;
T0* _list=NULL;
T2 _i=0;
r35put_string((T35*)(oBC18echo),((T0*)se_ms(34,"Writing default loadpath.se file:\n")));
_path=r7twin((T7*)((/*RF2*/(C)->_installation_path/*8*/)));
r38compute_subdirectory_with(_path,((T0*)se_ms(3,"sys")));
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(41,"Unable to compute subdirectory \"sys\" of \"")));
r35put_string((T35*)(oBC18echo),_path);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
r7copy(((T7*)_path),oBC38last_entry);
r38compute_file_path_with(_path,((T0*)se_ms(9,"loadpath.")));
r7copy(((T7*)_path),oBC38last_entry);
r7append(((T7*)_path),(/*RF2*/(C)->_system_name/*12*/));
r35tfw_connect((T35*)(oBC18echo),oBC16tfw,_path);
r16tfw_check_is_connected(C,_path);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(21,"--- Written data ---\n")));
/*[IF*/
if(r7same_as(se_ms(4,"UNIX"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(3,"./\n"));
}
 else if(r7same_as(se_ms(6,"Cygwin"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(3,"./\n"));
}
 else if(r7same_as(se_ms(3,"DOS"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(3,".\\\n"));
}
 else if(r7same_as(se_ms(7,"Windows"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(3,".\\\n"));
}
 else if(r7same_as(se_ms(4,"BeOS"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(3,"./\n"));
}
 else if(r7same_as(se_ms(9,"Macintosh"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(2,":\n"));
}
 else if(r7same_as(se_ms(7,"OpenVMS"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(3,"[]\n"));
}
 else if(r7same_as(se_ms(3,"OS2"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(3,".\\\n"));
}
 else if(r7same_as(se_ms(5,"Amiga"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(1,"\n"));
}
 else if(r7same_as(se_ms(5,"Elate"),(/*RF2*/(C)->_system_name/*12*/))){
_directory=((T0*)se_ms(3,"./\n"));
}
/*FI]*/
/*[IF*/
if((_directory)!=((void*)(NULL))){
r16echo_tfw_put_string(_directory);
}
/*FI]*/
_list=se_ma44(8,
((T0*)se_ms(6,"kernel")),
((T0*)se_ms(4,"base")),
((T0*)se_ms(2,"io")),
((T0*)se_ms(8,"iterator")),
((T0*)se_ms(6,"random")),
((T0*)se_ms(6,"number")),
((T0*)se_ms(7,"sorting")),
((T0*)se_ms(4,"time")));
_i=(/*RF2*/(((T44*)_list))->_lower/*16*/);
while (!((_i)>((/*RF2*/(((T44*)_list))->_upper/*12*/))))
{
_directory=r7twin((T7*)((/*RF2*/(C)->_installation_path/*8*/)));
r38compute_subdirectory_with(_directory,((T0*)se_ms(3,"lib")));
r7copy(((T7*)_directory),oBC38last_entry);
r38compute_subdirectory_with(_directory,r44item(((T44*)_list),_i));
r7copy(((T7*)_directory),oBC38last_entry);
r7extend(((T7*)_directory),((T3)'\n'));
r16echo_tfw_put_string(_directory);
_i=(_i)+(1);
}
_tools_directory=r7twin((T7*)((/*RF2*/(C)->_installation_path/*8*/)));
r38compute_subdirectory_with(_tools_directory,((T0*)se_ms(5,"tools")));
r7copy(((T7*)_tools_directory),oBC38last_entry);
r16echo_tfw_put_string(_tools_directory);
r16echo_tfw_put_string(((T0*)se_ms(1,"\n")));
_list=se_ma44(6,
((T0*)se_ms(10,"expression")),
((T0*)se_ms(11,"instruction")),
((T0*)se_ms(6,"e_type")),
((T0*)se_ms(7,"feature")),
((T0*)se_ms(11,"run_feature")),
((T0*)se_ms(4,"misc")));
_i=(/*RF2*/(((T44*)_list))->_lower/*16*/);
while (!((_i)>((/*RF2*/(((T44*)_list))->_upper/*12*/))))
{
_directory=r7twin(((T7*)_tools_directory));
r38compute_subdirectory_with(_directory,r44item(((T44*)_list),_i));
r7copy(((T7*)_directory),oBC38last_entry);
r7extend(((T7*)_directory),((T3)'\n'));
r16echo_tfw_put_string(_directory);
_i=(_i)+(1);
}
_directory=r7twin((T7*)((/*RF2*/(C)->_installation_path/*8*/)));
r38compute_subdirectory_with(_directory,((T0*)se_ms(8,"tutorial")));
r7copy(((T7*)_directory),oBC38last_entry);
r16echo_tfw_put_string(_directory);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(22,"\n--- Written data ---\n")));
r53disconnect((T53*)(oBC16tfw));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(11,"Update of \"")));
r35put_string((T35*)(oBC18echo),_path);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(41,"\" done.\nThe default loadpath is updated.\n")));
}

void r16clean_bin_c_directory_path(T16* C){
T2 _i=0;
T0* _item=NULL;
T0* _directory=NULL;
_i=1;
while (!((_i)>(r44count((T44*)(oBC16no_split_command_list)))))
{
_item=r44item((T44*)(oBC16no_split_command_list),_i);
r16call_clean(_item);
_i=(_i)+(1);
}
_i=1;
while (!((_i)>(r44count((T44*)(oBC16splitted_command_list)))))
{
_item=r44item((T44*)(oBC16splitted_command_list),_i);
/*[IF*/
if(!(r7is_equal(((T7*)_item),((T0*)se_ms(12,"compile_to_c"))))){
r16call_clean(_item);
}
/*FI]*/
_i=(_i)+(1);
}
{T48*n=((T48*)se_malloc(sizeof(*n))/*17*/);
*n=M48;
r48scan_current_working_directory(n);
_directory=((T0*)n);
}
_i=1;
while (!((_i)>(r48upper(((T48*)_directory)))))
{
_item=r7twin((T7*)(/*(IRF4.6item*//*(IRF4.6item*/((/*RF2*/(((T51*)((/*RF2*/(((T48*)_directory))->_name_list/*13*/))))->_storage/*4*/))[(_i)-(1)]/*)*//*)*/));
r16open_vms_entry_patch(C,_item);
/*[IF*/
if(r7has_prefix(((T7*)_item),((T0*)se_ms(12,"compile_to_c")))){
/*[INSPECT*/
{int z1=r7last(((T7*)_item));
switch(z1){
case 67:
case 72:
case 99:
case 104:
break;
default:;
r35file_removing((T35*)(oBC18echo),_item);
}
}/*INSPECT]*/
}
/*FI]*/
_i=(_i)+(1);
}
/*[IF*/
if(r7same_as(se_ms(9,"lcc-win32"),(/*RF2*/(C)->_c_compiler_name/*28*/))){
r35put_string((T35*)(oBC18echo),((T0*)se_ms(44,"In order to reset \"compile_to_c\" -no_gc in \"")));
r35put_string((T35*)(oBC18echo),(/*RF2*/(C)->_bin_c_directory_path/*36*/));
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r16call_clean(((T0*)se_ms(12,"compile_to_c")));
r16call_compile_to_c(((T0*)se_ms(13,"-boost -no_gc")),((T0*)se_ms(12,"compile_to_c")));
/*[IRF3.6remove_file*/{T0* b1=((T0*)se_ms(16,"compile_to_c.bat"));
r49delete(b1);
}/*]*/
}
/*FI]*/
}

T0* r16argument(T2 a1){
T0* R=NULL;
R=/*(IRF4.6item*/((/*RF2*/((T51*)(r16command_arguments()))->_storage/*4*/))[a1]/*)*/;
return R;
}

void r16move_executable_for(T16* C,T0* a1){
T0* _executable=NULL;
T0* _old_path=NULL;
T0* _new_path=NULL;
_executable=r7twin(((T7*)a1));
r37add_x_suffix((T37*)(oBC16system_tools),_executable);
r38compute_file_path_with((/*RF2*/(C)->_bin_c_directory_path/*36*/),_executable);
_old_path=r7twin((T7*)(oBC38last_entry));
r38compute_file_path_with((/*RF2*/(C)->_bin_directory_path/*32*/),_executable);
_new_path=r7twin((T7*)(oBC38last_entry));
/*[IF*/
if(!(r16file_exists(_old_path))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(27,"Unable to find executable \"")));
r35put_string((T35*)(oBC18echo),_old_path);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(3,"\".\n")));
r16fatal_problem_description_end(C);
}
/*FI]*/
/*[IF*/
if(!(r7same_as(se_ms(5,"Elate"),(/*RF2*/(C)->_system_name/*12*/)))){
r35file_renaming((T35*)(oBC18echo),_old_path,_new_path);
}
else{
r7copy((T7*)(oBC16command),((T0*)se_ms(4,"cpt ")));
r7append((T7*)(oBC16command),_old_path);
r7extend((T7*)(oBC16command),((T3)'\40'));
r7append((T7*)(oBC16command),_new_path);
r33put_string(oBC16command);
r33put_string(((T0*)se_ms(1,"\n")));
r35system_call((T35*)(oBC18echo),oBC16command);
}
/*FI]*/
}

void r16check_system_path_variable_warning(T16* C){
T6 _do_warning=0;
T0* _bin_directory=NULL;
T0* _variable=NULL;
T0* _content=NULL;
_do_warning=1;
_bin_directory=r7twin((T7*)((/*RF2*/(C)->_bin_directory_path/*32*/)));
/*[IF*/
if(((r7same_as(se_ms(4,"UNIX"),(/*RF2*/(C)->_system_name/*12*/)))||(r7same_as(se_ms(6,"Cygwin"),(/*RF2*/(C)->_system_name/*12*/))))||(r7same_as(se_ms(5,"Elate"),(/*RF2*/(C)->_system_name/*12*/)))){
/*[IF*/
if(r7same_as(se_ms(5,"Elate"),(/*RF2*/(C)->_system_name/*12*/))){
_variable=((T0*)se_ms(10,"shell.path"));
}
else{
_variable=((T0*)se_ms(4,"PATH"));
}
/*FI]*/
_content=r35getenv((T35*)(oBC18echo),_variable,NULL);
/*[IF*/
if((_content)!=((void*)(NULL))){
/*[IF*/
if((r7last(((T7*)_bin_directory)))==(((T3)'\57'))){
r7remove_last(((T7*)_bin_directory),1);
}
/*FI]*/
_content=r7twin(((T7*)_content));
while (!(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)))
{
/*[IF*/
if(r7has_prefix(((T7*)_content),_bin_directory)){
r7remove_first(((T7*)_content),(/*RF2*/(((T7*)_bin_directory))->_count/*4*/));
/*[IF*/
if(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)){
_do_warning=0;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\72'))){
/*[IRF3.3clear*/((((T7*)(((T7*)_content))))->_count/*4*/)=(0);
/*]*/
_do_warning=0;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_first(((T7*)_content),1);
/*[IF*/
if(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)){
_do_warning=0;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\72'))){
/*[IRF3.3clear*/((((T7*)(((T7*)_content))))->_count/*4*/)=(0);
/*]*/
_do_warning=0;
}
/*FI]*/
}
/*FI]*/
}
else{
r7remove_first(((T7*)_content),1);
}
/*FI]*/
}
}
/*FI]*/
}
 else if(r7same_as(se_ms(7,"Windows"),(/*RF2*/(C)->_system_name/*12*/))){
_content=r35getenv((T35*)(oBC18echo),((T0*)se_ms(4,"PATH")),NULL);
/*[IF*/
if((_content)!=((void*)(NULL))){
/*[IF*/
if((r7last(((T7*)_bin_directory)))==(((T3)'\134'))){
r7remove_last(((T7*)_bin_directory),1);
}
/*FI]*/
r7to_lower(((T7*)_bin_directory));
_content=r7twin(((T7*)_content));
r7to_lower(((T7*)_content));
while (!(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)))
{
/*[IF*/
if(r7has_prefix(((T7*)_content),_bin_directory)){
r7remove_first(((T7*)_content),(/*RF2*/(((T7*)_bin_directory))->_count/*4*/));
/*[IF*/
if(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)){
_do_warning=0;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\73'))){
/*[IRF3.3clear*/((((T7*)(((T7*)_content))))->_count/*4*/)=(0);
/*]*/
_do_warning=0;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\134'))){
r7remove_first(((T7*)_content),1);
/*[IF*/
if(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)){
_do_warning=0;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\73'))){
/*[IRF3.3clear*/((((T7*)(((T7*)_content))))->_count/*4*/)=(0);
/*]*/
_do_warning=0;
}
/*FI]*/
}
/*FI]*/
}
else{
r7remove_first(((T7*)_content),1);
}
/*FI]*/
}
}
/*FI]*/
}
else{
_do_warning=0;
}
/*FI]*/
/*[IF*/
if(_do_warning){
r33put_string(((T0*)se_ms(22,"Do not forget to add \"")));
r33put_string((/*RF2*/(C)->_bin_directory_path/*32*/));
r33put_string(((T0*)se_ms(12,"\" in \nyour \"")));
/*[IF*/
if((_variable)!=((void*)(NULL))){
r33put_string(_variable);
}
else{
r33put_string(((T0*)se_ms(6,"<PATH>")));
}
/*FI]*/
r33put_string(((T0*)se_ms(19,"\" system variable.\n")));
}
/*FI]*/
}

void r16tfw_check_is_connected(T16* C,T0* a1){
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T53*)(oBC16tfw))->_path/*0*/))!=(NULL)/*)*/)){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T35*)((T35*)(oBC18echo))))->_verbose/*0*/)=(1);
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));
/*]*/
r35put_string((T35*)(oBC18echo),((T0*)se_ms(19,"Cannot write file \"")));
r35put_string((T35*)(oBC18echo),a1);
r35put_string((T35*)(oBC18echo),((T0*)se_ms(27,"\".\nCheck write permissions.")));
r16fatal_problem_description_end(C);
}
/*FI]*/
}

T0* r16choice_in(T0* a1,T0* a2){
T0* R=NULL;
T2 _i=0;
T0* _w=NULL;
T0* _n=NULL;
while (!((R)!=((void*)(NULL))))
{
r33put_string(a1);
r33put_string(((T0*)se_ms(4,":\n  ")));
_i=1;
while (!((_i)>((/*RF2*/(((T44*)a2))->_upper/*12*/))))
{
r33put_string(r44item(((T44*)a2),_i));
_i=(_i)+(1);
/*[IF*/
if((_i)<=((/*RF2*/(((T44*)a2))->_upper/*12*/))){
r33put_string(((T0*)se_ms(2,", ")));
}
/*FI]*/
}
r33put_string(((T0*)se_ms(3,"\n? ")));
/*[IRF3.2flush*/basic_io_flush(basic_io_stdout);
/*]*/
r30read_word((T30*)(oBC1std_input));
_i=(/*RF2*/(((T44*)a2))->_lower/*16*/);
_w=r7twin((T7*)(oBC31last_string));
r7to_lower(((T7*)_w));
while (!((_i)>((/*RF2*/(((T44*)a2))->_upper/*12*/))))
{
_n=r7twin((T7*)(r44item(((T44*)a2),_i)));
r7to_lower(((T7*)_n));
/*[IF*/
if(r7same_as(((T7*)_w),_n)){
R=r44item(((T44*)a2),_i);
_i=(/*RF2*/(((T44*)a2))->_upper/*12*/);
}
 else if(r7has_prefix(((T7*)_n),_w)){
/*[IF*/
if((R)!=((void*)(NULL))){
R=NULL;
}
else{
R=r44item(((T44*)a2),_i);
}
/*FI]*/
}
/*FI]*/
_i=(_i)+(1);
}
/*[IF*/
if((R)==((void*)(NULL))){
r33put_string(((T0*)se_ms(1,"\"")));
r33put_string(_w);
r33put_string(((T0*)se_ms(25,"\" is not a valid choice.\n")));
}
/*FI]*/
}
r33put_string(((T0*)se_ms(10,"selected: ")));
r33put_string(R);
r33put_string(((T0*)se_ms(1,"\n")));
return R;
}

void r36execute_command_line(T0* a1){
/*[IF*/
if((r36execute_command(a1))==(0)){
}
/*FI]*/
}

T2 r36execute_command(T0* a1){
T2 R=0;
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
R=basic_system_execute_command(_p);
return R;
}

T0* r36get_environment_variable(T0* a1){
T0* R=NULL;
T8 _p=NULL;
T8 _null=NULL;
_p=r7to_external(((T7*)a1));
_p=basic_getenv(_p);
/*[IF*/
if((_p)!=(_null)){
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
r7from_external_copy(n,_p);
R=((T0*)n);
}
}
/*FI]*/
return R;
}

void r38set_notation_using(T0* a1){
/*[INSPECT*/
{int z1=/*(IRF4.6first*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[0]/*)*/;
switch(z1){
case 46:
case 47:
case 126:
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'U'));
/*]*/
/*[IF*/
if(((/*RF2*/(((T7*)a1))->_count/*4*/))>=(4)){
/*[IF*/
if((/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(2)-(1)]/*)*/)==(((T3)'\57'))){
/*[IF*/
if((/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(4)-(1)]/*)*/)==(((T3)'\57'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'C'));
/*]*/
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
break;
case 92:
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'W'));
/*]*/
break;
case 58:
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'M'));
/*]*/
break;
case 91:
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'V'));
/*]*/
break;
case 65:
case 66:
case 67:
case 68:
case 69:
case 70:
case 71:
case 72:
case 73:
case 74:
case 75:
case 76:
case 77:
case 78:
case 79:
case 80:
case 81:
case 82:
case 83:
case 84:
case 85:
case 86:
case 87:
case 88:
case 89:
case 90:
case 97:
case 98:
case 99:
case 100:
case 101:
case 102:
case 103:
case 104:
case 105:
case 106:
case 107:
case 108:
case 109:
case 110:
case 111:
case 112:
case 113:
case 114:
case 115:
case 116:
case 117:
case 118:
case 119:
case 120:
case 121:
case 122:
/*[IF*/
if(((/*RF2*/(((T7*)a1))->_count/*4*/))>=(2)){
/*[INSPECT*/
{int z2=/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(2)-(1)]/*)*/;
switch(z2){
case 58:
/*[IF*/
if(((/*RF2*/(((T7*)a1))->_count/*4*/))==(2)){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'W'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\134'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'W'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\77'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'A'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\57'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'C'));
/*]*/
}
/*FI]*/
break;
case 65:
case 66:
case 67:
case 68:
case 69:
case 70:
case 71:
case 72:
case 73:
case 74:
case 75:
case 76:
case 77:
case 78:
case 79:
case 80:
case 81:
case 82:
case 83:
case 84:
case 85:
case 86:
case 87:
case 88:
case 89:
case 90:
case 97:
case 98:
case 99:
case 100:
case 101:
case 102:
case 103:
case 104:
case 105:
case 106:
case 107:
case 108:
case 109:
case 110:
case 111:
case 112:
case 113:
case 114:
case 115:
case 116:
case 117:
case 118:
case 119:
case 120:
case 121:
case 122:
/*[IF*/
if(r7has(((T7*)a1),((T3)'\133'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'V'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\72'))){
/*[IF*/
if(r7has(((T7*)a1),((T3)'\57'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'A'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\133'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'V'));
/*]*/
}
else{
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'A'));
/*]*/
}
/*FI]*/
}
 else if(r7has(((T7*)a1),((T3)'\57'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'U'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\134'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'U'));
/*]*/
}
/*FI]*/
break;
}
}/*INSPECT]*/
}
/*FI]*/
break;
}
}/*INSPECT]*/
}

T6 r38amiga_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'A'));
return R;
}

void r38connect_to_current_working_directory(T38* C){
T8 _path=NULL;
_path=basic_directory_current_working_directory;
/*[IF*/
if((NULL!=_path)){
r7from_external_copy((T7*)(oBC38last_entry),_path);
(/*SFN*/C->_directory_stream/*0*/)=basic_directory_open(_path);
(/*SFN*/C->_current_entry/*4*/)=(/*RF2*/(*C)._directory_stream/*0*/);
/*[IF*/
if(r8is_null((/*RF2*/(*C)._directory_stream/*0*/))){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}

void r38disconnect(T38* C){
T8 _null=NULL;
/*[IF*/
if(basic_directory_close((/*RF2*/(*C)._directory_stream/*0*/))){
(/*SFN*/C->_directory_stream/*0*/)=_null;
(/*SFN*/C->_current_entry/*4*/)=_null;
}
/*FI]*/
}

void r38compute_subdirectory_with(T0* a1,T0* a2){
r7copy((T7*)(oBC38last_entry),a1);
/*[IF*/
if((r38unix_notation())||(r38cygwin_notation())){
/*[IF*/
if(r7is_equal(ms38_46,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
 else if(r7is_equal(ms38_276,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
else{
r7extend_unless((T7*)(oBC38last_entry),((T3)'\57'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC38last_entry),a2);
r7extend_unless((T7*)(oBC38last_entry),((T3)'\57'));
}
/*FI]*/
}
 else if(r38windows_notation()){
/*[IF*/
if(r7is_equal(ms38_46a,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
 else if(r7is_equal(ms38_276a,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
else{
r7extend_unless((T7*)(oBC38last_entry),((T3)'\134'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\134'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC38last_entry),a2);
r7extend_unless((T7*)(oBC38last_entry),((T3)'\134'));
}
/*FI]*/
}
 else if(r38amiga_notation()){
/*[INSPECT*/
{int z1=r7last((T7*)(oBC38last_entry));
switch(z1){
case 47:
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
break;
case 58:
break;
default:;
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)!=(((T3)'\57'))){
r7add_last((T7*)(oBC38last_entry),((T3)'\57'));
}
/*FI]*/
}
}/*INSPECT]*/
r7append((T7*)(oBC38last_entry),a2);
r7extend_unless((T7*)(oBC38last_entry),((T3)'\57'));
}
 else if(r38macintosh_notation()){
r7extend_unless((T7*)(oBC38last_entry),((T3)'\72'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\72'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC38last_entry),a2);
r7extend_unless((T7*)(oBC38last_entry),((T3)'\72'));
}
 else if(r38openvms_notation()){
/*[IF*/
if(((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(1)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
 else if((r7last((T7*)(oBC38last_entry)))==(((T3)'\135'))){
r7remove_last((T7*)(oBC38last_entry),1);
/*[IF*/
if((r7last((T7*)(oBC38last_entry)))==(((T3)'\133'))){
r7append((T7*)(oBC38last_entry),a2);
r7extend((T7*)(oBC38last_entry),((T3)'\135'));
}
else{
r7extend((T7*)(oBC38last_entry),((T3)'\56'));
r7append((T7*)(oBC38last_entry),a2);
r7extend((T7*)(oBC38last_entry),((T3)'\135'));
}
/*FI]*/
}
 else if((r7last((T7*)(oBC38last_entry)))==(((T3)'\72'))){
r7extend((T7*)(oBC38last_entry),((T3)'\133'));
r7append((T7*)(oBC38last_entry),a2);
r7extend((T7*)(oBC38last_entry),((T3)'\135'));
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}
 else if(r38system_notation_detected()){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
else{
r38set_notation_using(a1);
/*[IF*/
if(r38system_notation_detected()){
r38compute_subdirectory_with(a1,a2);
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}
/*FI]*/
}

T6 r38system_notation_detected(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[0]/*)*/)!=(((T3)'\77'));
return R;
}

T6 r38windows_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'W'));
return R;
}

T6 r38unix_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'U'));
return R;
}

void r38reset_notation_using(T0* a1){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'\77'));
/*]*/
r38set_notation_using(a1);
}
T0*oBC38last_entry=NULL;

T6 r38macintosh_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'M'));
return R;
}

void r38change_current_working_directory(T38* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
/*[IF*/
if(basic_directory_chdir(_p)){
r38connect_to_current_working_directory(C);
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/(*C)._directory_stream/*0*/))/*)*/){
r38disconnect(C);
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}

void r38compute_parent_directory_of(T0* a1){
r7copy((T7*)(oBC38last_entry),a1);
/*[IF*/
if(r38unix_notation()){
r7remove_last((T7*)(oBC38last_entry),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC38last_entry)))==(((T3)'\57')))))
{
r7remove_last((T7*)(oBC38last_entry),1);
}
}
 else if(r38windows_notation()){
r7remove_last((T7*)(oBC38last_entry),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC38last_entry)))==(((T3)'\134')))))
{
r7remove_last((T7*)(oBC38last_entry),1);
}
}
 else if(r38cygwin_notation()){
r7remove_last((T7*)(oBC38last_entry),1);
while (!(((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC38last_entry)))==(((T3)'\57'))))||((r7last((T7*)(oBC38last_entry)))==(((T3)'\72')))))
{
r7remove_last((T7*)(oBC38last_entry),1);
}
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/){
}
 else if((/*(IRF4.6first*/((/*RF2*/((T7*)(oBC38last_entry))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
/*[IF*/
if(((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(2)){
/*[IF*/
if((/*(IRF4.6item*/((/*RF2*/((T7*)(oBC38last_entry))->_storage/*0*/))[(2)-(1)]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
}
 else if(r38amiga_notation()){
/*[IF*/
if((r7last((T7*)(oBC38last_entry)))==(((T3)'\72'))){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
else{
r7remove_last((T7*)(oBC38last_entry),1);
while (!(((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC38last_entry)))==(((T3)'\57'))))||((r7last((T7*)(oBC38last_entry)))==(((T3)'\72')))))
{
r7remove_last((T7*)(oBC38last_entry),1);
}
}
/*FI]*/
}
 else if(r38macintosh_notation()){
r7remove_last((T7*)(oBC38last_entry),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC38last_entry)))==(((T3)'\72')))))
{
r7remove_last((T7*)(oBC38last_entry),1);
}
}
 else if(r38openvms_notation()){
/*[IF*/
if((r7last((T7*)(oBC38last_entry)))==(((T3)'\135'))){
r7remove_last((T7*)(oBC38last_entry),1);
while (!(((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC38last_entry)))==(((T3)'\56'))))||((r7last((T7*)(oBC38last_entry)))==(((T3)'\133')))))
{
r7remove_last((T7*)(oBC38last_entry),1);
}
/*[IF*/
if(((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))>(0)){
/*[INSPECT*/
{int z1=r7last((T7*)(oBC38last_entry));
switch(z1){
case 46:
r7remove_last((T7*)(oBC38last_entry),1);
r7extend((T7*)(oBC38last_entry),((T3)'\135'));
break;
default:;
/*[IF*/
if(((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(((/*RF2*/(((T7*)a1))->_count/*4*/))-(1))){
r7remove_last((T7*)(oBC38last_entry),1);
}
else{
r7extend((T7*)(oBC38last_entry),((T3)'\135'));
}
/*FI]*/
}
}/*INSPECT]*/
}
/*FI]*/
}
 else if((r7last((T7*)(oBC38last_entry)))==(((T3)'\72'))){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
else{
r7remove_last((T7*)(oBC38last_entry),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC38last_entry)))==(((T3)'\135')))))
{
r7remove_last((T7*)(oBC38last_entry),1);
}
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC38last_entry))->_count/*4*/))==(0)/*)*/){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}
/*FI]*/
}
 else if(r38system_notation_detected()){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
else{
r38set_notation_using(a1);
/*[IF*/
if(r38system_notation_detected()){
r38compute_parent_directory_of(a1);
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}
/*FI]*/
}

void r38read_entry(T38* C){
T8 _name=NULL;
(/*SFN*/C->_current_entry/*4*/)=basic_directory_read_entry((/*RF2*/(*C)._directory_stream/*0*/));
/*[IF*/
if((NULL!=(/*RF2*/(*C)._current_entry/*4*/))){
_name=basic_directory_get_entry_name((/*RF2*/(*C)._current_entry/*4*/));
r7from_external_copy((T7*)(oBC38last_entry),_name);
}
/*FI]*/
}

void r38connect_to(T38* C,T0* a1){
T8 _path_pointer=NULL;
_path_pointer=r7to_external(((T7*)a1));
(/*SFN*/C->_directory_stream/*0*/)=basic_directory_open(_path_pointer);
(/*SFN*/C->_current_entry/*4*/)=(/*RF2*/(*C)._directory_stream/*0*/);
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}

T6 r38create_new_directory(T0* a1){
T6 R=0;
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
R=basic_directory_mkdir(_p);
return R;
}

void r38compute_file_path_with(T0* a1,T0* a2){
r7copy((T7*)(oBC38last_entry),a1);
/*[IF*/
if((r38unix_notation())||(r38cygwin_notation())){
r7extend_unless((T7*)(oBC38last_entry),((T3)'\57'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC38last_entry),a2);
}
 else if(r38windows_notation()){
r7extend_unless((T7*)(oBC38last_entry),((T3)'\134'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\134'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC38last_entry),a2);
}
 else if(r38amiga_notation()){
/*[INSPECT*/
{int z1=r7last((T7*)(oBC38last_entry));
switch(z1){
case 58:
break;
case 47:
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
break;
default:;
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)!=(((T3)'\57'))){
r7extend((T7*)(oBC38last_entry),((T3)'\57'));
}
/*FI]*/
}
}/*INSPECT]*/
r7append((T7*)(oBC38last_entry),a2);
}
 else if(r38macintosh_notation()){
r7extend_unless((T7*)(oBC38last_entry),((T3)'\72'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\72'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC38last_entry),a2);
}
 else if(r38openvms_notation()){
/*[INSPECT*/
{int z1=r7last((T7*)(oBC38last_entry));
switch(z1){
case 93:
break;
case 46:
r7remove_last((T7*)(oBC38last_entry),1);
r7extend((T7*)(oBC38last_entry),((T3)'\135'));
break;
default:;
r7extend((T7*)(oBC38last_entry),((T3)'\135'));
}
}/*INSPECT]*/
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\135'))){
r7remove_last((T7*)(oBC38last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC38last_entry),a2);
}
 else if(r38system_notation_detected()){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
else{
r38set_notation_using(a1);
/*[IF*/
if(r38system_notation_detected()){
r38compute_file_path_with(a1,a2);
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC38last_entry))))->_count/*4*/)=(0);
/*]*/
}
/*FI]*/
}
/*FI]*/
}

T6 r38openvms_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'V'));
return R;
}

T6 r38cygwin_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms38_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'C'));
return R;
}
T16*eiffel_root_object=NULL;
int se_argc;
char**se_argv;
T7* g[59];
T7* t[59];

void initialize_eiffel_runtime(int argc,char*argv[]){
se_argc=argc;
se_argv=argv;
g[29]=se_string("SAFE_EQUAL");
g[34]=se_string("OUTPUT_STREAM");
g[21]=se_string("PLATFORM");
g[17]=se_string("COMMAND_LINE_TOOLS");
g[2]=se_string("INTEGER");
g[7]=se_string("STRING");
g[23]=se_string("COMPARABLE");
g[54]=se_string("ACE");
g[25]=se_string("INTEGER_REF");
g[10]=se_string("ANY");
g[50]=se_string("FIXED_ARRAY");
g[33]=se_string("STD_OUTPUT");
g[26]=se_string("NUMERIC");
g[38]=se_string("BASIC_DIRECTORY");
g[20]=se_string("ALIASED_STRING_LIST");
g[39]=se_string("TEXT_FILE_READ");
g[1]=se_string("GENERAL");
g[43]=se_string("TUPLE");
g[36]=se_string("SYSTEM");
g[46]=se_string("STD_ERROR");
g[40]=se_string("ARRAY");
g[49]=se_string("FILE_TOOLS");
g[18]=se_string("GLOBALS");
g[24]=se_string("HASHABLE");
g[56]=se_string("PARSER");
g[48]=se_string("DIRECTORY");
g[32]=se_string("POINTER_REF");
g[8]=se_string("POINTER");
g[53]=se_string("TEXT_FILE_WRITE");
g[37]=se_string("SYSTEM_TOOLS");
g[28]=se_string("NATIVE_ARRAY");
g[19]=se_string("FROZEN_STRING_LIST");
g[42]=se_string("COLLECTION");
g[30]=se_string("STD_INPUT");
g[27]=se_string("CHARACTER_REF");
g[55]=se_string("ASSERTION_LEVEL_NUMBERING");
g[3]=se_string("CHARACTER");
g[31]=se_string("INPUT_STREAM");
g[6]=se_string("BOOLEAN");
g[0]=se_string("NONE");
g[22]=se_string("BOOLEAN_REF");
g[35]=se_string("ECHO");
g[58]=se_string("SMALL_EIFFEL");
g[16]=se_string("INSTALL");
g[41]=se_string("ARRAYED_COLLECTION");
g[51]=g[50];
g[45]=g[28];
g[9]=g[28];
g[47]=g[29];
g[44]=g[40];
t[8]=g[8];
t[49]=g[49];
t[6]=g[6];
t[3]=g[3];
t[30]=g[30];
t[54]=g[54];
t[16]=g[16];
t[36]=g[36];
t[51]=se_string("FIXED_ARRAY[STRING]");
t[35]=g[35];
t[39]=g[39];
t[45]=se_string("NATIVE_ARRAY[STRING]");
t[37]=g[37];
t[7]=g[7];
t[9]=se_string("NATIVE_ARRAY[CHARACTER]");
t[38]=g[38];
t[47]=se_string("SAFE_EQUAL[STRING]");
t[48]=g[48];
t[2]=g[2];
t[44]=se_string("ARRAY[STRING]");
t[58]=g[58];
t[53]=g[53];
t[33]=g[33];
t[46]=g[46];
#ifdef SIGINT
signal(SIGINT,se_signal_handler);
#endif
#ifdef SIGQUIT
signal(SIGQUIT,se_signal_handler);
#endif
#ifdef SIGTERM
signal(SIGTERM,se_signal_handler);
#endif
#ifdef SIGBREAK
signal(SIGBREAK,se_signal_handler);
#endif
#ifdef SIGKILL
signal(SIGKILL,se_signal_handler);
#endif
se_msi1();
/*PCO*/
{T58*n=((T58*)se_malloc(1));
oBC18small_eiffel=((T0*)n);
}
/*PCO*/
{T39*n=((T39*)se_malloc(sizeof(*n))/*13*/);
*n=M39;
oBC16tfr=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T53*n=((T53*)se_malloc(sizeof(*n))/*8*/);
*n=M53;
oBC16tfw=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
oBC37compiler_list=se_ma44(13,
((T0*)ms37_3169),
((T0*)ms37_51699930),
((T0*)ms37_594),
((T0*)ms37_448859),
((T0*)ms37_76405),
((T0*)ms37_382130),
((T0*)ms37_603),
((T0*)ms37_674),
((T0*)ms37_15721),
((T0*)ms37_17794),
((T0*)ms37_3069),
((T0*)ms37_18144),
((T0*)ms37_207986277));
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC31last_string=((T0*)n);
r7make(n,1024);
}
/*PCO*/
{T54*n=((T54*)se_malloc(sizeof(*n))/*8*/);
*n=M54;
oBC18ace=((T0*)n);
}
/*PCO*/
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC37token_buffer=((T0*)n);
r7make(n,128);
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC7string_buffer=((T0*)n);
r7make(n,256);
}
/*PCO*/
{T44*n=((T44*)se_malloc(sizeof(*n))/*20*/);
*n=M44;
oBC7split_buffer=((T0*)n);
r44with_capacity(n,4,1);
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC34tmp_string=((T0*)n);
r7make(n,512);
}
/*PCO*/
oBC16no_split_command_list=se_ma44(5,
((T0*)se_ms(5,"clean")),
((T0*)se_ms(7,"compile")),
((T0*)se_ms(6,"finder")),
((T0*)se_ms(9,"ace_check")),
((T0*)se_ms(15,"print_jvm_class")));
/*PCO*/
oBC16splitted_command_list=se_ma44(4,
((T0*)se_ms(12,"compile_to_c")),
((T0*)se_ms(5,"short")),
((T0*)se_ms(6,"pretty")),
((T0*)se_ms(14,"compile_to_jvm")));
/*PCO*/
{T39*n=((T39*)se_malloc(sizeof(*n))/*13*/);
*n=M39;
oBC49tfr1=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T37*n=((T37*)se_malloc(sizeof(*n))/*25*/);
*n=M37;
oBC16system_tools=((T0*)n);
/*[IRF3.1install*//*]*/
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC16command=((T0*)n);
r7make(n,512);
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC18tmp_path=((T0*)n);
r7make(n,512);
}
/*PCO*/
{T46*n=((T46*)se_malloc(1));
oBC1std_error=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T35*n=((T35*)se_malloc(sizeof(*n))/*1*/);
*n=M35;
oBC18echo=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
oBC37system_list=se_ma44(10,
((T0*)ms37_13028),
((T0*)ms37_1772235),
((T0*)ms37_301485),
((T0*)ms37_11253),
((T0*)ms37_39617954),
((T0*)ms37_57487),
((T0*)ms37_2178),
((T0*)ms37_2440),
((T0*)ms37_1663868),
((T0*)ms37_59731));
/*PCO*/
{T39*n=((T39*)se_malloc(sizeof(*n))/*13*/);
*n=M39;
oBC18tmp_file_read=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC38last_entry=((T0*)n);
r7make(n,256);
}
/*PCO*/
{T33*n=((T33*)se_malloc(1));
oBC1std_output=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T30*n=((T30*)se_malloc(sizeof(*n))/*5*/);
*n=M30;
oBC1std_input=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
eiffel_root_object=((T16*)se_malloc(sizeof(*eiffel_root_object))/*52*/);
*eiffel_root_object=M16;
}
int main(int argc,char*argv[]){
initialize_eiffel_runtime(argc,argv);
{T16*n=eiffel_root_object;
r16make(n);
}
exit(0);
return 0;}
T7*ms37_16702;
T7*ms37_128214728;
T7*ms37_1631212670;
T7*ms37_18144;
T7*ms37_17794;
T7*ms37_218174;
T7*ms37_39204698;
T7*ms37_0a;
T7*ms37_1866433364;
T7*ms38_46;
T7*ms38_63;
T7*ms37_223953;
T7*ms37_530877013;
T7*ms37_968120;
T7*ms37_2075119688;
T7*ms19_1090;
T7*ms35_354654986;
T7*ms37_304aa;
T7*ms37_466551816;
T7*ms37_1125006;
T7*ms37_860169684;
T7*ms37_382130;
T7*ms19_3085;
T7*ms16_2073823;
T7*ms19_3595;
T7*ms37_426884100;
T7*ms37_1663868;
T7*ms37_1335;
T7*ms37_270309168;
T7*ms37_1438;
T7*ms37_1570;
T7*ms37_2178;
T7*ms37_1744;
T7*ms37_1774;
T7*ms37_2440;
T7*ms37_2565;
T7*ms37_3069;
T7*ms37_3094;
T7*ms17_118;
T7*ms37_3169;
T7*ms37_304a;
T7*ms37_2833;
T7*ms37_3294;
T7*ms37_340a;
T7*ms37_304;
T7*ms37_324;
T7*ms37_1826831355;
T7*ms37_326;
T7*ms37_340;
T7*ms37_336;
T7*ms37_341;
T7*ms37_297;
T7*ms35_1520107011;
T7*ms37_603;
T7*ms37_594;
T7*ms37_674;
T7*ms37_689;
T7*ms37_262628264;
T7*ms37_0aa;
T7*ms37_721564652;
T7*ms37_6687;
T7*ms35_141444;
T7*ms37_98806116;
T7*ms37_301485;
T7*ms18_329;
T7*ms37_1361085152;
T7*ms37_9107;
T7*ms37_9121;
T7*ms37_1023953763;
T7*ms38_276;
T7*ms37_8976;
T7*ms38_46a;
T7*ms16_0;
T7*ms37_0aaaaaa;
T7*ms37_447734;
T7*ms37_19761224;
T7*ms37_448859;
T7*ms37_0aaa;
T7*ms19_56612951;
T7*ms37_0;
T7*ms37_1494914262;
T7*ms58_1126833709;
T7*ms37_57487;
T7*ms19_216;
T7*ms37_467476687;
T7*ms37_59731;
T7*ms37_876917780;
T7*ms37_683870135;
T7*ms37_76405;
T7*ms35_210310269;
T7*ms37_17494489;
T7*ms37_561720547;
T7*ms37_1772235;
T7*ms35_3556890;
T7*ms35_1293738877;
T7*ms37_179868158;
T7*ms35_1800535743;
T7*ms37_91157;
T7*ms19_300594;
T7*ms37_581585530;
T7*ms17_142550;
T7*ms35_1662662954;
T7*ms38_276a;
T7*ms19_1071750288;
T7*ms18_8897;
T7*ms17_1042405932;
T7*ms37_1721407046;
T7*ms35_44975894;
T7*ms37_698995372;
T7*ms37_836475934;
T7*ms37_1106932385;
T7*ms35_27561173;
T7*ms35_136264778;
T7*ms37_39617954;
T7*ms19_2248290;
T7*ms37_207986277;
T7*ms37_683870135a;
T7*ms35_1430004157;
T7*ms37_11253;
T7*ms37_355003;
T7*ms37_51699930;
T7*ms37_13028;
T7*ms35_210141519;
T7*ms37_72020566;
T7*ms37_12782;
T7*ms35_1711985232;
T7*ms37_1091987;
T7*ms37_0aaaaa;
T7*ms37_1236979201;
T7*ms37_15721;
T7*ms37_0aaaa;
T7*ms37_1102814319;
T7*ms37_415107;
T7*ms37_137550186;

T7*se_ms(int c,char*e){
/* Allocate a Manifest STRING.*/
T7*s=((T7*)se_malloc(sizeof(T7)));
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}

T7*se_string(char*e){
/* Allocate an Eiffel STRING by copying C char*e */
int c=strlen(e);
T7*s=((T7*)se_malloc(sizeof(*s))/*12*/);
*s=M7;
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}

void se_msi1(void){
ms37_16702=se_ms(4,"mcr ");
ms37_128214728=se_ms(27,"Hope this is a VMS system.\n");
ms37_1631212670=se_ms(38,"Hope this is a Macintosh like system.\n");
ms37_18144=se_ms(4,"vpcc");
ms37_17794=se_ms(4,"vbcc");
ms37_218174=se_ms(6,"-s -d1");
ms37_39204698=se_ms(9,"SCOPTIONS");
ms37_0a=se_ms(0,"");
ms37_1866433364=se_ms(36,"\".\nCurrently handled system names :\n");
ms38_46=se_ms(1,".");
ms38_63=se_ms(1,"?");
ms37_223953=se_ms(6,"-lcpml");
ms37_530877013=se_ms(11," StripDebug");
ms37_968120=se_ms(7,"-DAMIGA");
ms37_2075119688=se_ms(22,"#1#2#3#4#5#6#7#8#9#?.o");
ms19_1090=se_ms(3,"\".\n");
ms35_354654986=se_ms(23,"Environment variable $\173""");
ms37_304aa=se_ms(2,"-O");
ms37_466551816=se_ms(11,"$ link/exe=");
ms37_1125006=se_ms(7,"-lmieee");
ms37_860169684=se_ms(74,"System environment variable \"SmallEiffel\" not set.\nTrying default value: \"");
ms37_382130=se_ms(6,"bcc32i");
ms19_3085=se_ms(3,"bin");
ms16_2073823=se_ms(7,"install");
ms19_3595=se_ms(3,"sys");
ms37_426884100=se_ms(22,"Optimize OptimizerTime");
ms37_1663868=se_ms(7,"OpenVMS");
ms37_1335=se_ms(3,",-\n");
ms37_270309168=se_ms(34,"Currently handled compiler names:\n");
ms37_1438=se_ms(3,".00");
ms37_1570=se_ms(3,"-O2");
ms37_2178=se_ms(3,"DOS");
ms37_1744=se_ms(3,".cc");
ms37_1774=se_ms(3,"-lm");
ms37_2440=se_ms(3,"OS2");
ms37_2565=se_ms(3,"[1-");
ms37_3069=se_ms(3,"ccc");
ms37_3094=se_ms(3,"dcc");
ms17_118=se_ms(1,"v");
ms37_3169=se_ms(3,"gcc");
ms37_304a=se_ms(2,"-O");
ms37_2833=se_ms(3,"g++");
ms37_3294=se_ms(3,"lcc");
ms37_340a=se_ms(2,"-s");
ms37_304=se_ms(2,"-O");
ms37_324=se_ms(2,"-c");
ms37_1826831355=se_ms(27,"-5 -w-aus -w-par -w-rvl -O2");
ms37_326=se_ms(2,"-e");
ms37_340=se_ms(2,"-s");
ms37_336=se_ms(2,"-o");
se_msi2();
}

void se_msi2(void){
ms37_341=se_ms(2,".o");
ms37_297=se_ms(2,".C");
ms35_1520107011=se_ms(39,"Unexpected end_of_input while reading \"");
ms37_603=se_ms(2,"cl");
ms37_594=se_ms(2,"cc");
ms37_674=se_ms(2,"sc");
ms37_689=se_ms(2,"vc");
ms37_262628264=se_ms(10,"linkit.com");
ms37_0aa=se_ms(0,"");
ms37_721564652=se_ms(18," NoVersion NoIcons");
ms37_6687=se_ms(4," To ");
ms35_141444=se_ms(6,"\" as \"");
ms37_98806116=se_ms(10," Data=Auto");
ms37_301485=se_ms(6,"Cygwin");
ms18_329=se_ms(2,".c");
ms37_1361085152=se_ms(30,"@linkit.com\ndelete linkit.com;");
ms37_9107=se_ms(4,".lnk");
ms37_9121=se_ms(4,".obj");
ms37_1023953763=se_ms(13,"SmallEiffel=\"");
ms38_276=se_ms(2,"..");
ms37_8976=se_ms(4,".exe");
ms38_46a=se_ms(1,".");
ms16_0=se_ms(0,"");
ms37_0aaaaaa=se_ms(0,"");
ms37_447734=se_ms(6,"wcc386");
ms37_19761224=se_ms(9," Data=Far");
ms37_448859=se_ms(6,"wcl386");
ms37_0aaa=se_ms(0,"");
ms19_56612951=se_ms(9,"system.se");
ms37_0=se_ms(0,"");
ms37_1494914262=se_ms(18," Ignore=93,194,304");
ms58_1126833709=se_ms(227,"SmallEiffel The GNU Eiffel Compiler\nRelease -0.74 Beta #18 (??? February ??th 2002)\nCopyright (C), 1994-2002 - LORIA - UHP - INRIA - FRANCE\nDominique COLNET and Suzanne COLLIN - SmallEiffel@loria.fr\nhttp://SmallEiffel.loria.fr\n");
ms37_57487=se_ms(5,"Amiga");
ms19_216=se_ms(2,"\".");
ms37_467476687=se_ms(33,"Hope this is a Unix like system.\n");
ms37_59731=se_ms(5,"Elate");
ms37_876917780=se_ms(31,"Unknown compiler name in file\n\"");
ms37_683870135=se_ms(45,"cc/warning=disable=(embedcomment,longextern) ");
ms37_76405=se_ms(5,"bcc32");
ms35_210310269=se_ms(10,"Removing \"");
ms37_17494489=se_ms(15,"compile_to_c: \"");
ms37_561720547=se_ms(62,"\": unknown C compiler name after -cc flag or in the ACE file.\n");
ms37_1772235=se_ms(7,"Windows");
ms35_3556890=se_ms(8,"\" file.\n");
ms35_1293738877=se_ms(13," is not set.\n");
ms37_179868158=se_ms(29,"Unknown system name in file\n\"");
ms35_1800535743=se_ms(13,"System call \"");
ms37_91157=se_ms(5,"wlink");
ms19_300594=se_ms(6,"File \"");
ms37_581585530=se_ms(36,"Hope this is a Windows like system.\n");
se_msi3();
}

void se_msi3(void){
ms17_142550=se_ms(6,"\" is:\n");
ms35_1662662954=se_ms(20,"SmallEiffelDirectory");
ms38_276a=se_ms(2,"..");
ms19_1071750288=se_ms(11,"SmallEiffel");
ms18_8897=se_ms(4,".cpp");
ms17_1042405932=se_ms(20,"Version of command \"");
ms37_1721407046=se_ms(34,"Math=IEEE Parameters=Both Code=Far");
ms35_44975894=se_ms(9,"Writing \"");
ms37_698995372=se_ms(19,"SmallCode SmallData");
ms37_836475934=se_ms(32,"-5 -w-aus -w-par -w-rvl -O2 -O-v");
ms37_1106932385=se_ms(13,"Last chance.\n");
ms35_27561173=se_ms(21,"Trying to read file \"");
ms35_136264778=se_ms(21,"Reading one word in \"");
ms37_39617954=se_ms(9,"Macintosh");
ms19_2248290=se_ms(7,"version");
ms37_207986277=se_ms(10,"OpenVMS_CC");
ms37_683870135a=se_ms(45,"cc/warning=disable=(embedcomment,longextern) ");
ms35_1430004157=se_ms(15," used in file \"");
ms37_11253=se_ms(4,"BeOS");
ms37_355003=se_ms(6,"][0-9]");
ms37_51699930=se_ms(9,"lcc-win32");
ms37_13028=se_ms(4,"UNIX");
ms35_210141519=se_ms(10,"Renaming \"");
ms37_72020566=se_ms(10,"\nlink/exe=");
ms37_12782=se_ms(4,"Link");
ms35_1711985232=se_ms(19,"Cannot write file \"");
ms37_1091987=se_ms(7,"-mD -mC");
ms37_0aaaaa=se_ms(0,"");
ms37_1236979201=se_ms(11,"compiler.se");
ms37_15721=se_ms(4,"dice");
ms37_0aaaa=se_ms(0,"");
ms37_1102814319=se_ms(11,"System is \"");
ms37_415107=se_ms(6,"lcclnk");
ms37_137550186=se_ms(21,"-O2 -nologo -D\"WIN32\"");
}

void*se_ma44(int argc,...){
T44*m;
va_list pa;
T0**s;
m=se_malloc(sizeof(*m));
*m=M44;
if(argc){
s=se_malloc(argc*sizeof(*s));
m->_storage=s;
m->_capacity=argc;
m->_lower=1;
m->_upper=argc;
va_start(pa,argc);
while(argc--){
*(s++)=((void*)(va_arg(pa,char*)));
}
va_end(pa);
}
else{
m->_storage=NULL;
m->_capacity=0;
m->_lower=1;
m->_upper=0;
}
return m;
}

void X57add_last(T0*C,T0* a1){
{Tid id=((T0*)C)->id;
if(id<=44){
r44add_last(((T44*)C),a1);
}
else{
r51add_last(((T51*)C),a1);
}}
}

#ifdef __cplusplus
}
#endif
