/* 
 * This file is for NON-unix systems.
 * Use config.h (generated by configure) for unix!!!
 * 
 * This file is used to indicate capabilities of the C compiler and
 * operating system.  Additionally, you can set optional features
 * here that are under autoconf control on unix.
 * 
 * See also slrnfeat.h for the rest of slrn features.
 */

/* define if you want slrnpull support */
#define SLRN_HAS_PULL_SUPPORT		1

/* define if you want NNTP support */
#define SLRN_HAS_NNTP_SUPPORT		1

/* define if you want support for reading from a news spool */
#define SLRN_HAS_SPOOL_SUPPORT		1

/* define if you want support for posting via inews */
#define SLRN_HAS_INEWS_SUPPORT		1

/* define if you want to force the use of inews */
#define SLRN_FORCE_INEWS		0

/* define if you want to disallow custom From headers
 * Works only on unix and VMS! */
#define SLRN_HAS_STRICT_FROM 0

/* define if you want SSL support */
#define SLRN_HAS_SSL_SUPPORT	0

/* define if you want uudeview support */
#define SLRN_HAS_UUDEVIEW	0

/* define if you want slang interpreter support */
#define SLRN_HAS_SLANG			1

/* define if you want MIME support */
#define SLRN_HAS_MIME			1

/* define if you want slrn to map between ISO-Latin and native charsets */
#define SLRN_HAS_CHARACTER_MAP		1

/* define if you want spoiler support */
#define SLRN_HAS_SPOILERS		1

/* define if you want emphasized text support */
#define SLRN_HAS_EMPHASIZED_TEXT	1

/* define if you want verbatim marks */
#define SLRN_HAS_VERBATIM_MARKS		1

/* define if you want grouplens (R.I.P.) support */
#define SLRN_HAS_GROUPLENS		0

/* define if you want slrn to generate Message-IDs */
#define SLRN_HAS_GEN_MSGID		1

/* define to make slrn cache Message-IDs to eliminate cross-posts */
#define SLRN_HAS_MSGID_CACHE		0

/* define if slrn should use In-Reply-To if no References are available */
#define SLRN_HAS_FAKE_REFS		1

/* End of features section. See slrnfeat.h for the rest. */

/* Does your compiler support vsnprintf()? */
/* #define HAVE_VSNPRINTF 1 */

#define SLTCP_HAS_SSL_SUPPORT SLRN_HAS_SSL_SUPPORT

#if defined (__USE_SVID) || defined (__USE_XOPEN) || (defined (__MSVCRT__) && !defined (_NO_OLDNAMES))
# define HAVE_TIMEZONE 1
#endif

#ifdef __USE_BSD
# define HAVE_TM_GMTOFF 1
#endif

#ifdef VMS
# ifndef MAIL_PROTOCOL
#   if defined(UCX) || defined(MULTINET)
#     define MAIL_PROTOCOL "SMTP%"
#   else
#     define MAIL_PROTOCOL "IN%"
#   endif
# endif
#endif

#ifdef __GO32__
# ifdef REAL_UNIX_SYSTEM
#  undef REAL_UNIX_SYSTEM
# endif
# ifndef __DJGPP__
#  define __DJGPP__ 1
# endif
#endif

#if defined(__MSDOS__) || defined(__DOS__)
# ifndef __MSDOS__
#  define __MSDOS__
# endif
# ifndef IBMPC_SYSTEM
#  define IBMPC_SYSTEM
# endif
#endif

#if defined(OS2) || defined(__OS2__)
# ifndef IBMPC_SYSTEM
#   define IBMPC_SYSTEM
# endif
# ifndef __os2__
#  define __os2__
# endif
#endif

#if defined(__CYGWIN32__) && !defined(__CYGWIN__)
# define __CYGWIN__
#endif

#if defined(__CYGWIN__) || defined(__MINGW32__) || defined(__WATCOMC__)
# ifndef __WIN32__
#  define __WIN32__
# endif
#endif

#if defined(WIN32) || defined(__WIN32__)
# ifndef IBMPC_SYSTEM
#  define IBMPC_SYSTEM
# endif
# ifndef __WIN32__
#  define __WIN32__ 
# endif
#endif

#if defined(__MSDOS__) && !defined(__GO32__) && !defined(DOS386) && !defined(__WIN32__)
# ifndef __MSDOS_16BIT__
#  define __MSDOS_16BIT__	1
# endif
#endif

#if defined(__NT__)
# ifndef IBMPC_SYSTEM
#  define IBMPC_SYSTEM
# endif
#endif

#if defined(IBMPC_SYSTEM) || defined (__DECC) || defined(VAXC)
# define HAVE_STDLIB_H 1
#else
# define HAVE_MALLOC_H 1
#endif

#if defined (__os2__)
# define HAVE_UNISTD_H 1
# define HAVE_MEMORY_H 1
# define HAVE_SYS_SOCKET_H 1
# define HAVE_NETINET_IN_H 1
# define HAVE_ARPA_INET_H 1
# define HAVE_DIRENT_H 1
# define HAVE_FCNTL_H 1
#endif

#if defined(__NT__) || defined(__WIN32__)
# ifndef __CYGWIN__
#  define HAVE_UNISTD_H 1
# endif
# define HAVE_MEMORY_H 1
# define HAVE_FCNTL_H 1
# define HAVE_LOCALE_H 1
# define HAVE_SETLOCALE 1
# if defined(__CYGWIN__) || defined(__MINGW32__)
#  define HAVE_DIRENT_H 1
# else
#  define HAVE_DIRECT_H 1
# endif
# define popen _popen
# define pclose _pclose
#endif

#if defined(__WIN32__)
# if !defined(__CYGWIN__) && !defined(__MINGW32__)
#  define HAVE_WINSPOOL_H
# endif
#endif

#ifdef VMS
# if __VMS_VER >= 60200000
#  define HAVE_UNISTD_H
# endif
# if __VMS_VER >= 70000000
#  define HAVE_GETTIMEOFDAY
# endif
#endif

/* Does VMS have these?  Do *all* VMS version have them? */
#ifndef VMS
# define HAVE_ISALPHA 1
# define HAVE_ISSPACE 1
# define HAVE_ISDIGIT 1
# define HAVE_ISALNUM 1
# define HAVE_ISPUNCT 1
#endif

#if defined(VMS) || defined(__os2__)
# define USE_NOTEPAD_PRINT_CODE
#endif

#ifdef __WIN32__
/* # define USE_NOTEPAD_PRINT_CODE */
#endif

/* 
 * Basic C library functions.
 */

#if defined(__os2__) || defined(__NT__)
# define HAVE_PUTENV 1
#endif

#define HAVE_GETCWD 1
#define HAVE_MEMSET 1
#define HAVE_MEMCPY 1
#define HAVE_MEMCHR 1

/* undefine if your sprintf does not return an int */
#define HAVE_ANSI_SPRINTF 1

#define SLRN_SERVER_ID_NNTP 1
#define SLRN_SERVER_ID_SPOOL 2

#define SLRN_POST_ID_NNTP 1
#define SLRN_POST_ID_INEWS 2
#define SLRN_POST_ID_PULL 3

#if defined(IBMPC_SYSTEM) && !defined(__CYGWIN__)
# define SLRN_PATH_SLASH_CHAR	'\\'
#endif

#ifndef SLRN_PATH_SLASH_CHAR
/* I have no idea whether or not this will work on VMS. 
 * Using ']' is probably better. 
 */
# define SLRN_PATH_SLASH_CHAR	'/'
#endif

#if defined(__os2__)
/* Uncomment for no FAT code */
# define SLRN_USE_OS2_FAT
#endif

/* gettext is currently only supported on unix */
#define _(a) (a)
#define N_(a) a
