\function{close_log_file}
\synopsis{Close a previously opened log file}
\usage{Void close_log_file ()}
\description
   The \var{close_log_file} function closes the file previously opened
   by \var{open_log_file}.
\seealso{open_log_file, log_message}
\done

\function{log_message}
\synopsis{Send a message to the log file}
\usage{Void log_message (String_Type msg)}
\description
   The \var{log_message} function may be used to write a string to the
   log file.  If no log file has been opened via \var{open_log_file},
   the message will be written to \var{stderr}.
\seealso{open_log_file, close_log_file, message}
\done

\function{make_home_filename}
\synopsis{-}
\usage{String make_home_filename (name)}
\description
   This function returns the complete filename associated with a file
   called \var{name} located in the user's home directory.
\seealso{read_mini}
\done

\function{open_log_file}
\synopsis{Log S-Lang traceback messages to a file}
\usage{Void open_log_file (String_Type file)}
\description
   The \var{open_log_file} function causes \slang traceback messages
   to be written to the specified file.  This is useful for debugging
   macros.  Traceback messages are enabled by setting the \slang
   variable \var{_traceback} to a non-zero value.
\seealso{close_log_file, log_message, _traceback, _trace_function}
\done

\function{print_file}
\synopsis{Send a file to the printer}
\usage{Void print_file (String_Type file)}
\description
   The \var{print_file} function may be used to send a specified file
   to the printer.
\notes
   The printer is specified via the slrnrc \var{printer_name} variable.
\done

