static variable window = NULL, region = NULL;
static variable gc, drawable, fillrule = GDK_WINDING_RULE;
static variable abscissae, ordinates;

static define realize_drawarea(darea)
{
   % Define a local drawable instance, to underscore that the returned
   % GdkWindow has an additional reference added by SLgtk, but which
   % will be properly dereferenced when the variable goes out of scope.
   variable local_drawable = gtk_widget_get_window(darea);

   drawable = gtk_widget_get_window(darea);
   vmessage("\nDrawing Area Allocation:\n\t%S\n",
	 	struct2string(gtk_widget_get_allocation(darea)));
   gc = gdk_gc_new(drawable);
   abscissae = [50];
   ordinates = [50];
}

static define expose_drawarea(darea,event)
{
   variable n = length(abscissae);
   !if (n) return TRUE;

   while (n, n--)
	gdk_draw_line(drawable,gc,abscissae[n],ordinates[n],
	      				abscissae[n-1],ordinates[n-1]);

   return TRUE;
}

static define add_vertex(darea,event)
{
   variable x, y;
   gtk_widget_get_pointer(darea,&x,&y);
   gdk_draw_line(drawable,gc,abscissae[-1],ordinates[-1], x, y);
   abscissae = [abscissae, x];
   ordinates = [ordinates, y];
   return TRUE;
}

static define contains_point(darea,event)
{
   if (region == NULL)
 	return printf("NULL region\n");

   variable x, y;
   gtk_widget_get_pointer(darea,&x,&y);
   () = printf("(%S,%S) ",x,y);

   if (gdk_region_point_in(region,x,y))
 	() = printf("IS within polygon interior\n");
   else
 	() = printf("IS NOT within polygon interior\n");

   return TRUE;
}

static define closepoly(darea,sigid)
{
   if (length(abscissae) < 2)
      return;

   if (g_signal_handler_is_connected(darea,sigid)) {
	gdk_draw_line(drawable,gc,abscissae[-1],ordinates[-1],
	    				abscissae[0], ordinates[0]);
	g_signal_handler_disconnect(darea,sigid);
	() = g_signal_connect(darea,"button-press-event",&contains_point);

	ERROR_BLOCK
	{
	   vmessage("could not create polygon region");
	   region = NULL;
	}
	region = gdk_region_arrays(abscissae,ordinates,fillrule);
   }
   vmessage("Polygon closed: %S vertices",length(abscissae));
}

static define set_fillrule(button)
{
   if (gtk_toggle_button_get_active(button))
	fillrule = GDK_EVEN_ODD_RULE;
   else
	fillrule = GDK_WINDING_RULE;

   if (region != NULL)
	region = gdk_region_arrays(abscissae,ordinates,fillrule);
}

define create_drawarea(test)
{
  if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	() = g_signal_connect (window, "destroy",
				&gtk_widget_destroyed,
				&window);

	gtk_window_set_title(window, "GtkDrawingArea");
	gtk_window_set_default_size(window, 450, 350);

	variable vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(window,vbox);

	variable frame = gtk_frame_new("DrawingArea");
	gtk_container_add(vbox,frame);
	variable darea = gtk_drawing_area_new();
	gtk_container_add(frame,darea);

	gtk_widget_add_events (darea,GDK_BUTTON_PRESS_MASK);
	() = g_signal_connect(darea,"realize",&realize_drawarea);
	() = g_signal_connect(darea,"expose_event",&expose_drawarea);
	variable sigid = g_signal_connect(darea,
	      				"button_press_event",&add_vertex);

	variable separator = gtk_hseparator_new();
	gtk_box_pack_start (vbox, separator, FALSE, TRUE, 0);

	variable comment = gtk_label_new("Click mouse within drawing area "+
		"to define vertices of polygon.\nAfter closing the polygon"+
		" clicking on the drawing area will emit\nmessages indicating"+
		" whether the mouse position is within the\npolygon.");
	gtk_box_pack_start (vbox, comment, FALSE, FALSE, 20);

	variable align = gtk_alignment_new(.5,.5,0.1,0.1);
	gtk_box_pack_start (vbox, align, FALSE, FALSE, 10);
		        
	variable button = gtk_check_button_new_with_label("Exclude points "+
					"within overlapping subpolygons");
	gtk_container_add(align, button);
	() = g_signal_connect(button,"clicked",&set_fillrule);

	variable hbox = gtk_hbox_new(TRUE,10);
	gtk_box_pack_start(vbox,hbox,FALSE,FALSE,15);

	button = gtk_button_new_with_label("Close Polygon");
	() = g_signal_connect_swapped(button, "clicked",&closepoly,darea,sigid);
	gtk_box_pack_start(hbox,button,FALSE,FALSE,20);

	button = gtk_button_new_with_label("     Quit    ");
	() = g_signal_connect_swapped(button, "clicked",
					&gtk_widget_destroy,window);
	gtk_box_pack_end(hbox,button,FALSE,FALSE,20);
	test.lower = button;
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
