#define pop_defaultable(argno, kind, type, obj, value) \
   (SLang_Num_Function_Args >= argno ? SLang_pop_##kind ( (type*)&obj) : ((obj = value) || &obj))

static void slirp_debug_pause(char *module_name)
{
   const char *var = getenv("SLIRP_DEBUG_PAUSE");
   if (var == NULL)
	return;
 {
   const char *prefix  = "slirp_debug_pause:";
   int length = atoi(var);

   if (module_name == NULL)
	module_name = (char*)"";

   if (length < 0) {
	length = abs(length);
	fprintf(stderr,"\n%s entered, ", prefix);
	fprintf(stderr,"will exit after %d second(s) ...\n",length);
	sleep(length);
	return;
   }

   fprintf(stderr,"\n%s %s module symbols have been loaded",prefix,module_name);
   fprintf(stderr,"\n%s set breakpoint(s) in debugger window, then",prefix);
   fprintf(stderr,"\n%s press any key in this window to continue\n",prefix);
   length = getchar();
 }
}

static void Slirp_usage_err(int i, int j);

static int slang_abi_mismatch(void)
{
   long module_abi = SLANG_VERSION / 10000;
   long app_abi    = SLang_Version / 10000;

   if (module_abi != app_abi) {
	SLang_verror(SL_APPLICATION_ERROR, (char*)
		"S-Lang library abi mismatch\nmodule: %s, application: %s",
		SLANG_VERSION_STRING, SLang_Version_String);
	return 1;
   }
			        
   return 0;
}
