
import("triv");
() = evalfile("../examples-common");

define do_sum(augend,addend)
{
   print("triv_sum (%S, %S) = %S",augend,addend, triv_sum(augend,addend));
}

define do_mult(op1,op2,func)
{
   print("%S (%S, %S) = %S",func,op1,op2,@func(op1,op2));
}

define use_triv_datum()
{
   print;
   variable datum = triv_datum_new("TheLorax",999.999);
   print("triv_datum_new() returned: <%S>", typeof(datum));
}

define map_voidstar(thing)
{
   variable vs = triv_voidstar_echo(thing);
   print("triv_voidstar_echo mapped <%S> type to <%S> type",thing,vs);
}


print;
do_sum(-1,1);
do_sum(55,45);
print;

do_mult(333,3,&triv_mult);
do_mult(333,3,&triv_mult2);	% Verify argmap applied to triv_mult2

set_float_format ("%16.14f");
do_mult(PI/2,2, &triv_mult);
do_mult(PI/2,2, &triv_mult2);	% Verify argmap applied to triv_mult2

variable i = 111;
triv_set_ref_i(&i);
print("\nAfter triv_set_ref_i(&i) the new value of i is: %d",i);

use_triv_datum();

% Test that functions which return arrays of indeterminate size,
% e.g. int*, are automatically remapped to return opaque pointers
variable opaque_int_array = triv_make_array_i();
print("triv_make_array_i() returned: <%S>", typeof(opaque_int_array));

% Verify that such can be passed back to C routines, e.g. which accept int*
triv_print_array_i(3, opaque_int_array);

% Similar test for opaque pointers to string arrays of indeterminate size
variable opaque_string_array = triv_make_array_s();
print("triv_make_array_s() returned: <%S>",typeof(opaque_string_array));
triv_print_array_s(opaque_string_array);

triv_print_array_s(["one","two","three"]);

variable sarray_2d = String_Type[2,3];
sarray_2d[0,*] = ["sarray_2d_elem11","sarray_2d_elem12","sarray_2d_elem13"];
sarray_2d[1,*] = ["sarray_2d_elem21","sarray_2d_elem22","sarray_2d_elem23"];
triv_print_array_s(sarray_2d);

% And for opaque pointers to indeterminately sized arrays of opaque types
variable opaque_datum_array = triv_make_array_datum();
print("triv_make_array_datum() returned: <%S>", typeof(opaque_datum_array));
triv_print_array_datum(3,opaque_datum_array);

print;
triv_print_array_f([1.1, 2.2, 3.3, 4.4, 5.5]);

% Now show that -refscalars option allows scalars to be
% passed to functions expecting array arguments
print;
triv_print_array_i(1, 999);
triv_print_array_f(11.1);


print;
% Demonstrate use of enumeration value mnemonics
Print_Error(TRIV_GOOD);
Print_Error(TRIV_BAD);
Print_Error(TRIV_UGLY);

print;

% Demonstrate handling of void* args and return values
map_voidstar(opaque_int_array);
map_voidstar(opaque_string_array);
map_voidstar(opaque_datum_array);

variable nts = triv_make_array_nts();
triv_print_array_nts(nts);

triv_int_accepter(101,202,303);

print;
variable j = -100;
print("Before triv_swap_double(&i, &j): i=<%f> and j=<%f>", i,j);
triv_swap_double(&i, &j);
print("After triv_swap_double(&i, &j): i=<%f> and j=<%f>", i,j);
i = 999;
print("Before triv_swap_double(i, &j): i=<%f> and j=<%f>", i,j);
triv_swap_double(i, &j);
print("After triv_swap_double(i, &j): i=<%f> and j=<%f>", i,j);
i = 333.333; j = 111.11;
print("Before triv_swap_double(i, j): i=<%f> and j=<%f>", i,j);
triv_swap_double(i, j);
print("After triv_swap_double(i, j): i=<%f> and j=<%f>", i,j);

% Next few examples exercise #argmaps which map N>1 C args to M>1 S-Lang args
variable array1 = [1,2,4,3];
print("triv_equals_array_d(array1, array2) returned: %d",
				triv_equals_array_d(array1, [1,2,3,4]));
print("triv_equals_array_d(array1, array1) returned: %d",
				triv_equals_array_d(array1, array1));

print("triv_copy_string returned: %s",triv_copy_string("WhoAreYou?"));

triv_arg_dropper_2();
triv_arg_dropper_1();
