//zzc:
#ifndef __CYGWIN__
/*
	skyeye_net_tuntap.c - tuntap net device file support functions
	Copyright (C) 2003 Skyeye Develop Group
	for help please send mail to <skyeye-developer@lists.sf.linuxforum.net> 
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 
*/

/*
 * 04/27/2003 	initial version
 *			chenyu <chenyu@hpclab.cs.tsinghua.edu.cn>
 */

//koodailar add for mingw 2005.12.18 ----------------------------------------
#ifdef __MINGW32__
#include "arch/arm/common/armdefs.h"
#else
#include <sys/ioctl.h>
#include "armdefs.h"
#endif
// end ----------------------------------------------------------------------


#ifdef __linux__
#include <net/if.h>
#include <linux/if_tun.h>
#endif

#ifdef __FreeBSD__
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/if_tun.h>
#include <fcntl.h>
#endif

#define DEBUG 0
#if DEBUG
#define DBG_PRINT(a...) fprintf(stderr, ##a)
#else
#define DBG_PRINT(a...)
#endif

#define DEFAULT_TUNTAP_IF_NAME "tap"
static name_index = 0;

//koodailar add this for mingw 2005.12.18---------------------------------------
//Makefile needs to change ...
#ifdef __MINGW32__
int tuntap_open(struct net_device *net_dev){return 0;}
#else
int
tuntap_open (struct net_device *net_dev)
{
	int tapif_fd;
	struct ifreq ifr;
	char buf[128];
	char if_name[10];


	DBG_PRINT ("tapif_init begin\n");

#ifdef __linux__
	tapif_fd = open ("/dev/net/tun", O_RDWR);
	DBG_PRINT ("tapif_init: fd %d\n", tapif_fd);
	if (tapif_fd < 0) {
		perror ("tapif_init:open");
		printf ("-----------------------------------------------------------\n");
		printf ("NOTICE: you should be root at first !!!\n");
		printf ("NOTICE: you should inmod linux kernel net driver tun.o!!!\n");
		printf ("NOTICE: if you don't make device node, you should do commands:\n");
		printf ("NOTICE:    mkdir /dev/net; mknod /dev/net/tun c 10 200\n");
		printf ("NOTICE: now the net simulation function can not support!!!\n");
		printf ("NOTICE: Please read SkyEye.README and try again!!!\n");
		printf ("-----------------------------------------------------------\n");
		return 1;
	}
#endif
#ifdef __FreeBSD__
	tapif_fd = open ("/dev/tap", O_RDWR);
	DBG_PRINT ("tapif_init: fd %d\n", tapif_fd);
	if (tapif_fd == -1) {
		perror ("tapif_init:open");
		printf ("-----------------------------------------------------------\n");
		printf ("NOTICE: You should run as root if you require network\n");
		printf ("NOTICE: load the kernel tap module with 'kldload if_tap'\n");
		printf ("NOTICE: and execute 'cat /dev/tap'. there should be a \n");
		printf ("NOTICE: device node under /dev/ (e.g. /dev/tap0).\n");
		printf ("-----------------------------------------------------------\n");
		return 1;
	}
#endif
#if !defined(__FreeBSD__)&&!defined(__linux__)
	printf ("NOTICE: No network support for your OS(yet). Bugging out!\n");
	return 1;
#endif

	snprintf (if_name, sizeof (if_name), "%s%d", DEFAULT_TUNTAP_IF_NAME,
		  name_index);

#ifdef __linux__
	memset (&ifr, 0, sizeof (ifr));
	ifr.ifr_flags = IFF_TAP | IFF_NO_PI;
	strncpy (ifr.ifr_name, if_name, IFNAMSIZ);

	if (ioctl (tapif_fd, TUNSETIFF, (void *) &ifr) < 0) {
		printf ("tapif_init: icotl TUNSETIFF error");
		return 1;
	}
#endif

	snprintf (buf, sizeof (buf), "ifconfig %s inet %d.%d.%d.%d",
		  if_name, net_dev->hostip[0], net_dev->hostip[1],
		  net_dev->hostip[2], net_dev->hostip[3]);

	DBG_PRINT ("tapif_init: system(\"%s\");\n", buf);

	system (buf);
	net_dev->net_fd = tapif_fd;

	name_index++;

	DBG_PRINT ("tapif_init end\n");

	return 0;
}
#endif
//end koodailar ----------------------------------------------------------------


int
tuntap_close (struct net_device *net_dev)
{
	close (net_dev->net_fd);
	return 0;
}

int
tuntap_read (struct net_device *net_dev, void *buf, size_t count)
{
	return read (net_dev->net_fd, buf, count);
}

int
tuntap_write (struct net_device *net_dev, void *buf, size_t count)
{
	return write (net_dev->net_fd, buf, count);
}

//zzc: #endif __CYGWIN__
#endif
