/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for operation management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgoperationboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgobjectbase.h"

#include <QDomDocument>

SKGOperationBoardWidget::SKGOperationBoardWidget ( SKGDocument* iDocument )
        : SKGWidget ( iDocument )
{
    SKGTRACEIN ( 10, "SKGOperationBoardWidget::SKGOperationBoardWidget" );

    ui.setupUi ( this );

    //Refresh
    connect ( ( const QObject* ) getDocument(), SIGNAL ( tableModified ( QString, int ) ), this, SLOT ( dataModified ( QString, int ) ), Qt::QueuedConnection );
}

SKGOperationBoardWidget::~SKGOperationBoardWidget()
{
    SKGTRACEIN ( 10, "SKGOperationBoardWidget::~SKGOperationBoardWidget" );

}

QString SKGOperationBoardWidget::getState()
{
    return "";
}

void SKGOperationBoardWidget::setState ( const QString& iState )
{
    Q_UNUSED(iState);
    dataModified ( "", 0 );
}

void SKGOperationBoardWidget::dataModified ( const QString& iTableName, int iIdTransaction )
{
    SKGTRACEIN ( 10, "SKGOperationBoardWidget::dataModified" );
    Q_UNUSED ( iIdTransaction );
    if ( iTableName=="operation" || iTableName.isEmpty() )
    {
        //Get month
        QDate date=QDate::currentDate();
        date=date.addDays ( 1-date.day() );
        QDate date1=date.addDays ( -1 );
        QString month=date.toString ( "yyyy-MM" );
        QString previousmonth=date1.toString ( "yyyy-MM" );

        SKGDocumentBank* doc= dynamic_cast<SKGDocumentBank*> ( getDocument() );
        if ( doc )
        {

            SKGServices::SKGUnitInfo primary=doc->getPrimaryUnit();
            SKGServices::SKGUnitInfo secondary=doc->getSecondaryUnit();

            SKGStringListList listTmp;
            SKGError err=SKGServices::executeSelectSqliteOrder ( getDocument(),
                         "SELECT TOTAL(f_CURRENTAMOUNT), d_DATEMONTH  from v_operation_display WHERE d_DATEMONTH IN ('"+month+"', '"+previousmonth+"') AND i_group_id=0 group by d_DATEMONTH, t_TYPEEXPENSE",
                         listTmp );
            if ( err.isSucceeded() )
            {
                double income_previous_month=0;
                double expense_previous_month=0;
                double income_month=0;
                double expense_month=0;

                int nbval=listTmp.count();
                for ( int i=1; i<nbval; ++i ) //Ignore header
                {
                    QString m=listTmp.at ( i ).at ( 1 );
                    double v=SKGServices::stringToDouble ( listTmp.at ( i ).at ( 0 ) );
                    if ( v>0 && m==month ) income_month=v;
                    else if ( v<0 && m==month ) expense_month=-v;
                    else if ( v>0 && m==previousmonth ) income_previous_month=v;
                    else if ( v<0 && m==previousmonth ) expense_previous_month=-v;
                }

                //Set Maximum
                int max=qMax ( income_previous_month, qMax ( expense_previous_month, qMax ( income_month, expense_month ) ) );
                if ( nbval==1 ) max=100.0;
                ui.kIncome->setMaximum ( max );
                ui.kIncome_previous->setMaximum ( max );
                ui.kExpense->setMaximum ( max );
                ui.kExpense_previous->setMaximum ( max );

                //Set value
                ui.kIncome->setValue ( income_month );
                ui.kIncome_previous->setValue ( income_previous_month );
                ui.kExpense->setValue ( expense_month );
                ui.kExpense_previous->setValue ( expense_previous_month );

                //Set tool tips
                QString tmp=doc->formatMoney ( income_month, primary );
                if ( !secondary.Symbol.isEmpty() && secondary.Value )
                {
                    tmp+="<br>"+doc->formatMoney ( income_month, secondary );
                }
                ui.kIncome->setToolTip ( tmp );

                tmp=doc->formatMoney ( income_previous_month, primary );
                if ( !secondary.Symbol.isEmpty() && secondary.Value )
                {
                    tmp+="<br>"+doc->formatMoney ( income_previous_month, secondary );
                }
                ui.kIncome_previous->setToolTip ( tmp );

                tmp=doc->formatMoney ( expense_month, primary );
                if ( !secondary.Symbol.isEmpty() && secondary.Value )
                {
                    tmp+="<br>"+doc->formatMoney ( expense_month, secondary );
                }
                ui.kExpense->setToolTip ( tmp );

                tmp=doc->formatMoney ( expense_previous_month, primary );
                if ( !secondary.Symbol.isEmpty() && secondary.Value )
                {
                    tmp+="<br>"+doc->formatMoney ( expense_previous_month, secondary );
                }
                ui.kExpense_previous->setToolTip ( tmp );
            }

            //No widget if no account
            int nbAccount=0;
            SKGObjectBase::getNbObjects(doc, "account", "", nbAccount);
            if (parentWidget()) setVisible(nbAccount>0);
        }
    }
}

#include "skgoperationboardwidget.moc"
