#!/usr/bin/ruby -Ke
# saihenkan.rb -- convert SKK normail dictionary to saihenkan dictionary.
#
# Copyright (C) 2003 NAKAJIMA Mikio <minakaji@namazu.org>
#
# Author: NAKAJIMA Mikio <minakaji@namazu.org>
# Created: March 26, 2003
# Last Modified: $Date: 2003/03/26 11:58:00 $
# Version: $Id: saihenkan.rb,v 1.1 2003/03/26 11:58:00 minakaji Exp $

# This file is part of Daredevil SKK.

# Daredevil SKK is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either versions 2, or (at your option)
# any later version.
#
# Daredevil SKK is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Daredevil SKK, see the file COPYING.  If not, write to the
# Free Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
# MA 02111-1307, USA.
#
# Commentary:
# saihenkan.rb SKK-JISYO.S | nkf -e > SKK-JISYO.saihenkan
#
file = ARGV.shift
if !file
else
  print ';;This file was generated by saihenkan.rb at ',
    Time.new(), "\n"
  print ";; okuri-ari entries.\n;; okuri-nasi entries.\n"
  File.open(file).each do |line|
    if (line =~ /^([^ a-z].*[^a-z]) \/(.+)\/$/)
      candidates = $2
      candidates = candidates.split('/')
      max_index = candidates.length - 1
      if (max_index > 0)
	copy = candidates
	candidates.each do |can|
	  print can, ' /'
	  copy.each do |c|
	    if c != can
	      print c, '/'
	    end
	  end
	  print "\n"
	end
      end
    end
  end
end
# end of saihenkan.rb
