;;; skk-num.el --- ѴΤΥץ
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Version: 1.2
;; Keywords: japanese
;; Last Modified: Sat Jan 18 07:26:06 1997

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:

;;; Change log:
;; version 1.1 released 1997.1.18 (derived from the skk.el 8.6)

;;; TODO
;; (1)skk-kanji-num-str2-subr ΥХskk-kanji-num-str2-subr ΥȻ
;;    Τȡ
;;
;; (2)skk-kanji-num-str3 οߡ

;;; Code:
(require 'skk)

;; user variables.
(skk-defvar skk-num-type-list
  '((?0 . identity)
    (?1 . skk-zenkaku-num-str)
    (?2 . skk-kanji-num-str)
    (?3 . skk-kanji-num-str2)
    ;;(?5 . skk-kanji-num-str3) ; 
    (?4 . skk-recompute-numerals)
    (?9 . skk-shogi-num-str) )
  "*ѴΤΡǥѴ˻ѤؿȤΥɥåȥڥΥꥹȡ
Ǥϡ( char-type . ؿ̾) ȤˤʤäƤ롣
car ʬϡ㤨СФ줬 \"ʿ#1ǯ\" ΤȤ# ľɽ
 \"1\"  char-type ɽ路Τ롣")

(skk-defvar skk-numeric-conversion-float-num nil
  "*Non-nil ǤСưȤäФбѴԤʤ
ͤ non-nil ˤ뤳Ȥǡ\"#.# /#1#1/#0#0/\" ʤɤμ񸫽Ф
ǤʤʤΤǡա" )

(skk-defvar skk-num-load-hook nil
  "*skk-num.el ɤ˥뤵եå" )

;; internal constants and variables
(defconst skk-num-alist-type1
  '((?0 . "") (?1 . "") (?2 . "") (?3 . "")
    (?4 . "") (?5 . "") (?6 . "") (?7 . "")
    (?8 . "") (?9 . "")
    (?. . "") ; (?. . ".") ɤͤ⤤뤫...
    (?  . "") )
  "ascii  char type ѿ string type Ϣۥꥹȡ
\"1995\" -> \"\" Τ褦ʸѴԤݤѤ롣" )

(defconst skk-num-alist-type2
  '((?0 . "") (?1 . "") (?2 . "") (?3 . "")
    (?4 . "") (?5 . "") (?6 . "ϻ") (?7 . "")
    (?8 . "Ȭ") (?9 . "") (?  . "") )
  "ascii  char type ȴ string type Ϣۥꥹȡ
\"1995\" -> \"\" Τ褦ʸѴԤݤѤ롣" )

;;; 
;;;(defconst skk-num-alist-type3
;;;  '((?1 . "") (?2 . "") (?3 . "")
;;;    (?4 . "") (?5 . "") (?6 . "ϻ") (?7 . "")
;;;    (?8 . "Ȭ") (?9 . "") (?  . "") )
;;;  "ascii  char type ȴ string type Ϣۥꥹȡ
;;;\"1995\" -> \"ɴ彦\" Τ褦ʸѴԤݤѤ롣" )

(defvar skk-num-list nil
  "skk-henkan-key ˴ޤޤɽʸΥꥹȡ
㤨С\"ؤ7ͤ10\" ѴԤȤskk-henkan-key 
\"ؤ7ͤ10\" Ǥꡢskk-num-list  \(\"7\" \"10\"\) Ȥʤ롣" )
(make-variable-buffer-local 'skk-num-list)

(defvar skk-noconv-henkan-list nil
  "Ѵ̤θꥹȤǡskk-numeric-convert ǿѴԤʤäƤʤΡ
skk-henkan-list  skk-numeric-convert ǿѴԤʤ줿䤬ݻ롣
񹹿ˤϡѴԤʤʸ򻲾Ȥɬפ롣")
(make-variable-buffer-local 'skk-noconv-henkan-list)

(defvar skk-noconv-henkan-key nil
  "skk-compute-numeric-henkan-key 򥳡뤹 skk-henkan-key ͡" )
(make-variable-buffer-local 'skk-noconv-henkan-key)

(defvar skk-recompute-numerals-key nil
  "#4 פΥˤͤκƷ׻ԤʤäȤθ" )
(make-variable-buffer-local 'skk-recompute-numerals-key)

(defun skk-compute-numeric-henkan-key (key)
  ;; KEY Ϣ³ʸ "#" ֤ʸ֤"12"  "" 
  ;; Ϣ³ 1 Ĥ "#" ֤뤳Ȥա
  ;; ֤ skk-num-list ˥ꥹȤη¸롣
  ;; 㤨СKEY  "ؤ 7 ǯ 12 " ǤС"ؤ # ͤ # "
  ;; Ѵskk-num-list  ("7" "12") ȤꥹȤ롣
  ;; θФθ˻Ѥ롣
  (let ((numberrep (if skk-numeric-conversion-float-num
                       "[.0-9]+" "[0-9]+" )))
    (setq skk-noconv-henkan-key key)
    (save-match-data
      ;; ѿ ascii Ѵ롣
      (while (string-match "[-]" key)
        (let ((zen-num (substring key (match-beginning 0)
                                  (match-end 0) )))
          (setq key (concat (substring key 0 (match-beginning 0))
                            (char-to-string
                             (if skk-mule
                                 (- (char-component
                                     (string-to-char zen-num) 2) 128 )
                               (- (aref zen-num (1- skk-kanji-len)) 128) ))
                            (substring key (match-end 0)) ))))
      ;; ascii  "#" ֤ο skk-num-list ¸
      (while (string-match numberrep key)
        (setq skk-num-list (nconc skk-num-list
                                  (list
                                   (substring key (match-beginning 0)
                                              (match-end 0) ))))
        (setq key (concat (substring key 0 (match-beginning 0))
                          "#"
                          (substring key (match-end 0)) )))))
  key )

(defun skk-compute-noconv-henkan-key (key)
  ;; ʸ KEY ˿Ѵɽ魯 "#" Сʬ
  ;; skk-num-list ǳǽ skk-start-henkan Ϥ
  ;; ʸ֤㤨Сskk-num-list  ("1" "2" "3") ǡKEY 
  ;; "#  #  # " ǤȤϡʸ "1  2  3 " ֤
  (if skk-num-list
      (save-match-data
        (let ((num-list skk-num-list)
              str )
          (while (and num-list key (string-match "#" key))
            (setq str (concat str (substring key 0 (match-beginning 0))
                              (car num-list) )
                  key (substring key (match-end 0))
                  num-list (cdr num-list) ))
          (setq key (concat str key)) )))
  key )

(defun skk-numeric-convert (henkan-list)
  ;; HENKAN-LIST ƤθĴ١줾ʸ #[012349] ɽޤ
  ;; Ǥ顢#[012349] ʬ skk-num-exp ˤѴѴʸ
  ;; ʤ HENKAN-LIST ֤
  (if (and henkan-list skk-num-list)
      (save-match-data
        (let ((n 0) convlist convlen current hl)
          ;; skk-uniq-numerals  uniq Ǥ褦ˡƤθФƤ
          (while (and (not skk-kakutei-flag) skk-current-search-prog-list)
            (setq henkan-list (skk-nunion henkan-list (skk-search))) )
          (setq henkan-list (skk-uniq-numerals henkan-list)
                skk-noconv-henkan-list (copy-sequence henkan-list) )
          (while (setq current (nth n henkan-list))
            (setq convlist (skk-numeric-convert-1 current))
            (if (null convlist)
                ;; ѴǽʥȥϾäƤ
                ;; current  henkan-list ǤľܻؤƤ롣delq ǽʬ
                (setq henkan-list (delq current henkan-list)
                      ;; current  skk-noconv-henkan-list Ǥľܻؤ
                      ;; ʤdelete Ȥɬפ롣
                      skk-noconv-henkan-list
                      (delete current skk-noconv-henkan-list) )
              (setq convlen (length convlist))
              ;; 1 ĤΥ 2 İʾθ֤Ȥϡ
              ;; skk-noconv-henkan-list Υȥ䤷Ƥ
              (if (> convlen 1)
                  ;; ⤦äȽ񤱤ʤʡ
                  (setcdr (nthcdr n skk-noconv-henkan-list)
                          (append (make-list (1- convlen)
                                             (nth n skk-noconv-henkan-list) )
                                  (copy-sequence
                                   (nthcdr (1+ n) skk-noconv-henkan-list) ))))
              (setq hl (nconc hl convlist)
                    n (1+ n) )))
          (setq henkan-list hl) )))
  henkan-list )

(defun skk-numeric-convert-1 (key)
  ;; skk-numeric-convert Υ֥롼KEY ѴԤʤѴ̤ʸ
  ;; ΥꥹȤ֤
  ;; 㤨Сskk-num-list  ("5" "2") ǤȤˡKEY  "#2#4" ǡ
  ;; "2 //" Ȥ񥨥ȥ꤬äȤȡ("ޤ" "ޤб") ȤĹ
  ;;  2 ΥꥹȤ֤
  (let ((numexp (if skk-numeric-conversion-float-num
                    "#[.0-9]+" "#[0-9]+" ))
        (n 0)
        num convnum string convlist )
    (catch 'exit
      (while (and (setq num (nth n skk-num-list))
                  (string-match numexp key) )
        (setq convnum (skk-num-exp num (string-to-char
                                        (substring key (1+ (match-beginning 0))
                                                   (match-end 0) ))))
        (if (null convnum)
            (throw 'exit nil)
          (setq string (substring key 0 (match-beginning 0))
                key (substring key (match-end 0))
                convlist (nconc convlist (list string convnum))
                n (1+ n) )))
      (skk-flatten-list (delete "" (nconc convlist (list key)))) )))

(defun skk-flatten-list (raw-list)
  ;; Ϳ줿ꥹȤγǤȤ߹礻ǽʸϢܤꡢꥹȤ
  ;; 
  ;; (("A" "B") "1" ("X" "Y")) -> ("A1X" "A1Y" "B1X" "B1Y")
  (cond ((null raw-list) nil)
        ((null (memq t (mapcar 'listp raw-list)))
         ;; RAW-LIST Ǥʸ
         (list (mapconcat 'identity raw-list "")) )
        ((eq (length raw-list) 1)
         (car raw-list) )
        (t
         (let (len-list total len num elm new)
           (setq len-list (mapcar 'length raw-list)
                 total (apply '* len-list)
                 elm (car raw-list)
                 len (car len-list)
                 num (/ total len) )
           ;; ޤRAW-LIST  car ١ˤʤꥹȤ롣
           (if (listp elm)
               (while elm
                 (setq new (nconc new (make-list num (list (car elm))))
                       elm (cdr elm) ))
             (setq new (make-list num (list elm))) )
           (setq raw-list (cdr raw-list)
                 len-list (cdr len-list) )
           ;; RAW-LIST  cdr  1 ĤŤļФ
           (while raw-list
             (let (attach)
               (setq elm (car raw-list)
                     len (car len-list)
                     num (/ total len) )
               (if (listp elm)
                   (while elm
                     (setq attach (nconc attach
                                         (make-list num (list (car elm))) )
                           elm (cdr elm) ))
                 (setq attach (make-list num (list elm))) )
               ;; ١ΥꥹȤˤäĤƤ椯
               (setq new (mapcar (function (lambda (l)
                                             (prog1 (append (car new) l)
                                               (setq new (cdr new)) )))
                                 attach )
                     raw-list (cdr raw-list)
                     len-list (cdr len-list) )))
           (mapcar (function (lambda (l)
                               (mapconcat 'identity l ""))) new) ))))

(defun skk-num-exp (num type)
  ;; ascii  NUM  TYPE ˽ѴѴʸ֤
  ;; TYPE ϲ̤ꡣ
  ;; 0 -> ̵Ѵ
  ;; 1 -> ѿѴ
  ;; 2 -> Ѵ
  ;; 3 -> Ѵ (̼򤹤)
  ;; 4 -> οΤΤ򥭡ˤƼƸ
  ;; 9 -> ǻѤ ("" ʤ) Ѵ
  (let ((fun (cdr (assq type skk-num-type-list))))
    (if fun (funcall fun num)) ))

(defun skk-zenkaku-num-str (num)
  ;; ascii  NUM ѿʸѴѴʸ֤
  ;; 㤨 "45"  "" Ѵ롣
  (let ((candidate
         (mapconcat (function (lambda (c) (cdr (assq c skk-num-alist-type1))))
                    num "" )))
    (if (not (string= candidate ""))
        candidate )))

(defun skk-kanji-num-str (num)
  ;; ascii  NUM ʸѴѴʸ֤
  ;; 㤨С"45"  "͸" Ѵ롣
  (save-match-data
    (if (not (string-match "\\.[0-9]" num))
        (let ((candidate
               (mapconcat (function (lambda (c)
                                      (cdr (assq c skk-num-alist-type2)) ))
                          num "" )))
          (if (not (string= candidate ""))
              candidate )))))

(defun skk-kanji-num-str2 (num)
  ;; ascii  NUM ʸѴ (̼򤹤)Ѵʸ
  ;; ֤㤨 "1021"  "󽽰" Ѵ롣
  (save-match-data
    (if (not (string-match "\\.[0-9]" num))
        (let ((str (skk-kanji-num-str2-subr num)))
          (if (string= "" str) "" str) ))))

(defun skk-kanji-num-str2-subr (num)
  ;; skk-kanji-num-str2 Υ֥롼
  ;;
  ;; Known Bug; 100000000 Ѵȡ"첯" ˤʤäƤޤ...Ǥ⤽
  ;; ѴȤͤϤʤʡȻפľϤͯʤ...
  (let ((len (length num))
        modulo )
    (mapconcat
     (function
      (lambda (char)
        ;; :            ɴ             ɴ       
        ;; modulo: 1 --> 2 --> 3 --> 0 -> 1 --> 2 ---> 3 ---> 0 ---> 1
        (setq modulo (mod len 4))
        (prog1
            (if (eq len 1)
                ;; 1  0 Ǥʤ
                (if (not (eq char 48)) ;?0
                    ;; ̤ɽ魯ʳδ
                    (cdr (assq char skk-num-alist-type2)) )
              (concat
               ;; ̤ɽ魯ʳδ
               (if (or
                    ;; 2 ʾǡΰ̤ο 0, 1 ʳο
                    ;; ?0 == 48, ?1 == 49
                    (null (memq char '(48 49)))
                    ;; 2 ʾǡΰ̤ο 1 ǡ̤ΰ̤ɽ魯
                    ;;  "" ʻ٤ (㤨С"첯" ʤɡ"" ǤϤ
                    ;; ) Ȥ
                    (and (eq char 49) ;?1
                         (eq modulo 1)) )
                   (cdr (assq char skk-num-alist-type2)) )
               ;; ̤ɽ魯
               (if (not (and (eq char 48) ;?0
                             (not (eq modulo 1)) ))
                   (cond ((eq modulo 2) "")
                         ((eq modulo 3) "ɴ")
                         ((eq modulo 0) "")
                         ((eq len 5) "")
                         ((eq len 9) "")
                         ((eq len 13) "")
                         ((eq len 17) "")
                         (t (skk-error "夬礭ޤ"
                                       "Too big number!" ))))))
          (setq len (1- len)) )))
     num "" )))

(defun skk-shogi-num-str (num)
  ;; ascii  NUM 򾭴ǻѤɽѴ롣
  ;; 㤨 "34"  "" Ѵ롣
  (save-match-data
    (if (and (eq (length num) 2)
             (not (string-match "\\.[0-9]" num)) )
        (let ((candidate
               (concat (cdr (assq (aref num 0) skk-num-alist-type1))
                       (cdr (assq (aref num 1) skk-num-alist-type2)) )))
          (if (not (string= candidate ""))
              candidate )))))

(defun skk-recompute-numerals (num)
  ;; #4 θФФskk-henkan-key 줿ΤΤٸ롣
  (let (result)
    (save-excursion
      ;; ȥХåեΥХåեѿ˱ƶڤܤʤ褦
      ;; 󥰥Хåեذöƨ
      (let (skk-use-numeric-conversion
            buffer-read-only )
        (set-buffer (get-buffer-create " *skk-work*"))
        (setq skk-current-search-prog-list skk-search-prog-list
              ;; ȤѴʤ (skk-henkan-okurigana 
              ;; skk-okuri-char Ϥ nil) ̥Хåե (work Хåե)
              ;; äƤΤǡǰΤᡢnil Ƥ
              skk-henkan-okurigana nil
              skk-okuri-char nil
              skk-henkan-key num
              result (skk-search) )))
    ;;  save-excursion ФѴԤʤäƤ륫ȥХåե
    ;; (ХåեͤǤ skk-henkan-list )
    (setq skk-recompute-numerals-key num)
    (if result
        (if (eq (length result) 1)
            (car result)
          result ))))

(defun skk-uniq-numerals (henkan-list)
  ;; 1 οѴݤˡskk-henkan-list  #2 ȥ #3 ȥ꤬
  ;; С#2 ⤷ #3 ȥΤˤΤä
  ;; 㤨С"4" Ѵ skk-henkan-list  (("#3" "#2")) ˤʤä
  ;; 嵭κȤԤʤʤСֻ͡פȤѴ̤ 2 ٽФƤ롣
  (catch 'not-work
    (if henkan-list
        (let ((num-list skk-num-list)
              (n 0)
              type2 type3 index2 index3 head2 head3 tail2 tail3 elm
              kanji-flag mc-flag enable-multibyte-characters case-fold-search )
          (while num-list
            (if (eq (length (car num-list)) 1)
                (setq num-list (cdr num-list))
              ;; 1 ĤǤ 2 ʾοСuniq ʤ
              (throw 'not-work t) ))
          (save-match-data
            (while (setq elm (nth n henkan-list))
              ;; elm  "#2" Τ褦˿Ѵ򼨤ʸΤߤȤϸ¤ʤΤǡ
              ;; member ϻȤʤ
              (cond ((string-match "#2" elm)
                     (setq type2 elm
                           index2 n
                           head2 (substring elm 0 (match-beginning 0))
                           tail2 (substring elm (match-end 0)) ))
                    ((string-match "#3" elm)
                     (setq type3 elm
                           index3 n
                           head3 (substring elm 0 (match-beginning 0))
                           tail3 (substring elm (match-end 0)) )))
              (setq n (1+ n)) )
            (if (and type2 type3
                     ;; Ѵ򼨤ʸ "#[012349]" ʸƱ
                     ;; ΤȤΤ uniq Ԥʤ
                     (string= head2 head3) (string= tail2 tail3))
                (if (> index2 index3)
                    ;; "#3" ˤ롣
                    (setq henkan-list (delq type2 henkan-list))
                    ;; ѿ type[23] ͤϡhenkan-list ľФ
                    ;;  delete Ǥʤdelq ǽʬ
                  (setq henkan-list (delq type3 henkan-list)) ))))))
    henkan-list )

(defun skk-adjust-henkan-data-for-numerals (key)
  ;; skk-henkan-in-minibuff ǡKEY ͤ skk-henkan-list 
  ;; skk-noconv-henkan-list ͤĴ롣
  ;; KEY  "#[012349]" ʸޤǤϡKEY ͤù롣
  ;; KEY ֤ͤ
  (if (string-match "#[012349]" key)
      (let (converted convlen)
	(setq converted (skk-numeric-convert-1 key)
	      skk-henkan-list (nconc skk-henkan-list converted)
	      convlen (length converted)
	      skk-noconv-henkan-list (nconc skk-noconv-henkan-list
                                            (make-list convlen key) )
	      key (nth skk-henkan-count skk-henkan-list) )
	(if (eq convlen 1)
	    ;; skk-numeric-convert-1 ʣθФȤˤϡ
	    ;; skk-kakutei-flag  non-nil ˤϤʤ
	    (setq skk-kakutei-flag t) ))
    (if skk-recompute-numerals-key
	(setq skk-henkan-list (nconc skk-henkan-list (list key))
	      skk-noconv-henkan-list (nconc skk-noconv-henkan-list
                                            ;; ѴϾ "#4" Ȥϸ¤
                                            ;; ʤ
                                            ;;(list "#4")
                                            (list skk-noconv-henkan-key) ))
      (setq skk-kakutei-flag t) ))
  key )

(defun skk-init-numeric-conversion-variables ()
  ;; skk-use-numeric-convert Ϣѿ롣
  (setq skk-noconv-henkan-key nil
        skk-noconv-henkan-list nil
        skk-num-list nil
        skk-recompute-numerals-key nil ))

(defun skk-noconv-kakutei-word ()
  ;; ꤷǡѴʸ֤
  (if (and skk-noconv-henkan-list (> skk-henkan-count -1))
      (nth skk-henkan-count skk-noconv-henkan-list) ))

(defun skk-numeric-midasi-word ()
  ;; type4 οͺѴԤʤ줿ȤϡͼȤ֤ʳοѴ
  ;; Ǥϡskk-henkan-key ֤ʾʴؿʤʤʤΤϡ
  ;; skk-use-numeric-conversion ˴Ϣѿ skk-num.el ˽󤷤̵
  ;; ̤...
  (if skk-num-list
      (or skk-recompute-numerals-key skk-henkan-key) ))

(defun skk-update-jisyo-for-numerals (word &optional purge)
  ;; Ȥ򸫽ФȤƼΥåץǡȤԤʤ
  (if (and skk-noconv-henkan-list skk-recompute-numerals-key
           (save-match-data (string-match "#4" word)) )
      (let ((skk-henkan-key skk-recompute-numerals-key))
	(skk-update-jisyo (nth skk-henkan-count skk-henkan-list) purge) )
    (if purge
        (skk-update-jisyo
         (nth skk-henkan-count skk-noconv-henkan-list) purge ))))


(run-hooks 'skk-num-load-hook)

(provide 'skk-num)
;;; skk-num.el ends here
