/* Public domain. */

#include <unistd.h>
#include "bytestr.h"
#include "stralloc.h"
#include "tai.h"
#include "env.h"
#include "djbunix.h"
#include "dns_transmit.h"

static int init (stralloc *rules, stralloc *tmp)
{
  unsigned int tmpbase = tmp->len ;
  char const *x ;
  int r ;

  rules->len = 0 ;
  x = env_get("DNSREWRITEFILE") ;
  if (!x) x = "/etc/dnsrewrite" ;

  r = openreadclose(x, tmp, 64) ;
  if (r == -1) return 0 ;

  if (r)
  {
    unsigned int i = 0, j = 0 ;
    if (!stralloc_catb(tmp, "\n", 1)) goto err ;
    for (; j < tmp->len - tmpbase ; j++)
      if (tmp->s[tmpbase + j] == '\n')
      {
        if (!stralloc_catb(rules, tmp->s + tmpbase + i, j - i)) goto err ;
        while (rules->len)
        {
          if (rules->s[rules->len - 1] != ' ')
          if (rules->s[rules->len - 1] != '\t')
          if (rules->s[rules->len - 1] != '\r')
            break ;
          --rules->len ;
        }
        if (!stralloc_0(rules)) goto err ;
        i = j + 1 ;
      }
    tmp->len = tmpbase ;
    return 1 ;
  }

  x = env_get("LOCALDOMAIN") ;
  if (x)
  {
    unsigned int i = 0, j = 0 ;
    tmp->len = tmpbase ; rules->len = 0 ;
    if (!stralloc_cats(tmp, x)) goto err ;
    if (!stralloc_catb(tmp, " ", 1)) goto err ;
    if (!stralloc_catb(rules, "?:", 2)) goto err ;
    for (; j < tmp->len - tmpbase ; j++)
      if (tmp->s[tmpbase + j] == ' ')
      {
        if (!stralloc_catb(rules, "+.", 2)) goto err ;
        if (!stralloc_catb(rules, tmp->s + tmpbase + i, j - i)) goto err ;
        i = j + 1 ;
      }
    if (!stralloc_0(rules)) goto err ;
    if (!stralloc_catb(rules, "*.:", 3)) goto err ;
    if (!stralloc_0(rules)) goto err ;
    tmp->len = tmpbase ;
    return 1 ;
  }

  r = openreadclose("/etc/resolv.conf", tmp, 64) ;
  if (r == -1) goto err ;

  if (r)
  {
    unsigned int i = 0, j = 0 ;
    if (!stralloc_catb(tmp, "\n", 1)) goto err ;
    for ( ; j < tmp->len - tmpbase ; j++)
      if (tmp->s[tmpbase + j] == '\n')
      {
        if (byte_equal("search ", 7, tmp->s + tmpbase + i) || byte_equal("search\t", 7, tmp->s + tmpbase + i) || byte_equal("domain ", 7, tmp->s + tmpbase + i) || byte_equal("domain\t", 7, tmp->s + tmpbase + i))
        {
          rules->len = 0 ;
          if (!stralloc_catb(rules, "?:", 2)) goto err ;
          i += 7 ;
          while (i < j)
          {
            unsigned int k = byte_chr(tmp->s + tmpbase + i, j - i, ' ') ;
            k = byte_chr(tmp->s + tmpbase + i, k, '\t') ;
            if (!k) { ++i ; continue ; }
            if (!stralloc_catb(rules, "+.", 2)) goto err ;
            if (!stralloc_catb(rules, tmp->s + tmpbase + i, k)) goto err ;
            i += k ;
          }
          if (!stralloc_0(rules)) goto err ;
          if (!stralloc_catb(rules, "*.:", 3)) goto err ;
          if (!stralloc_0(rules)) goto err ;
          tmp->len = tmpbase ;
          return 1 ;
        }
        i = j + 1 ;
      }
    tmp->len = tmpbase ;
  }

  if (sagethostname(tmp) == -1) goto err ;
  r = byte_chr(tmp->s + tmpbase, tmp->len - tmpbase, '.') ;
  if ((unsigned int)r < tmp->len - tmpbase)
  {
    rules->len = 0 ;
    if (!stralloc_catb(rules, "?:", 2)) goto err ;
    if (!stralloc_catb(rules, tmp->s + tmpbase + r, tmp->len - tmpbase - r)) goto err ;
    if (!stralloc_0(rules)) goto err ;
  }
  if (!stralloc_catb(rules, "*.:", 3)) goto err ;
  if (!stralloc_0(rules)) goto err ;

  tmp->len = tmpbase ;
  return 1 ;

err:
  tmp->len = tmpbase ;
  rules->len = 0 ;
  return 0 ;
}

int dns_resolvconfrewriteit_tmp (struct dns_rcrw_info *dr, stralloc *tmp)
{
  struct taia now ;
  taia_now(&now) ;
  if (!dr->uses-- || taia_less(&dr->deadline, &now))
  {
    if (!init(&dr->rules, tmp)) return 0 ;
    taia_addsec(&dr->deadline, &now, 600) ;
    dr->uses = 10000 ;
  }
  return 1 ;
}
