/* probably redondant includes... */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/keysym.h>
#include <X11/Xresource.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <dirent.h>
#include <stdarg.h>
#include <signal.h>
#include <sys/wait.h>

#include "sjog_scroll.h"


/* -------------------------------------------------------------------------- */

Display *disp = NULL;        /* X11 display sjog is running on */
KeyCode upKeycode;           /* what to send when jog is up */
KeyCode downKeycode;         /* what to send when jog is down */

/* -------------------------------------------------------------------------- */


/* 
 * Called by sjog_check_jog_position when we are in SJOG_MODE_SCROLL.
 * Checks the jog and send page up/down according to its position.
 */
void
sjog_scroll_check_jog_position(int jog)
{

#ifdef DEBUG
   fprintf(stdout, "sjog_scroll_check_jog_position\n");
#endif

   if (disp == NULL)
      sjog_scroll_init();

   switch (jog)
   {

        /* send page down */
     case JOG_BOTTOM:
        sjog_scroll_down();
        break;

        /* popup main window */
     case JOG_PUSHED:
        sjog_list_show();
        break;

        /* send page up */
     case JOG_TOP:
        sjog_scroll_up();
        break;

     default:

   }

}

/* -------------------------------------------------------------------------- */

/* 
 * Initializes the display and the keycodes for up/down action
 */
void
sjog_scroll_init()
{
   KeySym ks_up, ks_down;

   /* try to open x11 display */

   disp = XOpenDisplay(NULL);
   if (!disp)
   {
      fprintf(stderr, "Can't open X display. It *is* running, yeah?");
      exit(1);
   }

   if (mousewheelFakeKeys)
      sjog_scroll_init_keycodes();

}

/* -------------------------------------------------------------------------- */

/*
 * retrieve KeySym for page up/down then KeyCode.
 */
void
sjog_scroll_init_keycodes()
{

   KeySym ks_up, ks_down;

   ks_up = XStringToKeysym("Page_Up");
   upKeycode = XKeysymToKeycode(disp, ks_up);

   ks_down = XStringToKeysym("Page_Down");
   downKeycode = XKeysymToKeycode(disp, ks_down);

}

/* -------------------------------------------------------------------------- */

/* 
 * Sends Page_Up keyboard event through XTest extension. This won't
 * work if XTest is not available.
 */
void
sjog_scroll_up()
{

   XTestGrabControl(disp, True);

   if (mousewheelFakeKeys)
   {
      XTestFakeKeyEvent(disp, upKeycode, True, 0);
   }
   else
   {
      XTestFakeButtonEvent(disp, 4, True, CurrentTime);
      XTestFakeButtonEvent(disp, 4, False, 30);
   }

   XSync(disp, False);
   XTestGrabControl(disp, False);

}

/* -------------------------------------------------------------------------- */

/* Sends Page_Down keyboard event through XTest extension. This won't
 * work if XTest is not available.
 */
void
sjog_scroll_down()
{

   XTestGrabControl(disp, True);

   if (mousewheelFakeKeys)
   {
      XTestFakeKeyEvent(disp, downKeycode, True, 0);
   }
   else
   {
      XTestFakeButtonEvent(disp, 5, True, CurrentTime);
      XTestFakeButtonEvent(disp, 5, False, 30);
   }

   XSync(disp, False);
   XTestGrabControl(disp, False);

}
