# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: create sisupod filetype and copy it to output directory!

=end
module SiSU_Doc
  require 'fileutils'
  include SiSU_Env
  class Source
    include FileUtils #::Verbose
    require "#{SiSU_lib}/sysenv"
    require "#{SiSU_lib}/response"
    def initialize(opt)
      @opt=opt
      m=/.+\/(?:src\/)?(\S+)/im # m=/.+?\/(?:src\/)?([^\/]+)$/im # m=/.+\/(\S+)/m
      @date=SiSU_Env::Info_date.new.dt
      @env=SiSU_Env::Info_env.new(@opt.fns)
      @ver=SiSU_Env::Info_version.new.get_version
      @ans=SiSU_Response::Response.new
      pod_path="#{@env.path.processing}/sisupod"
      @v=if @opt.cmd =~/[VM]/; 'v'
      else                    ''
      end
      @local_path="#{@env.path.output_pod}" #@local_path="#{@env.path.output}/#{@env.fnb}"
      @zipfile=if @opt.fns =~/\.ssm\.sst$/; @opt.fns.gsub(/(?:\~\S{2,3})?\.ssm\.sst$/,'.ssm')
      else @opt.fns.gsub(/(?:\~\S{2,3})?(\.sst)$/,'\1')
      end
      mkdir_p(pod_path) unless FileTest.directory?(pod_path)
      rm_rf("#{@env.path.processing}sisupod/*") if FileTest.directory?("#{@env.path.processing}sisupod")
    end
    def read
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Share SiSU Document (zip)',@opt.fns)
      tell.green_hi_blue unless @opt.cmd =~/q/
      unless @opt.fns.empty?
        tell=SiSU_Screen::Ansi.new(@opt.cmd,'Make sisu document (zip) and place in output directory',"#{@opt.fns} -> file://#{@env.path.output_pod}/#{@zipfile}.zip")
        tell.warn unless @opt.cmd =~/q/
        directories
        sisupod_build
        sisupod_zip
        #sisupod_7zip
      else
        tell=SiSU_Screen::Ansi.new(@opt.cmd,'Make (zip) of sisu work directory',"#{@env.stub_pwd}\_#@date.zip")
        tell.warn unless @opt.cmd =~/q/
        tell.blue_tab unless @opt.cmd =~/q/
        ans=@ans.response?('make sisupod of entire directory?')
        if ans; sisupod_zip_directory
        end
      end
    end
    def sisupod_zip_directory
      sisupod_directory="sisupod-#{@env.stub_pwd}-#@date.ssp" # "sisupod-#{@env.stub_pwd}-#@date.zip"
      unless File.symlink?('sisupod'); File.symlink(Dir.pwd,'sisupod')
      end
      re_base_dir='^sisupod/([^.][^/]*\.(ssm|ssi|sst)$|_sisu/)'
      re_files='/[a-zA-Z0-9.~_-]+\.(ssm|ssi|sst|rb|css|png|jpg|gif|yaml)$'
      re_ignore='/[.~_-][^/]+$'
      if File.symlink?('sisupod')
        info="SiSU sisupod #{@ver[:version]} directory contents #{sisupod_directory}"
        system(%{
          echo "#{info}"
          echo "#{info}" > sisu_zip.txt
          zip -qz #{sisupod_directory} sisu_zip.txt < sisu_zip.txt
          for I in `find -H sisupod -print | \
            egrep "#{re_base_dir}" | \
            egrep "#{re_files}" | \
            egrep -v "#{re_ignore}" `
          do zip #{sisupod_directory} $I
          done
        })
      else puts "the required systemlink 'sisupod' could not be created on the current directory: remove the file or directory named 'sisupod' within #{Dir.pwd}"
      end
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Share SiSU Document (tar gzip)',@opt.fns)
      tell.green_hi_blue unless @opt.cmd =~/q/
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Zipped directory',sisupod_directory)
      tell.warn unless @opt.cmd =~/q/
      tell=SiSU_Screen::Ansi.new('',sisupod_directory)
      tell.blue_tab unless @opt.cmd =~/q/
    end
    def directories
      SiSU_Env::Info_env.new.sisupod
    end
    def select(skin='')                                                       # skin loading logic here
      load "#{SiSU_lib}/defaults.rb"
      @skin={}
      skin_path = [
        "#{@env.path.pwd}/_sisu/skin",
        "#{@env.path.home}/.sisu/skin",
        '/etc/sisu/skin',
        "#{@env.path.processing}/external_document/skin"
      ]
      sk_doc,sk_dir="doc/#{skin}.rb","dir/skin_#{@env.stub_pwd}.rb"
      skin_path.each do |v|                                                    #document skin priority 1
        if FileTest.file?("#{v}/#{sk_doc}")
          @skin[:name],@skin[:type]="#{v}/#{sk_doc}",'doc'
          break
        end
      end
      unless @skin.length > 0
        skin_path.each do |v|                                                  #directory skin priority 2
          if FileTest.file?("#{v}/#{sk_dir}")
            @skin[:name],@skin[:type]="#{v}/#{sk_dir}",'dir'
            break
          end
        end
      end
      @skin
    end
    def sisupod_build                                                         #see also sisupod in sysenv
      @rgx_rb_image=/["'](\S+?\.(?:png|jpg|gif))["']/
      @rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
      @rgx_skin=/^(?:@skin:|0~skin)\s+(\S+)/
      @rgx_doc_import=/^%\s\s*\|(\S+?\.ss[ti])\|@\|\^\|>>ok/
      use_file=if @opt.fns =~/(?:\.ssm|\.ssm\.sst)$/; "#{@env.path.composite_file}/#{@opt.fnb}.ssm.sst"
      else @opt.fns
      end
      file_array=IO.readlines(use_file,'')
      skin,images,doc_import=[],[],[]
      file_array.each do |f|                                                  #% work area
        if f !~/^%+\s/
          skin << f.scan(@rgx_skin).uniq.flatten if f =~@rgx_skin
          if f !~/^%+\s/ \
          and f =~@rgx_image
            images << f.scan(@rgx_image).uniq
          end
        elsif f =~/^%\s/ \
        and @opt.fns =~/\.ssm\.sst$/
          doc_import << f.scan(@rgx_doc_import).uniq if f =~@rgx_doc_import
        end
      end
      docskin=nil
      if skin \
      and skin.length > 0
        docskin=skin.pop.flatten.join
        skin_source=select(docskin)
      else
        skin_source=select
      end
      docskin_place="#{@env.path.processing}/sisupod/_sisu/skin/#{skin_source[:type]}"
      if skin_source[:type] =~/dir/
        docskin_with_path="#{docskin_place}/skin_#{@env.stub_pwd}.rb"
        docskin=[docskin_with_path.gsub(/.+?\/(skin_\S+?)\.rb/,'\1')]
        docskin='skin_sisupod'
      end
      if skin_source \
      and docskin #imperfect, revisit
        unless skin_source[:name].nil? \
        or skin_source[:name].empty?
          cp_r(skin_source[:name],"#{docskin_place}/#{docskin}.rb")
          skinfile_array=IO.readlines(skin_source[:name],'')
          para_images=[]
          skinfile_array.each do |f|                                            #% work area
            unless f =~/^%+ / #hmmm
              images << f.scan(@rgx_rb_image).uniq if f =~@rgx_rb_image #and FileTest.file?(f.scan(@rgx_rb_image).uniq)
              #does not really discriminate, may duplicate images in sisu file, and may take images from default image pool
            end
          end
        end
      end
      #1. mapping in doc dir?
      #2. need images used by skin, scan skin??
      if images \
      and images.length > 1
        images.flatten!
        images.uniq!
        images.delete_if {|x| x =~/http:\/\// }
        #images.sort!
        image_path_pwd='_sisu/image'
        path_pod_conf="#{@env.path.processing}/sisupod/_sisu"
        images_path_pod="#{path_pod_conf}/image"
        #unattractive hard coding ... !
        images_pwd="#{@env.path.pwd}/#{image_path_pwd}"
        ##sequence copies base images, defaults used in all html outputs
          #image_source_base='/usr/share/sisu/image'
          #dir_pwd=Dir.pwd
          #Dir.chdir(image_source_base)
          #base_images=Dir.glob('*')
          #base_images.each do |i|
          #  cp_r(i,"#{images_path_pod}/#{i}")
          #end
          #Dir.chdir(dir_pwd)
        if FileTest.directory?(image_path_pwd)
          images=images.uniq
          images.each do |i|
            cp_r("#{images_pwd}/#{i}","#{images_path_pod}/#{i}") if FileTest.file?("#{images_pwd}/#{i}")
          end
          #chmod(0755, dir_images_www)
        else puts "\tWARN, did not find - #{image_path_pod}"
        end
      end
      x=@env.document_language_versions_found   #check multiple document language versions (param not used)
      if doc_import.flatten.length > 0 \
      and @opt.fns =~/\.ssm\.sst$/
        doc_import.flatten.each do |f|
          cp_r("#{@env.path.pwd}/#{f}","#{@env.path.processing}/sisupod/#{f}")
        end
      end
      if x[:f] \
      and x[:f].length > 1             #store multiple document language versions, sisupod
        x[:f].each do |f|
          cp_r("#{@env.path.pwd}/#{f}","#{@env.path.processing}/sisupod/#{f}")
        end
      elsif @opt.fns =~/\.ssm\.sst/
        ssm=@opt.fns.gsub(/\.ssm\.sst/,'.ssm')
        cp_r("#{@env.path.pwd}/#{ssm}","#{@env.path.processing}/sisupod/#{ssm}")
      else cp_r("#{@env.path.pwd}/#{@opt.fns}","#{@env.path.processing}/sisupod/#{@opt.fns}")
      end #NB not all possibilies met, revisit, also in case of composite file may wish to add README
    end
    def sisupod_7zip #look at later
      mkdir_p(@local_path) unless FileTest.directory?(@local_path)
      system(%{
        cd #{@env.path.processing}
        echo "SiSU sisupod #{@ver[:version]}" > sisu_zip.txt
        #7zip -qz #{@opt.fns}.7z sisu_zip.txt < sisu_zip.txt
        7zr a -t7z -m0=lzma -mx=9 -ms=on #{@zipfile}.7z sisu_zip.txt
        7zr a -t7z -m0=lzma -mx=9 -ms=on #{@zipfile}.7z sisupod
        #7zip -qr #{@zipfile}.7z sisupod
        mv #{@zipfile}.7z #{@local_path}/. &
        rm -r sisupod/* && cd #{@env.path.pwd}
      })
      tell=SiSU_Screen::Ansi.new('',"#{@opt.fns}.7z")
      tell.blue_tab unless @opt.cmd =~/q/
    end
    def sisupod_zip
      mkdir_p(@local_path) unless FileTest.directory?(@local_path)
      system(%{
        cd #{@env.path.processing}
        echo "SiSU sisupod #{@ver[:version]}" > sisu_zip.txt
        zip -qz #{@zipfile}.zip sisu_zip.txt < sisu_zip.txt
        zip -qr #{@zipfile}.zip sisupod
        mv #{@zipfile}.zip #{@local_path}/. &
        rm -r sisupod/* && cd #{@env.path.pwd}
      })
      tell=SiSU_Screen::Ansi.new('',"#{@zipfile}.zip")
      tell.blue_tab unless @opt.cmd =~/q/
    end
  end
end
__END__
question?:                   should you permit the packing of multiple files in single .gz ?

  open @opt.fns, parse file
    extract from file content:
      images and copy each image from whatever image source to _sisu/sisupod/sisu/_sisu/image
      skin and copy active skin from whatever source to _sisu/sisupod/sisu/_sisu/skin/doc
      extract from skin images required by skin

   remove previously existing contents of _/sisu/sisupod &
   make directory structure:

   _sisu
     sisupod
       sisu
         content.sst              [file content]
         filename.sst             [link to content.sst]
         _sisu
           conf
             skin/
               doc                [relevant skin if any other than default]
           image                  [all images for specific document gathered here]

sisu
  _sisu
    sisurc.yml
    skin/
      dir/
      doc/
      misc/
      site/
      yaml/
    convert/
    standard_terms/
    image
    processing
      dal/
      tex/
      texinfo/
      tune/
    sisupod

special case

composite file (master), e.g.
SiSU.ssm

