/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.AbstractListenableFuture;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UninterruptibleFuture;
import com.google.common.util.concurrent.ValueFuture;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class Futures {
    private Futures() {
    }

    public static <V> UninterruptibleFuture<V> makeUninterruptible(final Future<V> future) {
        Preconditions.checkNotNull(future);
        if (future instanceof UninterruptibleFuture) {
            return (UninterruptibleFuture)future;
        }
        return new UninterruptibleFuture<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public V get(long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, ExecutionException {
                boolean interrupted = false;
                try {
                    long timeoutNanos = timeoutUnit.toNanos(timeoutDuration);
                    long end = System.nanoTime() + timeoutNanos;
                    while (true) {
                        Object v;
                        try {
                            v = future.get(timeoutNanos, TimeUnit.NANOSECONDS);
                        }
                        catch (InterruptedException e) {
                            timeoutNanos = end - System.nanoTime();
                            interrupted = true;
                            continue;
                        }
                        return v;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            @Override
            public V get() throws ExecutionException {
                boolean interrupted = false;
                while (true) {
                    try {
                        Object v = future.get();
                        return v;
                    }
                    catch (InterruptedException ignored) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }

    public static <T> ListenableFuture<T> makeListenable(Future<T> future) {
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<T>(future);
    }

    public static <T, E extends Exception> CheckedFuture<T, E> makeChecked(Future<T> future, Function<Exception, E> mapper) {
        return new MappingCheckedFuture<T, E>(Futures.makeListenable(future), mapper);
    }

    public static <T> ListenableFuture<T> immediateFuture(@Nullable T value) {
        ValueFuture future = ValueFuture.create();
        future.set(value);
        return future;
    }

    public static <T, E extends Exception> CheckedFuture<T, E> immediateCheckedFuture(@Nullable T value) {
        ValueFuture future = ValueFuture.create();
        future.set(value);
        return Futures.makeChecked(future, new Function<Exception, E>(){

            @Override
            public E apply(Exception e) {
                throw new AssertionError((Object)"impossible");
            }
        });
    }

    public static <T> ListenableFuture<T> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        ValueFuture future = ValueFuture.create();
        future.setException(throwable);
        return future;
    }

    public static <T, E extends Exception> CheckedFuture<T, E> immediateFailedCheckedFuture(final E exception) {
        Preconditions.checkNotNull(exception);
        return Futures.makeChecked(Futures.immediateFailedFuture(exception), new Function<Exception, E>(){

            @Override
            public E apply(Exception e) {
                return exception;
            }
        });
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, Function<? super I, ? extends ListenableFuture<? extends O>> function) {
        return Futures.chain(input, function, MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, Function<? super I, ? extends ListenableFuture<? extends O>> function, Executor exec) {
        ChainingListenableFuture chain = new ChainingListenableFuture(function, input);
        input.addListener(chain, exec);
        return chain;
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> future, Function<? super I, ? extends O> function) {
        return Futures.compose(future, function, MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> future, final Function<? super I, ? extends O> function, Executor exec) {
        Preconditions.checkNotNull(function);
        Function wrapperFunction = new Function<I, ListenableFuture<O>>(){

            @Override
            public ListenableFuture<O> apply(I input) {
                Object output = function.apply(input);
                return Futures.immediateFuture(output);
            }
        };
        return Futures.chain(future, wrapperFunction, exec);
    }

    public static <I, O> Future<O> compose(final Future<I> future, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(function);
        return new Future<O>(){
            private final Object lock = new Object();
            private boolean set = false;
            private O value = null;

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.apply(future.get());
            }

            @Override
            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.apply(future.get(timeout, unit));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private O apply(I raw) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.set) {
                        this.value = function.apply(raw);
                        this.set = true;
                    }
                    return this.value;
                }
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenableFutureAdapter<T>
    extends ForwardingFuture<T>
    implements ListenableFuture<T> {
        private static final Executor adapterExecutor = Executors.newCachedThreadPool();
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<T> delegate;

        ListenableFutureAdapter(Future<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected Future<T> delegate() {
            return this.delegate;
        }

        @Override
        public void addListener(Runnable listener, Executor exec) {
            if (!this.hasListeners.get() && this.hasListeners.compareAndSet(false, true)) {
                adapterExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            ListenableFutureAdapter.this.delegate.get();
                        }
                        catch (CancellationException e) {
                        }
                        catch (InterruptedException e) {
                            throw new IllegalStateException("Adapter thread interrupted!", e);
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        ListenableFutureAdapter.this.executionList.run();
                    }
                });
            }
            this.executionList.add(listener, exec);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingCheckedFuture<T, E extends Exception>
    extends AbstractCheckedFuture<T, E> {
        final Function<Exception, E> mapper;

        MappingCheckedFuture(ListenableFuture<T> delegate, Function<Exception, E> mapper) {
            super(delegate);
            this.mapper = Preconditions.checkNotNull(mapper);
        }

        @Override
        protected E mapException(Exception e) {
            return (E)((Exception)this.mapper.apply(e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainingListenableFuture<I, O>
    extends AbstractListenableFuture<O>
    implements Runnable {
        private Function<? super I, ? extends ListenableFuture<? extends O>> function;
        private UninterruptibleFuture<? extends I> inputFuture;

        private ChainingListenableFuture(Function<? super I, ? extends ListenableFuture<? extends O>> function, ListenableFuture<? extends I> inputFuture) {
            this.function = Preconditions.checkNotNull(function);
            this.inputFuture = Futures.makeUninterruptible(inputFuture);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            UninterruptibleFuture<I> future = this.inputFuture;
            if (future != null) {
                return future.cancel(mayInterruptIfRunning);
            }
            return false;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block14: {
                try {
                    I sourceResult;
                    try {
                        sourceResult = this.inputFuture.get();
                    }
                    catch (CancellationException e) {
                        this.cancel();
                        this.function = null;
                        this.inputFuture = null;
                        return;
                    }
                    catch (ExecutionException e) {
                        this.setException(e.getCause());
                        this.function = null;
                        this.inputFuture = null;
                        return;
                    }
                    final ListenableFuture<O> outputFuture = this.function.apply(sourceResult);
                    outputFuture.addListener(new Runnable(){

                        public void run() {
                            try {
                                ChainingListenableFuture.this.set(Futures.makeUninterruptible(outputFuture).get());
                            }
                            catch (ExecutionException e) {
                                ChainingListenableFuture.this.setException(e.getCause());
                            }
                        }
                    }, MoreExecutors.sameThreadExecutor());
                    break block14;
                    {
                        catch (UndeclaredThrowableException e) {
                            this.setException(e.getCause());
                            break block14;
                        }
                        catch (RuntimeException e) {
                            this.setException(e);
                            break block14;
                        }
                        catch (Error e) {
                            this.setException(e);
                            throw e;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.function = null;
                    this.inputFuture = null;
                }
            }
        }
    }
}

