/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.Iterator4;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRangeSingle;

public abstract class AbstractBTreeRangeIterator
implements Iterator4 {
    private final BTreeRangeSingle _range;
    private BTreePointer _cursor;
    private BTreePointer _current;

    public AbstractBTreeRangeIterator(BTreeRangeSingle bTreeRangeSingle) {
        this._range = bTreeRangeSingle;
        this._cursor = bTreeRangeSingle.first();
    }

    public boolean moveNext() {
        if (this.reachedEnd(this._cursor)) {
            this._current = null;
            return false;
        }
        this._current = this._cursor;
        this._cursor = this._cursor.next();
        return true;
    }

    public void reset() {
        this._cursor = this._range.first();
    }

    protected BTreePointer currentPointer() {
        if (null == this._current) {
            throw new IllegalStateException();
        }
        return this._current;
    }

    private boolean reachedEnd(BTreePointer bTreePointer) {
        if (bTreePointer == null) {
            return true;
        }
        if (this._range.end() == null) {
            return false;
        }
        return this._range.end().equals(bTreePointer);
    }
}

