/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Visitor4;
import com.db4o.internal.HashcodeReferenceSystem;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceSystem;

public class TransactionalReferenceSystem
implements ReferenceSystem {
    final ReferenceSystem _committedReferences = new HashcodeReferenceSystem();
    private ReferenceSystem _newReferences;

    public TransactionalReferenceSystem() {
        this.createNewReferences();
    }

    public void addExistingReference(ObjectReference objectReference) {
        this._committedReferences.addExistingReference(objectReference);
    }

    public void addExistingReferenceToIdTree(ObjectReference objectReference) {
        this._committedReferences.addExistingReferenceToIdTree(objectReference);
    }

    public void addExistingReferenceToObjectTree(ObjectReference objectReference) {
        this._committedReferences.addExistingReferenceToObjectTree(objectReference);
    }

    public void addNewReference(ObjectReference objectReference) {
        this._newReferences.addNewReference(objectReference);
    }

    public void commit() {
        this.traveseNewReferences(new Visitor4(){

            public void visit(Object object) {
                ObjectReference objectReference = (ObjectReference)object;
                Object object2 = objectReference.getObject();
                if (object2 != null) {
                    TransactionalReferenceSystem.this._committedReferences.addExistingReference(objectReference);
                }
            }
        });
        this.createNewReferences();
    }

    public void traveseNewReferences(Visitor4 visitor4) {
        this._newReferences.traverseReferences(visitor4);
    }

    private void createNewReferences() {
        this._newReferences = new HashcodeReferenceSystem();
    }

    public ObjectReference referenceForId(int n) {
        ObjectReference objectReference = this._newReferences.referenceForId(n);
        if (objectReference != null) {
            return objectReference;
        }
        return this._committedReferences.referenceForId(n);
    }

    public ObjectReference referenceForObject(Object object) {
        ObjectReference objectReference = this._newReferences.referenceForObject(object);
        if (objectReference != null) {
            return objectReference;
        }
        return this._committedReferences.referenceForObject(object);
    }

    public void removeReference(ObjectReference objectReference) {
        this._newReferences.removeReference(objectReference);
        this._committedReferences.removeReference(objectReference);
    }

    public void rollback() {
        this.createNewReferences();
    }

    public void traverseReferences(Visitor4 visitor4) {
        this.traveseNewReferences(visitor4);
        this._committedReferences.traverseReferences(visitor4);
    }
}

