/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4Iterator;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.types.Unversioned;

public class Collection4
implements Iterable4,
DeepClone,
Unversioned {
    public List4 _first;
    public List4 _last;
    public int _size;
    public int _version;

    public Collection4() {
    }

    public Collection4(Object[] objectArray) {
        this.addAll(objectArray);
    }

    public Collection4(Iterable4 iterable4) {
        this.addAll(iterable4);
    }

    public Collection4(Iterator4 iterator4) {
        this.addAll(iterator4);
    }

    public Object singleElement() {
        if (this.size() != 1) {
            throw new IllegalStateException();
        }
        return this._first._element;
    }

    public final void add(Object object) {
        this.doAdd(object);
        this.changed();
    }

    public final void prepend(Object object) {
        this.doPrepend(object);
        this.changed();
    }

    private void doPrepend(Object object) {
        if (this._first == null) {
            this.doAdd(object);
        } else {
            this._first = new List4(this._first, object);
            ++this._size;
        }
    }

    private void doAdd(Object object) {
        this._last = this._last == null ? (this._first = new List4(object)) : (this._last._next = new List4(object));
        ++this._size;
    }

    public final void addAll(Object[] objectArray) {
        this.assertNotNull(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.add(objectArray[i]);
        }
    }

    public final void addAll(Iterable4 iterable4) {
        this.assertNotNull(iterable4);
        this.addAll(iterable4.iterator());
    }

    public final void addAll(Iterator4 iterator4) {
        this.assertNotNull(iterator4);
        while (iterator4.moveNext()) {
            this.add(iterator4.current());
        }
    }

    public final void clear() {
        this._first = null;
        this._last = null;
        this._size = 0;
        this.changed();
    }

    public final boolean contains(Object object) {
        return this.find(object) != null;
    }

    public boolean containsAll(Iterator4 iterator4) {
        this.assertNotNull(iterator4);
        while (iterator4.moveNext()) {
            if (this.contains(iterator4.current())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsByIdentity(Object object) {
        Iterator4 iterator4 = this.internalIterator();
        while (iterator4.moveNext()) {
            Object object2 = iterator4.current();
            if (object2 != object) continue;
            return true;
        }
        return false;
    }

    private List4 find(Object object) {
        List4 list4 = this._first;
        while (list4 != null) {
            if (list4.holds(object)) {
                return list4;
            }
            list4 = list4._next;
        }
        return null;
    }

    public final Object get(Object object) {
        List4 list4 = this.find(object);
        return list4 == null ? null : list4._element;
    }

    public Object deepClone(Object object) {
        Collection4 collection4 = new Collection4();
        Object object2 = null;
        Iterator4 iterator4 = this.internalIterator();
        while (iterator4.moveNext()) {
            object2 = iterator4.current();
            if (object2 instanceof DeepClone) {
                collection4.add(((DeepClone)object2).deepClone(object));
                continue;
            }
            collection4.add(object2);
        }
        return collection4;
    }

    public final Object ensure(Object object) {
        List4 list4 = this.find(object);
        if (list4 == null) {
            this.add(object);
            return object;
        }
        return list4._element;
    }

    public final Iterator4 iterator() {
        return this._first == null ? Iterators.EMPTY_ITERATOR : new Collection4Iterator(this, this._first);
    }

    public Object remove(Object object) {
        List4 list4 = null;
        List4 list42 = this._first;
        while (list42 != null) {
            if (list42.holds(object)) {
                --this._size;
                this.adjustOnRemoval(list4, list42);
                this.changed();
                return list42._element;
            }
            list4 = list42;
            list42 = list42._next;
        }
        return null;
    }

    public void replace(Object object, Object object2) {
        List4 list4 = this.find(object);
        if (list4 != null) {
            list4._element = object2;
        }
    }

    private void adjustOnRemoval(List4 list4, List4 list42) {
        if (list42 == this._first) {
            this._first = list42._next;
        } else {
            list4._next = list42._next;
        }
        if (list42 == this._last) {
            this._last = list4;
        }
    }

    public final int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final Object[] toArray(Object[] objectArray) {
        int n = 0;
        Iterator4 iterator4 = this.internalIterator();
        while (iterator4.moveNext()) {
            objectArray[n++] = iterator4.current();
        }
        return objectArray;
    }

    public final Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        this.toArray(objectArray);
        return objectArray;
    }

    public String toString() {
        return Iterators.toString(this.internalIterator());
    }

    private void changed() {
        ++this._version;
    }

    int version() {
        return this._version;
    }

    private void assertNotNull(Object object) {
        if (object == null) {
            throw new ArgumentNullException();
        }
    }

    private Iterator4 internalIterator() {
        return new Iterator4Impl(this._first);
    }
}

