/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.LuceneWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneBackendQueueProcessor
implements Runnable {
    private List<LuceneWork> queue;
    private SearchFactory searchFactory;

    public LuceneBackendQueueProcessor(List<LuceneWork> queue, SearchFactory searchFactory) {
        this.queue = queue;
        this.searchFactory = searchFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Workspace workspace = new Workspace(this.searchFactory);
        LuceneWorker worker = new LuceneWorker(workspace);
        try {
            this.deadlockFreeQueue(this.queue, workspace);
            for (LuceneWork luceneWork : this.queue) {
                worker.performWork(luceneWork);
            }
        }
        finally {
            workspace.clean();
            this.queue.clear();
        }
    }

    private void deadlockFreeQueue(List<LuceneWork> queue, final Workspace workspace) {
        Collections.sort(queue, new Comparator<LuceneWork>(){

            @Override
            public int compare(LuceneWork o1, LuceneWork o2) {
                long h2;
                long h1 = LuceneBackendQueueProcessor.this.getWorkHashCode(o1, workspace);
                return h1 < (h2 = LuceneBackendQueueProcessor.this.getWorkHashCode(o2, workspace)) ? -1 : (h1 == h2 ? 0 : 1);
            }
        });
    }

    private long getWorkHashCode(LuceneWork luceneWork, Workspace workspace) {
        long h = workspace.getDocumentBuilder(luceneWork.getEntityClass()).hashCode() * 2;
        if (luceneWork instanceof AddLuceneWork) {
            ++h;
        }
        return h;
    }
}

