/*
**  Sinek (Video Player)
**  Copyright (c) 2001 the Sinek Team, see the AUTHORS file.
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  hue, saturation, etc, controls
*/

#include "common.h"

static GtkWidget *tune_win = NULL;
static GtkObject *hue_adj, *sat_adj, *bri_adj, *con_adj;
static int vidcap = 0;
static int hue, sat, bri, con;

static GtkObject *create_prop(GtkWidget *box, char *name, int cap, int prop);
static void cb_cancel(GtkWidget *w, gpointer data);
static void cb_hue(GtkAdjustment *adj);
static void cb_sat(GtkAdjustment *adj);
static void cb_bri(GtkAdjustment *adj);
static void cb_con(GtkAdjustment *adj);


void tune_show(void)
{
	GtkWidget *vb, *hb, *hb2, *b;

	if(tune_win) goto out;

	vidcap = sinek.vd->get_capabilities(sinek.vd);

	tune_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(tune_win), _("Sinek Tuner"));
	gtk_window_set_wmclass(GTK_WINDOW(tune_win), "Sinek Tune", "Sinek");

	vb = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vb);
	gtk_container_add(GTK_CONTAINER(tune_win), vb);

	b = gtk_frame_new(NULL);
	gtk_widget_show(b);
	gtk_box_pack_start(GTK_BOX(vb), b, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(b), 5);

	hb = gtk_hbox_new(TRUE, 0);
	gtk_widget_show(hb);
	gtk_container_add(GTK_CONTAINER(b), hb);
	gtk_container_set_border_width(GTK_CONTAINER(hb), 5);

	hue_adj = create_prop(hb, _("Hue"), VO_CAP_HUE, VO_PROP_HUE);
	gtk_signal_connect(hue_adj, "value_changed", GTK_SIGNAL_FUNC(cb_hue), NULL);
	sat_adj = create_prop(hb, _("Saturation"), VO_CAP_SATURATION, VO_PROP_SATURATION);
	gtk_signal_connect(sat_adj, "value_changed", GTK_SIGNAL_FUNC(cb_sat), NULL);
	bri_adj = create_prop(hb, _("Brightness"), VO_CAP_BRIGHTNESS, VO_PROP_BRIGHTNESS);
	gtk_signal_connect(bri_adj, "value_changed", GTK_SIGNAL_FUNC(cb_bri), NULL);
	con_adj = create_prop(hb, _("Contrast"), VO_CAP_CONTRAST, VO_PROP_CONTRAST);
	gtk_signal_connect(con_adj, "value_changed", GTK_SIGNAL_FUNC(cb_con), NULL);

	hb2 = gtk_hbutton_box_new();
	gtk_widget_show(hb2);
	gtk_box_pack_start(GTK_BOX(vb), hb2, FALSE, FALSE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hb2), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hb2), 10);

	b = gtk_button_new_with_label(_("OK"));
	gtk_widget_show(b);
	gtk_container_add(GTK_CONTAINER(hb2), b);
	GTK_WIDGET_SET_FLAGS(b, GTK_CAN_DEFAULT);
	gtk_signal_connect_object(GTK_OBJECT(b), "clicked", gtk_widget_hide, GTK_OBJECT(tune_win));

	b = gtk_button_new_with_label(_("Cancel"));
	gtk_widget_show(b);
	gtk_container_add(GTK_CONTAINER(hb2), b);
	GTK_WIDGET_SET_FLAGS(b, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(b), "clicked", GTK_SIGNAL_FUNC(cb_cancel), NULL);

	gtk_signal_connect(GTK_OBJECT(tune_win), "delete_event", GTK_SIGNAL_FUNC(cb_cancel), NULL);

	wm_manage(tune_win, WM_NORMAL);
out:
	hue = GTK_ADJUSTMENT(hue_adj)->value;
	sat = GTK_ADJUSTMENT(sat_adj)->value;
	bri = GTK_ADJUSTMENT(bri_adj)->value;
	con = GTK_ADJUSTMENT(con_adj)->value;
	gtk_widget_show(tune_win);
}


static GtkObject *create_prop(GtkWidget *box, char *name, int cap, int prop)
{
	GtkWidget *vb, *scale, *lab;
	GtkObject *adj;
	int cur, min, max;

	vb = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vb);
	gtk_box_pack_start(GTK_BOX(box), vb, TRUE, TRUE, 0);

	cur = sinek.vd->get_property(sinek.vd, prop);
	sinek.vd->get_property_min_max(sinek.vd, prop, &min, &max);
	adj = gtk_adjustment_new(cur, min, max, 1, 0, 0);

	scale = gtk_vscale_new(GTK_ADJUSTMENT(adj));
	gtk_widget_show(scale);
	gtk_box_pack_start(GTK_BOX(vb), scale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos(GTK_SCALE(scale), GTK_POS_RIGHT);
	gtk_scale_set_digits(GTK_SCALE(scale), 0);
	if(!(vidcap & cap)) gtk_widget_set_sensitive(scale, FALSE);

	lab = gtk_label_new(name);
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb), lab, FALSE, FALSE, 0);

	return adj;
}


static void cb_cancel(GtkWidget *w, gpointer data)
{
	if(GTK_ADJUSTMENT(hue_adj)->value != hue)
	{
		GTK_ADJUSTMENT(hue_adj)->value = hue;
		gtk_signal_emit_by_name(hue_adj, "changed");
		sinek.vd->set_property(sinek.vd, VO_PROP_HUE, hue);
	}
	if(GTK_ADJUSTMENT(sat_adj)->value != sat)
	{
		GTK_ADJUSTMENT(sat_adj)->value = sat;
		gtk_signal_emit_by_name(sat_adj, "changed");
		sinek.vd->set_property(sinek.vd, VO_PROP_SATURATION, sat);
	}
	if(GTK_ADJUSTMENT(bri_adj)->value != bri)
	{
		GTK_ADJUSTMENT(bri_adj)->value = bri;
		gtk_signal_emit_by_name(bri_adj, "changed");
		sinek.vd->set_property(sinek.vd, VO_PROP_BRIGHTNESS, bri);
	}
	if(GTK_ADJUSTMENT(con_adj)->value != con)
	{
		GTK_ADJUSTMENT(con_adj)->value = con;
		gtk_signal_emit_by_name(con_adj, "changed");
		sinek.vd->set_property(sinek.vd, VO_PROP_CONTRAST, con);
	}

	gtk_widget_hide(tune_win);
}


static void cb_hue(GtkAdjustment *adj)
{
	sinek.vd->set_property(sinek.vd, VO_PROP_HUE, adj->value);
}


static void cb_sat(GtkAdjustment *adj)
{
	sinek.vd->set_property(sinek.vd, VO_PROP_SATURATION, adj->value);
}


static void cb_bri(GtkAdjustment *adj)
{
	sinek.vd->set_property(sinek.vd, VO_PROP_BRIGHTNESS, adj->value);
}


static void cb_con(GtkAdjustment *adj)
{
	sinek.vd->set_property(sinek.vd, VO_PROP_CONTRAST, adj->value);
}
