/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* zipfile.h*/

#ifndef __ZIPFILE_H__
#define __ZIPFILE_H__

#include <kprocess.h>

class ZipFile:QObject
{
	Q_OBJECT;

public:
	ZipFile (const char *archive, const char *file);
	virtual ~ZipFile();
  
public:
	int size ();
	bool deleteFile ();

protected:
	QString * archive;
	QString *file;

	QCString *stdout;


private slots:
	void slotMsgRcv (KProcess *, char *, int);

};
#endif
