/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _IMAGEFILEINFO_H_
#define _IMAGEFILEINFO_H_

#include <qstring.h>

#define IMAGE	0
#define ALBUM	1

class QString;

class ImageFileInfo
{
public:
	ImageFileInfo(QString filename, int type, bool r=true);
	~ImageFileInfo();
	
	bool hasInfo();
	
	void write(QString title, QString event,
			QString location, QString people,
			QString date, QString description,
			QString fileDest=QString());
			
	void write(QString title,
		QString shortDescription, QString longDescription,
		QString fileDest=QString());
	
	void update(QString destDir);
	
	QString getTitle();
	void setTitle(QString title);	
	QString getEvent();
	void setEvent(QString event);	
	QString getLocation();
	void setLocation(QString location);	
	QString getPeople();
	void setPeople(QString people);
	QString getDate();
	void setDate(QString date);
	QString getDescription();
	void setDescription(QString description);
	QString getShortDescription();
	void setShortDescription(QString shortdesc);
	QString getLongDescription();
	void setLongDescription(QString longdesc);
	
protected:
	bool verif(QString info);
	void read(bool r=true);
	int type;
	
	QString filename,imageid;
	QString info;
	
	QString 
		title, event, 
		location, people, 
		date, description,
		shortdesc, longdesc;

private:
	bool found;
	
};
#endif
