/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __FORMATCONVERSION_H__
#define __FORMATCONVERSION_H__

#include <qvariant.h>

#include <kapp.h>
#include <klocale.h>
#include <kdialog.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QCheckBox;
class QComboBox;
class QGroupBox;
class QLabel;
class QListView;
class QListViewItem;
class QPushButton;

class FormatConversion : public KDialog
{ 
	Q_OBJECT

public:
	FormatConversion( QWidget* parent = 0, const char* name = 0, bool modal = TRUE, WFlags fl = 0 );
	~FormatConversion();

	QString getOptions();
	QString getType();
	bool replace();
    
private:
	QString options;    

	QGroupBox* GroupBox1;
	QLabel* TextLabel1;
	QListView* listViewFormat;
	QPushButton* pushButtonSetting;
	QPushButton* pushButtonOK;
	QPushButton* pushButtonCancel;
	QGroupBox* GroupBox10;
	QLabel* TextLabel2;
	QLabel* TextLabel3;
	QCheckBox* CheckBox1;
	QPushButton* PushButton15;
	QComboBox* ComboBox2;
	QComboBox* ComboBox1;
	QHBoxLayout* Layout2;

public slots:
	virtual void enabledDisabledSettingButton(QListViewItem*);
	void showJPGOption();
};
#endif // FORMATCONVERSION_H
