

/*
#    Sfront, a SAOL to C translator    
#    This file: Writes ascii SAOL and SASL files
#    Copyright (C) 1999  Regents of the University of California
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License (Version 2) as
#    published by the Free Software Foundation.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu
*/

#include "tree.h"
#include "parser.tab.h"

/******************************************************************/
/*               writes saol tokens -- recursive                  */
/******************************************************************/

void ascsaoltreewrite(tnode * tbranch, int * indent)

{
  int i;
  sigsym * sptr;

  while (tbranch != NULL)
    {
      if (tbranch->down != NULL)
	ascsaoltreewrite(tbranch->down, indent);
      else
	{
	  if ((tbranch->ttype < 0xFF)||(tbranch->ttype == S_PRINTF))
	    {
	      switch(tbranch->ttype) {  /* space before */
	      case S_NUMBER:
	      case S_INTGR:
		fprintf(orcoutfile," ");
		break;
	      case S_STRCONST:
		fprintf(orcoutfile," \"");
		break;
	      case S_LC:
		*indent += 2;
		break;
	      case S_RC:
		*indent -= 2;
		break;
	      default:
		break;
	      }
	      if (bitsymin)
		{
		  sptr = getvsym(&bitsymin,tbranch->val);
		  if (sptr)
		    fprintf(orcoutfile,"%s",sptr->defnode->val);
		  else
		    fprintf(orcoutfile,"%s",tbranch->val);
		}
	      else
		fprintf(orcoutfile,"%s",tbranch->val);
	      switch(tbranch->ttype) {  /* space after */
	      case S_NUMBER:
	      case S_INTGR:
	      case S_INSTR:
	      case S_AOPCODE:
	      case S_KOPCODE:
	      case S_IOPCODE:
	      case S_OPCODE:
	      case S_ASIG:
	      case S_KSIG:
	      case S_IVAR:
	      case S_XSIG:
	      case S_OPARRAY:
	      case S_TABLE:
	      case S_TABLEMAP:
	      case S_IMPORTS:
	      case S_EXPORTS:
		fprintf(orcoutfile," ");
		break;
	      case S_STRCONST:
		fprintf(orcoutfile,"\" ");
	      default:
		break;
	      }

	      switch(tbranch->ttype) { /* <CR>'s after */
	      case S_SEM:
	      case S_LC:
		fprintf(orcoutfile,"\n");
		for (i = 0; i<*indent; i++)
		  fprintf(orcoutfile," ");
		break;
	      case S_RC:
		fprintf(orcoutfile,"\n\n");
		for (i = 0;i<*indent; i++)
		  fprintf(orcoutfile," ");
		break;
	      default:
		break;
	      }
	    }
	}
      tbranch = tbranch->next;
    }
}


/******************************************************************/
/*               writes saol tokens -- wrapper                  */
/******************************************************************/

void ascsaolwrite (void)

{
  int indent = 0;
  tnode * saolroot, * tptr;

  fprintf(orcoutfile,"\n//\n// automatically generated by sfront\n//\n\n");

  if (ascsaolptree)
    ascsaoltreewrite(troot,&indent);
  else
    {
      if (saolfilelist == NULL)
	readprepare(BINORC);
      else
	{
	  currsaolfile = saolfilelist;
	  saollinenumber = 1;
	  saolsourcefile = currsaolfile->val;
	  if (currsaolfile->filename)
	    saolfile = fopen(currsaolfile->filename,"r");
	  else
	    saolfile = fopen(currsaolfile->val,"r");
	}
      
      yylex();
      saolroot = tptr = yylval;
      while (yylex()) 
	{
	  tptr->next = yylval;
	  tptr = yylval;
	}
      ascsaoltreewrite(saolroot,&indent);
    }

}

/******************************************************************/
/*                       writes sasl line                         */
/******************************************************************/

void slinewrite(tnode * tptr)

{
  sigsym * sptr;

  while (tptr != NULL)
    {
      if (bitsymin)
	{
	  sptr = getvsym(&bitsymin, tptr->val);
	  if (sptr)
	    fprintf(scooutfile," %s ",sptr->defnode->val);
	  else
	    fprintf(scooutfile," %s ",tptr->val);
	}
      else
	fprintf(scooutfile, " %s ", tptr->val);
      tptr = tptr->next;
    }
  fprintf(scooutfile, "\n");
      
}


/******************************************************************/
/*                       writes sasl file                         */
/******************************************************************/

void ascsaslwrite(sasdata * sdata)

{
  tnode * tptr;
  
  for (tptr = sdata->temporoot; tptr != NULL; tptr = tptr->next)
    slinewrite(tptr->down);

  for (tptr = sdata->tableroot; tptr != NULL; tptr = tptr->next)
    slinewrite(tptr->down);

  for (tptr = sdata->controlroot; tptr != NULL; tptr = tptr->next)
    slinewrite(tptr->down);

  for (tptr = sdata->instrroot; tptr != NULL; tptr = tptr->next)
    slinewrite(tptr->down);

  if (sdata->endtimeval != NULL)
    fprintf(scooutfile, "%s end\n", sdata->endtimeval);

}
