 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_STORE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_STORE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AlignQualityStoreElement

template <typename TScore, typename TSpec > struct AlignQualityStoreElement;       	// "projects/library/seqan/store/store_align.h"(55)

//____________________________________________________________________________
// AlignedReadStoreElement

template <typename _TPos, typename _TGapAnchor, typename _TSpec > struct AlignedReadStoreElement;       	// "projects/library/seqan/store/store_align.h"(33)

//____________________________________________________________________________
// AnchorGaps

template <typename TGapAnchors > struct AnchorGaps;       	// "projects/library/seqan/store/store_align.h"(436)

//____________________________________________________________________________
// AnnotationStoreElement

template <typename TPos, typename TSpec > struct AnnotationStoreElement;       	// "projects/library/seqan/store/store_annotation.h"(33)

//____________________________________________________________________________
// Cigar

template <typename TChar , typename TNum > struct Cigar;       	// "projects/library/seqan/store/store_io_sam.h"(47)

//____________________________________________________________________________
// ContigStoreElement

template <typename _TContigSeq, typename _TGapAnchor, typename _TSpec > struct ContigStoreElement;       	// "projects/library/seqan/store/store_contig.h"(35)

//____________________________________________________________________________
// FragmentStore

template <typename TSpec , typename TConfig > struct FragmentStore;       	// "projects/library/seqan/store/store_all.h"(61)

//____________________________________________________________________________
// FragmentStoreConfig

template <typename TSpec > struct FragmentStoreConfig;       	// "projects/library/seqan/store/store_all.h"(37)

//____________________________________________________________________________
// GapAnchor

template <typename TPos> struct GapAnchor;       	// "projects/library/seqan/store/store_base.h"(36)

//____________________________________________________________________________
// LibraryStoreElement

template <typename TMean , typename TStd , typename TSpec > struct LibraryStoreElement;       	// "projects/library/seqan/store/store_library.h"(35)

//____________________________________________________________________________
// MatePairStoreElement

template <typename TSpec > struct MatePairStoreElement;       	// "projects/library/seqan/store/store_matepair.h"(35)

//____________________________________________________________________________
// ReadStoreElement

template <typename TReadSeq, typename TPos, typename TSpec > struct ReadStoreElement;       	// "projects/library/seqan/store/store_read.h"(33)

//____________________________________________________________________________
// TagAmos_

struct TagAmos_;       	// "projects/library/seqan/store/store_io.h"(37)

//____________________________________________________________________________
// _LessAlignedRead

template <typename TAlignedRead, typename TTag> struct _LessAlignedRead;       	// "projects/library/seqan/store/store_align.h"(104)

//____________________________________________________________________________
// _LessGapAnchor

template <typename TGapAnchor, typename TTag> struct _LessGapAnchor;       	// "projects/library/seqan/store/store_base.h"(141)

//____________________________________________________________________________
// _SortBeginPos

struct _SortBeginPos;       	// "projects/library/seqan/store/store_align.h"(83)

//____________________________________________________________________________
// _SortContigId

struct _SortContigId;       	// "projects/library/seqan/store/store_align.h"(76)

//____________________________________________________________________________
// _SortEndPos

struct _SortEndPos;       	// "projects/library/seqan/store/store_align.h"(86)

//____________________________________________________________________________
// _SortGapPos

struct _SortGapPos;       	// "projects/library/seqan/store/store_base.h"(135)

//____________________________________________________________________________
// _SortId

struct _SortId;       	// "projects/library/seqan/store/store_align.h"(80)

//____________________________________________________________________________
// _SortPairMatchId

struct _SortPairMatchId;       	// "projects/library/seqan/store/store_align.h"(89)

//____________________________________________________________________________
// _SortReadId

struct _SortReadId;       	// "projects/library/seqan/store/store_align.h"(92)

//____________________________________________________________________________
// _SortSeqPos

struct _SortSeqPos;       	// "projects/library/seqan/store/store_base.h"(132)

//____________________________________________________________________________
// comparePosLengthPair

struct comparePosLengthPair;       	// "projects/library/seqan/store/store_io_sam.h"(564)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Amos

typedef Tag<TagAmos_> const Amos;       	// "projects/library/seqan/store/store_io.h"(38)

//____________________________________________________________________________
// SortBeginPos

typedef Tag<_SortBeginPos> const SortBeginPos;       	// "projects/library/seqan/store/store_align.h"(84)

//____________________________________________________________________________
// SortContigId

typedef Tag<_SortContigId> const SortContigId;       	// "projects/library/seqan/store/store_align.h"(77)

//____________________________________________________________________________
// SortEndPos

typedef Tag<_SortEndPos> const SortEndPos;       	// "projects/library/seqan/store/store_align.h"(87)

//____________________________________________________________________________
// SortGapPos

typedef Tag<_SortGapPos> const SortGapPos;       	// "projects/library/seqan/store/store_base.h"(136)

//____________________________________________________________________________
// SortId

typedef Tag<_SortId> const SortId;       	// "projects/library/seqan/store/store_align.h"(81)

//____________________________________________________________________________
// SortPairMatchId

typedef Tag<_SortPairMatchId> const SortPairMatchId;       	// "projects/library/seqan/store/store_align.h"(90)

//____________________________________________________________________________
// SortReadId

typedef Tag<_SortReadId> const SortReadId;       	// "projects/library/seqan/store/store_align.h"(93)

//____________________________________________________________________________
// SortSeqPos

typedef Tag<_SortSeqPos> const SortSeqPos;       	// "projects/library/seqan/store/store_base.h"(133)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _appendContig

template <typename TSpec, typename TConfig, typename TId, typename TName, typename TContigGaps> inline void _appendContig(FragmentStore<TSpec, TConfig> & fragStore, TId & contigId, TName & rName, TContigGaps & contigGap);       	// "projects/library/seqan/store/store_io_sam.h"(481)

//____________________________________________________________________________
// _appendRead

template <typename TSpec, typename TConfig, typename TId, typename TName, typename TString, typename TFlag> inline void _appendRead(FragmentStore<TSpec, TConfig> & fragStore, TId & readId, TName & qname, TString & readSeq, TFlag & flag);       	// "projects/library/seqan/store/store_io_sam.h"(413)

//____________________________________________________________________________
// _dataAnchors

template <typename TSource, typename TGapAnchors> inline TGapAnchors & _dataAnchors(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "projects/library/seqan/store/store_align.h"(493)
template <typename TSource, typename TGapAnchors> inline TGapAnchors const & _dataAnchors(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "projects/library/seqan/store/store_align.h"(501)

//____________________________________________________________________________
// _dataSource

template <typename TSource, typename TGapAnchors> inline Holder<TSource> & _dataSource(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "projects/library/seqan/store/store_align.h"(476)
template <typename TSource, typename TGapAnchors> inline Holder<TSource> const & _dataSource(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "projects/library/seqan/store/store_align.h"(483)

//____________________________________________________________________________
// _generatePairMatchIds

template <typename TSpec, typename TConfig, typename TMateInfo, typename TSize> inline void _generatePairMatchIds(FragmentStore<TSpec, TConfig> & fragStore, TMateInfo mateInfos, TSize shift);       	// "projects/library/seqan/store/store_io_sam.h"(515)

//____________________________________________________________________________
// _getAnchor

template <typename TAnchor, typename TSource, typename TGapAnchors, typename TIdx> inline void _getAnchor(TAnchor &anchor, Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, TIdx idx);       	// "projects/library/seqan/store/store_align.h"(511)

//____________________________________________________________________________
// _getClippedLength

template <typename TChar, typename TNum, typename TNum2> inline void _getClippedLength(Cigar<TChar, TNum> const & cigar, TNum2 & sum);       	// "projects/library/seqan/store/store_io_sam.h"(69)

//____________________________________________________________________________
// _getID

template <typename TType, typename TID> inline bool _getID(StringSet<TType> & store, TType & elem, TID & elem_id);       	// "projects/library/seqan/store/store_io_sam.h"(351)

//____________________________________________________________________________
// _getMate

template <typename TSpec, typename TConfig, typename TPos, typename TID> inline void _getMate(FragmentStore<TSpec, TConfig> & fragStore, String<char> & readName, TPos & mPos, TID & mateID);       	// "projects/library/seqan/store/store_io_sam.h"(319)

//____________________________________________________________________________
// _goNext_gapAnchorIterator

template <typename T> inline void _goNext_gapAnchorIterator(T & me);       	// "projects/library/seqan/store/store_align.h"(1052)

//____________________________________________________________________________
// _goPrevious_gapAnchorIterator

template <typename T> inline void _goPrevious_gapAnchorIterator(T & me);       	// "projects/library/seqan/store/store_align.h"(1069)

//____________________________________________________________________________
// _goTo_gapAnchorIterator

template <typename T, typename TPos> inline void _goTo_gapAnchorIterator(T & me, TPos pos);       	// "projects/library/seqan/store/store_align.h"(1086)

//____________________________________________________________________________
// _helperIsNegative

template <typename T> inline bool _helperIsNegative(T, False);       	// "projects/library/seqan/store/store_align.h"(646)
template <typename T> inline bool _helperIsNegative(T t, True);       	// "projects/library/seqan/store/store_align.h"(652)

//____________________________________________________________________________
// _parse_is_PhredQual

template <typename TChar> inline bool _parse_is_PhredQual(TChar const & c);       	// "projects/library/seqan/store/store_io_sam.h"(711)

//____________________________________________________________________________
// _parse_is_dna

template <typename TChar> inline bool _parse_is_dna(TChar const & c);       	// "projects/library/seqan/store/store_io_sam.h"(683)

//____________________________________________________________________________
// _parse_readCharsTillEndOfLine

template <typename TFile, typename TChar> inline void _parse_readCharsTillEndOfLine(TFile & file, String<char> & str, TChar& c);       	// "projects/library/seqan/store/store_io_sam.h"(752)

//____________________________________________________________________________
// _parse_readCigar

template <typename TFile, typename TChar, typename TNum> inline void _parse_readCigar(TFile & file, Cigar<TChar, TNum> & cigar, TChar& c);       	// "projects/library/seqan/store/store_io_sam.h"(641)

//____________________________________________________________________________
// _parse_readDnaSeq

template <typename TFile, typename TString, typename TChar> inline void _parse_readDnaSeq(TFile & file, TString & str, TChar& c);       	// "projects/library/seqan/store/store_io_sam.h"(693)

//____________________________________________________________________________
// _parse_readSamIdentifier

template <typename TFile, typename TString, typename TChar> inline void _parse_readSamIdentifier(TFile & file, TString & str, TChar& c);       	// "projects/library/seqan/store/store_io_sam.h"(667)

//____________________________________________________________________________
// _parse_readSeqQual

template <typename TFile, typename TChar> inline void _parse_readSeqQual(TFile & file, String<Dna5Q> & str, TChar& c);       	// "projects/library/seqan/store/store_io_sam.h"(724)

//____________________________________________________________________________
// _print_gapAnchor

template <typename TChar, typename TGapAnchor> inline void _print_gapAnchor(String<TChar> seq, String<TGapAnchor> gaps);       	// "projects/library/seqan/store/store_io_sam.h"(266)

//____________________________________________________________________________
// _readAlignments

template <typename TFile, typename TSpec, typename TConfig, typename TContigGaps, typename TMateInfo, typename TChar> inline void _readAlignments(TFile& file, FragmentStore<TSpec, TConfig>& fragStore, TContigGaps & contigGaps, TMateInfo & mateInfos, TChar & c, SAM);       	// "projects/library/seqan/store/store_io_sam.h"(848)

//____________________________________________________________________________
// _readHeader

template <typename TFile, typename TSpec, typename TConfig, typename TChar> inline void _readHeader(TFile& file, FragmentStore<TSpec, TConfig>& fragStore, TChar & c, SAM);       	// "projects/library/seqan/store/store_io_sam.h"(827)

//____________________________________________________________________________
// _readOneAlignment

template <typename TFile, typename TSpec, typename TConfig, typename TContigGaps, typename TMateInfo, typename TChar> inline void _readOneAlignment(TFile& file, FragmentStore<TSpec, TConfig>& fragStore, TContigGaps & contigsGaps, TMateInfo & mateInfos, TChar & c, SAM);       	// "projects/library/seqan/store/store_io_sam.h"(890)

//____________________________________________________________________________
// _unclippedLength

template <typename TSource, typename TGapAnchors> inline typename Size< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type _unclippedLength(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "projects/library/seqan/store/store_align.h"(538)

//____________________________________________________________________________
// _writeAlignments

template <typename TFile, typename TSpec, typename TConfig> inline void _writeAlignments(TFile & target, FragmentStore<TSpec, TConfig> & store, SAM);       	// "projects/library/seqan/store/store_io_sam_out.h"(91)

//____________________________________________________________________________
// _writeContigsGapsInStore

template <typename TFragmentStore, typename TContigPos> inline void _writeContigsGapsInStore(TFragmentStore & fragStore, StringSet<String<Pair<TContigPos, TContigPos> > > const & contigsGaps);       	// "projects/library/seqan/store/store_io_sam.h"(578)

//____________________________________________________________________________
// _writeHeader

template <typename TFile, typename TSpec, typename TConfig> inline void _writeHeader(TFile & target, FragmentStore<TSpec, TConfig> & store, SAM);       	// "projects/library/seqan/store/store_io_sam_out.h"(36)

//____________________________________________________________________________
// append

template <typename TChar, typename TNum> inline void append(Cigar<TChar, TNum> & cigar, TChar const c, TNum const i);       	// "projects/library/seqan/store/store_io_sam.h"(59)

//____________________________________________________________________________
// appendAlignment

template <typename TSpec, typename TConfig, typename TId, typename TPos, typename TGaps> inline void appendAlignment( FragmentStore<TSpec, TConfig> & fragStore, TId & readId, TId & contigId, TPos & beginPos, TPos & endPos, TGaps & gaps);       	// "projects/library/seqan/store/store_io_sam.h"(382)

//____________________________________________________________________________
// appendMatePair

template <typename TSpec, typename TConfig, typename TRead> inline typename Size<typename FragmentStore<TSpec, TConfig>::TMatePairStore>::Type appendMatePair( FragmentStore<TSpec, TConfig> &me, TRead const &read1, TRead const &read2);       	// "projects/library/seqan/store/store_all.h"(221)
template <typename TSpec, typename TConfig, typename TRead> inline typename Size<typename FragmentStore<TSpec, TConfig>::TMatePairStore>::Type appendMatePair( FragmentStore<TSpec, TConfig> &me, TRead const &read1, TRead const &read2, CharString const &name1, CharString const &name2);       	// "projects/library/seqan/store/store_all.h"(248)

//____________________________________________________________________________
// appendRead

template <typename TSpec, typename TConfig, typename TRead, typename TId> inline typename Size<typename FragmentStore<TSpec, TConfig>::TReadStore>::Type appendRead( FragmentStore<TSpec, TConfig> &me, TRead const &read, TId matePairId);       	// "projects/library/seqan/store/store_all.h"(147)
template <typename TSpec, typename TConfig, typename TRead, typename TId> inline typename Size<typename FragmentStore<TSpec, TConfig>::TReadStore>::Type appendRead( FragmentStore<TSpec, TConfig> &me, TRead const &read, CharString const &name, TId matePairId);       	// "projects/library/seqan/store/store_all.h"(166)
template <typename TSpec, typename TConfig, typename TRead> inline typename Size<typename FragmentStore<TSpec, TConfig>::TReadStore>::Type appendRead( FragmentStore<TSpec, TConfig> &me, TRead const &read);       	// "projects/library/seqan/store/store_all.h"(184)
template <typename TSpec, typename TConfig, typename TRead> inline typename Size<typename FragmentStore<TSpec, TConfig>::TReadStore>::Type appendRead( FragmentStore<TSpec, TConfig> &me, TRead const &read, CharString const &name);       	// "projects/library/seqan/store/store_all.h"(197)

//____________________________________________________________________________
// atBegin

template <typename TGaps, typename TGapAnchors> inline bool atBegin(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "projects/library/seqan/store/store_align.h"(882)
template <typename TGaps, typename TGapAnchors> inline bool atBegin(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "projects/library/seqan/store/store_align.h"(889)

//____________________________________________________________________________
// atEnd

template <typename TGaps, typename TGapAnchors> inline bool atEnd(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "projects/library/seqan/store/store_align.h"(897)
template <typename TGaps, typename TGapAnchors> inline bool atEnd(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "projects/library/seqan/store/store_align.h"(904)

//____________________________________________________________________________
// begin

template <typename TSource, typename TGapAnchors> inline typename Iterator<Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type begin(Gaps<TSource, AnchorGaps<TGapAnchors> > & me, Standard);       	// "projects/library/seqan/store/store_align.h"(573)
template <typename TSource, typename TGapAnchors> inline typename Iterator<Gaps<TSource, AnchorGaps<TGapAnchors> > const>::Type begin(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, Standard);       	// "projects/library/seqan/store/store_align.h"(581)
template <typename TSource, typename TGapAnchors> inline typename Iterator<Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type begin(Gaps<TSource, AnchorGaps<TGapAnchors> > & me, Rooted);       	// "projects/library/seqan/store/store_align.h"(591)
template <typename TSource, typename TGapAnchors> inline typename Iterator<Gaps<TSource, AnchorGaps<TGapAnchors> > const>::Type begin(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, Rooted);       	// "projects/library/seqan/store/store_align.h"(599)

//____________________________________________________________________________
// beginPosition

template <typename TSource, typename TGapAnchors> inline typename Position< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type beginPosition(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "projects/library/seqan/store/store_align.h"(609)

//____________________________________________________________________________
// calculateLibSizes

template <typename TLibSizeString, typename TSpec, typename TConfig> inline void calculateLibSizes(TLibSizeString &libSize, FragmentStore<TSpec, TConfig> &me);       	// "projects/library/seqan/store/store_all.h"(353)

//____________________________________________________________________________
// calculateMateIndices

template <typename TMateIndexString, typename TSpec, typename TConfig> inline void calculateMateIndices(TMateIndexString &mateIndex, FragmentStore<TSpec, TConfig> &me);       	// "projects/library/seqan/store/store_all.h"(410)

//____________________________________________________________________________
// cigarToContigGaps

template <typename TChar, typename TNum, typename TPos, typename TFlag, typename TGap> inline void cigarToContigGaps(Cigar<TChar, TNum> const & cigar, TPos beginPos, TFlag flag, String<Pair<TGap, TGap> > & gaps);       	// "projects/library/seqan/store/store_io_sam.h"(173)

//____________________________________________________________________________
// cigarToGapAnchorRead

template <typename TChar, typename TNum, typename TGapAnchor> inline void cigarToGapAnchorRead(Cigar<TChar, TNum> const & cigar, String<TGapAnchor> & gaps);       	// "projects/library/seqan/store/store_io_sam.h"(94)

//____________________________________________________________________________
// clearReads

template <typename TSpec, typename TConfig> inline void clearReads(FragmentStore<TSpec, TConfig> &me);       	// "projects/library/seqan/store/store_all.h"(136)

//____________________________________________________________________________
// compactAlignedReads

template <typename TSpec, typename TConfig> inline typename Size<typename FragmentStore<TSpec, TConfig>::TAlignedReadStore>::Type compactAlignedReads(FragmentStore<TSpec, TConfig> &me);       	// "projects/library/seqan/store/store_all.h"(278)

//____________________________________________________________________________
// compactPairMatchIds

template <typename TSpec, typename TConfig> inline typename Size<typename FragmentStore<TSpec, TConfig>::TAlignedReadStore>::Type compactPairMatchIds(FragmentStore<TSpec, TConfig> &me);       	// "projects/library/seqan/store/store_all.h"(319)

//____________________________________________________________________________
// convertMatchesToGlobalAlignment

template <typename TSpec, typename TConfig, typename TScore> void convertMatchesToGlobalAlignment(FragmentStore<TSpec, TConfig> &store, TScore &score);       	// "projects/library/seqan/store/store_all.h"(590)

//____________________________________________________________________________
// countGaps

template <typename TGaps, typename TGapAnchors> inline typename Size<TGaps>::Type countGaps(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "projects/library/seqan/store/store_align.h"(867)

//____________________________________________________________________________
// endPosition

template <typename TSource, typename TGapAnchors> inline typename Position< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type endPosition(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "projects/library/seqan/store/store_align.h"(617)

//____________________________________________________________________________
// getCigarString

template <typename TCigar, typename TGaps1, typename TGaps2, typename TThresh> inline void getCigarString( TCigar &cigar, TGaps1 &gaps1, TGaps2 &gaps2, TThresh splicedGapThresh);       	// "projects/library/seqan/store/store_align.h"(1152)
template <typename TCigar, typename TGaps1, typename TGaps2> inline void getCigarString( TCigar &cigar, TGaps1 &gaps1, TGaps2 &gaps2);       	// "projects/library/seqan/store/store_align.h"(1221)

//____________________________________________________________________________
// getClrRange

template <typename TSpec, typename TConfig, typename TPos, typename TGapAnchor, typename TSpecAlign, typename TBeginClr, typename TEndClr> inline void getClrRange(FragmentStore<TSpec, TConfig> const& fragStore, AlignedReadStoreElement<TPos, TGapAnchor, TSpecAlign> const& alignEl, TBeginClr& begClr, TEndClr& endClr);       	// "projects/library/seqan/store/store_io.h"(55)

//____________________________________________________________________________
// getMateNo

template <typename TSpec, typename TConfig, typename TId> inline signed char getMateNo(FragmentStore<TSpec, TConfig> const &me, TId readId);       	// "projects/library/seqan/store/store_all.h"(385)

//____________________________________________________________________________
// getRead

template <typename TSpec, typename TConfig, typename TId> inline typename Value<typename FragmentStore<TSpec, TConfig>::TReadSeqStore>::Type getRead( FragmentStore<TSpec, TConfig> &me, TId id);       	// "projects/library/seqan/store/store_all.h"(209)

//____________________________________________________________________________
// getValue

template <typename TGaps, typename TGapAnchors> inline typename GetValue< Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > >::Type getValue(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "projects/library/seqan/store/store_align.h"(830)
template <typename TGaps, typename TGapAnchors> inline typename GetValue< Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const>::Type getValue(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "projects/library/seqan/store/store_align.h"(839)

//____________________________________________________________________________
// goFurther

template <typename TGaps, typename TGapAnchors, typename TSize> inline void goFurther(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me, TSize steps);       	// "projects/library/seqan/store/store_align.h"(1135)

//____________________________________________________________________________
// goNext

template <typename TGaps, typename TGapAnchors> inline void goNext(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "projects/library/seqan/store/store_align.h"(1121)

//____________________________________________________________________________
// goPrevious

template <typename TGaps, typename TGapAnchors> inline void goPrevious(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "projects/library/seqan/store/store_align.h"(1128)

//____________________________________________________________________________
// insertGaps

template <typename TGaps, typename TGapAnchors, typename TCount> inline void insertGaps(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me, TCount size);       	// "projects/library/seqan/store/store_align.h"(953)

//____________________________________________________________________________
// isClipped

template <typename TGaps, typename TGapAnchors> inline bool isClipped(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "projects/library/seqan/store/store_align.h"(858)

//____________________________________________________________________________
// isGap

template <typename TGaps, typename TGapAnchors> inline bool isGap(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "projects/library/seqan/store/store_align.h"(851)

//____________________________________________________________________________
// layoutAlignment

template <typename TLayoutStringSet, typename TSpec, typename TConfig, typename TContigId> void layoutAlignment(TLayoutStringSet &layout, FragmentStore<TSpec, TConfig> &store, TContigId contigId);       	// "projects/library/seqan/store/store_all.h"(435)

//____________________________________________________________________________
// length

template <typename TSource, typename TGapAnchors> inline typename Size< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type length(Gaps<TSource, AnchorGaps<TGapAnchors> > & me);       	// "projects/library/seqan/store/store_align.h"(555)
template <typename TSource, typename TGapAnchors> inline typename Size< Gaps<TSource, AnchorGaps<TGapAnchors> > >::Type length(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me);       	// "projects/library/seqan/store/store_align.h"(563)

//____________________________________________________________________________
// loadContigs

template <typename TFSSpec, typename TFSConfig> bool loadContigs(FragmentStore<TFSSpec, TFSConfig> &store, StringSet<CharString> const &fileNameList);       	// "projects/library/seqan/store/store_io.h"(780)
template <typename TFSSpec, typename TFSConfig> bool loadContigs(FragmentStore<TFSSpec, TFSConfig> &store, CharString const &fileName);       	// "projects/library/seqan/store/store_io.h"(810)

//____________________________________________________________________________
// lowerBoundAlignedReads

template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortId);       	// "projects/library/seqan/store/store_align.h"(221)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortContigId);       	// "projects/library/seqan/store/store_align.h"(257)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortBeginPos);       	// "projects/library/seqan/store/store_align.h"(293)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortEndPos);       	// "projects/library/seqan/store/store_align.h"(330)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortPairMatchId);       	// "projects/library/seqan/store/store_align.h"(367)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type lowerBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortReadId);       	// "projects/library/seqan/store/store_align.h"(403)

//____________________________________________________________________________
// lowerBoundGapAnchor

template <typename TGapAnchor, typename TSearchValue> inline typename Iterator<TGapAnchor, Standard>::Type lowerBoundGapAnchor(TGapAnchor const& gaps, TSearchValue const val, SortSeqPos);       	// "projects/library/seqan/store/store_base.h"(176)
template <typename TGapAnchor, typename TSearchValue> inline typename Iterator<TGapAnchor, Standard>::Type lowerBoundGapAnchor(TGapAnchor const& gaps, TSearchValue const val, SortGapPos);       	// "projects/library/seqan/store/store_base.h"(212)

//____________________________________________________________________________
// operator!=

template <typename TGaps, typename TGapAnchors> inline bool operator!= ( Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & left, Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & right);       	// "projects/library/seqan/store/store_align.h"(925)

//____________________________________________________________________________
// operator<

template <typename TGaps, typename TGapAnchors> inline bool operator< ( Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & left, Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & right);       	// "projects/library/seqan/store/store_align.h"(934)

//____________________________________________________________________________
// operator==

template <typename TGaps, typename TGapAnchors> inline bool operator== ( Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & left, Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & right);       	// "projects/library/seqan/store/store_align.h"(916)

//____________________________________________________________________________
// operator>

template <typename TGaps, typename TGapAnchors> inline bool operator> ( Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & left, Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & right);       	// "projects/library/seqan/store/store_align.h"(943)

//____________________________________________________________________________
// positionGapToSeq

template <typename TSource, typename TGapAnchors, typename TPosition> inline TPosition positionGapToSeq(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, TPosition pos);       	// "projects/library/seqan/store/store_align.h"(659)

//____________________________________________________________________________
// positionSeqToGap

template <typename TSource, typename TGapAnchors, typename TPosition> inline TPosition positionSeqToGap(Gaps<TSource, AnchorGaps<TGapAnchors> > const & me, TPosition pos);       	// "projects/library/seqan/store/store_align.h"(695)

//____________________________________________________________________________
// printAlignment

template <typename TStream, typename TLayoutStringSet, typename TSpec, typename TConfig, typename TContigId, typename TPos, typename TNum> void printAlignment( TStream &stream, TLayoutStringSet &layout, FragmentStore<TSpec, TConfig> &store, TContigId contigId, TPos posBegin, TPos posEnd, TNum lineBegin, TNum lineEnd, unsigned lastRead);       	// "projects/library/seqan/store/store_all.h"(491)

//____________________________________________________________________________
// read

template <typename TFile, typename TSpec, typename TConfig> inline void read(TFile & file, FragmentStore<TSpec, TConfig>& fragStore, Amos);       	// "projects/library/seqan/store/store_io.h"(104)
template <typename TFile, typename TSpec, typename TConfig> inline void read(TFile& file, FragmentStore<TSpec, TConfig>& fragStore, SAM);       	// "projects/library/seqan/store/store_io_sam.h"(778)

//____________________________________________________________________________
// removeGaps

template <typename TGaps, typename TGapAnchors, typename TCount> inline void removeGaps(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me, TCount size);       	// "projects/library/seqan/store/store_align.h"(1006)

//____________________________________________________________________________
// setBeginPosition

template <typename TSource, typename TGapAnchors, typename TPosition> inline void setBeginPosition(Gaps<TSource, AnchorGaps<TGapAnchors> > & me, TPosition view_position);       	// "projects/library/seqan/store/store_align.h"(627)

//____________________________________________________________________________
// setEndPosition

template <typename TSource, typename TGapAnchors, typename TPosition> inline void setEndPosition(Gaps<TSource, AnchorGaps<TGapAnchors> > & me, TPosition view_position);       	// "projects/library/seqan/store/store_align.h"(635)

//____________________________________________________________________________
// sortAlignedReads

template <typename TAlign, typename TSortSpec> inline void sortAlignedReads(TAlign& alignStore, Tag<TSortSpec> const &);       	// "projects/library/seqan/store/store_align.h"(175)
template <typename TAlign, typename TSortSpec> inline void sortAlignedReads(TAlign const & alignStore, Tag<TSortSpec> const &);       	// "projects/library/seqan/store/store_align.h"(187)
template <typename TAlign, typename TFunctorLess> inline void sortAlignedReads(TAlign & alignStore, TFunctorLess const &less);       	// "projects/library/seqan/store/store_align.h"(197)
template <typename TAlign, typename TFunctorLess> inline void sortAlignedReads(TAlign const & alignStore, TFunctorLess const &less);       	// "projects/library/seqan/store/store_align.h"(207)

//____________________________________________________________________________
// source

template <typename TGaps, typename TGapAnchors> inline typename Source<Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const>::Type source(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > & me);       	// "projects/library/seqan/store/store_align.h"(815)
template <typename TGaps, typename TGapAnchors> inline typename Source<Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > >::Type source(Iter<TGaps, GapsIterator<AnchorGaps<TGapAnchors> > > const & me);       	// "projects/library/seqan/store/store_align.h"(821)

//____________________________________________________________________________
// upperBoundAlignedReads

template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortId);       	// "projects/library/seqan/store/store_align.h"(239)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortContigId);       	// "projects/library/seqan/store/store_align.h"(275)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortBeginPos);       	// "projects/library/seqan/store/store_align.h"(311)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortEndPos);       	// "projects/library/seqan/store/store_align.h"(348)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortPairMatchId);       	// "projects/library/seqan/store/store_align.h"(385)
template <typename TAlign, typename TSearchValue> inline typename Iterator<TAlign, Standard>::Type upperBoundAlignedReads(TAlign const& alignStore, TSearchValue const val, SortReadId);       	// "projects/library/seqan/store/store_align.h"(421)

//____________________________________________________________________________
// upperBoundGapAnchor

template <typename TGapAnchor, typename TSearchValue> inline typename Iterator<TGapAnchor, Standard>::Type upperBoundGapAnchor(TGapAnchor const& gaps, TSearchValue const val, SortSeqPos);       	// "projects/library/seqan/store/store_base.h"(194)
template <typename TGapAnchor, typename TSearchValue> inline typename Iterator<TGapAnchor, Standard>::Type upperBoundGapAnchor(TGapAnchor const& gaps, TSearchValue const val, SortGapPos);       	// "projects/library/seqan/store/store_base.h"(230)

//____________________________________________________________________________
// write

template <typename TFile, typename TSpec, typename TConfig> inline void write(TFile & target, FragmentStore<TSpec, TConfig> & store, SAM);       	// "projects/library/seqan/store/store_io_sam_out.h"(263)
template <typename TFile, typename TSpec, typename TConfig> inline void write(TFile & target, FragmentStore<TSpec, TConfig>& fragStore, Amos);       	// "projects/library/seqan/store/store_io.h"(518)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

