/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
/***************************************************************************
 *  Module:      $Id: strerror.c,v 2.16 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: Replacement code for strerror if a system doesn't have it
 *  Author:      UofC people, maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/*
 * $Log: strerror.c,v $
 * Revision 2.16  1997/12/31 05:18:32  nemesis
 * CLOCAL for all, GCC fixes, WAIT_WORD finished
 *
 * Revision 2.15  1997/12/28 23:20:45  nemesis
 * include cleanups, configure additions/corrections
 *
 * Revision 2.14  1997/12/25 06:44:34  nemesis
 * time_t declarations and "make install" fix
 *
 * Revision 2.13  1997/12/24 21:50:04  nemesis
 * mailing list updates
 *
 * Revision 2.12  1997/12/24 21:42:54  nemesis
 * 0.8a released.
 *
 * Revision 2.11  1997/12/24 21:02:02  nemesis
 * more changes
 *
 * Revision 2.10  1997/12/24 20:56:03  nemesis
 * gearing up for 0.8a more
 *
 * Revision 2.9  1997/12/24 20:45:35  nemesis
 * trying to make 0.8a release
 *
 * Revision 2.8  1997/12/24 20:29:08  nemesis
 * fixed up autoconf modifications, cleaned up signal stuff
 *
 * Revision 2.7  1997/12/24 20:15:13  nemesis
 * sendpage.h now mostly contained within 'configure'
 *
 * Revision 2.6  1997/12/24 19:52:04  nemesis
 * fixing posix checking
 *
 * Revision 2.5  1997/12/24 19:41:49  nemesis
 * posix additions, syslog autoconf'd
 *
 * Revision 2.4  1997/12/24 19:33:03  nemesis
 * check for POSIX
 *
 * Revision 2.3  1997/12/17 09:37:27  nemesis
 * more autoconf changes... mostly strerror.o
 * */

#include "sendpage.h"

#ifndef HAVE_STRERROR
char * strerror(errnum)
	int errnum;
{
	extern int sys_nerr;
	extern char *sys_errlist[];
	static char ebuf[40];		/* 64-bit number + slop */

	if ((unsigned int)errnum < sys_nerr)
		return(sys_errlist[errnum]);
	(void)sprintf(ebuf, "Unknown error: %d", errnum);
	return(ebuf);
}
#endif
