/***************************************************************************
 *  Module:      $Id: cf.c,v 1.3 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: Configuration file and alias functions for sendpage
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
$Log: cf.c,v $
Revision 1.3  1997/12/31 05:18:32  nemesis
CLOCAL for all, GCC fixes, WAIT_WORD finished

Revision 1.2  1997/12/29 02:45:13  nemesis
include strengthening.  works with db 2.0+1.85 compats.  compiles/runs on HPUX

Revision 1.1  1997/12/28 23:20:45  nemesis
include cleanups, configure additions/corrections

Revision 2.17  1997/12/27 20:53:04  nemesis
db.1.85 stuff, maxTransactions implemented

Revision 2.16  1997/12/26 02:37:31  nemesis
code clean up, b* -> mem* funcs, finding NL -> # bug

Revision 2.15  1997/12/25 08:30:52  nemesis
code cleanups

Revision 2.14  1997/12/25 06:44:34  nemesis
time_t declarations and "make install" fix

Revision 2.13  1997/12/24 21:50:04  nemesis
mailing list updates

Revision 2.12  1997/12/24 21:42:54  nemesis
0.8a released.

Revision 2.11  1997/12/24 21:02:02  nemesis
more changes

Revision 2.10  1997/12/24 20:56:03  nemesis
gearing up for 0.8a more

Revision 2.9  1997/12/24 20:45:35  nemesis
trying to make 0.8a release

Revision 2.8  1997/12/24 20:29:08  nemesis
fixed up autoconf modifications, cleaned up signal stuff

Revision 2.7  1997/12/24 20:15:13  nemesis
sendpage.h now mostly contained within 'configure'

Revision 2.6  1997/12/24 19:52:04  nemesis
fixing posix checking

Revision 2.5  1997/12/24 19:41:49  nemesis
posix additions, syslog autoconf'd

Revision 2.4  1997/12/24 19:33:03  nemesis
check for POSIX

Revision 2.3  1997/12/17 09:37:27  nemesis
more autoconf changes... mostly strerror.o

Revision 2.2  1997/12/17 08:24:05  nemesis
autoconf-ing

Revision 2.1  1997/12/17 08:03:38  nemesis
adjustments

Revision 2.0  1997/12/17 08:01:05  nemesis
setting up autoconf

Revision 1.9  1997/12/17 07:56:23  nemesis
starting on the autoconfing

Revision 1.8  1997/12/17 04:47:05  nemesis
still adjusting

Revision 1.7  1997/12/17 04:46:25  nemesis
adjusting version numbers

Revision 1.6  1997/12/17 04:44:36  nemesis
*** empty log message ***

Revision 1.3  1997/12/15 17:29:08  nemesis
added Steve Kennedy <steve@demon.net> patches for
being able to alias paging-centrals and having
various profile bits set in the pc.
see: http://www.gbnet.net/public/paging/sendpage-multi/

Revision 1.2  1997/12/15 16:08:52  nemesis
added copyright line

Revision 1.1  1997/12/15 15:53:38  nemesis
Initial revision

 * Revision 1.10  1996/02/14  09:49:11  maf
 * ARSYSTEM_NOTIFIER
 *
 * Revision 1.9  1996/02/13  04:38:03  maf
 * *** empty log message ***
 *
 * Revision 1.8  1996/02/12  03:50:19  maf
 * break's missing, timeForma
 *
 * Revision 1.7  1995/12/18  00:00:49  maf
 * still broke, but less broken
 *
 * Revision 1.6  1995/11/13  04:43:08  maf
 * *** empty log message ***
 *
 * Revision 1.5  1995/11/13  03:26:24  maf
 * *** empty log message ***
 *
 * Revision 1.4  1995/10/09  01:39:08  maf
 * user database parse option, expanded alias parsing
 * datastring.buf and keystring.buf were memory leak in alias parsing
 *
 * Revision 1.3  1995/05/24  00:44:37  maf
 * termio -> termios
 * pcinfo.modeminit not terminated right
 * all unknown string sizes use %.512s for report()
 * casts for picky Solaris compiler
 *
 * Revision 1.2  1995/03/15  04:40:46  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:42:09  maf
 * Initial revision
 *
*/

#include "sendpage.h"
#include "report.h"
#include "cf.h"

/*********************************************************************
 * Function: ReadConfig
 *	reads sendpage configuration file, updating the paging central
 *	and alias database.
 *
 * Returns: 0	good  - aliasdb and pcdb point to a new database reflecting
 *			the contents of the configuration file.  if aliasdb
 *	 	        or pcdb were passed as non null pointers, the old
 *			databases are closed.
 *		      - ncentral is updated with the number of paging
 *			central entries stored - currently this is
 *			limited to the PET protocol.  ncentral is left
 *			untouched on error.
 *
 *	   !0	bad   - if aliasdb pcdb were passed as non null pointers, 
 *			they are left untouched.
 *
 *	The initial call to ReadConfig() should have aliasdb and pcdb be
 *	null pointers.
 *
 *	The caller is responsible for closing pcdb and aliasdb
 *
 *	error reporting is done via report()
 *
 *********************************************************************/
int ReadConfig(DB ** aliasdb, DB **pcdb, DB**trdb, DB**profdb,
	       u_int *ncentral, char *fname) {
  int r, fd, lineno;
  struct cbuf cbuf;
  int err;
  extern int errno;
  int where, type, ret;
  int cferr;
  struct dynstring keystring, datastring;
  u_int naliases, npets;
  DBT dbkey, dbval;
  DB *tpcdb, *taliasdb, *ttrdb, *tprofdb; 
  u_int tncentral;
  char nullbyte;
  struct pcinfo pcinfo;
  struct profile tProfile, activeProfile;
  char *c, *c2, tmpstr[PCINFO_STR_LEN];
  int trIndex = 0;
  int trMap[256];
  char sKey[PCINFO_STR_LEN];
  char sTmp[PCINFO_STR_LEN];
  extern struct profile defaultProfile;
  extern struct global globalOptions;
  
  
  fd = -1;		/* unused */
  err = 1;		/* bad */
  where = 0;		/* field in type */
  type = CF_UNKNOWN;	/* what is it */
  cferr = 0;		/* no errors (yet) parsing config file */
  lineno = 1;		/* people count from 1 */
  naliases = 0;		/* # of aliases loaded */
  npets = 0;		/* # of pet protocol defs loaded */
  tpcdb = (DB*)0;	/* database not opened */
  taliasdb = (DB*)0;	/* database not opened */
  ttrdb = (DB*)0;	/* database not opened */
  tprofdb = (DB*)0;	/* database not opened */
  nullbyte = 0;		/* null byte */
  tncentral = 0;	/* none */

  bzero(&keystring, sizeof(keystring));
  bzero(&datastring, sizeof(datastring));
  bzero(&cbuf, sizeof(cbuf));

  /* setup default profile */
  memcpy(&activeProfile, &defaultProfile, sizeof activeProfile);
  
  if (!(tpcdb = (DB*)dbopen((char*)0, O_CREAT|O_RDWR|O_TRUNC,
			    S_IRUSR|S_IWUSR, DB_HASH, (void*)0))) {
    report (LOG_ERR, "dbopen(tpcdb) failed");
    goto ReadConfigout;
  }

  if (!(taliasdb = (DB*)dbopen((char*)0, O_CREAT|O_RDWR|O_TRUNC,
			       S_IRUSR|S_IWUSR, DB_HASH, (void*)0))) {
    report (LOG_ERR, "dbopen(taliasdb) failed");
    goto ReadConfigout;
  }
  
  if (!(ttrdb = (DB*)dbopen((char*)0, O_CREAT|O_RDWR|O_TRUNC,
			    S_IRUSR|S_IWUSR, DB_HASH, (void*)0))) {
    report (LOG_ERR, "dbopen(ttrdb) failed");
    goto ReadConfigout;
  }
  
  if (!(tprofdb = (DB*)dbopen((char*)0, O_CREAT|O_RDWR|O_TRUNC,
			      S_IRUSR|S_IWUSR, DB_HASH, (void*)0))) {
    report (LOG_ERR, "dbopen(tprofdb) failed");
    goto ReadConfigout;
  }
  
  if ((fd = open(fname, O_RDONLY, 0)) == -1) {
    report(LOG_ERR, "open (%s): %.512s", fname, strerror(errno));
    goto ReadConfigout;
  }
  
  
  while (!cferr) {
    
    if ((r = GetNextField(fd, &cbuf, &lineno)) == -1) {
      report(LOG_ERR, "GetNextField() returned error condition");
      goto ReadConfigout;
    }
    
    ++ where;
    
    c = (char*) (cbuf.buf+cbuf.start);
    
    switch (type) {
      
    case CF_UNKNOWN:
      
      where = 0; /* 0th field */
      
      /* skip blank and comment lines */
      if (!cbuf.len)
	break;
      
      if ((cbuf.len == 2) && (!strncmp(c, "pc", 2)))
	type = CF_PC;
      else if ((cbuf.len == 5) && (!strncmp(c, "alias", 5)))
	type = CF_ALIAS;
      else if ((cbuf.len == 5) && (!strncmp(c, "trMap", 5)))
	type = CF_TRMAP;
      else if ((cbuf.len == 7) && (!strncmp(c, "profile", 7)))
	type = CF_PROFILE;
      else if ((cbuf.len == 3) && (!strncmp(c, "set", 3)))
	type = CF_SET;
      else if ((cbuf.len == 6) && (!strncmp(c, "global", 6)))
	type = CF_GLOBAL;
      else if ((cbuf.len == 6) && (!strncmp(c, "dopple", 6)))
	type = CF_DOPPLE;
      else
	cferr = 1;
      break;
      
    case CF_PC:
      
      switch (where) {
	
      case 1:		/* first field, init the struct */
	
	bzero(&pcinfo, sizeof(pcinfo));
	pcinfo.id = tncentral;
	pcinfo.dialer = DIALER_INTERNAL;
	strcpy(pcinfo.password, "000000");
	strcpy(pcinfo.modemInit, MODEM_INIT);
	strcpy(pcinfo.modemDev, MODEM_DEV);
	strcpy(pcinfo.modemDial, MODEM_DIAL);
	pcinfo.answerTime = 25;
	pcinfo.parity = PARENB;
	pcinfo.speed = B1200;
	pcinfo.databits = CS7;
	pcinfo.protocol = PC_PET1;
	pcinfo.msgRetries = 30;
	pcinfo.maxMsgSize = 0;
	pcinfo.maxTransactions = 0; /* unlimited */
	pcinfo.retryNotify = 2;
	strcpy(pcinfo.trMap, "std");
	strcpy(pcinfo.emailFrom, globalOptions.emailFrom);
	pcinfo.flags = 0;
	pcinfo.pc_set = 0;
	pcinfo.dopple_set = 0;
	pcinfo.mangle = 1;
	pcinfo.pc_alias = 0;
	strcpy(pcinfo.alias_name, "nothingatall");
	
      default: /* handle the option */
	
	/* check if this line is done */
	if (!cbuf.len) { 
	  
	  /* reset for next line */
	  type = 0; 
	  
	  /* sanity check */
	  /* TODO */
	  
	  ++npets;
	  ++tncentral;
	  
	  dbval.data = (void*)&pcinfo;
	  dbval.size = sizeof(struct pcinfo);
	  
	  dbkey.data = (void*)pcinfo.name;
	  dbkey.size = strlen(pcinfo.name);
	  
	  if (tpcdb->put(tpcdb, &dbkey, &dbval,
			 (u_int)R_NOOVERWRITE)) {
	    report(LOG_ERR,
		   "db->put() failed - line %d, errno=%d",
		   lineno, errno);
	    cferr = 1;
	    break;
	  }
	  
	  break;
	}
	
	if ((c2 = CheckTagField(c, cbuf.len, "name="))) {
	  memcpy(pcinfo.name, c2, cbuf.len - 5);
	  pcinfo.name[cbuf.len-5] = 0;
	  break;
	}
	
	if (!pcinfo.name[0]) {
	  report (LOG_ERR, "name must be set first");
	  cferr = 1;
	  break;
	}
	
	if ((c2 = CheckTagField(c, cbuf.len,
				"protocol="))) {
	  memcpy(tmpstr, c2, cbuf.len - 9);
	  tmpstr[cbuf.len-9] = 0;
	  if (!strcasecmp(tmpstr, "pet-pg1"))
	    pcinfo.protocol = PC_PET1;
	  else if (!strcasecmp(tmpstr, "pet-pg3"))
	    pcinfo.protocol = PC_PET3;
	  else if (!strcasecmp(tmpstr, "null"))
	    pcinfo.protocol = PC_NULL;
#ifdef ARSYSTEM_NOTIFIER
	  else if (!strcasecmp(tmpstr, "ARSystemNotifier"))
	    pcinfo.protocol = PC_REMEDY;
#endif /* ARSYSTEM_NOTIFIER */
	  else {
	    cferr = 1;
	  }
	  break;
	}
	
	if (pcinfo.protocol == PC_UNKNOWN) {
	  report (LOG_ERR, "protocol must be set first");
	  cferr = 1;
	  break;
	}
	
#ifdef ARSYSTEM_NOTIFIER
	if (pcinfo.protocol == PC_REMEDY) {
	  
	  if ((c2 = CheckTagField(c, cbuf.len, "server="))) {
	    memcpy(pcinfo.phone, c2, cbuf.len - 7);
	    pcinfo.phone[cbuf.len-7] = 0;
	    break;
	  }
	  
	} /* PC_REMEDY specific */
	
#endif /* ARSYSTEM_NOTIFIER */
	
	if ((pcinfo.protocol == PC_PET1) ||
	    (pcinfo.protocol == PC_PET3)) {
	  
	  if ((c2 = CheckTagField(c, cbuf.len,
				  "phone="))) {
	    memcpy(pcinfo.phone, c2, cbuf.len - 6);
	    pcinfo.phone[cbuf.len-6] = 0;
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "modemInit="))) {
	    memcpy(pcinfo.modemInit, c2, cbuf.len - 10);
	    pcinfo.modemInit[cbuf.len-10] = 0;
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "modemDev="))) {
	    memcpy(pcinfo.modemDev, c2, cbuf.len - 9);
	    pcinfo.modemDev[cbuf.len-9] = 0;
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "modemDial="))) {
	    memcpy(pcinfo.modemDial, c2, cbuf.len - 10);
	    pcinfo.modemDial[cbuf.len-10] = 0;
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "password="))) {
	    memcpy(pcinfo.password, c2, cbuf.len - 9);
	    pcinfo.password[cbuf.len-9] = 0;
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "answerTime="))) {
	    memcpy(tmpstr, c2, cbuf.len - 11);
	    tmpstr[cbuf.len-11] = 0;
	    pcinfo.answerTime = atoi(tmpstr);
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "msgRetries="))) {
	    memcpy(tmpstr, c2, cbuf.len - 11);
	    tmpstr[cbuf.len-11] = 0;
	    pcinfo.msgRetries = atoi(tmpstr);
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "dialer="))) {
	    memcpy(tmpstr, c2, cbuf.len - 7);
	    tmpstr[cbuf.len-7] = 0;
	    if (!strcasecmp(tmpstr, "internal"))
	      pcinfo.dialer = DIALER_INTERNAL;
	    else if (!strcasecmp(tmpstr, "external"))
	      pcinfo.dialer = DIALER_EXTERNAL;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "speed="))) {
	    memcpy(tmpstr, c2, cbuf.len - 6);
	    tmpstr[cbuf.len-6] = 0;
	    if (!strcmp(tmpstr, "B110"))
	      pcinfo.speed = B110;
	    else if (!strcmp(tmpstr, "300"))
	      pcinfo.speed = B300;
	    else if (!strcmp(tmpstr, "1200"))
	      pcinfo.speed = B1200;
	    else if (!strcmp(tmpstr, "2400"))
	      pcinfo.speed = B2400;
	    else if (!strcmp(tmpstr, "4800"))
	      pcinfo.speed = B4800;
	    else if (!strcmp(tmpstr, "9600"))
	      pcinfo.speed = B9600;
	    else if (!strcmp(tmpstr, "19200"))
	      pcinfo.speed = B19200;
	    else if (!strcmp(tmpstr, "38400"))
	      pcinfo.speed = B38400;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "parity="))) {
	    memcpy(tmpstr, c2, cbuf.len - 7);
	    tmpstr[cbuf.len-7] = 0;
	    if (!strcasecmp(tmpstr, "none"))
	      pcinfo.parity = 0;
	    else if (!strcasecmp(tmpstr, "even"))
	      pcinfo.parity = PARENB;
	    else if (!strcasecmp(tmpstr, "odd"))
	      pcinfo.parity = PARENB|PARODD;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "databits="))) {
	    memcpy(tmpstr, c2, cbuf.len - 9);
	    tmpstr[cbuf.len-9] = 0;
	    if (!strcmp(tmpstr, "8"))
	      pcinfo.databits = CS8;
	    else if (!strcmp(tmpstr, "7"))
	      pcinfo.databits = CS7;
	    else if (!strcmp(tmpstr, "6"))
	      pcinfo.databits = CS6;
	    else if (!strcmp(tmpstr, "5"))
	      pcinfo.databits = CS5;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "stopbits="))) {
	    memcpy(tmpstr, c2, cbuf.len - 9);
	    tmpstr[cbuf.len-9] = 0;
	    if (!strcmp(tmpstr, "1"))
	      pcinfo.stopbits = 0;
	    else if (!strcmp(tmpstr, "2"))
	      pcinfo.stopbits = CSTOPB;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "maxTransactions="))) {
	    memcpy(tmpstr, c2, cbuf.len - 16);
	    tmpstr[cbuf.len-16] = 0;
	    pcinfo.maxTransactions = atoi(tmpstr);
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "retryNotify="))) {
	    memcpy(tmpstr, c2, cbuf.len - 12);
	    tmpstr[cbuf.len-12] = 0;
	    pcinfo.retryNotify = atoi(tmpstr);
	    break;
	  }
	  
	} /* PC_PET? specific */
	
	/*
	 * non pc specific options 
	 */
	
	if ((c2 = CheckTagField(c, cbuf.len,
				"trMap="))) {
	  memcpy(pcinfo.trMap, c2, cbuf.len - 6);
	  pcinfo.trMap[cbuf.len-6] = 0;
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "fallBackGateway="))) {
	  memcpy(pcinfo.fallBackGateway, c2, cbuf.len-16);
	  pcinfo.fallBackGateway[cbuf.len-16] = 0;
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "emailReplyTo="))) {
	  memcpy(pcinfo.emailReplyTo, c2, cbuf.len-13);
	  pcinfo.emailReplyTo[cbuf.len-13] = 0;
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "emailFrom="))) {
	  memcpy(pcinfo.emailFrom, c2, cbuf.len-10);
	  pcinfo.emailFrom[cbuf.len-10] = 0;
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "maxMsgSize="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len-11] = 0;
	  pcinfo.maxMsgSize = atoi(tmpstr);
	  break;
	  /* pcinfo.flags bit and pc.mangle - added SK */
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncSender="))) {
	  memcpy(tmpstr, c2, cbuf.len - 13);
	  tmpstr[cbuf.len - 13] = 0;
	  if (!strcasecmp(tmpstr, "yes")) {
	    pcinfo.flags |= PROF_FLAGS_INC_SENDER;
	    pcinfo.pc_set |= PROF_FLAGS_INC_SENDER;
	  }
	  else if (!strcasecmp(tmpstr, "no")) {
	    pcinfo.flags &= ~PROF_FLAGS_INC_SENDER;
	    pcinfo.pc_set |= PROF_FLAGS_INC_SENDER;
	  }
	  else {
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncDate="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  if (!strcasecmp(tmpstr, "yes")) {
	    pcinfo.flags |= PROF_FLAGS_INC_DATE;
	    pcinfo.pc_set |= PROF_FLAGS_INC_DATE;
	  }
	  else if (!strcasecmp(tmpstr, "no")) {
	    pcinfo.flags &= ~PROF_FLAGS_INC_DATE;
	    pcinfo.pc_set |= PROF_FLAGS_INC_DATE;
	  }
	  else {
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncTime="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  if (!strcasecmp(tmpstr, "yes")) {
	    pcinfo.flags |= PROF_FLAGS_INC_TIME;
	    pcinfo.pc_set |= PROF_FLAGS_INC_TIME;
	  }
	  else if (!strcasecmp(tmpstr, "no")) {
	    pcinfo.flags &= ~PROF_FLAGS_INC_TIME;
	    pcinfo.pc_set |= PROF_FLAGS_INC_TIME;
	  }
	  else {
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "mangle="))) {
	  memcpy(tmpstr, c2, cbuf.len - 7);
	  tmpstr[cbuf.len - 7] = 0;
	  if (!strcasecmp(tmpstr, "yes")) {
	    pcinfo.mangle = 1;
	  }
	  else if (!strcasecmp(tmpstr, "no")) {
	    pcinfo.mangle = 0;
	  }
	  else {
	    cferr = 1;
	  }
	  break;
	  /* end pcinfo.flags bit and pc.mangle - added SK */
	} else {
	  cferr = 1; /* not valid option */
	}
	
	break;
	
      } /* switch where */
      
      break; /* CF_PC */
      
    case CF_ALIAS:
      
      switch (where) {
	
      case 1:		/* alias name -- key */
	
	if (!cbuf.len) {
	  cferr = 1;
	  break;
	}
	
	/* initialize profile with active one */
	memcpy(&tProfile, &activeProfile, sizeof tProfile);
	
	if (cbuf.len >= PCINFO_STR_LEN) {
	  report (LOG_ERR, "name >= %d, line %d",
		  (int)PCINFO_STR_LEN, lineno);
	  cferr = 1;
	  break;
	}
	memcpy(tProfile.name, cbuf.buf+cbuf.start, cbuf.len);
	tProfile.name[cbuf.len] = 0;
	
	memcpy(sTmp, cbuf.buf+cbuf.start, cbuf.len);
	sTmp[cbuf.len] = 0;
	
	break;
	
      default:	/* alias values or options */
	
	if (cbuf.len) {
	  
	  /* is this an option (has an =)? */
	  if ((c2 = CheckTagField(c, cbuf.len,
				  "emailReply="))) {
	    memcpy(tmpstr, c2, cbuf.len - 11);
	    tmpstr[cbuf.len - 11] = 0;
	    if (!strcasecmp(tmpstr, "yes"))
	      tProfile.flags |= PROF_FLAGS_MAIL_GOOD;
	    else if (!strcasecmp(tmpstr, "no"))
	      tProfile.flags &= ~PROF_FLAGS_MAIL_GOOD;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "msgIncSender="))) {
	    memcpy(tmpstr, c2, cbuf.len - 13);
	    tmpstr[cbuf.len - 13] = 0;
	    if (!strcasecmp(tmpstr, "yes"))
	      tProfile.flags |= PROF_FLAGS_INC_SENDER;
	    else if (!strcasecmp(tmpstr, "no"))
	      tProfile.flags &= ~PROF_FLAGS_INC_SENDER;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "msgIncDate="))) {
	    memcpy(tmpstr, c2, cbuf.len - 11);
	    tmpstr[cbuf.len - 11] = 0;
	    if (!strcasecmp(tmpstr, "yes"))
	      tProfile.flags |= PROF_FLAGS_INC_DATE;
	    else if (!strcasecmp(tmpstr, "no"))
	      tProfile.flags &= ~PROF_FLAGS_INC_DATE;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "msgIncTime="))) {
	    memcpy(tmpstr, c2, cbuf.len - 11);
	    tmpstr[cbuf.len - 11] = 0;
	    if (!strcasecmp(tmpstr, "yes"))
	      tProfile.flags |= PROF_FLAGS_INC_TIME;
	    else if (!strcasecmp(tmpstr, "no"))
	      tProfile.flags &= ~PROF_FLAGS_INC_TIME;
	    else {
	      cferr = 1;
	    }
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "emailCC="))) {
	    memcpy(tProfile.emailCC, c2, cbuf.len - 8);
	    tProfile.emailCC[cbuf.len - 8] = 0;
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "trMap="))) {
	    memcpy(tProfile.trMap, c2, cbuf.len - 6);
	    tProfile.trMap[cbuf.len - 6] = 0;
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "maxMsgSize="))) {
	    memcpy(tmpstr, c2, cbuf.len - 11);
	    tmpstr[cbuf.len-11] = 0;
	    tProfile.maxMsgSize = atoi(tmpstr);
	    break;
	  } else if ((c2 = CheckTagField(c, cbuf.len,
					 "emailReplyErr="))) {
	    memcpy(tmpstr, c2, cbuf.len - 14);
	    tmpstr[cbuf.len - 14] = 0;
	    if (!strcasecmp(tmpstr, "yes"))
	      tProfile.flags |= PROF_FLAGS_MAIL_BAD;
	    else if (!strcasecmp(tmpstr, "no"))
	      tProfile.flags &= ~PROF_FLAGS_MAIL_BAD;
	    else {
	      cferr = 1;
	    }
	    break;
	    /*
	     * if not an option, then assume it's the
	     * LHS of an alias
	     */
	  } else {
	    
	    if (AddToDynString(&datastring,
			       cbuf.buf+cbuf.start, cbuf.len)) {
	      cferr = 1;
	    }
	  }
	  
	} else { /* !cbuf.len */
	  
	  /* only accept blank line if value defined */
	  if (!datastring.bufused) {
	    cferr = 1;
	  } else {
	    /* reset for next line */
	    type = 0; 
	    
	    ++naliases;
	    
	    /* add null byte to signal last value */
	    if (AddToDynString(&datastring, &nullbyte, 0)) {
	      cferr = 1;
	      break;
	    }
	    
	    
	    dbkey.data = (void*)&sTmp;
	    dbkey.size = strlen(sTmp);
	    dbval.data = datastring.buf;
	    dbval.size = datastring.bufused;
	    if (taliasdb->put(taliasdb, &dbkey, &dbval,
			      (u_int)R_NOOVERWRITE)) {
	      report(LOG_ERR,
		     "db->put() failed - line %d, errno=%d",
		     lineno, errno);
	      cferr = 1;
	      break;
	    } /* if db->put */
	    
	    if (datastring.buf)
	      free (datastring.buf);
	    bzero(&datastring, sizeof datastring);
	    
	    
	    /* create the user profile here too */
	    dbkey.data = (void*)&tProfile.name;
	    dbkey.size = strlen(tProfile.name);
	    dbval.data = (void*)&tProfile;
	    dbval.size = sizeof tProfile;
	    if (tprofdb->put(tprofdb, &dbkey, &dbval,
			     (u_int)R_NOOVERWRITE)) {
	      report(LOG_ERR,
		     "db->put() failed - line %d, errno=%d",
		     lineno, errno);
	      cferr = 1;
	      break;
	    } /* if db->put */
	    
	  } /* else */
	} /* else */
	
	break; /* default */
	
      } /* switch where */
      
      break; /* CF_ALIAS */
      
    case CF_TRMAP:

      switch (where) {
	
      case 1:		/* map name is the key */
	
	if (!cbuf.len) {
	  cferr = 1;
	  break;
	}
	
	if (cbuf.len >= PCINFO_STR_LEN) {
	  report (LOG_ERR, "key >= %d chars, line %d",
		  (int)PCINFO_STR_LEN, lineno);
	  cferr = 1;
	  break;
	}
	
	memcpy(sKey, cbuf.buf+cbuf.start, cbuf.len);
	sKey[cbuf.len] = 0;
	
	trIndex = 0; /* index into map */
	bzero(trMap, sizeof(trMap)); /* start new */
	
	break;
	
      default:	/* trmap values */
	
	if (cbuf.len) {
	  
	  if (cbuf.len >= PCINFO_STR_LEN) {
	    report (LOG_ERR, "data >= %d chars, line %d",
		    (int)PCINFO_STR_LEN, lineno);
	    cferr = 1;
	    break;
	  }
	  
	  if (trIndex >= sizeof (trMap) / sizeof(int)) {
	    report (LOG_ERR, "trMap too big, line %d",
		    lineno);
	    cferr = 1;
	    break;
	  }
	  
	  memcpy(sTmp, cbuf.buf+cbuf.start, cbuf.len);
	  sTmp[cbuf.len] = 0;
	  
	  sscanf(sTmp, "%i", &trMap[trIndex++]);
	  
	} else { /* process end of line */
	  
	  /* reset for next line */
	  type = 0; 
	  
	  dbkey.data = sKey;
	  dbkey.size = strlen(sKey);
	  dbval.data = trMap;
	  dbval.size = sizeof trMap;
	  
	  if (ttrdb->put(ttrdb, &dbkey, &dbval, (u_int)0)) {
	    report(LOG_ERR,
		   "db->put() failed - line %d, errno=%d",
		   lineno, errno);
	    cferr = 1;
	    break;
	  } /* if db->put */
	  
	} /* else */
	
	break; /* default */
	
      } /* switch where */
      
      break; /* CF_TRMAP */
      
    case CF_PROFILE:
      
      switch (where) {
	
      case 1:		/* profile name is the key */
	if (!cbuf.len) {
	  cferr = 1;
	  break;
	}
	
	if (cbuf.len >= PCINFO_STR_LEN) {
	  report (LOG_ERR, "key >= %d chars, line %d",
		  (int)PCINFO_STR_LEN, lineno);
	  cferr = 1;
	  break;
	}
	
	/* initialize profile with default one */
	memcpy(&tProfile, &defaultProfile, sizeof tProfile);
	memcpy(tProfile.name, cbuf.buf+cbuf.start, cbuf.len);
	tProfile.name[cbuf.len] = 0;
	
	break;
	
      default:	/* profile options */
	
	/* check if this line is done */
	if (!cbuf.len) { 
	  
	  /* reset for next line */
	  type = 0; 
	  
	  /* sanity check */
	  /* TODO */
	  
	  dbval.data = (void*)&tProfile;
	  dbval.size = sizeof tProfile;
	  
	  dbkey.data = (void*)tProfile.name;
	  dbkey.size = strlen(tProfile.name);
	  
	  if (tprofdb->put(tprofdb, &dbkey, &dbval,
			   (u_int)R_NOOVERWRITE)) {
	    report(LOG_ERR,
		   "db->put() failed - line %d, errno=%d",
		   lineno, errno);
	    cferr = 1;
	    break;
	  }
	  
	  break;
	}
	
	if ((c2 = CheckTagField(c, cbuf.len, "emailReply="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  if (!strcasecmp(tmpstr, "yes"))
	    tProfile.flags |= PROF_FLAGS_MAIL_GOOD;
	  else if (!strcasecmp(tmpstr, "no"))
	    tProfile.flags &= ~PROF_FLAGS_MAIL_GOOD;
	  else {
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncSender="))) {
	  memcpy(tmpstr, c2, cbuf.len - 13);
	  tmpstr[cbuf.len - 13] = 0;
	  if (!strcasecmp(tmpstr, "yes"))
	    tProfile.flags |= PROF_FLAGS_INC_SENDER;
	  else if (!strcasecmp(tmpstr, "no"))
	    tProfile.flags &= ~PROF_FLAGS_INC_SENDER;
	  else {
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncDate="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  if (!strcasecmp(tmpstr, "yes"))
	    tProfile.flags |= PROF_FLAGS_INC_DATE;
	  else if (!strcasecmp(tmpstr, "no"))
	    tProfile.flags &= ~PROF_FLAGS_INC_DATE;
	  else {
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncTime="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  if (!strcasecmp(tmpstr, "yes"))
	    tProfile.flags |= PROF_FLAGS_INC_TIME;
	  else if (!strcasecmp(tmpstr, "no"))
	    tProfile.flags &= ~PROF_FLAGS_INC_TIME;
	  else {
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "emailCC="))) {
	  memcpy(tProfile.emailCC, c2, cbuf.len - 8);
	  tProfile.emailCC[cbuf.len - 8] = 0;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "trMap="))) {
	  memcpy(tProfile.trMap, c2, cbuf.len - 6);
	  tProfile.trMap[cbuf.len - 6] = 0;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "maxMsgSize="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len-11] = 0;
	  tProfile.maxMsgSize = atoi(tmpstr);
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "emailReplyErr="))) {
	  memcpy(tmpstr, c2, cbuf.len - 14);
	  tmpstr[cbuf.len - 14] = 0;
	  if (!strcasecmp(tmpstr, "yes"))
	    tProfile.flags |= PROF_FLAGS_MAIL_BAD;
	  else if (!strcasecmp(tmpstr, "no"))
	    tProfile.flags &= ~PROF_FLAGS_MAIL_BAD;
	  else {
	    cferr = 1;
	  }
	} else {
	  cferr = 1;
	}
	
	break; /* default */
	
      } /* switch where */
      
      break; /* CF_PROFILE */
      
    case CF_SET:
      
      /* check if this line is done */
      if (cbuf.len) { 
	
	if ((c2 = CheckTagField(c, cbuf.len, "profile="))) {
	  memcpy(sTmp, c2, cbuf.len - 8);
	  sTmp[cbuf.len - 8] = 0;
	  
	  dbkey.data = (void*)&sTmp;
	  dbkey.size = strlen(sTmp);
	  
	  if ((ret = tprofdb->get(tprofdb, &dbkey, &dbval,
				  (u_int)0)) == -1) {
	    report (LOG_ERR, "db->get failed, errno=%d",
		    errno);
	    cferr = 1;
	    break;
	  }
	  
	  if (ret) {
	    report (LOG_ERR, "unknown profile line %d",
		    lineno);
	    cferr = 1;
	    break;
	  }
	  
	  memcpy(&activeProfile, (void*)dbval.data,
		 sizeof (activeProfile));
	  
	} else {
	  cferr = 1;
	}
      } else /* handle eoln */
	type = 0; 
      
      break;
      
      break; /* CF_SET */
      
    case CF_GLOBAL: 
      if (cbuf.len) {
	
	/* is this an option (has an =)? */
	if ((c2 = CheckTagField(c, cbuf.len, "maxMsgSize="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  globalOptions.maxMsgSize = atoi(tmpstr);
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "maxMsgSplit="))) {
	  memcpy(tmpstr, c2, cbuf.len - 12);
	  tmpstr[cbuf.len - 12] = 0;
	  globalOptions.maxMsgSplit = atoi(tmpstr);
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "syslogFacility="))) {
	  memcpy(tmpstr, c2, cbuf.len - 15);
	  tmpstr[cbuf.len - 15] = 0;
	  if (!strcasecmp(tmpstr, "LOG_KERN"))
	    globalOptions.syslogFacility = LOG_KERN;
	  else if (!strcasecmp(tmpstr, "LOG_USER"))
	    globalOptions.syslogFacility = LOG_USER;
	  else if (!strcasecmp(tmpstr, "LOG_MAIL"))
	    globalOptions.syslogFacility = LOG_MAIL;
	  else if (!strcasecmp(tmpstr, "LOG_DAEMON"))
	    globalOptions.syslogFacility = LOG_DAEMON;
	  else if (!strcasecmp(tmpstr, "LOG_AUTH"))
	    globalOptions.syslogFacility = LOG_AUTH;
	  else if (!strcasecmp(tmpstr, "LOG_SYSLOG"))
	    globalOptions.syslogFacility = LOG_SYSLOG;
	  else if (!strcasecmp(tmpstr, "LOG_LPR"))
	    globalOptions.syslogFacility = LOG_LPR;
	  else if (!strcasecmp(tmpstr, "LOG_NEWS"))
	    globalOptions.syslogFacility = LOG_NEWS;
	  else if (!strcasecmp(tmpstr, "LOG_UUCP"))
	    globalOptions.syslogFacility = LOG_UUCP;
	  else if (!strcasecmp(tmpstr, "LOG_CRON"))
	    globalOptions.syslogFacility = LOG_CRON;
	  else if (!strcasecmp(tmpstr, "LOG_LOCAL0"))
	    globalOptions.syslogFacility = LOG_LOCAL0;
	  else if (!strcasecmp(tmpstr, "LOG_LOCAL1"))
	    globalOptions.syslogFacility = LOG_LOCAL1;
	  else if (!strcasecmp(tmpstr, "LOG_LOCAL2"))
	    globalOptions.syslogFacility = LOG_LOCAL2;
	  else if (!strcasecmp(tmpstr, "LOG_LOCAL3"))
	    globalOptions.syslogFacility = LOG_LOCAL3;
	  else if (!strcasecmp(tmpstr, "LOG_LOCAL4"))
	    globalOptions.syslogFacility = LOG_LOCAL4;
	  else if (!strcasecmp(tmpstr, "LOG_LOCAL5"))
	    globalOptions.syslogFacility = LOG_LOCAL5;
	  else if (!strcasecmp(tmpstr, "LOG_LOCAL6"))
	    globalOptions.syslogFacility = LOG_LOCAL6;
	  else if (!strcasecmp(tmpstr, "LOG_LOCAL7"))
	    globalOptions.syslogFacility = LOG_LOCAL7;
	  else {
	    cferr = 1;
	  }
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "timeFormat="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  if (!strcasecmp(tmpstr, "MonthFirst"))
	    globalOptions.flags |= GLOBAL_FLAGS_MONTH_FIRST;
	  else if (!strcasecmp(tmpstr, "DayFirst"))
	    globalOptions.flags &= ~GLOBAL_FLAGS_MONTH_FIRST;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "replyToSender="))) {
	  memcpy(tmpstr, c2, cbuf.len - 14);
	  tmpstr[cbuf.len - 14] = 0;
	  if (!strcasecmp(tmpstr, "yes"))
	    globalOptions.flags |= GLOBAL_FLAGS_SET_REPLYTO;
	  else if (!strcasecmp(tmpstr, "no"))
	    globalOptions.flags &= ~GLOBAL_FLAGS_SET_REPLYTO;
	  else {
	    cferr = 1;
	  }
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "emailFrom="))) {
	  memcpy(globalOptions.emailFrom, c2, cbuf.len - 10);
	  globalOptions.emailFrom[cbuf.len - 10] = 0;
	} else {
	  cferr = 1;
	}
      } else {
	type = 0; /* EOLN */
      }
      break;
      
    case CF_DOPPLE:
      
      switch (where) {
	
      case 1:		/* first field, init the struct */
	
	bzero(&pcinfo, sizeof(pcinfo));
	pcinfo.id = tncentral;
	pcinfo.dialer = DIALER_INTERNAL;
	strcpy(pcinfo.password, "000000");
	strcpy(pcinfo.modemInit, MODEM_INIT);
	strcpy(pcinfo.modemDev, MODEM_DEV);
	strcpy(pcinfo.modemDial, MODEM_DIAL);
	pcinfo.answerTime = 25;
	pcinfo.parity = PARENB;
	pcinfo.speed = B1200;
	pcinfo.databits = CS7;
	pcinfo.protocol = PC_PET1;
	pcinfo.msgRetries = 30;
	pcinfo.maxMsgSize = 0;
	pcinfo.maxTransactions = 0; /* unlimited */
	pcinfo.retryNotify = 2;
	strcpy(pcinfo.trMap, "std");
	strcpy(pcinfo.emailFrom, globalOptions.emailFrom);
	pcinfo.flags = 0;
	pcinfo.pc_set = 0;
	pcinfo.dopple_set = 0;
	pcinfo.mangle = 1;
	pcinfo.pc_alias = 1;
	strcpy(pcinfo.alias_name, "nothingatall");
	
      default: /* handle the option */
	
	/* check if this line is done */
	if (!cbuf.len) { 
	  
	  /* reset for next line */
	  type = 0; 
	  
	  /* sanity check */
	  /* TODO */
	  
	  ++npets;
	  ++tncentral;
	  
	  dbval.data = (void*)&pcinfo;
	  dbval.size = sizeof(struct pcinfo);
	  
	  dbkey.data = (void*)pcinfo.name;
	  dbkey.size = strlen(pcinfo.name);
	  
	  if (tpcdb->put(tpcdb, &dbkey, &dbval,
			 (u_int)R_NOOVERWRITE)) {
	    report(LOG_ERR,
		   "db->put() failed - line %d, errno=%d",
		   lineno, errno);
	    cferr = 1;
	    break;
	  }
	  
	  break;
	}
	
	if ((c2 = CheckTagField(c, cbuf.len, "name="))) {
	  memcpy(pcinfo.name, c2, cbuf.len - 5);
	  pcinfo.name[cbuf.len-5] = 0;
	  break;
	}
	/*report (LOG_ERR, "name=%s", pcinfo.name);*/
	
	if (!pcinfo.name[0]) {
	  report (LOG_ERR, "name must be set first");
	  cferr = 1;
	  break;
	}
	
	if ((c2 = CheckTagField(c, cbuf.len, "alias="))) {
	  memcpy(pcinfo.alias_name, c2, cbuf.len - 6);
	  pcinfo.alias_name[cbuf.len-6] = 0;
	  break;
	}
	/*report (LOG_ERR, "alias=%s", pcinfo.alias_name);*/
	
	if (!pcinfo.alias_name[0]) {
	  report (LOG_ERR, "alias must be set second");
	  cferr = 1;
	  break;
	}
	
	
	/*
	 * non pc specific options 
	 */
	
	if ((c2 = CheckTagField(c, cbuf.len,
				"trMap="))) {
	  memcpy(pcinfo.trMap, c2, cbuf.len - 6);
	  pcinfo.trMap[cbuf.len-6] = 0;
	  pcinfo.dopple_set |= DOPPLE_TRMAP;
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "maxMsgSize="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len-11] = 0;
	  pcinfo.maxMsgSize = atoi(tmpstr);
	  pcinfo.dopple_set |= DOPPLE_MAXMSGSIZE;
	  break;
	  /* pcinfo.flags bit and pc.mangle - added SK */
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncSender="))) {
	  memcpy(tmpstr, c2, cbuf.len - 13);
	  tmpstr[cbuf.len - 13] = 0;
	  if (!strcasecmp(tmpstr, "yes")) {
	    pcinfo.flags |= PROF_FLAGS_INC_SENDER;
	    pcinfo.pc_set |= PROF_FLAGS_INC_SENDER;
	  }
	  else if (!strcasecmp(tmpstr, "no")) {
	    pcinfo.flags &= ~PROF_FLAGS_INC_SENDER;
	    pcinfo.pc_set |= PROF_FLAGS_INC_SENDER;
	  }
	  else {
	    report(LOG_ERR, "msgIncSender must be yes or no");
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncDate="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  if (!strcasecmp(tmpstr, "yes")) {
	    pcinfo.flags |= PROF_FLAGS_INC_DATE;
	    pcinfo.pc_set |= PROF_FLAGS_INC_DATE;
	  }
	  else if (!strcasecmp(tmpstr, "no")) {
	    pcinfo.flags &= ~PROF_FLAGS_INC_DATE;
	    pcinfo.pc_set |= PROF_FLAGS_INC_DATE;
	  }
	  else {
	    report(LOG_ERR, "msgIncDate must be yes or no");
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "msgIncTime="))) {
	  memcpy(tmpstr, c2, cbuf.len - 11);
	  tmpstr[cbuf.len - 11] = 0;
	  if (!strcasecmp(tmpstr, "yes")) {
	    pcinfo.flags |= PROF_FLAGS_INC_TIME;
	    pcinfo.pc_set |= PROF_FLAGS_INC_TIME;
	  }
	  else if (!strcasecmp(tmpstr, "no")) {
	    pcinfo.flags &= ~PROF_FLAGS_INC_TIME;
	    pcinfo.pc_set |= PROF_FLAGS_INC_TIME;
	  }
	  else {
	    report(LOG_ERR, "msgIncTime must be yes or no");
	    cferr = 1;
	  }
	  break;
	} else if ((c2 = CheckTagField(c, cbuf.len,
				       "mangle="))) {
	  memcpy(tmpstr, c2, cbuf.len - 7);
	  tmpstr[cbuf.len - 7] = 0;
	  if (!strcasecmp(tmpstr, "yes")) {
	    pcinfo.mangle = 1;
	    pcinfo.dopple_set |= DOPPLE_MANGLE;
	  }
	  else if (!strcasecmp(tmpstr, "no")) {
	    pcinfo.mangle = 0;
	    pcinfo.dopple_set |= DOPPLE_MANGLE;
	  }
	  else {
	    report(LOG_ERR, "mangle must be yes or no");
	    cferr = 1;
	  }
	  break;
	  /* end pcinfo.flags bit and pc.mangle - added SK */
	} else {
	  report(LOG_ERR, "invalid option to dopple");
	  cferr = 1; /* not valid option */
	}
	
	break;
	
      } /* switch where */
      break;
      /* End CF_DOPPLE */
      
    default:
      report (LOG_ERR, "internal error ReadConfig() switch type");
      break;
      
    } /* switch type */
    
    if (cferr) {
      report (LOG_ERR, "%s: syntax error line %d", fname, lineno);
      break;
    }
    
    /* exit out of this loop on eof */
    if (r == 1)
      break;
    
  } /* while 1 */
  
  err = cferr;
  
  if (!err) {
    report (LOG_INFO, "%.512s: read %d aliases, %d pc", fname, naliases,
	    npets);
    
    /* juggle the database pointers */
    
    /* close the old */
    if (*aliasdb)
      err |= (*aliasdb)->close(*aliasdb);
    if (*pcdb)
      err |= (*pcdb)->close(*pcdb);  
    if (*trdb)
      err |= (*trdb)->close(*trdb);  
    if (*profdb)
      err |= (*profdb)->close(*profdb);  
    
    /* swap in the new datbase pointers */
    *aliasdb = taliasdb;
    *pcdb = tpcdb; 
    *trdb = ttrdb;
    *profdb = tprofdb;
    
    /* swap in the new ncentral */
    *ncentral = tncentral;
    
  } 
  
  
ReadConfigout:

  if (err) {
    if (taliasdb)
      err |= taliasdb->close(taliasdb);
    if (tpcdb)
      err |= tpcdb->close(tpcdb);
    if (ttrdb) 
      err |= ttrdb->close(ttrdb);
    if (tprofdb) 
      err |= tprofdb->close(tprofdb);
    
  } /* err */

  if (fd != -1)
    err |= close(fd);
  
  if (datastring.buf)
    free (datastring.buf);
  
  if (keystring.buf)
    free (keystring.buf);
  
  return err;  
  
} /* ReadConfig */

/*********************************************************************
 * Function: GetNextField
 *
 *	returns next field (non whitespace separated by whitespace, 
 *
 * Returns: 0	good	lineno reflects the current line in the input.
 *			cbuf.buf+cbuf.start points to the start of the
 *			field, cbuf.len is the length of the field, and
 *			cbuf.end points to the end cbuf.eof and cbuf.bufused
 *			are used internally.
 *	   -1	error	
 *	    1	got eol with blank field.  lineno updated.
 *
 *	cbuf should be bzero()'d for the initial call.
 *
 *	fields need to be less that CBUF_BYTES chars long, or
 *	will return error condition.
 *
 *	fields with the first non white space being # are returned
 *	as blank lines (buffer is flushed till eoln)
 *
 *	\ can be used to quote characters.  Quoting \n ignores it.
 *
 *	" can be used to allow spaces to be returned in a field.  The
 *	trailing " is not required.  ie "This is a test" or
 *	This" "is" "a" "test are returned the same.
 *
 *	no error reporting is done.
 *
 *********************************************************************/
int GetNextField(int fd, struct cbuf *cbuf, int *lineno) {
  int n, eof, x, eol, comment, start,  escaped, inquote, len;
  int end, incomment, starto, startb, need_read;
  unsigned char c;
  
  end = 0;		/* not done */
  eol = 0;		/* not eol */
  start = 0;		/* got start */
  len = 0;		/* length of field */
  comment = 0;	        /* in comment? */
  escaped = 0;	        /* got the escape char */
  incomment = 0;	/* in comment */
  starto = 0;		/* start offset */
  startb = 0;		/* compare ofset */
  need_read = 0;	/* need to do a read()? */
  eof = cbuf->eof;      /* remember from last time */
  inquote = 0;	        /* in " " */
  
  /* move unused portion of buffer (left over from previous call)
     to index 0 of the buffer.  end = start = 0 == no field found
     in buffer */
  
  if (cbuf->end) {
    memcpy(cbuf->buf, cbuf->buf+cbuf->end, cbuf->bufused - cbuf->end);
    cbuf->bufused -= cbuf->end;
    cbuf->start = cbuf->end = 0;
  } else
    cbuf->start = cbuf->bufused = 0;
  
  while (1) {
    
    /* only perform a read() if needed */
    if (((need_read) || (!cbuf->bufused)) && (!eof)) {
      
      if ((n = read(fd, cbuf->buf+cbuf->bufused, CBUF_BYTES - 
		    cbuf->bufused)) == -1) 
	return -1; /* bad */
      
      /* set EOF condition (don't try to read anymore) if bytes
	 requested is != bytes returned */
      
      if (n != (CBUF_BYTES - cbuf->bufused))
	eof = 1;
    } else
      n = 0;
    
    /* at this point, n is bytes read */
    
    cbuf->bufused += n;
    
    for (x = startb; x < cbuf->bufused; ++x) {
      
      
      c = cbuf->buf[x];
      
      
      /*
	# character before any non white space marks comment lines
      */

      if ((!escaped) && (!start) && (!inquote) && (c == '#')) {
	incomment = 1;
	continue;
      }
      
      /*
	ignore everything to eol when in comment 
	return it like it's just a eol
      */
      
      if (incomment) {
	if (c == '\n')  {
	  incomment = 0; 
	  
	  eol = 1;
	  
	  /*
	   * end must be set so to be able to preserve anything
	   * that's left after the eol.  If nothing has been
	   * read yet, then there's nothing to preserve
	   */
	  
	  if ((x+1) < cbuf->bufused)
	    end = x + 1;
	  
	  break;
	  
	}
	
	continue;
      }
      
      /*
       * process escaped -- \? characters
       */
      
      if (escaped) {
	
	escaped = 0; /* not in escape mode anymore */
	
	/* an escaped \n means just ignore it */
	if (c == '\n') {
	  
	  /* if there's anything left after the \n char, copy it */
	  if (x < cbuf->bufused)
	    memcpy(cbuf->buf+x, cbuf->buf+x+1, cbuf->bufused - x);
	  
	  /* there's 1 less character in the buffer */
	  cbuf->bufused -= 1;
	  x -= 1;
	  
	  /* To decrease confusion, increment
	   * number of lines even on escaped
	   * newline.  Not yet right, but
	   * closer. */
	  ++*lineno;
	  
	  continue;
	}
	
	/* anything else escaped is taken as is.  ie. \u == u */
	
	/* count this in the length of the field */
	++len;
	
	continue;
      }
      
      /*
       * test for and remove escape character
       */

      if (c == '\\') {
	
	escaped = 1; /* set flag */
	
	/* if there's anything left after the \ char, copy it over */
	if (x < cbuf->bufused)
	  memcpy(cbuf->buf+x, cbuf->buf+x+1, cbuf->bufused - x);

	/* there's 1 less character in the buffer */
	cbuf->bufused -= 1;
	x -= 1;

	continue;
	
      }
      
      /*
       * test for and remove quote character
       */
      
      if (c == '"') {

	inquote = (inquote)?0:1;
	
	/* if there's anything left after the \ char, copy it over */
	if (x < cbuf->bufused)
	  memcpy(cbuf->buf+x, cbuf->buf+x+1, cbuf->bufused - x);
	
	/* there's 1 less character in the buffer */
	cbuf->bufused -= 1;
	x -= 1;
	
	continue;
      }
      
      
      /*
       * test for eol
       */
      if (c == '\n') {

	eol = 1;
	
	/* if in a field, this is the last char */
	/* or where to overwrite next call */
	if (start)
	  end = x;
	
        /* else the last char is the next one */
	else if ((x+1) < cbuf->bufused)
	  end = x + 1;
	
	break;
	
      }
      
      /*
       * skip whitespace, but it also terminates a field
       * consider null whitespace
       */

      if ((!inquote) && ((c == ' ') || (c == '\t') || (!c))) {
	if (start) {
	  end = x;
	  break;
	}
	continue;
      }
      
      if (!start) {
	start = 1;
	starto = x;
      }
      
      /* increment length of field var */
      ++len;
      
    } /* for x */
    
    /* a field has been successfully read if either
       1) eol was hit (maybe be an empty field)
       2) eof was hit (maybe be an empty field)
       3) a field started, and ended */
    
    
    /* check for field overflow condition */
    if (len+1 > CBUF_BYTES)
      return -1;
    
    /* increment line counter */
    if (eol)
      ++*lineno;
    
    if (eol || end || eof)
      break;
    
    /* at this point, the field has not ended for any reason, and
       eof has not been hit.  Need to request more data */
    need_read = 1;
    
    /* if there is something to preserve, then do it */
    if (starto) 
      memcpy(cbuf->buf, cbuf->buf+starto, len);
    
    cbuf->bufused = len;
    startb = len;
    starto = 0;
    
  } /* while 1 */

  cbuf->start = starto;
  cbuf->end = end;
  cbuf->len = len;
  cbuf->eof = eof;
  
  if ((!end) && eof)
    return 1;
  
  return 0; /* good */
} /* GetNextField */

/*********************************************************************
 * Function: AddToDynString
 *	adds a string (p) of length (len) to the dynamic string (str)
 *	then null terminates it.
 *
 * Returns: 0	good	the string was added
 *	   !0	bad
 *
 *	a dynstring is just an array of bytes that can grow dynamically.
 *
 *	The initial call should use a bzero()'d str
 *	The caller is responsible for free()ing the storage allocated.
 *
 *	errors are reported via report()
 *
 *********************************************************************/
int AddToDynString(struct dynstring *str, char *p, int len) {
  char *tmpp;

  while (1) {
    /* allocate length + null byte bytes ?? */
    if ((len + 1 + str->bufused) > (str->nblocks * ADD_STR_BLOCKSIZE)) {
      /* allocate more */
      if (!str->nblocks) {
	if (!(str->buf = (char*) malloc((unsigned)(++str->nblocks *
						   ADD_STR_BLOCKSIZE)))) {
	  report (LOG_ERR, "AddToDynString() can't malloc()");
	  return -1; /* bad */
	}
      } else {
	tmpp = str->buf;
	if (!(str->buf = (char*) realloc(str->buf, (unsigned)
					 (++str->nblocks * ADD_STR_BLOCKSIZE)))) {
	  str->buf = tmpp; /* realloc null'd it */
	  report (LOG_ERR, "AddToDynString() can't realloc()");
	  if (str->buf)
	    free (str->buf);
	  str->buf = (char*)NULL;
	  return -1; /* bad */
	}
      } /* else */
    } else 
      break; /* done allocating */
  } /* while 1 */
  
  memcpy(str->buf+str->bufused, p, len);
  str->buf[str->bufused+len] = 0; /* null terminate it */
  str->bufused += len +1;
  
  return 0; /* good */
} /* AddToDynString */


/*********************************************************************
 * Function: AliasExpand
 *	recursively expands an alias in key
 *
 * Returns: struct dystring.
 *		if retlist.bufused == -1, then error condition was found.
 *
 *	The caller is responsible for free()'ing the storage allocated
 *	to dynstring.
 *
 *	If the alias doesn't expand, the returned retlist has retlist.bufused
 *	set to 0, and no storage was allocated.
 *
 *	Will only recurse up to MAX_ALIAS_RECURSE_DEPTH before returning error.
 *
 *	The alias list is terminated with a null string.
 *
 *	The value passed in key may be munged.
 *
 *	aliases can either be
 *	xxx	yyy		 : AliasExpand(xxx) returns "yyy"
 *	xxx	yyy	zzz	 : AliasExpand(xxx) returns "yyy zzz"
 * 
 *	xxx	/etc/yyy	 : AliasExpand(xxx) returns contents
 *                                 of file /etc/yyy 
 *	xxx	/etc/yyy:z	 : AliasExpand(xxx) returns contents 
 *                                 of file /etc/yyy, but if file couldn't be 
 *                                 read or parsed, return "z"
 *	xxx |/etc/yyy	         : AliasExpand(xxx) returns output of program
 *                                 /etc/yyy
 *	xxx |/etc/yyy:z	         : AliasExpand(xxx) returns output of program
 *                                 /etc/yyy, but if program couldn't be run or
 *                                 no output, return "z"
 *
 *	errors are reported via report()
 *
 *********************************************************************/
struct dynstring AliasExpand(DB *aliasdb, DBT key) {
  struct dynstring tmplist, retlist, tmplist2;
  DBT val, tmpkey;
  int ret, len;
  char *p, *q, nullbyte, *tmpd;
  extern int alias_recurse_depth;
  
  if (++alias_recurse_depth > MAX_ALIAS_RECURSE_DEPTH) {
    report (LOG_ERR, "ExpandAlias() nested too deep (%d)",
	    alias_recurse_depth);
    retlist.bufused = -1; /* caller knows it failed */
    --alias_recurse_depth;
    return retlist;
  }
  
  bzero(&retlist, sizeof(retlist));
  bzero(&tmplist, sizeof(tmplist));
  bzero(&tmplist2, sizeof(tmplist2));
  tmpd = (char*)NULL;
  nullbyte = 0;
  
  /* if this is the first level of recursion, skip the special file
     and pipe lookups (the data for these is expected to be null
     terminated anyways, which it's not from the first call)
  */
  if (alias_recurse_depth == 1)
    goto skipspecial;
  
  
  p = key.data;
  
  /*
   * if the alias begins with a /, then this is a file lookup 
   * else, if it begins with a |, this is a program lookup
   */
  
  if (*p == '/') {
    
    /*
     * key.data is not null terminated, which is required to make
     *	a pathname.  malloc() a copy.
     */
    
    if (!(tmpd = (char*)malloc((int)key.size+1))) {
      report (LOG_ERR, "malloc %d failed", (int)key.size);
      retlist.bufused = -1; /* signal error to caller */
      return retlist;
    }
    
    memcpy((char*)tmpd, (char*)key.data, (int)key.size);
    p = tmpd;
    *(p+key.size) = 0; 
    
    /* see if there is a default (ends in :default) */
    for (q = p; *q && (*q != ':'); ++q);
    
    if (*q == ':') 
      *q++ = 0;	 /* separate file and defalias */
    else
      q = (char*)NULL;
    
    /* p == pathname, q == default alias */
    tmplist2 = ReadAliasByFile(p, q);
		
    /* tmp copy was only needed for above call */
    if (tmpd)
      free (tmpd);
    
    /* tmplist2 will either have something in it, or be an error --
       either way, it's right for the caller */
    
    /* if error, or no expansion return the list -- it won't expand 
       further */
    if ((!tmplist2.bufused) || (tmplist2.bufused == -1) ||
	(tmplist2.bufused == -2)) 
      return tmplist2;
    
    p = tmplist2.buf;
    goto listexp1;
    
    
    /* by file */
    
  } else if (*p == '|') { 
    
    
    /*
     * key.data is not null terminated, which is required to make
     *	a pathname.  malloc() a copy.
     */
    
    if (!(tmpd = (char*)malloc((int)key.size+1))) {
      report (LOG_ERR, "malloc %d failed", (int)key.size);
      retlist.bufused = -1; /* signal error to caller */
      return retlist;
    }
    
    memcpy((char*)tmpd, (char*)key.data, (int)key.size);
    p = tmpd;
    *(p+key.size) = 0; 

    ++p; /* don't pass the | */
    
    /* see if there is a default (ends in :default) */
    for (q = p; *q && (*q != ':'); ++q);
    
    if (*q == ':') 
      *q++ = 0;	 /* separate file and defalias */
    else
      q = (char*)NULL;
    
    /* p == pathname, q == default alias */
    tmplist2 = ReadAliasByProgram(p, q);
    
    /* tmp copy was only needed for above call */
    if (tmpd)
      free (tmpd);
    
    /* tmplist2 will either have something in it, or be an error --
       either way, it's right for the caller */
    
    /* if error, or no expansion return the list -- it won't expand 
       further */
    if ((!tmplist2.bufused) || (tmplist2.bufused == -1) ||
	(tmplist2.bufused == -2)) 
      return tmplist2;
    
    p = tmplist2.buf;
    goto listexp1;
    
    
  } /* by program */
  
  

skipspecial:

  /* try a database lookup, if this fails, return 0 byte list - ie
     the alias didn't expand */
  
  if ((ret = aliasdb->get(aliasdb, &key, &val, (u_int)0)) == -1) {
    report (LOG_ERR, "ExpandAlias() db->get failed, errno=%d", errno);
    retlist.bufused = -1; /* caller knows it failed */
    --alias_recurse_depth;
    return retlist;
  }
  
  /* lookup failed? */
  if (ret == 1) {
    --alias_recurse_depth;
    return retlist; /* nothing */
  }
  
  /* p points to the first entry in the list, each entry is separated
     by a null byte, with the last entry being a null string itself */
  p = val.data;
  
listexp1:

  /* foreach entry in the list, try to expand it. */
  while (1) {
    if (!(len = strlen(p))) /* list is terminated with null string */
      break;
    
    tmpkey.data = p;
    tmpkey.size = len;
    
    tmplist = AliasExpand(aliasdb, tmpkey);
    
    /*
     * if it didn't expand, but there was a non fatal error then
     *	return an empty list -- ie program alias fails
     */
    if (tmplist.bufused == -2) {
      if (tmplist2.buf)
	free (tmplist2.buf);
      return retlist;
      /* if it didn't expand, add p to the return list */
    } else if (!tmplist.bufused) {
      if (AddToDynString(&retlist, p, len)) {
	retlist.bufused = -1; /* caller knows it failed */
	--alias_recurse_depth;
      }
    } else if (tmplist.bufused == -1) { /* call failed */
      retlist.bufused = -1;
      --alias_recurse_depth;
      if (tmplist2.buf);
      free (tmplist2.buf);
      return retlist; /* caller knows it failed, propogate up */
    } else { /* call returned a list, add all but the trailing null
		and the end of list marker (second null)  */
      if (AddToDynString(&retlist, tmplist.buf, tmplist.bufused-2)) {
	retlist.bufused = -1; /* caller knows it failed */
	--alias_recurse_depth;
	if (tmplist2.buf)
	  free (tmplist2.buf);
	if (tmplist.buf)
	  free (tmplist.buf);
	return retlist;
      } /* if */
    } /* else */
    
    /* on to the next entry in the list */
    p += len+1;
    
  } /* while 1 */
  
  /* caller needs to free the space allocated by AliasExpand */
  /* ...and we were a caller */
  if (tmplist.buf)
    free (tmplist.buf);
  if (tmplist2.buf)
    free (tmplist2.buf);
  
  /* add trailing null byte - end of list marker if anything expanded */
  if (retlist.bufused) 
    if (AddToDynString(&retlist, &nullbyte, 0)) {
      retlist.bufused = -1;
      --alias_recurse_depth;
      return retlist;
    }
  
  --alias_recurse_depth;
  return retlist;
} /* AliasExpand */

/*********************************************************************
 * Function: ReadAliasByFile
 *	implements the file reading code for AliasExpand()
 *
 * Returns: struct dystring.
 *		if retlist.bufused == -1, then error condition was found.
 *
 *	The caller is responsible for free()'ing the storage allocated
 *	to dynstring.
 *
 *	if the file can't be read, or there are no valid alias fields in it,
 *	the retlist will contain the single element pointed to by defalias.
 *	if defalias is null, no storage will be allocated - retlist.bufused
 *	will be 0.
 *
 *	errors are reported via report()
 *********************************************************************/
struct dynstring ReadAliasByFile(char *fname, char *defalias) {
  struct dynstring retlist;
  struct cbuf cbuf;
  int fd, err, ret, lineno;
  char nullbyte;
  
  err = 1; /* bad */
  fd = -1; /* not opened */
  bzero(&retlist, sizeof(retlist));
  bzero(&cbuf, sizeof(cbuf));
  nullbyte = 0;
  
  /* open the file */
  if ((fd = open(fname, O_RDONLY, 0)) == -1) {
    report (LOG_ERR, "open (%.512s): %s", fname, strerror(errno));
    goto ReadAliasByFileout;
  }

  while (1) {
    
    if ((ret = GetNextField(fd, &cbuf, &lineno)) == -1) {
      report (LOG_ERR, "GetNextField() returned error condition");
      goto ReadAliasByFileout;
    }
    
    if (cbuf.len)
      if (AddToDynString(&retlist, cbuf.buf+cbuf.start, cbuf.len))
	goto ReadAliasByFileout;
    
    /* done on eof */
    if (ret == 1)
      break;
  }
  
  err = 0; /* good */
  
ReadAliasByFileout:

  if (err) {
    if (retlist.buf) {
      free (retlist.buf);
      retlist.buf = (char*)NULL;
    }
  }
  
  /* if error condition was set or empty file, try using the default */
  if ((err || (!retlist.bufused)) && defalias) {
    if (AddToDynString(&retlist, defalias, strlen(defalias))) {
      if (retlist.bufused) {
	free (retlist.buf);
	retlist.buf = (char*)NULL;
      }
      err = 1;
    } else {
      err = 0;
    }
  }
  
  /* add trailing null string */
  if (!err && retlist.bufused) 
    if (AddToDynString(&retlist, &nullbyte, 0)) {
      free (retlist.buf);
      retlist.buf = (char*)NULL;
      err = 1;
    }
  
  if (err)
    retlist.bufused = -2;
  
  if (fd != -1)
    close(fd);
  
  return retlist;
  
} /* ReadAliasByFile */

/*********************************************************************
 * Function: CheckTagField
 *
 * Returns: pointer to data portion of tag (tag=data), or if tag
 *	doesn't match or length error (char*)0L;
 *			
 *********************************************************************/
char *CheckTagField(char *buf, int len, char *tag) {
  int n;

  n = strlen(tag);

  /* if the length of the buffer is less than the length of the
     tag field then can't possibly match */
  
  if (len < n)
    return (char*)0L;
  
  /* check for a match */
  if (strncasecmp(buf, tag, n))
    return (char*)0L;
  
  /* got match, make sure length of data is okay */
  
  if ((len - n + 1) > PCINFO_STR_LEN)
    return (char*)0L;
  
  return buf+n;
} /* CheckTagField */

/*********************************************************************
 * Function: ReadAliasByProgram
 *	implements the program/pipe reading code for AliasExpand()
 *
 * Returns: struct dystring.
 *		if retlist.bufused == -1, then error condition was found.
 *
 *	The caller is responsible for free()'ing the storage allocated
 *	to dynstring.
 *
 *	If the program can't be opened, or there is no output, or
 *	there is no output in PIPE_READ_SECONDS then the default
 *	alias (if non null) is returned.
 *
 *	the program argument may be munged.
 *
 *	errors are reported via report()
 *********************************************************************/
struct dynstring ReadAliasByProgram(char *program, char *defalias) {
  struct dynstring retlist;
  struct cbuf cbuf;
  int err, ret, lineno;
  char nullbyte;
  int pipefd[2], statloc;
  pid_t pid;
  char *pgm, *arg, *p;
  extern char *sendpage_env[];
  
  err = 1; /* bad */
  bzero(&retlist, sizeof(retlist));
  bzero(&cbuf, sizeof(cbuf));
  nullbyte = 0;
  pipefd[0] = pipefd[1] = -1;
  
  arg = (char*)0L;

  /*
   * the program string can also contain a single argument
   */

  for (p = program; *p; ++p)
    if (*p == ' ') 
      *p = 0, arg = p+1;
  
  /* program name is the last path element */
  if ((pgm = strrchr(program, '/')))
    ++pgm;
  else
    pgm = program;
  
  if (pipe(pipefd) == -1) {
    report (LOG_ERR, "ReadAliasByProgram: pipe(): %s", strerror(errno));
    goto ReadAliasByProgramout;
  }
  
  if ((pid = fork()) == -1) {
    report (LOG_ERR, "ReadAliasByProgram: fork(): %s", strerror(errno));
    goto ReadAliasByProgramout;
  }
  
  if (pid) { /* parent */
    
    /* close write end */
    if (close (pipefd[1])) {
      report (LOG_ERR, "ReadAliasByProgram: close(): %s",
	      strerror(errno));
      goto skip1;
    }
    
    pipefd[1] = -1;
    
    while (1) {
      
      if ((ret = GetNextField(pipefd[0], &cbuf, &lineno)) == -1) {
	report (LOG_ERR, "GetNextField() returned error condition");
	goto skip1;
      }
      
      if (cbuf.len)
	if (AddToDynString(&retlist, cbuf.buf+cbuf.start, cbuf.len))
	  goto skip1;
      
      /* done on eof */
      if (ret == 1)
	break;
    }
    
    err = 0; /* good */
    
skip1:
    /* no zombies */
    statloc = 0;
    if (waitpid(pid, &statloc, 0) == -1)
      report (LOG_ERR, "waitpid(): %s", strerror(errno));
    
    /* expect exit status 0 */
    if (statloc) {
      report (LOG_WARNING,
	      "%.512s exited with status %d", program, statloc);
      err = 1;
      goto ReadAliasByProgramout;
    }
    
    
  } /* parent */ else {
    
    /* child */
    
    if (close(pipefd[0])) {
      report (LOG_ERR, "child: pipe read close(): %s", strerror(errno));
      exit (1);
    }
    
    /* pipe becomes stdout */
    if (dup2(pipefd[1], STDOUT_FILENO) != STDOUT_FILENO) {
      report (LOG_ERR, "child: dup2() to stdout failed");
      exit (1);
    }
    
    if (close (pipefd[1])) {
      report (LOG_ERR, "child: pipe write close(): %s", strerror(errno));
      exit (1);
    }
    
    /* invoke external program */
    if (arg)
      ret = execle(program, pgm, arg, (char*)0L, sendpage_env);
    else
      ret = execle(program, pgm, (char*)0L, sendpage_env); 
    if (ret == -1) {
      report (LOG_ERR,
	      "child: execl() %.512s: %s", program, strerror(errno));
      exit (1);
    }
    
  } /* child */
  
  
ReadAliasByProgramout:
  if (err) {
    if (retlist.buf) {
      free (retlist.buf);
      retlist.buf = (char*)NULL;
    }
  }
  
  /* if error condition was set or empty file, try using the default */
  if ((err || (!retlist.bufused)) && defalias) {
    if (AddToDynString(&retlist, defalias, strlen(defalias))) {
      if (retlist.bufused) {
	free (retlist.buf);
	retlist.buf = (char*)NULL;
      }
      err = 1;
    } else {
      err = 0;
    }
  }
  
  /* add trailing null string */
  if (!err && retlist.bufused) 
    if (AddToDynString(&retlist, &nullbyte, 0)) {
      free (retlist.buf);
      retlist.buf = (char*)NULL;
      err = 1;
    }
  
  if (err)
    retlist.bufused = -2;
  
  if (pipefd[0] != -1)
    err |= close(pipefd[0]);
  
  if (pipefd[1] != -1)
    err |= close(pipefd[1]);
  
  return retlist;
} /* ReadAliasByProgram */
