#ifndef _GET_SID_LIST_H
#define _GET_SID_LIST_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ss.h>
#include <linux/flask/flask_types.h>
#include <proc_secure.h>
#include <context.h>
#include <errno.h>

#define _DEFCONTEXT_PATH "/etc/security/default_contexts"
#define BUF_SIZE 1000
#define MAX_CONFIG_SIDS 100

extern int find_line (FILE *infile, security_id_t current_sid, char *line, 
                      int length);
extern int list_from_string (char *instr, char *user, security_id_t *pri_list, 
                             int pri_length);
extern int get_current_part_context (security_id_t current_sid, char **part_context, 
                                     int *part_len);
extern int get_ordered_sid_list (char *user_name, security_id_t from_sid,
                                 security_id_t *ordered_list, int *length);
extern int get_config_priority (security_id_t from_sid, char *username, 
                                security_id_t *pri_list, int pri_length, int which);
extern int get_ordered_sid_list (char *user_name, security_id_t from_sid, 
                                 security_id_t *ordered_list, int *length);
extern int insert (security_id_t *ordered_list, int length, int pos, 
                   security_id_t newitem);
extern int add_priority_list (security_id_t *ordered_list, security_id_t *total_list,
                              int *bitmap, int length, security_id_t *pri_list,
                              int pri_length, int *pos);
extern int locate (security_id_t *list, int list_len, security_id_t element);
extern int complete_ordered_list (security_id_t *ordered_list, int *pos,
                                  security_id_t *init_list, int *bitmap, int length);
extern int get_context_list (FILE *infile, security_id_t current_sid, char *user_name,
                             security_id_t *pri_list, int pri_length);
extern int query_user_sid (security_id_t *ordered_sid_list, int length,
                            security_id_t *user_sid);
extern int sid_menu (security_id_t *ordered_sid_list, int length);
extern int manual_user_enter (char *user, security_id_t *user_sid);

#endif
