#include "pdflib.h"
#include "seaview.h"
#include <time.h>
#include <ctype.h>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Check_Button.H>

extern int printout_block, printout_fontsize, printout_black, printout_vary;
extern paperformat printout_pageformat;


int pdf_printout(SEA_VIEW *view, const char *filename, 
	int fontsize, int block_size, paperformat pageformat, int vary_only, int ref0, int blackonly);
static void color_pdf_display(PDF *pdf, SEA_VIEW *view, int (*calc_color_function)( int ), char *oneline, 
	int widnames, double x, double y, int fontsize, double char_width, double descender);
static int calc_vary_lines(int *vary_pos, int widpos);
static void out_vary_pos(int *vary_pos, int widnames, int widpos, int nl, PDF *pdf);


int pdf_printout(SEA_VIEW *view, const char *filename, 
	int fontsize, int block_size, paperformat pageformat, int vary_only, int ref0, int blackonly)
{
int num, i, j, k, current, max_seq_length, fin, curr_lines, widnames, 
	res_per_line, nl, firstpage, lines_per_page;
time_t heure;
static char unnamed[] = "<unnamed>";
static char num_line[200];
int lettre, char_per_line;
short *vary_need = NULL;
int *vary_pos; /* rang ds alignement de la colonne imprime */
char oneline[500];
int (*calc_color_function)(int);
PDF *pdf;
double	char_width, width, height, descender, margin = 25;
char	*fontname, *encoding;
int		font;

    fontname	= "Courier";
#ifdef __APPLE__
    encoding	= "macroman";
#else
    encoding	= "iso8859-1";
#endif
if(view->tot_seqs == 0) return 0;
if(view->protein) calc_color_function = get_color_for_aa;
else  calc_color_function = get_color_for_base;
if(pageformat == A4) { width = a4_width; height = a4_height; }
else /* LETTER */ { width = letter_width; height = letter_height; }
lines_per_page = (int)((height - 2*margin) / fontsize + 0.5);

pdf = PDF_new();
if(pdf == NULL) return TRUE;

if( PDF_begin_document(pdf, filename, 0, "compatibility=1.3") == -1) {
	PDF_delete(pdf);
	return TRUE;
	}

PDF_TRY(pdf) {

PDF_set_info(pdf, "Title", PREPARE_LABEL(view->masename) );
PDF_set_info(pdf, "Creator", "seaview");
font = PDF_load_font(pdf, fontname, 0, encoding, "");
char_width = PDF_stringwidth(pdf, "X", font, (double)fontsize);
char_per_line = (int)((width - 2*margin) / char_width + 0.5);
descender = PDF_get_value(pdf, "descender", font) * fontsize;

PDF_begin_page_ext(pdf, width, height, "");
PDF_setfont(pdf, font, (double)fontsize);
PDF_set_text_pos(pdf, margin, height - margin);
firstpage = TRUE;

if(ref0 < 0) vary_only = FALSE;
time(&heure);
sprintf(oneline,"Alignment: %s", view->masename == NULL ? unnamed : PREPARE_LABEL(view->masename) );
PDF_continue_text(pdf, oneline);
curr_lines = 1;
if(vary_only) {
	PDF_continue_text(pdf, "Displaying variable sites only.");
	++curr_lines;
	}
sprintf(oneline,"Seaview [blocks=%d fontsize=%d %s] on %s",
		block_size, fontsize, pageformat == A4 ? "A4" : "LETTER", ctime(&heure));
PDF_continue_text(pdf, oneline);
PDF_continue_text(pdf, "");
curr_lines += 2;
max_seq_length = 0; widnames = 0;
for(i=0; i < view->tot_seqs; i++) {
	if(view->each_length[i] > max_seq_length) max_seq_length = view->each_length[i];
	if( ( fin=strlen(view->seqname[i]) ) > widnames) widnames = fin;
	}
widnames += 2;
if(vary_only) {
	vary_need = (short *)calloc(max_seq_length, sizeof(short));
	if(vary_need == NULL) return TRUE;
	vary_pos = (int *)calloc(char_per_line, sizeof(int));
	if(vary_pos == NULL) return TRUE;
	for(i = 0; i < max_seq_length; i++) {
		for(num = 0; num < view->tot_seqs; num++) {
			if( toupper(view->sequence[num][i]) != toupper(view->sequence[ref0][i]) ) { 
				vary_need[i] = TRUE;
				break;
				}
			}
		}
	}
/* nombre max de blocks qui tiennent sur une ligne de cpl chars */
fin = (char_per_line - widnames + 1) / (block_size + 1);
if(fin < 1) { /* garde fou */
	fin = 1; block_size = char_per_line - widnames;
	}
res_per_line = fin * block_size;
current = 0; 
while( current < max_seq_length ) {
	nl = 1;
	if(vary_only) { 
		memset(vary_pos, 0, res_per_line * sizeof(int) );
		i = -1; j = 0; k = 0;
		while( j < res_per_line) {
			if(current + i >= max_seq_length) break;
			if( !vary_need[current + ++i] ) continue;
			j++;
			vary_pos[k++] = current + i + 1;
			if( j % block_size == 0) k++;
			}
		nl = calc_vary_lines(vary_pos,  k);
		}
	if( (!firstpage) && curr_lines + view->tot_seqs + nl > lines_per_page) {
		PDF_end_page_ext(pdf, "");
		PDF_begin_page_ext(pdf, width, height, "");
		PDF_setfont(pdf, font, (double)fontsize);
		PDF_set_text_pos(pdf, margin, height - margin);
		curr_lines = 0;
		}
	if(vary_only) {
		out_vary_pos(vary_pos, widnames, k, nl, pdf);
		curr_lines += nl;
		}
	else	{
		sprintf(num_line, "%d", current + 1);
		fin = strlen(num_line);
		memmove(num_line + widnames - fin + 1, num_line, fin+1);
		if(fin <= widnames) memset(num_line, ' ', widnames - fin + 1);
		PDF_continue_text(pdf, num_line);
		++curr_lines;
		}
	for(num=0; num < view->tot_seqs; num++) {
		k = 0;
		for(j = 0; j < widnames; j++) {
			if(view->seqname[num][j] == 0) break;
			oneline[k++] = view->seqname[num][j];
			}
		while( j < widnames) {
			j++;
			oneline[k++] = ' ';
			}
		if(vary_only) {
			i = -1; j = 0;
			while( j < res_per_line) {
				if(current + i >= max_seq_length) break;
				if( !vary_need[current + ++i] ) continue;
				j++;
				if(current + i < view->each_length[num]) {
					if(num != ref0) lettre = ( toupper(view->sequence[num][current+i]) == 
						toupper(view->sequence[ref0][current+i]) ? '.' : view->sequence[num][current+i] );
					else lettre = view->sequence[ref0][current+i];
					oneline[k++] = lettre;
					}
				if( j % block_size == 0) oneline[k++] = ' ';
				}
			if(num == view->tot_seqs - 1) current = current + i + 1;
			}

		else	{
			fin = res_per_line;
			if(current+fin > view->each_length[num]) 
				fin = view->each_length[num] - current;
			if(ref0 != -1 && num != ref0) {
				/* ecriture par reference a seq ref0 */
				for(i=0; i<fin; i++) {
					lettre = ( toupper(view->sequence[num][current+i]) == 
						toupper(view->sequence[ref0][current+i]) ? '.' : view->sequence[num][current+i] );
					oneline[k++] = lettre;
					if( i < fin-1 && (i+1)%block_size == 0) 
						oneline[k++] = ' ';
					}
				}
			else	{ /* ecriture normale de seq */
				for(i=0; i<fin; i++) {
					oneline[k++] = view->sequence[num][current+i];
					if( i < fin-1 && (i+1)%block_size == 0) 
						oneline[k++] = ' ';
					}
				}
			}
		oneline[k] = 0;
		if(curr_lines >= lines_per_page) {
			PDF_end_page_ext(pdf, "");
			PDF_begin_page_ext(pdf, width, height, "");
			PDF_setfont(pdf, font, (double)fontsize);
			PDF_set_text_pos(pdf, margin, height - margin);
			curr_lines = 0;
			}
		if(blackonly) {
			PDF_show_xy(pdf, oneline, margin, height - margin - (curr_lines+1) * fontsize);
			}
		else 
			color_pdf_display(pdf, view, calc_color_function, oneline, widnames, margin, 
				height - margin - (curr_lines+1) * fontsize, fontsize, char_width, descender);
		++curr_lines;
		firstpage = FALSE;
		}
	if(curr_lines + 1 <= lines_per_page) {
		PDF_continue_text(pdf, "");
		++curr_lines;
		}
	if( ! vary_only ) current += res_per_line;
	}
PDF_end_page_ext(pdf, "");
PDF_end_document(pdf, "");
PDF_delete(pdf);
} /* end of PDF_TRY */
PDF_CATCH(pdf) {
        fl_alert("Error while writing pdf file:\n"
       	 "[%d] %s: %s\n",
	  	  PDF_get_errnum(pdf), PDF_get_apiname(pdf), PDF_get_errmsg(pdf) );
        PDF_delete(pdf);
        return TRUE; 
}
return FALSE;
}


static void color_pdf_display(PDF *pdf, SEA_VIEW *view, int (*calc_color_function)( int ), char *oneline, 
	int widnames, double x, double y, int fontsize, double char_width, double descender)
{
uchar red, green, blue;
double r, g, b, xx;
int c, l;
char *p, **clines;

clines = (char **)malloc(sizeof(char *) * view->numb_gc); if(clines==NULL) return;
l = strlen(oneline);
for(c = 1; c < view->numb_gc; c++) {
	clines[c] = (char *)malloc(l + 1); if(clines[c] == NULL) return;
	memset(clines[c], ' ', l); clines[c][l] = 0;
	}
for(p = oneline + widnames; *p != 0; p++) {
	c = calc_color_function(*p);
	if(c > 0) clines[c][p - oneline] = 'X';
	}
for(c = 1; c < view->numb_gc; c++) {
	if(strchr(clines[c], 'X') == NULL) continue;
	Fl::get_color((Fl_Color)view->curr_colors[c], red, green, blue);
	r = red/255.; g = green/255.; b = blue/255.;
	PDF_setcolor(pdf, "fillstroke", "rgb", r, g, b, 0);
	for(xx = x + widnames*char_width, p = clines[c] + widnames; *p != 0; p++, xx += char_width) {
		if(*p == ' ') continue;
		PDF_rect(pdf, xx, y + descender, char_width, (double)fontsize);
		}
	PDF_fill_stroke(pdf);
	}
PDF_setcolor(pdf, "fillstroke", "rgb", 0, 0, 0, 0);
PDF_show_xy(pdf, oneline, x, y);
for(c = 1; c < view->numb_gc; c++) free(clines[c]);
free(clines);
}


static int calc_vary_lines(int *vary_pos, int widpos)
{
int maxi = 0, num, nl;

for(num = 0; num < widpos; num++) 
	if(vary_pos[num] > maxi) maxi = vary_pos[num];
if(maxi >= 100000)
	 nl = 6;
else if(maxi >= 10000)
	 nl = 5;
else if(maxi >= 1000)
	 nl = 4;
else if(maxi >= 100)
	 nl = 3;
else if(maxi >= 10)
	 nl = 2;
else 	
	 nl = 1;
return nl;
}


static void out_vary_pos(int *vary_pos, int widnames, int widpos, int nl, PDF *pdf)
{
int num, l, k, echelle, digit, val;
static char chiffre[] = "0123456789";
char oneline[300];

echelle = 1; k = 0;
for(l = 2; l <= nl; l++) echelle *= 10;
for(l = nl; l > 0; l--) {
	for(num = 0; num < widnames; num++) oneline[k++] = ' ';
	for(num = 0; num < widpos; num++) {
		val = vary_pos[num];
		if(val < echelle)
			oneline[k++] = ' ';
		else	{
			digit = (val / echelle) % 10 ;
			oneline[k++] = *(chiffre + digit);
			}
		}
	oneline[k] = 0;
	PDF_continue_text(pdf, oneline);
	k = 0;
	echelle /= 10;
	}
}

