#include "seaview.h"
#include <stdlib.h>
#include <ctype.h>
#ifdef unix
#include <unistd.h>
#endif
#ifndef WIN32
#include <FL/x.H>
#endif
#if defined(__APPLE__) && TARGET_RT_MAC_MACHO
#include <unistd.h>
#include <sys/stat.h>
#endif


/* local prototypes */
int save_part_as_pir(int debut, int fin, char **sequence, char **seqname, 
	int *sel_seqs, int tot_seqs, char *fname, int *withU, int *empty_seq,
	int *num_longest, int protein);
int replace_align_part(SEA_VIEW *view, int debut, int fin, char *fname, int withU, int num_longest,
	int has_phylip_format);
void align_selected_parts(SEA_VIEW *view, int align_algorithm);
int calc_gap_sites(char *old_seq, char *new_seq, int lold, int lnew, 
	gap_site *gap_sites, int maxsites);
int insert_gaps_new_align(char **seq, int site, int number, int numseqs, 
	int lseqs);
int reset_stars(SEA_VIEW *view, int debut, int lpart, char **seq, int lfrag);
int confirm_refer_seq(int num_longest, SEA_VIEW *view);

/* extern proto */
extern int insert_gaps_at(SEA_VIEW *view, int seq, int site, int total);
extern int insert_gap_all_comments(int numgaps, int pos,  SEA_VIEW *view);
#ifdef WIN32
extern "C" {
int mysystem(const char *command);
}
#elif defined(__APPLE__)
#if TARGET_RT_MAC_MACHO
int my_system_macho(char *command, char *base_fname);
extern "C" { char *MG_GetBundleResourcesDir(void); }
#else
void *my_run_program(char *prog, char *arguments, int flavor);
void loop_till_program_ends(void *psn);
extern "C" { char *get_prog_dir(void); }
#endif
#else
void change_attr(Fl_Window *w);
#endif


/* extern variables */
extern gap_site gap_sites[];

int save_part_as_pir(int debut, int fin, char **sequence, char **seqname, 
	int *sel_seqs, int tot_seqs, char *fname, int *withU, int *empty_seq,
	int *num_longest, int protein)
/* returns TRUE iff error */
{
FILE *out;
int num, pos, l_line, retval, maxlen, seqlen, current;
char line[90];

out = fopen(fname,"w");
if( out == NULL ) return TRUE;
retval = TRUE;
*withU = FALSE;
maxlen = 0; current = 0;
for(num = 0; num < tot_seqs; num++) {
	if( ! sel_seqs[num] ) continue;
	sprintf(line, "%d_%s", ++current, seqname[num]);
	fprintf(out, ">%.10s\n", line);
	if(ferror(out)) goto fin;
	*empty_seq = TRUE;
	l_line = 0;
	seqlen = 0;
	for ( pos = debut - 1 ; pos < fin; pos++) {
		if( sequence[num][pos] == 0 ) break;
		if( sequence[num][pos] == '-' ) continue;
		if(l_line >= 70) {
			line[l_line] = 0;
			if(!*withU) *withU = (strchr(line, 'U') != NULL);
			fprintf(out, "%s\n", line);
 			if(ferror(out)) goto fin;
			seqlen += l_line;
			l_line = 0;
			}
		line[l_line++] = sequence[num][pos];
		if(protein && sequence[num][pos] == '*') line[l_line - 1] = 'X';
		*empty_seq = FALSE;
		}
	line[l_line] = 0;
	seqlen += l_line;
	if(seqlen > maxlen) {
		maxlen = seqlen; *num_longest = num;
		}
	if(!*withU) *withU = (strchr(line, 'U') != NULL);
	fprintf(out, "%s\n", line);
	if( *empty_seq ) strcpy(fname, seqname[num]);
	if(ferror(out) || *empty_seq) goto fin;
	}
retval = FALSE;
fin:
if( fclose(out) != 0) return TRUE;
return retval;		
}


void align_selected_parts(SEA_VIEW *view, int align_algorithm)
{
int debut, fin, status, withU, empty_seq, num_longest, l;
char *p, *q;
static char base_fname[100], commande[300];
FILE *in;
static char *prog_path;
static char algo_name[2][20] = {"clustalw", "muscle"};

/* check for presence of xterm + clustalw/muscle + seaview_align.sh */
#ifdef WIN32
	p = (char *)(align_algorithm == CLUSTALW ? "clustalw.exe" : "muscle.exe" ); 
	status = check_path( p ); 
#elif defined(__APPLE__) /* need clustalw in same directory as seaview */
#if TARGET_RT_MAC_MACHO
	p = MG_GetBundleResourcesDir();
#else
	p = get_prog_dir();
#endif
	if(p == NULL) status = 1;
	else	{
		strcpy(commande, p); 
#if TARGET_RT_MAC_MACHO
switch ( align_algorithm ) {
	case CLUSTALW : strcat(commande, "/clustalw"); break;
	default : strcat(commande, "/muscle");
	}
#else
		strcat(commande, align_algorithm == CLUSTALW ? ":clustalw" : ":muscle");
#endif
		in = fopen(commande, "r");
		status = (in == NULL);
		fclose(in);
		prog_path = (char *)malloc(strlen(commande) + 1);
		strcpy(prog_path, commande);
		}
#else
	status = check_path((char*)(align_algorithm == CLUSTALW ? "clustalw" : "muscle"));
	if(status == 0) {
		status = check_path("xterm");
		}
	if(status == 0) {
		status = check_path("seaview_align.sh");
		}
#endif
	if(status != 0) {
		fl_message("Alignment operation is impossible because\n"
#ifdef WIN32
		  "program clustalw.exe/muscle.exe\n"
#elif defined(__APPLE__)
		  "program clustalw/muscle\n"
#else
		  "one of the programs xterm, clustalw, muscle, seaview_align.sh\n"
#endif
		  "is missing");
		((Fl_Menu_ *)view->menu_edit)->mode(ALIGN_SEQS,
			FL_MENU_INACTIVE);
		return;
		}
if(view->active_region == NULL || view->active_region->list == NULL ||
	view->active_region->list->next != NULL || view->tot_sel_seqs <= 1) {
	fl_message("Need to have exactly one block of selected sites\n"
		"and some selected sequences");
	return;
	}
#if !( defined(WIN32) || defined(__APPLE__) )
/* mettre fenetres en Backing Store State: WhenMapped */
change_attr( view->DNA_obj->window() ); 
change_attr( view->dnawin ); 
#endif
debut = view->active_region->list->debut;
fin = view->active_region->list->fin;
#if  defined(WIN32) || defined(__APPLE__) 
tmpnam(base_fname); 
#else
strcpy(base_fname, "/tmp/seaview.XXXXXX");
if(mktemp(base_fname) == NULL) return;
#endif
/* 
convertir en minuscules car clustalw n'accepte pas les majuscules ds filenames
*/
p = base_fname - 1; while( *(++p) != 0) *p = tolower( *p);
#ifdef WIN32 /* pas de . et pas plus de 8 car */
p = base_fname; while( ( q = strchr(p, '\\')) != NULL ) p = q + 1;
p[8] = 0;
if( (q = strchr(p + 1,'.')) != NULL ) *q = 0;
#endif
sprintf(commande, "%s.pir", base_fname);
/* allonger les seqs plus courtes que la region traitee */
for(l = 0; l < view->tot_seqs; l++) {
	if(!view->sel_seqs[l]) continue;
	if(fin > view->each_length[l]) insert_gaps_at(view, l + 1, 
			view->each_length[l] + 1, fin - view->each_length[l]);
	}
status = save_part_as_pir(debut, fin, view->sequence, view->seqname, 
	view->sel_seqs, view->tot_seqs, commande, &withU, &empty_seq, 
	&num_longest, view->protein);
if(view->protein) withU = FALSE;
if(empty_seq) {
	fl_alert("Cannot process sequence(s)\n%s\n"
		 "containing only gaps", commande);
	}
if( (!empty_seq) && status) {
	fl_alert("Cannot write sequences to filename\n%s", commande);
	return;
	}
if(!empty_seq) num_longest = confirm_refer_seq(num_longest, view);
if(num_longest == -1 || empty_seq) {
	sprintf(commande, "%s.pir", base_fname);
	remove(commande);
	return;
	}
my_watch_cursor(view->dnawin);

/* pour memoire: clustalw retourne 1 ou -1 si erreur, autre chose = succes */
#ifdef WIN32
switch (align_algorithm) {
	case CLUSTALW : 
		sprintf(commande, 
		"clustalw.exe /align /infile=%s.pir /outfile=%s.out /output=phylip /outorder=input ", 
		base_fname, base_fname); break;
	default:
		sprintf(commande, 
		"muscle.exe  -in %s.pir -out %s.out -stable ", 
		base_fname, base_fname); break;
	}
#elif defined(__APPLE__)
#if TARGET_RT_MAC_MACHO
switch (align_algorithm) {
	case CLUSTALW : 
		sprintf(commande, 
	"#!/bin/sh\n\"%s\" -align -infile=%s.pir -outfile=%s.out -output=phylip -outorder=input ", 
		prog_path, base_fname, base_fname); break;
	default : 
		sprintf(commande, 
	"#!/bin/sh\n\"%s\" -in %s.pir -out %s.out  -stable ", 
		prog_path, base_fname, base_fname);
	}
#else
sprintf(commande, 
	"/align /infile=%s.pir /outfile=%s.out /output=phylip /outorder=input ", 
	base_fname, base_fname);
#endif
#else
sprintf(commande, "xterm -T \"%s alignment\" -n %s -sb -sl 2000 "
	"-e seaview_align.sh %s ", algo_name[align_algorithm], algo_name[align_algorithm], 
	algo_name[align_algorithm]);
l = strlen(commande);
switch (align_algorithm) {
	case CLUSTALW : 
		sprintf(commande + l, 
		" %s -infile=%s.pir -outfile=%s.out -output=phylip -outorder=input ", 
		base_fname, base_fname, base_fname); break;
	default: 
		sprintf(commande + l, 
		" %s -in %s.pir -out %s.out -stable ", 
		base_fname, base_fname, base_fname); break;
	}
#endif
Fl_Menu_Button *menu_props = (Fl_Menu_Button *)view->bouton_props;
props_menu_parts *props_parts = 
		(props_menu_parts *)menu_props->user_data();
status = menu_props->mode(props_parts->clustalopt + 2) & FL_MENU_VALUE;
if(view->clustal_options != NULL && status ) 
	sprintf(commande + strlen(commande), "%s", view->clustal_options);
#ifdef WIN32
status = mysystem(commande);
#elif defined(__APPLE__)
#if TARGET_RT_MAC_MACHO
status = my_system_macho(commande, base_fname);
#else
void *psn = my_run_program(prog_path, commande, 'SvCw');
if(psn != NULL) loop_till_program_ends(psn);
status = 0;
sprintf(commande, "%s.status", base_fname);
in = fopen(commande, "r");
if(in == NULL) status = 1;
else fclose(in);
#endif
#else
status = system(commande);
if( status == 0 ) {
	sprintf(commande, "%s.status", base_fname);
	in = fopen(commande, "r");
	if(in != NULL) {
		fgets(commande, sizeof(commande), in);
		if( strcmp(commande, "success\n") != 0) status = 1;
		fclose(in);
		}
	else	status = 1;
	}
#endif
sprintf(commande, "%s.out", base_fname);
if( status == 0 ) {
	in = fopen(commande, "r");
	if(in != NULL) {
		fseek(in, 0, SEEK_END);
		status = (ftell(in) < 10);
		fclose(in);
		}
	else	status = 1;
	}
if( status != 0 )
	fl_message("Alignment operation ignored");
else	{
	status = replace_align_part(view, debut, fin, commande, withU, num_longest,
		(align_algorithm == CLUSTALW ? TRUE : FALSE) );
	if(status) fl_alert("Not enough memory\nor\n" 
		"max sequence length reached");
	}
sprintf(commande, "%s.pir", base_fname);
remove(commande);
sprintf(commande, "%s.out", base_fname);
remove(commande);
if(align_algorithm == CLUSTALW) {
	sprintf(commande, "%s.dnd", base_fname);
	remove(commande);
	}
#ifndef WIN32
sprintf(commande, "%s.status", base_fname);
remove(commande);
#endif
}


int calc_gap_sites(char *old_seq, char *new_seq, int lold, int lnew, 
	gap_site *gap_sites, int maxsites)
{
char *fin_old, *fin_new;
int tot_sites = 0, posalign = 0;
fin_old = old_seq + lold - 1; fin_new = new_seq + lnew - 1;
while( old_seq <= fin_old || new_seq <= fin_new ) {
	if(old_seq <= fin_old && new_seq <= fin_new && 
		( ( *old_seq != '-' && *new_seq != '-') ||
		  ( *old_seq == '-' && *new_seq == '-') ) ){
		old_seq++; new_seq++;
		posalign++;
		continue;
		}
	if(tot_sites >= maxsites) return -1;
	gap_sites[tot_sites].l[1] = 0;
	gap_sites[tot_sites].l[0] = 0;
	if(old_seq <= fin_old && *old_seq == '-') {
		gap_sites[tot_sites].pos = posalign;
		do	{ old_seq++; ++(gap_sites[tot_sites].l[1]); }
		while( *old_seq == '-' && old_seq < fin_old);
		posalign += gap_sites[tot_sites].l[1];
		}
	else 	{
		gap_sites[tot_sites].pos = posalign;
		do	{ new_seq++; ++(gap_sites[tot_sites].l[0]); }
		while( *new_seq == '-' && new_seq < fin_new);
		posalign += gap_sites[tot_sites].l[0];
		}
	tot_sites++;
	}
return tot_sites;
}


int replace_align_part(SEA_VIEW *view, int debut, int fin, char *fname, 
	int withU, int num_longest, int has_phylip_format)
/* returns TRUE if error, FALSE if ok */
{
int num, lfrag, lpart, i, col, rang, retval, newlength, lfrag2;
char **seq, **comments, **seqname, *pheader, *err_message;
int (*calc_color_function)(int);
int totgapsites, num1, site, l_copy, res;
char *tmp;

view->cursor_in_comment = FALSE;
view->cursor_seq = view->first_seq;
/* lecture de l'alignement multiple produit par clustalw */
num = (has_phylip_format ?
	read_phylip_align(fname, &seq, &seqname, &comments, &pheader, &err_message)
	:
	read_fasta_align(fname, &seq, &seqname, &comments, &pheader, &err_message)
	);
for(i = 0; i < num; i++) free(seqname[i]);
if(num > 0) { free(seqname); free(comments); }
if(num != view->tot_sel_seqs) { if(num > 0) free(seq); return TRUE; }

retval = TRUE;
if(withU) { 
/* si seq avec U au depart, les remettre car ont ete changes en T par clustalw */
	char *p, *q;
 	for(num = 0; num < view->tot_sel_seqs; num++) {
 		p = seq[num];
 		while( (q = strchr(p, 'T')) != NULL) { *q = 'U'; p = q; }
		}
	}	
lfrag = strlen(seq[0]); /* long alignement de clustalw */
lpart = fin - debut + 1; /*long region traitee de l'ancien alignement multiple*/
if(view->protein) {
	if( reset_stars(view, debut, lpart, seq, lfrag) ) return TRUE;
	}
/* num1 = rang dans align clustalw de num_longest dans align multiple */
num1 = -1;
for(i = 0; i < view->tot_seqs; i++) {
	if( !view->sel_seqs[i]) continue;
	num1++;
	if( i == num_longest) break;
	}
/* calcul des pos et longs de gaps a inserer:
gap_sites[x].pos = position a droite du gap a inserer (from 0)
gap_sites[x].l[0] = longueur a inserer dans alignement multiple
gap_sites[x].l[1] = longueur a inserer dans alignement produit par clustalw
*/
totgapsites = calc_gap_sites(view->sequence[num_longest] + debut - 1, seq[num1],
	FL_min(lpart, view->each_length[num_longest] - debut + 1),
	lfrag, gap_sites, MAX_GAP_SITES);
if(totgapsites == -1) goto fin;
/* calcul long region traitee apres ajout des gaps */
for(site=0; site<totgapsites; site++) 
	lpart += gap_sites[site].l[0];
/* l'alignement multiple serait-il trop long en fin d'operation? */
if( view->seq_length + lpart - (fin - debut + 1) > view->max_seq_length ) 
	goto fin;
/* calcul long alignement de clustalw apres ajout des gaps */
lfrag2 = lfrag;
for(site = 0; site < totgapsites; site++) 
	lfrag2 += gap_sites[site].l[1];
/* allongement memoire pour seqs de l'alignement de clustalw */
for(num=0; num<view->tot_sel_seqs; num++) {
	tmp = (char *)malloc(lfrag2+1);
	if(tmp == NULL) goto fin;
	memcpy(tmp, seq[num], lfrag+1);
	free(seq[num]);
	seq[num] = tmp;
	}
/* allongement des seqs de l'alignement de clustalw */
for(site = 0; site < totgapsites; site++) {
	if(gap_sites[site].l[1] == 0) continue;
	lfrag = insert_gaps_new_align(seq, gap_sites[site].pos, 
		gap_sites[site].l[1],
		view->tot_sel_seqs, lfrag);
	}
if(view->numb_gc > 1) {
	calc_color_function = ( view->protein ? 
		get_color_for_aa : get_color_for_base );
	}
newlength = view->seq_length;
/* allongement des seqs de l'alignement multiple */
for(site = 0; site < totgapsites; site++) {
	if(gap_sites[site].l[0] == 0) continue;
	for(num = 0; num < view->tot_seqs; num++) {
		insert_gaps_at(view, num + 1, 
			debut + gap_sites[site].pos, gap_sites[site].l[0]);
		}
	newlength += gap_sites[site].l[0];
	insert_region_part(view, debut + gap_sites[site].pos, 
		gap_sites[site].l[0]);
	if(view->tot_comment_lines > 0) insert_gap_all_comments(
		gap_sites[site].l[0], debut + gap_sites[site].pos, view);
	}

/* copie des sequences de clustalw vers alignement multiple */
rang = -1;
for(num = 0; num < view->tot_seqs; num++) {
	if(  ! view->sel_seqs[num] ) continue;
	rang++;
/* on met les nouvelles seqs */ 
	l_copy = FL_min(lpart, lfrag);
	memcpy( view->sequence[num] + debut - 1, seq[rang], l_copy);
	if(debut + l_copy - 1 > view->each_length[num])
		view->each_length[num] = debut + l_copy - 1;
	newlength = FL_max(newlength, view->each_length[num]);
	if(view->each_length[num] == debut + l_copy - 1) 
		view->sequence[num][debut + l_copy - 1] = 0;
	if(view->numb_gc == 1) continue;
	for(i = 0; i < view->numb_gc; i++) {
		memset( view->col_seq[num][i] + debut - 1, ' ', l_copy);
		}
	for(i = debut - 1; i < debut + l_copy - 1; i++) {
		res = view->sequence[num][i];
		col = calc_color_function( res );
		view->col_seq[num][col][i] = 
			(view->allow_lower ? res : toupper(res) );
		}
	if(view->each_length[num] == debut + l_copy - 1) {
		for(col = 0; col < view->numb_gc; col++) 
			view->col_seq[num][col][debut + l_copy - 1] = 0;
		}
	}
/* mettre a jour horsli */
update_current_seq_length(newlength, view);
view->modif_but_not_saved = TRUE;
retval = FALSE;

fin:
for(num = 0; num < view->tot_sel_seqs; num++) 
	free(seq[num]);
free(seq);
return retval;
}


int insert_gaps_new_align(char **seq, int site, int number, int numseqs, 
	int lseqs)
{
int num;
char *pos;
for(num=0; num < numseqs; num++) {
	pos = seq[num] + site;
	memmove(pos + number, pos, lseqs - site + 1);
	memset(pos, '-', number);
	}
return lseqs + number;
}


int reset_stars(SEA_VIEW *view, int debut, int lpart, char **seq, int lfrag)
{
int oldseq, newseq;
char *p, *q;

newseq = -1;
for(oldseq = 0; oldseq < view->tot_seqs; oldseq++) {
	if(!view->sel_seqs[oldseq]) continue;
	newseq++;
	p = view->sequence[oldseq] + debut - 2;
	q = seq[newseq] - 1;
	while(TRUE) {
		p++; q++;
		while (*p == '-') p++;
		while (*q == '-') q++;
		if(*p == 0 || *q == 0) break;
		if( *p == '*' && *q == 'X') *q = '*';
		if( toupper(*p) != toupper(*q) ) return TRUE;
		if( islower(*p) ) *q = *p;
		}
	}
return FALSE;
}


int confirm_refer_seq(int num_longest, SEA_VIEW *view)
{
static Fl_Window *form;
static int first = TRUE;
static Fl_Browser *browser_noms;
static Fl_Button *ok_button, *cancel_button;
int lnum, i;
if(first) {
	first = FALSE;
	form = new Fl_Window( 300, 400);
	form->label("Reference Sequence");
	form->box(FL_FLAT_BOX);
	fl_font(FL_HELVETICA, FL_NORMAL_SIZE);
	browser_noms = new Fl_Browser(5, 5 + fl_height(), form->w() - 10, 
		form->h() - 35 - fl_height(), "Choose one seq.");
	browser_noms->type(FL_HOLD_BROWSER);
	browser_noms->textsize(FL_NORMAL_SIZE);
	browser_noms->has_scrollbar(Fl_Browser_::VERTICAL);
	browser_noms->align(FL_ALIGN_TOP);
	browser_noms->color(FL_LIGHT1, browser_noms->selection_color());
	ok_button = new Fl_Return_Button(5, form->h() - 25, 
		browser_noms->w() / 2, 20, "OK");
	cancel_button = new Fl_Button(ok_button->x() + ok_button->w(), 
		ok_button->y(), ok_button->w(), ok_button->h(), "Cancel");
	form->resizable(browser_noms);
	form->end();
	form->set_modal();
	}
browser_noms->clear();
lnum = 0;
for(i = 0; i < view->tot_seqs; i++) {
	if(!view->sel_seqs[i]) continue;
	lnum++;
	browser_noms->add(view->seqname[i]);
	if(i == num_longest) browser_noms->value(lnum);
	}
form->show();
for (;;) {
	Fl_Widget *o = Fl::readqueue();
	if (!o) Fl::wait();
	else if(o == cancel_button ) { num_longest = -1; break; }
	else if(o == ok_button && browser_noms->value() != 0) break;
	}
form->hide();
if(num_longest == -1) return -1;
Fl::flush();

lnum = browser_noms->value();
for(i = 0; i < view->tot_seqs; i++) {
		if(!view->sel_seqs[i]) continue;
		if(strcmp(view->seqname[i], browser_noms->text(lnum)) == 0) {
			num_longest = i;
			break;
			}
		}
return num_longest;
}



#if defined(__APPLE__)

#if TARGET_RT_MAC_MACHO

int my_system_macho(char *command, char *base_fname)
{
char comfile[300];
FILE *out;
FSRef myref, myterm, frontproc;
LSLaunchFSRefSpec mylaunch;
OSStatus status;
ProcessSerialNumber newpsn;

sprintf(comfile, "%s.command", base_fname);
out = fopen(comfile, "w");
fprintf(out, "%s\n", command);
fclose(out);
chmod(comfile, S_IRUSR|S_IXUSR);
status = FSPathMakeRef((const UInt8 *)comfile, &myref, NULL);
LSFindApplicationForInfo(kLSUnknownCreator, CFSTR("com.apple.terminal"), NULL, &myterm, NULL);
mylaunch.appRef = &myterm; // FSRef to the Terminal application
mylaunch.numDocs = 1;
mylaunch.itemRefs = &myref;
mylaunch.passThruParams = NULL;
mylaunch.launchFlags =  kLSLaunchNewInstance ; // run a new Terminal instance
mylaunch.asyncRefCon = NULL;
status = LSOpenFromRefSpec(&mylaunch, &frontproc); // frontproc becomes FSRef to newly started Terminal
if(status == noErr) {
	GetFrontProcess(&newpsn); // the newly started Terminal
    sleep(2);
	fl_cursor(FL_CURSOR_DEFAULT, FL_BLACK, FL_BLACK);
	status = fl_ask("Wait for alignment completion in Terminal window.\nIs it completed ?") ? 0 : 1 ; 
	// try to kill only a newly started Terminal and not something else
	if( FSCompareFSRefs(&frontproc, &myterm) == noErr) KillProcess(&newpsn);
	}
unlink(comfile);
return status != noErr;
}

#else

void loop_till_program_ends(void *psn)
{
ProcessInfoRec pinfo;
OSErr err;

while(1) {
    Fl::wait();
    pinfo.processInfoLength = sizeof(ProcessInfoRec);
    pinfo.processName = NULL;
    pinfo.processAppSpec = NULL;
    err = GetProcessInformation((ProcessSerialNumber *)psn, &pinfo);
    if(err == procNotFound) break;
  }
}


void *my_run_program(char *prog, char *arguments, int flavor)
{
LaunchParamBlockRec pbloc;
FSSpec fspec;
OSErr err;
char pfname[256];
ProcessSerialNumber *pinfo;
ScrapRef scrapref;
OSStatus etat;
Size l;
UInt32 count;

if(arguments != NULL) { // put arguments in the scrap under the specified flavor
	etat = ClearCurrentScrap();  // indispensable !
	etat = GetCurrentScrap(&scrapref);
	l = strlen(arguments);
	etat = PutScrapFlavor(scrapref, flavor, kScrapFlavorMaskNone, l, arguments);
	}
strcpy(pfname + 1, prog );
pfname[0] = strlen(pfname+1);
err = FSMakeFSSpec(0, 0, (ConstStr255Param)pfname, &fspec);
if(err != noErr) return NULL;

pbloc.launchControlFlags = launchContinue | launchNoFileFlags ;
pbloc.launchBlockID = extendedBlock;
pbloc.launchEPBLength = extendedBlockLen;
pbloc.launchAppParameters = NULL;
pbloc.launchAppSpec = &fspec;
err = LaunchApplication(&pbloc);
pinfo = (ProcessSerialNumber *)malloc(sizeof(ProcessSerialNumber));
*pinfo = pbloc.launchProcessSN;
return ( err == noErr ? pinfo : NULL) ;
}

#endif

#elif !defined(WIN32)

void change_attr(Fl_Window *w)
{
XSetWindowAttributes attr;
XWindowAttributes current;

XGetWindowAttributes(fl_display, fl_xid(w), &current);
if(current.backing_store != NotUseful) return;
attr.backing_store = WhenMapped;
XChangeWindowAttributes(fl_display, fl_xid(w), CWBackingStore, &attr);
// il faut la redessiner pour que ca fasse effet
w->redraw(); 
Fl::flush();
}

#endif



