/*
                             SAR Sound Utilities

	See sound.c for low-level to sound output library functions.

 */

#ifndef SARSOUND_H
#define SARSOUND_H

#include "sound.h"
#include "obj.h"

#define SAR_SOUND_PREDEFINED_LAND_BELLY		10
#define SAR_SOUND_PREDEFINED_LAND_SKI		11
#define SAR_SOUND_PREDEFINED_LAND_SKI_SKID	12
#define SAR_SOUND_PREDEFINED_LAND_WHEEL_SKID	13

#define SAR_SOUND_PREDEFINED_CRASH_GROUND	30
#define SAR_SOUND_PREDEFINED_CRASH_OBSTRUCTION	31
#define SAR_SOUND_PREDEFINED_SPLASH_AIRCRAFT	40
#define SAR_SOUND_PREDEFINED_SPLASH_HUMAN	41

extern void SARSoundEngineVolumeMute(
        snd_recorder_struct *recorder,
        snd_play_struct *inside_snd_play,
        snd_play_struct *outside_snd_play
);
extern void SARSoundAdjustEngineVolume(
        snd_recorder_struct *recorder,
        snd_play_struct *inside_snd_play,
        snd_play_struct *outside_snd_play,
        int is_inside,
        int engine_state,
        double throttle,
        double distance_to_camera
);

extern void SARSoundPlayPredefined(
        snd_recorder_struct *recorder,
        int type,			/* One of SAR_SOUND_PREDEFINED_*. */
        sar_scene_struct *scene,
        double distance_to_camera	/* In meters. */
);

#endif	/* SARSOUND_H */
