#!/usr/bin/env perl -w

use ExtUtils::MakeMaker;
use strict;

#
# Configure SDL proper
#

my $sdl_cflags = undef;
my $sdl_libs = undef;

my ($sdl_image, 
    $sdl_mixer, 
    $sdl_ttf,
    $sdl_net,
    $png, 
    $jpeg, 
    $gl, 
    $glu) = (0,0,0,0,0,0,0,0); 

my @dirs = ();
my $inc_flags = "";


# check if we are running on Win32, not an exhuastive check! (no cygwin support)
if ($^O eq "MSWin32")
{
  print "Configuring for Win32 SDL-Perl (MSVC++ 6.x only)\n";
  print "------------------------------------------------\n";

  my $sdlpl_sdl_home = "..\\sdl";

  if (exists($ENV{SDLPL_SDL_HOME}))
  {
    $sdlpl_sdl_home=$ENV{SDLPL_SDL_HOME};
  }
  else
  {
    warn "Warning: Using default SDLPL_SDL_HOME value of: $sdlpl_sdl_home\n";
  }


  my $sdlpl_sdl_inc_home = $sdlpl_sdl_home."\\include";
  my $sdlpl_sdl_lib_home = $sdlpl_sdl_home."\\lib";

  warn "Warning: Env var INCLUDE should be set."  unless exists $ENV{INCLUDE};
  warn "Warning: Env var LIB should be set."  unless exists $ENV{INCLUDE};

  # add VC include search path to our search
  my @incDirs=  map { '"' . $_ .'"' } split ';', $ENV{INCLUDE};
  push @incDirs, $sdlpl_sdl_inc_home;

  # add SDL lib to VC lib search path
  my @libDirs = ($sdlpl_sdl_lib_home);
  $ENV{LIB}=$ENV{LIB}.";". join ";", @libDirs;

  @dirs=@incDirs;

  # set SDL build flags
  $sdl_cflags = join " ", map { "-I$_" } @incDirs;
  $sdl_libs = "-lsdl";
  map { $sdl_libs.=" -L$_"} @libDirs;


  # check for libs, not include files, to determine some runtime support

  my @dllDirs=  @libDirs;
  push @dllDirs , split ';', '"' .$ENV{PATH} . '"';

  print "Scanning DLL Dirs:";
  for ( @dllDirs ) 
  {
    print "\t$_";
    $png = '-DHAVE_PNG' if -e "$_/libpng1.dll";
    $jpeg = '-DHAVE_JPEG' if -e "$_/jpeg.dll";
    $gl = '-DHAVE_GL' if -e "$_/gl.dll";
    $glu = '-DHAVE_GLU' if -e "$_/glu.dll";
  }
}
else # not win32 platform
{
  $sdl_cflags = `sdl-config --cflags`;
  $sdl_libs = `sdl-config --libs`;
  $sdl_libs =~ s/-Wl,-rpath,\/usr\/local\/lib//; # suppress the insanity

  @dirs=(
	 '/usr/local/include/SDL', 
	 '/usr/local/include',
	 '/usr/include/SDL',
	 '/usr/include',
	 '/usr/local/include/GL',
	 '/usr/include/GL', 
	);
  $inc_flags = "-ggdb";
}


#
# Locate optional packages
#


for ( @dirs ) {
  print "Scanning Include Dirs: $_\n";
	$sdl_image = '-DHAVE_SDL_IMAGE' if -e "$_/SDL_image.h";
	$sdl_mixer = '-DHAVE_SDL_MIXER' if -e "$_/SDL_mixer.h";
	$sdl_net = '-DHAVE_SDL_NET' if -e "$_/SDL_net.h";
	$sdl_ttf = '-DHAVE_SDL_TTF' if -e "$_/SDL_ttf.h";
	$png = '-DHAVE_PNG' if -e "$_/png.h";
	$jpeg = '-DHAVE_JPEG' if -e "$_/jpeglib.h";
	$gl = '-DHAVE_GL' if -e "$_/gl.h";
	$glu = '-DHAVE_GLU' if -e "$_/glu.h";	
	$gl = '-DHAVE_GL' if -e "$_/gl/gl.h";
	$glu = '-DHAVE_GLU' if -e "$_/gl/glu.h";	
}

print "Found SDL_image	" . ( $sdl_image ? "yes" : "no" ) . "\n";
print "Found SDL_mixer	" . ( $sdl_mixer ? "yes" : "no" ) . "\n";
print "Found SDL_net	" . ( $sdl_net ? "yes" : "no" ) . "\n";
print "Found SDL_ttf	" . ( $sdl_ttf ? "yes" : "no" ) . "\n";
print "Found libpng	" . ( $png ? "yes" : "no" ) . "\n";
print "Found jpeg	" . ( $jpeg ? "yes" : "no" ) . "\n";
print "Found OpenGL	" . ( $gl ? "yes" : "no" ) . "\n";
print "Found GLUT	" . ( $glu ? "yes" : "no" ) . "\n";

#
# Specify Makefile options
#

my %options = (
    'NAME'	=> 'SDL_perl',
    'VERSION_FROM' => 'SDL.pm', 
    'LIBS'	=> [ join( " ",	"$sdl_libs", 
			($sdl_image) ? '-lSDL_image' : "", 
			($png) ? '-lpng' : "",
			($jpeg) ? '-ljpeg' : "", 
			($sdl_mixer) ? '-lSDL_mixer' : "", 
			($sdl_net) ? '-lSDL_net' : "",
			($sdl_ttf) ? '-lSDL_ttf' : "",
			($gl) ? '' : "", 
			($glu) ? '' : ""  )
			],  
    'DEFINE'	=> "$sdl_image $png $jpeg $sdl_mixer $sdl_net $sdl_ttf $gl $glu", 
    'INC'	=> "$inc_flags $sdl_cflags",
    'OBJECT'	=> ($sdl_image ? 'SFont.o' : "" ) . " SDL_perl.o",
);
    
#
# Write Makefile 
#

WriteMakefile(%options );


