/***************************************************************************
                          bookmwin.h  -  description
                             -------------------
    begin                : Mon Feb 11 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BOOKMWIN_H
#define BOOKMWIN_H

#include <qdialog.h>
#include <qlistview.h>
#include <qevent.h>
#include <qpoint.h>
#include <qlayout.h>
#include "scribusview.h"

/**
  *@author Franz Schmid
  */

class BookMItem : public QListViewItem
{
public:
    BookMItem(QListView* parent, int nr, int s, int el);
    ~BookMItem();
    virtual QString key(int, bool) const;
    int ItemNr;
    int Seite;
    int Element;
    int PdfObj;
    QString Action;
    QString Titel;
		int First;
		int Last;
		int Prev;
		int Next;
		int Pare;
};

class BookMView : public QListView
{
    Q_OBJECT

public:
    BookMView(QWidget* parent, ScribusView* vie);
    ~BookMView();
    void AddItem(QString text, QString Tit, int s, int el);
    void DeleteItem(int nr);
    void SetAction(int nr, QString Act);
    int NrItems;
    bool Mpressed;
    QPoint Mpos;
    BookMItem *DraggedI;
    ScribusView *View;
    int First;
    int Last;

protected:
    void contentsMouseReleaseEvent(QMouseEvent *m);
    void contentsMousePressEvent(QMouseEvent* e);
    void contentsMouseMoveEvent(QMouseEvent* e);
    void contentsDropEvent(QDropEvent *e);
    void contentsDragMoveEvent(QDragMoveEvent *e);
};

#endif
