;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/prgm.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep 26 15:35:16 2001                          */
;*    Last change :  Wed Jan 16 12:04:05 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The handling of the prgm forms.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_prgm
   
   (import  __scribeapi_pbigloo
	    __scribeapi_pxml
	    __scribeapi_pscribe
	    __scribeapi_pc
	    __scribeapi_ast)
   
   (export  (program ::obj ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    program ...                                                      */
;*---------------------------------------------------------------------*/
(define (program body lnum uproc)
   (let* ((body (if (and (pair? body) (null? (cdr body)))
		    (car body)
		    body))
	  ;; we strip the first newline of the body
	  (body (cond
		   ((and (string? body)
			 (>fx (string-length body) 0)
			 (char=? (string-ref body 0) #\Newline))
		    (substring body 1 (string-length body)))
		   ((and (pair? body)
			 (string? (car body))
			 (>fx (string-length (car body)) 0)
			 (char=? (string-ref (car body) 0) #\Newline))
		    (cons (substring (car body) 1 (string-length (car body)))
			  (cdr body)))
		   (else
		    body)))
	  (uproc (cond
		    ((procedure? uproc)
		     uproc)
		    ((symbol? uproc)
		     (find-registered-fontifier uproc))
		    (else
		     (lambda (x) x)))))
      ;; initialize the line counter...
      (set! *lnum* lnum)
      (let ((prgm (strip-ending-blank-lines (pretty-printer body uproc))))
	 ;; and if needed insert the first line number
	 (if (number? lnum)
	     (cons (line lnum) (pretty-printer prgm line-numberer))
	     prgm))))

;*---------------------------------------------------------------------*/
;*    *fontifiers* ...                                                 */
;*---------------------------------------------------------------------*/
(define *fontifiers*
   `((bigloo . ,bigloo)
     (xml . ,xml)
     (scribe . ,scribe)
     (c . ,c)))

;*---------------------------------------------------------------------*/
;*    find-registered-fontifier ...                                    */
;*---------------------------------------------------------------------*/
(define (find-registered-fontifier sym::symbol)
   (let ((cell (assq sym *fontifiers*)))
      (if (pair? cell)
	  (cdr cell)
	  (lambda (x) x))))

;*---------------------------------------------------------------------*/
;*    *lnum* ...                                                       */
;*---------------------------------------------------------------------*/
(define *lnum* #f)

;*---------------------------------------------------------------------*/
;*    line ...                                                         */
;*---------------------------------------------------------------------*/
(define (line num)
   (let* ((num (number->string num))
	  (lnum (string-length num))
	  (res (if (< lnum 4)
		   (let ((res (make-string 4)))
		      (blit-string! num 0 res (-fx 4 lnum) lnum)
		      res)
		   num)))
      (instantiate::%it
	 (body (string-append res ":")))))

;*---------------------------------------------------------------------*/
;*    line-numberer ...                                                */
;*---------------------------------------------------------------------*/
(define (line-numberer obj)
   (string-case obj
      (#\Newline
       (let ((str (the-string)))
	  (set! *lnum* (+fx 1 *lnum*))
	  (cons* str (line *lnum*) (ignore))))
      ((+ all)
       (let ((str (the-string)))
	  (cons str (ignore))))
      (else
       '())))

;*---------------------------------------------------------------------*/
;*    pretty-printer ...                                               */
;*---------------------------------------------------------------------*/
(define-generic (pretty-printer obj uproc)
   (cond
      ((or (number? obj) (char? obj))
       (list obj))
      ((string? obj)
       (let ((uobj (uproc obj)))
	  (if (list? uobj)
	      (map eval uobj)
	      uobj)))
      ((list? obj)
       (match-case obj
	  ((from-file ?file ?def ?start ?stop)
	   (let ((mark (with-output-to-string
			  (lambda ()
			     (display "%% ")
			     (write file)
			     (display " ")
			     (write def)
			     (print " " start " " stop)))))
	      (pretty-printer mark uproc)))
	  (else
	   (map (lambda (o) (pretty-printer o uproc)) obj))))
      (else
       (with-access::%node obj (loc)
	  (error/location "prgm"
			  "Can't find method for node"
			  (find-runtime-type obj)
			  (car loc)
			  (cdr loc))))))

;*---------------------------------------------------------------------*/
;*    pretty-printer ::node ...                                        */
;*---------------------------------------------------------------------*/
(define-method (pretty-printer node::%node uproc)
   node)

;*---------------------------------------------------------------------*/
;*    pretty-printer ::text ...                                        */
;*---------------------------------------------------------------------*/
(define-method (pretty-printer node::%text uproc)
   (with-access::%text node (body)
      (set! body (pretty-printer body uproc))
      node))
;*---------------------------------------------------------------------*/
;*    pretty-printer ::%linebreak ...                                  */
;*---------------------------------------------------------------------*/
(define-method (pretty-printer node::%linebreak uproc)
   (pretty-printer (make-string (%linebreak-repetition node) #\Newline) uproc))

;*---------------------------------------------------------------------*/
;*    strip-ending-blank-lines ...                                     */
;*---------------------------------------------------------------------*/
(define (strip-ending-blank-lines body)
   (define (newline-string? str)
      (let ((len (string-length str)))
	 (let loop ((i 0))
	    (cond
	       ((=fx len i)
		#t)
	       ((char=? (string-ref str i) #\Newline)
		(loop (+fx i 1)))
	       (else
		#f)))))
   (cond
      ((string? body)
       (let ((len (string-length body)))
	  (let loop ((r (-fx len 1)))
	     (cond
		((=fx r 0)
		 body)
		((char=? (string-ref body r) #\Newline)
		 (loop (-fx r 1)))
		(else
		 (if (=fx r (-fx len 1))
		     body
		     (substring body 0 r)))))))
      ((pair? body)
       (let loop ((lines (reverse! body)))
	  (cond
	     ((null? lines)
	      body)
	     ((equal? (car lines) '())
	      (loop (cdr lines)))
	     ((newline-string? (car lines))
	      (loop (cdr lines)))
	     ((or (pair? (car lines)) (string? (car lines)))
	      (reverse!
	       (cons (strip-ending-blank-lines (car lines)) (cdr lines))))
	     (else
	      (reverse! lines)))))))
