#ifndef SCREEM_STRUCTURE_H
#define SCREEM_STRUCTURE_H

void build_page_structure_tree( void );
void build_attribute_list( void );


typedef enum StructureTreeEnums {
	TARGET_SCREEM_STRUCTURE,
	TARGET_STRUCTURE_URL,
	TARGET_STRUCTURE_URI_LIST,
	TARGET_STRUCTURE_TEXT
} StructureTreeEnums;

static const GtkTargetEntry structure_tree_drag_types[] = {
        { "application/x-screem-structure", 0, TARGET_SCREEM_STRUCTURE }
};
static const gint structure_tree_num_drag_types =
sizeof( structure_tree_drag_types ) /
sizeof( structure_tree_drag_types [0] );

static const GtkTargetEntry structure_tree_drop_types[] = {
        { "application/x-screem-structure", 0, TARGET_SCREEM_STRUCTURE },
	{ "x-url/http", 0, TARGET_STRUCTURE_URL },
        { "x-url/ftp", 0, TARGET_STRUCTURE_URL },
	{ "text/x-moz-url", 0, TARGET_STRUCTURE_URL },
        { "_NETSCAPE_URL", 0, TARGET_STRUCTURE_URL },
	{ "text/uri-list", 0, TARGET_STRUCTURE_URI_LIST },
	{ "text/plain", 0, TARGET_STRUCTURE_TEXT }
};

static const gint structure_tree_num_drop_types =
sizeof( structure_tree_drop_types ) /
sizeof( structure_tree_drop_types [0] );

#endif
