#ifndef SCREEM_PREVIEW_H
#define SCREEM_PREVIEW_H

#include <libgtkhtml/gtkhtml.h>

#include "screem-view.h"

#include "screem-page.h"


#define SCREEM_TYPE_PREVIEW  (screem_preview_get_type())
#define SCREEM_PREVIEW(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_TYPE_PREVIEW, \
                                                ScreemPreview ) )
#define SCREEM_PREVIEW_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_TYPE_PREVIEW, \
                                                             ScreemPreviewClass ) )
#define SCREEM_IS_PREVIEW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_TYPE_PREVIEW ) )

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct ScreemPreviewPrivate ScreemPreviewPrivate;

typedef struct {
	ScreemView parent;

	ScreemPreviewPrivate *priv;
} ScreemPreview;

typedef struct {
	ScreemViewClass parent_class;

} ScreemPreviewClass;

GType screem_preview_get_type( void );
ScreemPreview *screem_preview_new( void );
ScreemPreview *screem_preview_new_with_window( ScreemWindow *window );

void screem_preview_display( ScreemPreview *preview, const gchar *text,
			     const gchar *base_uri,
			     gboolean online );

void screem_preview_uri( ScreemPreview *preview, const gchar *uri,
			 gboolean online );

#endif
