/** @file scim_gconf_config.h
 * definition of GConfConfig class.
 */

/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_gconf_config.h,v 1.10 2004/05/13 09:03:45 suzhe Exp $
 */

#if !defined (__SCIM_GCONF_CONFIG_H)
#define __SCIM_GCONF_CONFIG_H

#include <sys/time.h>

using namespace scim;

class GConfConfig : public ConfigBase
{
    GConfClient *m_client;
    timeval      m_update_timestamp;
    bool         m_modified; 
    bool         m_need_reload;

public:
    GConfConfig (const String& app_name = String ("scim"));

    virtual ~GConfConfig ();

    virtual bool valid () const;
    
    // String
    virtual bool read (const String& key, String *pStr) const;

    // int
    virtual bool read (const String& key, int *pl) const;

    // double
    virtual bool read (const String& key, double* val) const;

    // bool
    virtual bool read (const String& key, bool* val) const;

    //String list
    virtual bool read (const String& key, std::vector <String>* val) const;

    //int list
    virtual bool read (const String& key, std::vector <int>* val) const;

    // write the value (return true on success)
    virtual bool write (const String& key, const String& value);
    virtual bool write (const String& key, int value);
    virtual bool write (const String& key, double value);
    virtual bool write (const String& key, bool value);
    virtual bool write (const String& key, const std::vector <String>& value);
    virtual bool write (const String& key, const std::vector <int>& value);

    // permanently writes all changes
    virtual bool flush();

    // delete entries
    virtual bool erase (const String& key );

    virtual bool reload ();
private:
    String compose_key (const String& key) const;

    GConfValue * get_gconf_value (const String& key) const;
};
#endif

/*
vi:ts=4:nowrap:ai:expandtab
*/
