/* vim:set noet ts=4: */
/** 
 * scim-python
 * 
 * Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: $
 */
#ifndef __SCIM_PYTHON_ENGINE_H_
#define __SCIM_PYTHON_ENGINE_H_
#define Uses_SCIM_IMENGINE
#include <Python.h>
#include <scim.h>

using namespace scim;

struct PyIMEngineObject;

class PyIMEngine : public IMEngineInstanceBase 
{
private:
	PyObject *self;
	PyObject *factory;
	PyObject *config;
	Connection reload_signal_connection;

private:
	PyIMEngine (PyObject *self,
			PyObject			*factory,
			PyObject			*config,
			const String		&encoding,
			int					id = -1);
	virtual ~PyIMEngine ();

public:
	virtual bool process_key_event (const KeyEvent &key);
	virtual void move_preedit_caret (unsigned int pos);
	virtual void select_candidate (unsigned int index);
	virtual void update_lookup_table_page_size (unsigned int page_size);
	virtual void lookup_table_page_up ();
	virtual void lookup_table_page_down ();
	virtual void reset ();
	virtual void focus_in ();
	virtual void focus_out ();
	virtual void trigger_property (const String &property);
	virtual void process_helper_event (const String &helper_uuid, const Transaction &trans);
	virtual void update_client_capabilities (unsigned int cap);

private:
	void reload_config (const ConfigPointer &config);

public:

	/* 
	 * Wrapper functions
	 */

	static PyObject *py_process_key_event (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_move_preedit_caret (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_select_candidate (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_update_lookup_table_page_size (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_lookup_table_page_up (PyIMEngineObject *self);
	static PyObject *py_lookup_table_page_down (PyIMEngineObject *self);
	static PyObject *py_reset (PyIMEngineObject *self);
	static PyObject *py_focus_in (PyIMEngineObject *self);
	static PyObject *py_focus_out (PyIMEngineObject *self);
	static PyObject *py_trigger_property (PyIMEngineObject *self, PyObject *arg);
	static PyObject *py_process_helper_event (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_update_client_capabilities (PyIMEngineObject *self, PyObject *arg);

	static PyObject *py_show_preedit_string (PyIMEngineObject *self);
	static PyObject *py_show_aux_string (PyIMEngineObject *self);
	static PyObject *py_show_lookup_table (PyIMEngineObject *self);
	static PyObject *py_hide_preedit_string (PyIMEngineObject *self);
	static PyObject *py_hide_aux_string (PyIMEngineObject *self);
	static PyObject *py_hide_lookup_table (PyIMEngineObject *self);
	static PyObject *py_update_preedit_caret (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_update_preedit_string (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_update_aux_string (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_update_lookup_table (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_commit_string (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_forward_key_event (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_register_properties (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_update_property	 (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_beep (PyIMEngineObject *self);
	static PyObject *py_start_helper (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_stop_helper (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_send_helper_event (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_get_surrounding_text (PyIMEngineObject *self, PyObject *args);
	static PyObject *py_delete_surrounding_text (PyIMEngineObject *self, PyObject *args);

	static PyObject *py_new (PyTypeObject *type, PyObject *args, PyObject *kwds);
	static int py_init (PyIMEngineObject *self, PyObject *args, PyObject *kwds);
	static void py_dealloc (PyIMEngineObject *self);

	static IMEngineInstanceBase *from_pyobject (PyObject *object);
	static PyMethodDef py_methods[];

public:
	static void operator delete (void *p);
};

void init_engine (PyObject *module);

#endif /*__SCIM_PYTHON_ENGINE_H_*/
