# -*- coding: utf-8 -*-
# vim:set noet ts=4:
#
# scim-python
#
# Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License
#
# This library is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not
# Free Software Foundation
# Boston
#
# $Id: $
#

SC_TO_TC_DICT = {
	u"¨": u"‥", u"―": u"─", u"‖": u"∥", u"″": u"〞",
	u"∏": u"Π", u"∑": u"Σ", u"∧": u"︿", u"∨": u"﹀",
	u"∶": u"︰", u"≈": u"≒", u"≤": u"≦", u"≥": u"≧",
	u"━": u"─", u"┃": u"│", u"┏": u"┌", u"┓": u"┐",
	u"┗": u"└", u"┛": u"┘", u"┣": u"├", u"┫": u"┤",
	u"┳": u"┬", u"┻": u"┴", u"╋": u"┼", u"・": u"·",
	u"万": u"萬", u"与": u"與", u"丑": u"醜", u"专": u"專",
	u"业": u"業", u"丛": u"叢", u"东": u"東", u"丝": u"絲",
	u"丢": u"丟", u"两": u"兩", u"严": u"嚴", u"丧": u"喪",
	u"个": u"個", u"丬": u"爿", u"丰": u"豐", u"临": u"臨",
	u"为": u"為", u"丽": u"麗", u"举": u"舉", u"么": u"麼",
	u"义": u"義", u"乌": u"烏", u"乐": u"樂", u"乔": u"喬",
	u"习": u"習", u"乡": u"鄉", u"书": u"書", u"买": u"買",
	u"乱": u"亂", u"争": u"爭", u"亏": u"虧", u"云": u"雲",
	u"亘": u"亙", u"亚": u"亞", u"产": u"產", u"亩": u"畝",
	u"亲": u"親", u"亵": u"褻", u"亻": u"人", u"亿": u"億",
	u"仅": u"僅", u"仆": u"僕", u"从": u"從", u"仑": u"侖",
	u"仓": u"倉", u"仪": u"儀", u"们": u"們", u"价": u"價",
	u"众": u"眾", u"优": u"優", u"会": u"會", u"伛": u"傴",
	u"伞": u"傘", u"伟": u"偉", u"传": u"傳", u"伤": u"傷",
	u"伥": u"倀", u"伦": u"倫", u"伧": u"傖", u"伪": u"偽",
	u"伫": u"佇", u"伲": u"你", u"体": u"體", u"余": u"餘",
	u"佣": u"傭", u"佥": u"僉", u"侄": u"姪", u"侠": u"俠",
	u"侣": u"侶", u"侥": u"僥", u"侦": u"偵", u"侧": u"側",
	u"侨": u"僑", u"侩": u"儈", u"侪": u"儕", u"侬": u"儂",
	u"俣": u"俁", u"俦": u"儔", u"俨": u"儼", u"俩": u"倆",
	u"俪": u"儷", u"俭": u"儉", u"倮": u"裸", u"债": u"債",
	u"倾": u"傾", u"偬": u"傯", u"偻": u"僂", u"偾": u"僨",
	u"偿": u"償", u"傥": u"儻", u"傧": u"儐", u"储": u"儲",
	u"傩": u"儺", u"儿": u"兒", u"兑": u"兌", u"兖": u"兗",
	u"党": u"黨", u"兰": u"蘭", u"关": u"關", u"兴": u"興",
	u"兹": u"茲", u"养": u"養", u"兽": u"獸", u"冁": u"囅",
	u"内": u"內", u"冈": u"岡", u"册": u"冊", u"写": u"寫",
	u"军": u"軍", u"农": u"農", u"冢": u"塚", u"冯": u"馮",
	u"冲": u"衝", u"决": u"決", u"况": u"況", u"冻": u"凍",
	u"净": u"淨", u"凄": u"淒", u"准": u"準", u"凇": u"淞",
	u"凉": u"涼", u"减": u"減", u"凑": u"湊", u"凛": u"凜",
	u"几": u"幾", u"凤": u"鳳", u"凫": u"鳧", u"凭": u"憑",
	u"凯": u"凱", u"凶": u"兇", u"击": u"擊", u"凼": u"幽",
	u"凿": u"鑿", u"刂": u"刀", u"刍": u"芻", u"划": u"劃",
	u"刘": u"劉", u"则": u"則", u"刚": u"剛", u"创": u"創",
	u"删": u"刪", u"别": u"別", u"刭": u"剄", u"刹": u"剎",
	u"刽": u"劊", u"刿": u"劌", u"剀": u"剴", u"剂": u"劑",
	u"剐": u"剮", u"剑": u"劍", u"剥": u"剝", u"剧": u"劇",
	u"剿": u"勦", u"劝": u"勸", u"办": u"辦", u"务": u"務",
	u"劢": u"勱", u"动": u"動", u"励": u"勵", u"劲": u"勁",
	u"劳": u"勞", u"势": u"勢", u"勋": u"勳", u"勖": u"勗",
	u"匀": u"勻", u"匦": u"匭", u"匮": u"匱", u"区": u"區",
	u"医": u"醫", u"华": u"華", u"协": u"協", u"单": u"單",
	u"卖": u"賣", u"占": u"佔", u"卢": u"盧", u"卤": u"滷",
	u"卧": u"臥", u"卩": u"部", u"卫": u"衛", u"却": u"卻",
	u"卺": u"巹", u"厂": u"廠", u"厅": u"廳", u"历": u"歷",
	u"厉": u"厲", u"压": u"壓", u"厌": u"厭", u"厍": u"厙",
	u"厕": u"廁", u"厘": u"釐", u"厢": u"廂", u"厣": u"厴",
	u"厦": u"廈", u"厨": u"廚", u"厩": u"廄", u"厮": u"廝",
	u"厶": u"私", u"县": u"縣", u"叁": u"參", u"参": u"參",
	u"双": u"雙", u"发": u"發", u"变": u"變", u"叙": u"敘",
	u"叠": u"疊", u"叶": u"葉", u"号": u"號", u"叹": u"嘆",
	u"叽": u"嘰", u"吁": u"籲", u"后": u"後", u"吓": u"嚇",
	u"吕": u"呂", u"吗": u"嗎", u"吨": u"噸", u"听": u"聽",
	u"启": u"啟", u"吴": u"吳", u"呐": u"吶", u"呒": u"嘸",
	u"呓": u"囈", u"呕": u"嘔", u"呖": u"嚦", u"呗": u"唄",
	u"员": u"員", u"呙": u"咼", u"呛": u"嗆", u"呜": u"嗚",
	u"周": u"週", u"咏": u"詠", u"咙": u"嚨", u"咛": u"嚀",
	u"咸": u"鹹", u"哌": u"呱", u"响": u"響", u"哑": u"啞",
	u"哒": u"噠", u"哓": u"嘵", u"哔": u"嗶", u"哕": u"噦",
	u"哗": u"嘩", u"哙": u"噲", u"哜": u"嚌", u"哝": u"噥",
	u"哟": u"喲", u"唛": u"嘜", u"唠": u"嘮", u"唢": u"嗩",
	u"唤": u"喚", u"啧": u"嘖", u"啬": u"嗇", u"啭": u"囀",
	u"啮": u"囓", u"啸": u"嘯", u"喷": u"噴", u"喽": u"嘍",
	u"喾": u"嚳", u"嗫": u"囁", u"嗬": u"呵", u"嗳": u"噯",
	u"嘘": u"噓", u"嘤": u"嚶", u"嘱": u"囑", u"噜": u"嚕",
	u"嚣": u"囂", u"团": u"團", u"园": u"園", u"囱": u"囪",
	u"围": u"圍", u"囵": u"圇", u"国": u"國", u"图": u"圖",
	u"圆": u"圓", u"圣": u"聖", u"圹": u"壙", u"场": u"場",
	u"坂": u"阪", u"坏": u"壞", u"块": u"塊", u"坚": u"堅",
	u"坛": u"壇", u"坜": u"壢", u"坝": u"壩", u"坞": u"塢",
	u"坟": u"墳", u"坠": u"墜", u"垄": u"壟", u"垅": u"壟",
	u"垆": u"壚", u"垒": u"壘", u"垦": u"墾", u"垩": u"堊",
	u"垫": u"墊", u"垭": u"埡", u"垲": u"塏", u"埘": u"塒",
	u"埙": u"壎", u"埚": u"堝", u"堑": u"塹", u"堕": u"墮",
	u"墒": u"墑", u"墙": u"牆", u"壮": u"壯", u"声": u"聲",
	u"壳": u"殼", u"壶": u"壺", u"处": u"處", u"备": u"備",
	u"复": u"復", u"够": u"夠", u"头": u"頭", u"夸": u"誇",
	u"夹": u"夾", u"夺": u"奪", u"奁": u"奩", u"奂": u"奐",
	u"奋": u"奮", u"奖": u"獎", u"奥": u"奧", u"妆": u"妝",
	u"妇": u"婦", u"妈": u"媽", u"妩": u"嫵", u"妪": u"嫗",
	u"妫": u"媯", u"姗": u"姍", u"娄": u"婁", u"娅": u"婭",
	u"娆": u"嬈", u"娇": u"嬌", u"娈": u"孌", u"娱": u"娛",
	u"娲": u"媧", u"娴": u"嫻", u"婴": u"嬰", u"婵": u"嬋",
	u"婶": u"嬸", u"媪": u"媼", u"嫒": u"嬡", u"嫔": u"嬪",
	u"嫱": u"嬙", u"嬷": u"嬤", u"孙": u"孫", u"学": u"學",
	u"孪": u"孿", u"宁": u"寧", u"宝": u"寶", u"实": u"實",
	u"宠": u"寵", u"审": u"審", u"宪": u"憲", u"宫": u"宮",
	u"宽": u"寬", u"宾": u"賓", u"寝": u"寢", u"对": u"對",
	u"寻": u"尋", u"导": u"導", u"寿": u"壽", u"将": u"將",
	u"尔": u"爾", u"尘": u"塵", u"尜": u"嘎", u"尝": u"嘗",
	u"尧": u"堯", u"尴": u"尷", u"尸": u"屍", u"尽": u"盡",
	u"层": u"層", u"屉": u"屜", u"届": u"屆", u"属": u"屬",
	u"屡": u"屢", u"屦": u"屨", u"屿": u"嶼", u"岁": u"歲",
	u"岂": u"豈", u"岖": u"嶇", u"岗": u"崗", u"岘": u"峴",
	u"岚": u"嵐", u"岛": u"島", u"岭": u"嶺", u"岽": u"崠",
	u"岿": u"巋", u"峄": u"嶧", u"峡": u"峽", u"峤": u"嶠",
	u"峥": u"崢", u"峦": u"巒", u"崂": u"嶗", u"崃": u"崍",
	u"崭": u"嶄", u"嵘": u"嶸", u"嵛": u"崳", u"嵝": u"嶁",
	u"巅": u"巔", u"巩": u"鞏", u"巯": u"巰", u"币": u"幣",
	u"帅": u"帥", u"师": u"師", u"帏": u"幃", u"帐": u"帳",
	u"帘": u"簾", u"帜": u"幟", u"带": u"帶", u"帧": u"幀",
	u"帮": u"幫", u"帱": u"幬", u"帻": u"幘", u"帼": u"幗",
	u"幂": u"冪", u"干": u"幹", u"并": u"並", u"幺": u"么",
	u"广": u"廣", u"庄": u"莊", u"庆": u"慶", u"庐": u"廬",
	u"庑": u"廡", u"库": u"庫", u"应": u"應", u"庙": u"廟",
	u"庞": u"龐", u"废": u"廢", u"廪": u"廩", u"开": u"開",
	u"异": u"異", u"弃": u"棄", u"弑": u"弒", u"张": u"張",
	u"弥": u"彌", u"弪": u"弳", u"弯": u"彎", u"弹": u"彈",
	u"强": u"強", u"归": u"歸", u"当": u"當", u"录": u"錄",
	u"彦": u"彥", u"彻": u"徹", u"径": u"徑", u"徕": u"徠",
	u"御": u"禦", u"忄": u"心", u"忆": u"憶", u"忏": u"懺",
	u"忧": u"憂", u"忾": u"愾", u"怀": u"懷", u"态": u"態",
	u"怂": u"慫", u"怃": u"憮", u"怄": u"慪", u"怅": u"悵",
	u"怆": u"愴", u"怜": u"憐", u"总": u"總", u"怼": u"懟",
	u"怿": u"懌", u"恋": u"戀", u"恒": u"恆", u"恳": u"懇",
	u"恶": u"惡", u"恸": u"慟", u"恹": u"懨", u"恺": u"愷",
	u"恻": u"惻", u"恼": u"惱", u"恽": u"惲", u"悦": u"悅",
	u"悫": u"愨", u"悬": u"懸", u"悭": u"慳", u"悯": u"憫",
	u"惊": u"驚", u"惧": u"懼", u"惨": u"慘", u"惩": u"懲",
	u"惫": u"憊", u"惬": u"愜", u"惭": u"慚", u"惮": u"憚",
	u"惯": u"慣", u"愠": u"慍", u"愤": u"憤", u"愦": u"憒",
	u"愿": u"願", u"慑": u"懾", u"懑": u"懣", u"懒": u"懶",
	u"懔": u"懍", u"戆": u"戇", u"戋": u"戔", u"戏": u"戲",
	u"戗": u"戧", u"战": u"戰", u"戬": u"戩", u"户": u"戶",
	u"扌": u"手", u"扑": u"撲", u"托": u"託", u"执": u"執",
	u"扩": u"擴", u"扪": u"捫", u"扫": u"掃", u"扬": u"揚",
	u"扰": u"擾", u"抚": u"撫", u"抛": u"拋", u"抟": u"摶",
	u"抠": u"摳", u"抡": u"掄", u"抢": u"搶", u"护": u"護",
	u"报": u"報", u"担": u"擔", u"拟": u"擬", u"拢": u"攏",
	u"拣": u"揀", u"拥": u"擁", u"拦": u"攔", u"拧": u"擰",
	u"拨": u"撥", u"择": u"擇", u"挂": u"掛", u"挚": u"摯",
	u"挛": u"攣", u"挝": u"撾", u"挞": u"撻", u"挟": u"挾",
	u"挠": u"撓", u"挡": u"擋", u"挢": u"撟", u"挣": u"掙",
	u"挤": u"擠", u"挥": u"揮", u"捂": u"摀", u"捞": u"撈",
	u"损": u"損", u"捡": u"撿", u"换": u"換", u"捣": u"搗",
	u"据": u"據", u"掳": u"擄", u"掴": u"摑", u"掷": u"擲",
	u"掸": u"撢", u"掺": u"摻", u"掼": u"摜", u"揽": u"攬",
	u"揿": u"撳", u"搀": u"攙", u"搁": u"擱", u"搂": u"摟",
	u"搅": u"攪", u"携": u"攜", u"摄": u"攝", u"摅": u"攄",
	u"摆": u"擺", u"摇": u"搖", u"摈": u"擯", u"摊": u"攤",
	u"撄": u"攖", u"撑": u"撐", u"撵": u"攆", u"撷": u"擷",
	u"撸": u"擼", u"撺": u"攛", u"擀": u"搟", u"擞": u"擻",
	u"攒": u"攢", u"攴": u"撲", u"敌": u"敵", u"敛": u"斂",
	u"数": u"數", u"斋": u"齋", u"斓": u"斕", u"斗": u"鬥",
	u"斩": u"斬", u"断": u"斷", u"无": u"無", u"旧": u"舊",
	u"时": u"時", u"旷": u"曠", u"昙": u"曇", u"昵": u"暱",
	u"昼": u"晝", u"显": u"顯", u"晋": u"晉", u"晒": u"曬",
	u"晓": u"曉", u"晔": u"曄", u"晕": u"暈", u"晖": u"暉",
	u"暂": u"暫", u"暧": u"曖", u"朐": u"胊", u"术": u"術",
	u"朴": u"樸", u"机": u"機", u"杀": u"殺", u"杂": u"雜",
	u"权": u"權", u"杆": u"桿", u"杠": u"槓", u"条": u"條",
	u"来": u"來", u"杨": u"楊", u"杩": u"榪", u"杰": u"傑",
	u"松": u"鬆", u"极": u"極", u"构": u"構", u"枞": u"樅",
	u"枢": u"樞", u"枣": u"棗", u"枥": u"櫪", u"枨": u"棖",
	u"枪": u"槍", u"枫": u"楓", u"枭": u"梟", u"柜": u"櫃",
	u"柠": u"檸", u"柽": u"檉", u"栀": u"梔", u"栅": u"柵",
	u"标": u"標", u"栈": u"棧", u"栉": u"櫛", u"栊": u"櫳",
	u"栋": u"棟", u"栌": u"櫨", u"栎": u"櫟", u"栏": u"欄",
	u"树": u"樹", u"栖": u"棲", u"样": u"樣", u"栾": u"欒",
	u"桠": u"椏", u"桡": u"橈", u"桢": u"楨", u"档": u"檔",
	u"桤": u"榿", u"桥": u"橋", u"桦": u"樺", u"桧": u"檜",
	u"桨": u"槳", u"桩": u"樁", u"梦": u"夢", u"检": u"檢",
	u"棂": u"櫺", u"棰": u"箠", u"棱": u"稜", u"椁": u"槨",
	u"椟": u"櫝", u"椠": u"槧", u"椤": u"欏", u"椭": u"橢",
	u"楼": u"樓", u"榄": u"欖", u"榇": u"櫬", u"榈": u"櫚",
	u"榉": u"櫸", u"榘": u"矩", u"槛": u"檻", u"槟": u"檳",
	u"槠": u"櫧", u"横": u"橫", u"樯": u"檣", u"樱": u"櫻",
	u"橥": u"櫫", u"橱": u"櫥", u"橹": u"櫓", u"橼": u"櫞",
	u"檐": u"簷", u"檩": u"檁", u"欢": u"歡", u"欤": u"歟",
	u"欧": u"歐", u"歼": u"殲", u"殁": u"歿", u"殇": u"殤",
	u"残": u"殘", u"殒": u"殞", u"殓": u"殮", u"殚": u"殫",
	u"殡": u"殯", u"殴": u"毆", u"毁": u"毀", u"毂": u"轂",
	u"毕": u"畢", u"毙": u"斃", u"毡": u"氈", u"毵": u"毿",
	u"氇": u"氌", u"气": u"氣", u"氢": u"氫", u"氩": u"氬",
	u"氲": u"氳", u"氵": u"水", u"氽": u"汆", u"汇": u"匯",
	u"汉": u"漢", u"汤": u"湯", u"汹": u"洶", u"沟": u"溝",
	u"没": u"沒", u"沣": u"灃", u"沤": u"漚", u"沥": u"瀝",
	u"沦": u"淪", u"沧": u"滄", u"沩": u"溈", u"沪": u"滬",
	u"沲": u"沱", u"泄": u"洩", u"泞": u"濘", u"泪": u"淚",
	u"泶": u"澩", u"泷": u"瀧", u"泸": u"瀘", u"泺": u"濼",
	u"泻": u"瀉", u"泼": u"潑", u"泽": u"澤", u"泾": u"涇",
	u"洁": u"潔", u"洒": u"灑", u"洼": u"窪", u"浃": u"浹",
	u"浅": u"淺", u"浆": u"漿", u"浇": u"澆", u"浈": u"湞",
	u"浊": u"濁", u"测": u"測", u"浍": u"澮", u"济": u"濟",
	u"浏": u"瀏", u"浑": u"渾", u"浒": u"滸", u"浓": u"濃",
	u"浔": u"潯", u"浜": u"濱", u"涂": u"塗", u"涌": u"湧",
	u"涛": u"濤", u"涝": u"澇", u"涞": u"淶", u"涟": u"漣",
	u"涠": u"潿", u"涡": u"渦", u"涣": u"渙", u"涤": u"滌",
	u"润": u"潤", u"涧": u"澗", u"涨": u"漲", u"涩": u"澀",
	u"淀": u"澱", u"渊": u"淵", u"渌": u"淥", u"渍": u"漬",
	u"渎": u"瀆", u"渐": u"漸", u"渑": u"澠", u"渔": u"漁",
	u"渖": u"瀋", u"渗": u"滲", u"温": u"溫", u"游": u"遊",
	u"湾": u"灣", u"湿": u"濕", u"溃": u"潰", u"溅": u"濺",
	u"溆": u"漵", u"滗": u"潷", u"滚": u"滾", u"滞": u"滯",
	u"滟": u"灩", u"滠": u"灄", u"满": u"滿", u"滢": u"瀅",
	u"滤": u"濾", u"滥": u"濫", u"滦": u"灤", u"滨": u"濱",
	u"滩": u"灘", u"潆": u"瀠", u"潇": u"瀟", u"潋": u"瀲",
	u"潍": u"濰", u"潜": u"潛", u"潴": u"瀦", u"澜": u"瀾",
	u"濑": u"瀨", u"濒": u"瀕", u"灏": u"灝", u"灬": u"火",
	u"灭": u"滅", u"灯": u"燈", u"灵": u"靈", u"灾": u"災",
	u"灿": u"燦", u"炀": u"煬", u"炉": u"爐", u"炖": u"燉",
	u"炜": u"煒", u"炝": u"熗", u"炮": u"砲", u"点": u"點",
	u"炼": u"鍊", u"炽": u"熾", u"烁": u"爍", u"烂": u"爛",
	u"烃": u"烴", u"烛": u"燭", u"烟": u"煙", u"烦": u"煩",
	u"烧": u"燒", u"烨": u"燁", u"烩": u"燴", u"烫": u"燙",
	u"烬": u"燼", u"热": u"熱", u"焕": u"煥", u"焖": u"燜",
	u"焘": u"燾", u"焰": u"燄", u"煅": u"鍛", u"熏": u"燻",
	u"爱": u"愛", u"爷": u"爺", u"牍": u"牘", u"牦": u"犛",
	u"牵": u"牽", u"牺": u"犧", u"犊": u"犢", u"犭": u"犬",
	u"状": u"狀", u"犷": u"獷", u"犹": u"猶", u"狈": u"狽",
	u"狞": u"獰", u"独": u"獨", u"狭": u"狹", u"狮": u"獅",
	u"狯": u"獪", u"狰": u"猙", u"狱": u"獄", u"狲": u"猻",
	u"猃": u"獫", u"猎": u"獵", u"猕": u"獼", u"猡": u"玀",
	u"猪": u"豬", u"猫": u"貓", u"猬": u"蝟", u"献": u"獻",
	u"獭": u"獺", u"玑": u"璣", u"玛": u"瑪", u"玮": u"瑋",
	u"环": u"環", u"现": u"現", u"玺": u"璽", u"珉": u"玟",
	u"珏": u"玨", u"珐": u"琺", u"珑": u"瓏", u"珲": u"琿",
	u"琏": u"璉", u"琐": u"瑣", u"琼": u"瓊", u"瑶": u"瑤",
	u"瑷": u"璦", u"璎": u"瓔", u"瓒": u"瓚", u"瓮": u"甕",
	u"瓯": u"甌", u"电": u"電", u"画": u"畫", u"畅": u"暢",
	u"畲": u"畬", u"畴": u"疇", u"疖": u"癤", u"疗": u"療",
	u"疟": u"瘧", u"疠": u"癘", u"疡": u"瘍", u"疮": u"瘡",
	u"疯": u"瘋", u"疱": u"皰", u"疴": u"痾", u"痈": u"癰",
	u"痉": u"痙", u"痒": u"癢", u"痨": u"癆", u"痪": u"瘓",
	u"痫": u"癇", u"痴": u"癡", u"痹": u"痺", u"瘅": u"癉",
	u"瘗": u"瘞", u"瘘": u"瘺", u"瘪": u"癟", u"瘫": u"癱",
	u"瘾": u"癮", u"瘿": u"癭", u"癞": u"癩", u"癣": u"癬",
	u"癫": u"癲", u"皑": u"皚", u"皱": u"皺", u"皲": u"皸",
	u"盏": u"盞", u"盐": u"鹽", u"监": u"監", u"盖": u"蓋",
	u"盗": u"盜", u"盘": u"盤", u"眦": u"眥", u"眯": u"瞇",
	u"着": u"著", u"睁": u"睜", u"睐": u"睞", u"睑": u"瞼",
	u"睾": u"睪", u"睿": u"叡", u"瞒": u"瞞", u"瞩": u"矚",
	u"矫": u"矯", u"矶": u"磯", u"矾": u"礬", u"矿": u"礦",
	u"砀": u"碭", u"码": u"碼", u"砖": u"磚", u"砗": u"硨",
	u"砚": u"硯", u"砺": u"礪", u"砻": u"礱", u"砾": u"礫",
	u"础": u"礎", u"硕": u"碩", u"硖": u"硤", u"硗": u"磽",
	u"确": u"確", u"硷": u"鹼", u"碍": u"礙", u"碛": u"磧",
	u"碜": u"磣", u"碱": u"堿", u"礴": u"礡", u"礻": u"示",
	u"礼": u"禮", u"祛": u"袪", u"祢": u"禰", u"祯": u"禎",
	u"祷": u"禱", u"祸": u"禍", u"禀": u"稟", u"禄": u"祿",
	u"禅": u"禪", u"离": u"離", u"秃": u"禿", u"秆": u"稈",
	u"种": u"種", u"积": u"積", u"称": u"稱", u"秽": u"穢",
	u"税": u"稅", u"稣": u"穌", u"稳": u"穩", u"穑": u"穡",
	u"穷": u"窮", u"窃": u"竊", u"窍": u"竅", u"窑": u"窯",
	u"窜": u"竄", u"窝": u"窩", u"窥": u"窺", u"窦": u"竇",
	u"窭": u"窶", u"竖": u"豎", u"竞": u"競", u"笃": u"篤",
	u"笋": u"筍", u"笔": u"筆", u"笕": u"筧", u"笺": u"箋",
	u"笼": u"籠", u"笾": u"籩", u"筇": u"笻", u"筑": u"築",
	u"筚": u"篳", u"筛": u"篩", u"筝": u"箏", u"筱": u"篠",
	u"筹": u"籌", u"签": u"簽", u"简": u"簡", u"箦": u"簀",
	u"箧": u"篋", u"箨": u"籜", u"箩": u"籮", u"箪": u"簞",
	u"箫": u"簫", u"篑": u"簣", u"篓": u"簍", u"篮": u"籃",
	u"篱": u"籬", u"簖": u"籪", u"籁": u"籟", u"籴": u"糴",
	u"类": u"類", u"籼": u"秈", u"粜": u"糶", u"粝": u"糲",
	u"粤": u"粵", u"粪": u"糞", u"粮": u"糧", u"糁": u"糝",
	u"糇": u"餱", u"糍": u"餈", u"紧": u"緊", u"絷": u"縶",
	u"纟": u"絲", u"纠": u"糾", u"纡": u"紆", u"红": u"紅",
	u"纣": u"紂", u"纤": u"纖", u"纥": u"紇", u"约": u"約",
	u"级": u"級", u"纨": u"紈", u"纩": u"纊", u"纪": u"紀",
	u"纫": u"紉", u"纬": u"緯", u"纭": u"紜", u"纯": u"純",
	u"纰": u"紕", u"纱": u"紗", u"纲": u"綱", u"纳": u"納",
	u"纵": u"縱", u"纶": u"綸", u"纷": u"紛", u"纸": u"紙",
	u"纹": u"紋", u"纺": u"紡", u"纽": u"紐", u"纾": u"紓",
	u"线": u"線", u"绀": u"紺", u"绁": u"紲", u"绂": u"紱",
	u"练": u"練", u"组": u"組", u"绅": u"紳", u"细": u"細",
	u"织": u"織", u"终": u"終", u"绉": u"縐", u"绊": u"絆",
	u"绋": u"紼", u"绌": u"絀", u"绍": u"紹", u"绎": u"繹",
	u"经": u"經", u"绐": u"紿", u"绑": u"綁", u"绒": u"絨",
	u"结": u"結", u"绔": u"褲", u"绕": u"繞", u"绗": u"絎",
	u"绘": u"繪", u"给": u"給", u"绚": u"絢", u"绛": u"絳",
	u"络": u"絡", u"绝": u"絕", u"绞": u"絞", u"统": u"統",
	u"绠": u"綆", u"绡": u"綃", u"绢": u"絹", u"绣": u"繡",
	u"绥": u"綏", u"绦": u"絛", u"继": u"繼", u"绨": u"綈",
	u"绩": u"績", u"绪": u"緒", u"绫": u"綾", u"续": u"續",
	u"绮": u"綺", u"绯": u"緋", u"绰": u"綽", u"绲": u"緄",
	u"绳": u"繩", u"维": u"維", u"绵": u"綿", u"绶": u"綬",
	u"绷": u"繃", u"绸": u"綢", u"绺": u"綹", u"绻": u"綣",
	u"综": u"綜", u"绽": u"綻", u"绾": u"綰", u"绿": u"綠",
	u"缀": u"綴", u"缁": u"緇", u"缂": u"緙", u"缃": u"緗",
	u"缄": u"緘", u"缅": u"緬", u"缆": u"纜", u"缇": u"緹",
	u"缈": u"緲", u"缉": u"緝", u"缋": u"繢", u"缌": u"緦",
	u"缍": u"綞", u"缎": u"緞", u"缏": u"緶", u"缑": u"緱",
	u"缒": u"縋", u"缓": u"緩", u"缔": u"締", u"缕": u"縷",
	u"编": u"編", u"缗": u"緡", u"缘": u"緣", u"缙": u"縉",
	u"缚": u"縛", u"缛": u"縟", u"缜": u"縝", u"缝": u"縫",
	u"缟": u"縞", u"缠": u"纏", u"缡": u"縭", u"缢": u"縊",
	u"缣": u"縑", u"缤": u"繽", u"缥": u"縹", u"缦": u"縵",
	u"缧": u"縲", u"缨": u"纓", u"缩": u"縮", u"缪": u"繆",
	u"缫": u"繅", u"缬": u"纈", u"缭": u"繚", u"缮": u"繕",
	u"缯": u"繒", u"缰": u"韁", u"缱": u"繾", u"缲": u"繰",
	u"缳": u"繯", u"缴": u"繳", u"缵": u"纘", u"罂": u"罌",
	u"网": u"網", u"罗": u"羅", u"罚": u"罰", u"罢": u"罷",
	u"罴": u"羆", u"羁": u"羈", u"羟": u"羥", u"羡": u"羨",
	u"翘": u"翹", u"耧": u"耬", u"耸": u"聳", u"耻": u"恥",
	u"聂": u"聶", u"聋": u"聾", u"职": u"職", u"聍": u"聹",
	u"联": u"聯", u"聩": u"聵", u"聪": u"聰", u"肀": u"聿",
	u"肃": u"肅", u"肠": u"腸", u"肤": u"膚", u"肮": u"骯",
	u"肴": u"餚", u"肾": u"腎", u"肿": u"腫", u"胀": u"脹",
	u"胁": u"脅", u"胄": u"冑", u"胆": u"膽", u"胜": u"勝",
	u"胧": u"朧", u"胪": u"臚", u"胫": u"脛", u"胶": u"膠",
	u"脉": u"脈", u"脍": u"膾", u"脏": u"髒", u"脐": u"臍",
	u"脑": u"腦", u"脓": u"膿", u"脔": u"臠", u"脚": u"腳",
	u"脱": u"脫", u"脲": u"尿", u"脶": u"腡", u"脸": u"臉",
	u"腊": u"臘", u"腌": u"醃", u"腭": u"齶", u"腻": u"膩",
	u"腼": u"靦", u"腽": u"膃", u"腾": u"騰", u"膑": u"臏",
	u"舆": u"輿", u"舣": u"艤", u"舰": u"艦", u"舱": u"艙",
	u"舻": u"艫", u"艰": u"艱", u"艳": u"豔", u"艹": u"艸",
	u"艺": u"藝", u"节": u"節", u"芈": u"羋", u"芗": u"薌",
	u"芜": u"蕪", u"芦": u"蘆", u"苁": u"蓯", u"苇": u"葦",
	u"苈": u"藶", u"苋": u"莧", u"苌": u"萇", u"苍": u"蒼",
	u"苎": u"苧", u"苏": u"蘇", u"苹": u"蘋", u"范": u"範",
	u"茎": u"莖", u"茏": u"蘢", u"茑": u"蔦", u"茔": u"塋",
	u"茕": u"煢", u"茧": u"繭", u"荆": u"荊", u"荐": u"薦",
	u"荚": u"莢", u"荛": u"蕘", u"荜": u"蓽", u"荞": u"蕎",
	u"荟": u"薈", u"荠": u"薺", u"荡": u"蕩", u"荣": u"榮",
	u"荤": u"葷", u"荥": u"滎", u"荦": u"犖", u"荧": u"熒",
	u"荨": u"蕁", u"荩": u"藎", u"荪": u"蓀", u"荫": u"蔭",
	u"荬": u"藚", u"荭": u"葒", u"药": u"藥", u"莅": u"蒞",
	u"莱": u"萊", u"莲": u"蓮", u"莳": u"蒔", u"莴": u"萵",
	u"莶": u"薟", u"获": u"獲", u"莸": u"蕕", u"莹": u"瑩",
	u"莺": u"鶯", u"莼": u"蓴", u"萝": u"蘿", u"萤": u"螢",
	u"营": u"營", u"萦": u"縈", u"萧": u"蕭", u"萨": u"薩",
	u"葱": u"蔥", u"蒇": u"蕆", u"蒉": u"蕢", u"蒋": u"蔣",
	u"蒌": u"蔞", u"蓑": u"簑", u"蓝": u"藍", u"蓟": u"薊",
	u"蓠": u"蘺", u"蓣": u"蕷", u"蓥": u"鎣", u"蓦": u"驀",
	u"蔷": u"薔", u"蔹": u"蘞", u"蔺": u"藺", u"蔼": u"藹",
	u"蕲": u"蘄", u"蕴": u"蘊", u"薮": u"藪", u"藓": u"蘚",
	u"蘖": u"蘗", u"虏": u"虜", u"虑": u"慮", u"虚": u"虛",
	u"虫": u"蟲", u"虬": u"虯", u"虮": u"蟣", u"虽": u"雖",
	u"虾": u"蝦", u"虿": u"蠆", u"蚀": u"蝕", u"蚁": u"蟻",
	u"蚂": u"螞", u"蚕": u"蠶", u"蚝": u"蠔", u"蚬": u"蜆",
	u"蛊": u"蠱", u"蛎": u"蠣", u"蛏": u"蟶", u"蛮": u"蠻",
	u"蛰": u"蟄", u"蛱": u"蛺", u"蛲": u"蟯", u"蛳": u"螄",
	u"蛴": u"蠐", u"蜕": u"蛻", u"蜗": u"蝸", u"蜡": u"蠟",
	u"蝇": u"蠅", u"蝈": u"蟈", u"蝉": u"蟬", u"蝎": u"蠍",
	u"蝰": u"虺", u"蝼": u"螻", u"蝾": u"蠑", u"蟮": u"蟺",
	u"衅": u"釁", u"衔": u"銜", u"衤": u"衣", u"补": u"補",
	u"衬": u"襯", u"衮": u"袞", u"袄": u"襖", u"袅": u"裊",
	u"袜": u"襪", u"袭": u"襲", u"装": u"裝", u"裆": u"襠",
	u"裢": u"褳", u"裣": u"襝", u"裤": u"褲", u"裥": u"襉",
	u"褛": u"褸", u"褴": u"襤", u"见": u"見", u"观": u"觀",
	u"规": u"規", u"觅": u"覓", u"视": u"視", u"觇": u"覘",
	u"览": u"覽", u"觉": u"覺", u"觊": u"覬", u"觋": u"覡",
	u"觌": u"覿", u"觎": u"覦", u"觏": u"覯", u"觐": u"覲",
	u"觑": u"覷", u"觞": u"觴", u"触": u"觸", u"觯": u"觶",
	u"誉": u"譽", u"誊": u"謄", u"讠": u"言", u"计": u"計",
	u"订": u"訂", u"讣": u"訃", u"认": u"認", u"讥": u"譏",
	u"讦": u"訐", u"讧": u"訌", u"讨": u"討", u"让": u"讓",
	u"讪": u"訕", u"讫": u"訖", u"训": u"訓", u"议": u"議",
	u"讯": u"訊", u"记": u"記", u"讲": u"講", u"讳": u"諱",
	u"讴": u"謳", u"讵": u"詎", u"讶": u"訝", u"讷": u"訥",
	u"许": u"許", u"讹": u"訛", u"论": u"論", u"讼": u"訟",
	u"讽": u"諷", u"设": u"設", u"访": u"訪", u"诀": u"訣",
	u"证": u"證", u"诂": u"詁", u"诃": u"訶", u"评": u"評",
	u"诅": u"詛", u"识": u"識", u"诈": u"詐", u"诉": u"訴",
	u"诊": u"診", u"诋": u"詆", u"诌": u"謅", u"词": u"詞",
	u"诎": u"詘", u"诏": u"詔", u"译": u"譯", u"诒": u"詒",
	u"诓": u"誆", u"诔": u"誄", u"试": u"試", u"诖": u"詿",
	u"诗": u"詩", u"诘": u"詰", u"诙": u"詼", u"诚": u"誠",
	u"诛": u"誅", u"诜": u"詵", u"话": u"話", u"诞": u"誕",
	u"诟": u"詬", u"诠": u"詮", u"诡": u"詭", u"询": u"詢",
	u"诣": u"詣", u"诤": u"諍", u"该": u"該", u"详": u"詳",
	u"诧": u"詫", u"诨": u"諢", u"诩": u"詡", u"诫": u"誡",
	u"诬": u"誣", u"语": u"語", u"诮": u"誚", u"误": u"誤",
	u"诰": u"誥", u"诱": u"誘", u"诲": u"誨", u"诳": u"誑",
	u"说": u"說", u"诵": u"誦", u"诶": u"誒", u"请": u"請",
	u"诸": u"諸", u"诹": u"諏", u"诺": u"諾", u"读": u"讀",
	u"诼": u"諑", u"诽": u"誹", u"课": u"課", u"诿": u"諉",
	u"谀": u"諛", u"谁": u"誰", u"谂": u"諗", u"调": u"調",
	u"谄": u"諂", u"谅": u"諒", u"谆": u"諄", u"谇": u"誶",
	u"谈": u"談", u"谊": u"誼", u"谋": u"謀", u"谌": u"諶",
	u"谍": u"諜", u"谎": u"謊", u"谏": u"諫", u"谐": u"諧",
	u"谑": u"謔", u"谒": u"謁", u"谓": u"謂", u"谔": u"諤",
	u"谕": u"諭", u"谖": u"諼", u"谗": u"讒", u"谘": u"諮",
	u"谙": u"諳", u"谚": u"諺", u"谛": u"諦", u"谜": u"謎",
	u"谝": u"諞", u"谟": u"謨", u"谠": u"讜", u"谡": u"謖",
	u"谢": u"謝", u"谣": u"謠", u"谤": u"謗", u"谥": u"謚",
	u"谦": u"謙", u"谧": u"謐", u"谨": u"謹", u"谩": u"謾",
	u"谪": u"謫", u"谫": u"譾", u"谬": u"謬", u"谭": u"譚",
	u"谮": u"譖", u"谯": u"譙", u"谰": u"讕", u"谱": u"譜",
	u"谲": u"譎", u"谳": u"讞", u"谴": u"譴", u"谵": u"譫",
	u"谶": u"讖", u"贝": u"貝", u"贞": u"貞", u"负": u"負",
	u"贡": u"貢", u"财": u"財", u"责": u"責", u"贤": u"賢",
	u"败": u"敗", u"账": u"賬", u"货": u"貨", u"质": u"質",
	u"贩": u"販", u"贪": u"貪", u"贫": u"貧", u"贬": u"貶",
	u"购": u"購", u"贮": u"貯", u"贯": u"貫", u"贰": u"貳",
	u"贱": u"賤", u"贲": u"賁", u"贳": u"貰", u"贴": u"貼",
	u"贵": u"貴", u"贶": u"貺", u"贷": u"貸", u"贸": u"貿",
	u"费": u"費", u"贺": u"賀", u"贻": u"貽", u"贼": u"賊",
	u"贽": u"贄", u"贾": u"賈", u"贿": u"賄", u"赀": u"貲",
	u"赁": u"賃", u"赂": u"賂", u"赃": u"贓", u"资": u"資",
	u"赅": u"賅", u"赆": u"贐", u"赇": u"賕", u"赈": u"賑",
	u"赉": u"賚", u"赊": u"賒", u"赋": u"賦", u"赌": u"賭",
	u"赍": u"齎", u"赎": u"贖", u"赏": u"賞", u"赐": u"賜",
	u"赓": u"賡", u"赔": u"賠", u"赕": u"賧", u"赖": u"賴",
	u"赘": u"贅", u"赙": u"賻", u"赚": u"賺", u"赛": u"賽",
	u"赜": u"賾", u"赝": u"贗", u"赞": u"贊", u"赠": u"贈",
	u"赡": u"贍", u"赢": u"贏", u"赣": u"贛", u"赵": u"趙",
	u"赶": u"趕", u"趋": u"趨", u"趱": u"趲", u"趸": u"躉",
	u"跃": u"躍", u"跄": u"蹌", u"跞": u"躒", u"践": u"踐",
	u"跷": u"蹺", u"跸": u"蹕", u"跹": u"躚", u"跻": u"躋",
	u"踊": u"踴", u"踌": u"躊", u"踪": u"蹤", u"踬": u"躓",
	u"踯": u"躑", u"蹑": u"躡", u"蹒": u"蹣", u"蹰": u"躕",
	u"蹿": u"躥", u"躏": u"躪", u"躜": u"躦", u"躯": u"軀",
	u"车": u"車", u"轧": u"軋", u"轨": u"軌", u"轩": u"軒",
	u"轫": u"軔", u"转": u"轉", u"轭": u"軛", u"轮": u"輪",
	u"软": u"軟", u"轰": u"轟", u"轲": u"軻", u"轳": u"轤",
	u"轴": u"軸", u"轵": u"軹", u"轶": u"軼", u"轸": u"軫",
	u"轹": u"轢", u"轺": u"軺", u"轻": u"輕", u"轼": u"軾",
	u"载": u"載", u"轾": u"輊", u"轿": u"轎", u"辁": u"輇",
	u"辂": u"輅", u"较": u"較", u"辄": u"輒", u"辅": u"輔",
	u"辆": u"輛", u"辇": u"輦", u"辈": u"輩", u"辉": u"輝",
	u"辊": u"輥", u"辋": u"輞", u"辍": u"輟", u"辎": u"輜",
	u"辏": u"輳", u"辐": u"輻", u"辑": u"輯", u"输": u"輸",
	u"辔": u"轡", u"辕": u"轅", u"辖": u"轄", u"辗": u"輾",
	u"辘": u"轆", u"辙": u"轍", u"辚": u"轔", u"辞": u"辭",
	u"辟": u"闢", u"辩": u"辯", u"辫": u"辮", u"边": u"邊",
	u"辽": u"遼", u"达": u"達", u"迁": u"遷", u"过": u"過",
	u"迈": u"邁", u"运": u"運", u"还": u"還", u"这": u"這",
	u"进": u"進", u"远": u"遠", u"违": u"違", u"连": u"連",
	u"迟": u"遲", u"迩": u"邇", u"迳": u"逕", u"迹": u"蹟",
	u"适": u"適", u"选": u"選", u"逊": u"遜", u"递": u"遞",
	u"逦": u"邐", u"逻": u"邏", u"遗": u"遺", u"遥": u"遙",
	u"邓": u"鄧", u"邝": u"鄺", u"邬": u"鄔", u"邮": u"郵",
	u"邹": u"鄒", u"邺": u"鄴", u"邻": u"鄰", u"郁": u"鬱",
	u"郄": u"隙", u"郏": u"郟", u"郐": u"鄶", u"郑": u"鄭",
	u"郓": u"鄆", u"郦": u"酈", u"郧": u"鄖", u"郸": u"鄲",
	u"酝": u"醞", u"酱": u"醬", u"酽": u"釅", u"酾": u"釃",
	u"酿": u"釀", u"采": u"採", u"释": u"釋", u"里": u"裡",
	u"鉴": u"鑑", u"銮": u"鑾", u"錾": u"鏨", u"钅": u"金",
	u"钆": u"釓", u"钇": u"釔", u"针": u"針", u"钉": u"釘",
	u"钊": u"釗", u"钋": u"釙", u"钌": u"釕", u"钍": u"釷",
	u"钎": u"釬", u"钏": u"釧", u"钐": u"釤", u"钒": u"釩",
	u"钓": u"釣", u"钔": u"鍆", u"钕": u"釹", u"钗": u"釵",
	u"钙": u"鈣", u"钛": u"鈦", u"钜": u"鉅", u"钝": u"鈍",
	u"钞": u"鈔", u"钟": u"鐘", u"钠": u"鈉", u"钡": u"鋇",
	u"钢": u"鋼", u"钣": u"鈑", u"钤": u"鈐", u"钥": u"鑰",
	u"钦": u"欽", u"钧": u"鈞", u"钨": u"鎢", u"钩": u"鉤",
	u"钪": u"鈧", u"钫": u"鈁", u"钬": u"鈥", u"钭": u"鈄",
	u"钮": u"鈕", u"钯": u"鈀", u"钰": u"鈺", u"钱": u"錢",
	u"钲": u"鉦", u"钳": u"鉗", u"钴": u"鈷", u"钵": u"缽",
	u"钶": u"鈳", u"钸": u"鈽", u"钹": u"鈸", u"钺": u"鉞",
	u"钻": u"鑽", u"钼": u"鉬", u"钽": u"鉭", u"钾": u"鉀",
	u"钿": u"鈿", u"铀": u"鈾", u"铁": u"鐵", u"铂": u"鉑",
	u"铃": u"鈴", u"铄": u"鑠", u"铅": u"鉛", u"铆": u"鉚",
	u"铈": u"鈰", u"铉": u"鉉", u"铊": u"鉈", u"铋": u"鉍",
	u"铌": u"鈮", u"铍": u"鈹", u"铎": u"鐸", u"铐": u"銬",
	u"铑": u"銠", u"铒": u"鉺", u"铕": u"銪", u"铖": u"鋮",
	u"铗": u"鋏", u"铙": u"鐃", u"铛": u"鐺", u"铜": u"銅",
	u"铝": u"鋁", u"铟": u"銦", u"铠": u"鎧", u"铡": u"鍘",
	u"铢": u"銖", u"铣": u"銑", u"铤": u"鋌", u"铥": u"銩",
	u"铧": u"鏵", u"铨": u"銓", u"铩": u"鎩", u"铪": u"鉿",
	u"铫": u"銚", u"铬": u"鉻", u"铭": u"銘", u"铮": u"錚",
	u"铯": u"銫", u"铰": u"鉸", u"铱": u"銥", u"铲": u"鏟",
	u"铳": u"銃", u"铴": u"鐋", u"铵": u"銨", u"银": u"銀",
	u"铷": u"銣", u"铸": u"鑄", u"铹": u"鐒", u"铺": u"鋪",
	u"铼": u"錸", u"铽": u"鋱", u"链": u"鏈", u"铿": u"鏗",
	u"销": u"銷", u"锁": u"鎖", u"锂": u"鋰", u"锄": u"鋤",
	u"锅": u"鍋", u"锆": u"鋯", u"锇": u"鋨", u"锈": u"鏽",
	u"锉": u"銼", u"锊": u"鋝", u"锋": u"鋒", u"锌": u"鋅",
	u"锐": u"銳", u"锑": u"銻", u"锒": u"鋃", u"锓": u"鋟",
	u"锔": u"鋦", u"锕": u"錒", u"锖": u"錆", u"锗": u"鍺",
	u"错": u"錯", u"锚": u"錨", u"锛": u"錛", u"锞": u"錁",
	u"锟": u"錕", u"锡": u"錫", u"锢": u"錮", u"锣": u"鑼",
	u"锤": u"鎚", u"锥": u"錐", u"锦": u"錦", u"锩": u"錈",
	u"锬": u"錟", u"锭": u"錠", u"键": u"鍵", u"锯": u"鋸",
	u"锰": u"錳", u"锱": u"錙", u"锲": u"鍥", u"锴": u"鍇",
	u"锵": u"鏘", u"锶": u"鍶", u"锷": u"鍔", u"锸": u"鍤",
	u"锹": u"鍬", u"锺": u"鍾", u"锻": u"鍛", u"锼": u"鎪",
	u"锾": u"鍰", u"镀": u"鍍", u"镁": u"鎂", u"镂": u"鏤",
	u"镄": u"鐨", u"镆": u"鏌", u"镇": u"鎮", u"镉": u"鎘",
	u"镊": u"鑷", u"镌": u"鐫", u"镍": u"鎳", u"镏": u"鎦",
	u"镐": u"鎬", u"镑": u"鎊", u"镒": u"鎰", u"镓": u"鎵",
	u"镔": u"鑌", u"镖": u"鏢", u"镗": u"鏜", u"镘": u"鏝",
	u"镙": u"鏍", u"镛": u"鏞", u"镜": u"鏡", u"镝": u"鏑",
	u"镞": u"鏃", u"镟": u"鏇", u"镡": u"鐔", u"镣": u"鐐",
	u"镤": u"鏷", u"镦": u"鐓", u"镧": u"鑭", u"镨": u"鐠",
	u"镪": u"鏹", u"镫": u"鐙", u"镬": u"鑊", u"镭": u"鐳",
	u"镯": u"鐲", u"镰": u"鐮", u"镱": u"鐿", u"镳": u"鑣",
	u"镶": u"鑲", u"长": u"長", u"门": u"門", u"闩": u"閂",
	u"闪": u"閃", u"闫": u"閆", u"闭": u"閉", u"问": u"問",
	u"闯": u"闖", u"闰": u"閏", u"闱": u"闈", u"闲": u"閒",
	u"闳": u"閎", u"间": u"間", u"闵": u"閔", u"闶": u"閌",
	u"闷": u"悶", u"闸": u"閘", u"闹": u"鬧", u"闺": u"閨",
	u"闻": u"聞", u"闼": u"闥", u"闽": u"閩", u"闾": u"閭",
	u"阀": u"閥", u"阁": u"閣", u"阂": u"閡", u"阃": u"閫",
	u"阄": u"鬮", u"阅": u"閱", u"阆": u"閬", u"阈": u"閾",
	u"阉": u"閹", u"阊": u"閶", u"阋": u"鬩", u"阌": u"閿",
	u"阍": u"閽", u"阎": u"閻", u"阏": u"閼", u"阐": u"闡",
	u"阑": u"闌", u"阒": u"闃", u"阔": u"闊", u"阕": u"闋",
	u"阖": u"闔", u"阗": u"闐", u"阙": u"闕", u"阚": u"闞",
	u"阝": u"阜", u"队": u"隊", u"阳": u"陽", u"阴": u"陰",
	u"阵": u"陣", u"阶": u"階", u"际": u"際", u"陆": u"陸",
	u"陇": u"隴", u"陈": u"陳", u"陉": u"陘", u"陕": u"陝",
	u"陧": u"隉", u"陨": u"隕", u"险": u"險", u"随": u"隨",
	u"隐": u"隱", u"隶": u"隸", u"隽": u"雋", u"难": u"難",
	u"雏": u"雛", u"雠": u"讎", u"雳": u"靂", u"雾": u"霧",
	u"霁": u"霽", u"霭": u"靄", u"靓": u"靚", u"静": u"靜",
	u"靥": u"靨", u"鞑": u"韃", u"鞒": u"橇", u"鞯": u"韉",
	u"韦": u"韋", u"韧": u"韌", u"韩": u"韓", u"韪": u"韙",
	u"韫": u"韞", u"韬": u"韜", u"韵": u"韻", u"页": u"頁",
	u"顶": u"頂", u"顷": u"頃", u"顸": u"頇", u"项": u"項",
	u"顺": u"順", u"须": u"須", u"顼": u"頊", u"顽": u"頑",
	u"顾": u"顧", u"顿": u"頓", u"颀": u"頎", u"颁": u"頒",
	u"颂": u"頌", u"颃": u"頏", u"预": u"預", u"颅": u"顱",
	u"领": u"領", u"颇": u"頗", u"颈": u"頸", u"颉": u"頡",
	u"颊": u"頰", u"颌": u"頜", u"颍": u"潁", u"颏": u"頦",
	u"颐": u"頤", u"频": u"頻", u"颓": u"頹", u"颔": u"頷",
	u"颖": u"穎", u"颗": u"顆", u"题": u"題", u"颚": u"顎",
	u"颛": u"顓", u"颜": u"顏", u"额": u"額", u"颞": u"顳",
	u"颟": u"顢", u"颠": u"顛", u"颡": u"顙", u"颢": u"顥",
	u"颤": u"顫", u"颦": u"顰", u"颧": u"顴", u"风": u"風",
	u"飑": u"颮", u"飒": u"颯", u"飓": u"颶", u"飕": u"颼",
	u"飘": u"飄", u"飙": u"飆", u"飞": u"飛", u"飨": u"饗",
	u"餍": u"饜", u"饣": u"食", u"饥": u"飢", u"饧": u"餳",
	u"饨": u"飩", u"饩": u"餼", u"饪": u"飪", u"饫": u"飫",
	u"饬": u"飭", u"饭": u"飯", u"饮": u"飲", u"饯": u"餞",
	u"饰": u"飾", u"饱": u"飽", u"饲": u"飼", u"饴": u"飴",
	u"饵": u"餌", u"饶": u"饒", u"饷": u"餉", u"饺": u"餃",
	u"饼": u"餅", u"饽": u"餑", u"饿": u"餓", u"馀": u"餘",
	u"馁": u"餒", u"馄": u"餛", u"馅": u"餡", u"馆": u"館",
	u"馈": u"饋", u"馊": u"餿", u"馋": u"饞", u"馍": u"糢",
	u"馏": u"餾", u"馐": u"饈", u"馑": u"饉", u"馒": u"饅",
	u"馔": u"饌", u"马": u"馬", u"驭": u"馭", u"驮": u"馱",
	u"驯": u"馴", u"驰": u"馳", u"驱": u"驅", u"驳": u"駁",
	u"驴": u"驢", u"驵": u"駔", u"驶": u"駛", u"驷": u"駟",
	u"驸": u"駙", u"驹": u"駒", u"驺": u"騶", u"驻": u"駐",
	u"驼": u"駝", u"驽": u"駑", u"驾": u"駕", u"驿": u"驛",
	u"骀": u"駘", u"骁": u"驍", u"骂": u"罵", u"骄": u"驕",
	u"骅": u"驊", u"骆": u"駱", u"骇": u"駭", u"骈": u"駢",
	u"骊": u"驪", u"骋": u"騁", u"验": u"驗", u"骏": u"駿",
	u"骐": u"騏", u"骑": u"騎", u"骒": u"騍", u"骓": u"騅",
	u"骖": u"驂", u"骗": u"騙", u"骘": u"騭", u"骚": u"騷",
	u"骛": u"騖", u"骜": u"驁", u"骝": u"騮", u"骞": u"騫",
	u"骟": u"騸", u"骠": u"驃", u"骡": u"騾", u"骢": u"驄",
	u"骣": u"驏", u"骤": u"驟", u"骥": u"驥", u"骧": u"驤",
	u"髅": u"髏", u"髋": u"髖", u"髌": u"髕", u"鬓": u"鬢",
	u"魇": u"魘", u"魉": u"魎", u"鱼": u"魚", u"鱿": u"魷",
	u"鲁": u"魯", u"鲂": u"魴", u"鲇": u"鯰", u"鲈": u"鱸",
	u"鲋": u"鮒", u"鲍": u"鮑", u"鲎": u"鱟", u"鲐": u"鮐",
	u"鲑": u"鮭", u"鲒": u"鮚", u"鲔": u"鮪", u"鲕": u"鮞",
	u"鲚": u"鱭", u"鲛": u"鮫", u"鲜": u"鮮", u"鲞": u"鯗",
	u"鲟": u"鱘", u"鲠": u"鯁", u"鲡": u"鱺", u"鲢": u"鰱",
	u"鲣": u"鰹", u"鲤": u"鯉", u"鲥": u"鰣", u"鲦": u"鰷",
	u"鲧": u"鯀", u"鲨": u"鯊", u"鲩": u"鯇", u"鲫": u"鯽",
	u"鲭": u"鯖", u"鲮": u"鯪", u"鲰": u"鯫", u"鲱": u"鯡",
	u"鲲": u"鯤", u"鲳": u"鯧", u"鲵": u"鯢", u"鲶": u"鯰",
	u"鲷": u"鯛", u"鲸": u"鯨", u"鲻": u"鯔", u"鲽": u"鰈",
	u"鳃": u"鰓", u"鳄": u"鱷", u"鳅": u"鰍", u"鳆": u"鰒",
	u"鳇": u"鰉", u"鳌": u"鰲", u"鳍": u"鰭", u"鳎": u"鰨",
	u"鳏": u"鰥", u"鳐": u"鰩", u"鳓": u"鰳", u"鳔": u"鰾",
	u"鳕": u"鱈", u"鳖": u"鱉", u"鳗": u"鰻", u"鳜": u"鱖",
	u"鳝": u"鱔", u"鳞": u"鱗", u"鳟": u"鱒", u"鳢": u"鱧",
	u"鸟": u"鳥", u"鸠": u"鳩", u"鸡": u"雞", u"鸢": u"鳶",
	u"鸣": u"鳴", u"鸥": u"鷗", u"鸦": u"鴉", u"鸨": u"鴇",
	u"鸩": u"鴆", u"鸪": u"鴣", u"鸫": u"鶇", u"鸬": u"鸕",
	u"鸭": u"鴨", u"鸯": u"鴦", u"鸱": u"鴟", u"鸲": u"鴝",
	u"鸳": u"鴛", u"鸵": u"鴕", u"鸶": u"鷥", u"鸷": u"鷙",
	u"鸸": u"鴯", u"鸹": u"鴰", u"鸺": u"鵂", u"鸽": u"鴿",
	u"鸾": u"鸞", u"鸿": u"鴻", u"鹁": u"鵓", u"鹂": u"鸝",
	u"鹃": u"鵑", u"鹄": u"鵠", u"鹅": u"鵝", u"鹆": u"鵒",
	u"鹇": u"鷴", u"鹈": u"鵜", u"鹉": u"鵡", u"鹊": u"鵲",
	u"鹌": u"鵪", u"鹎": u"鵯", u"鹏": u"鵬", u"鹑": u"鶉",
	u"鹕": u"鶘", u"鹗": u"鶚", u"鹘": u"鶻", u"鹚": u"鶿",
	u"鹜": u"鶩", u"鹞": u"鷂", u"鹣": u"鶼", u"鹤": u"鶴",
	u"鹦": u"鸚", u"鹧": u"鷓", u"鹨": u"鷚", u"鹩": u"鷯",
	u"鹪": u"鷦", u"鹫": u"鷲", u"鹬": u"鷸", u"鹭": u"鷺",
	u"鹰": u"鷹", u"鹳": u"鸛", u"鹾": u"鹺", u"麦": u"麥",
	u"麸": u"麩", u"麽": u"麼", u"黄": u"黃", u"黉": u"黌",
	u"黩": u"黷", u"黪": u"黲", u"黾": u"黽", u"鼋": u"黿",
	u"鼍": u"鼉", u"鼹": u"鼴", u"齐": u"齊", u"齑": u"齏",
	u"齿": u"齒", u"龀": u"齔", u"龃": u"齟", u"龄": u"齡",
	u"龅": u"齙", u"龆": u"齠", u"龇": u"齜", u"龈": u"齦",
	u"龉": u"齬", u"龊": u"齪", u"龋": u"齲", u"龌": u"齷",
	u"龙": u"龍", u"龚": u"龔", u"龛": u"龕", u"龟": u"龜",
	u"＂": u"〞", u"［": u"﹝", u"］": u"﹞", u"｀": u"‵",
}

TC_TO_SC_DICT = {
	u"¯": u"ˉ", u"·": u"・", u"Π": u"∏", u"Σ": u"∑",
	u"‥": u"¨", u"‧": u"・", u"‵": u"｀", u"∥": u"‖",
	u"≒": u"≈", u"≦": u"≤", u"≧": u"≥", u"─": u"―",
	u"╱": u"／", u"╲": u"＼", u"╴": u"＿", u"〝": u"＂",
	u"〞": u"″", u"丟": u"丢", u"並": u"并", u"丼": u"井",
	u"乾": u"干", u"亂": u"乱", u"亙": u"亘", u"亞": u"亚",
	u"伕": u"夫", u"佇": u"伫", u"佈": u"布", u"佔": u"占",
	u"佪": u"徊", u"併": u"并", u"來": u"来", u"侖": u"仑",
	u"侚": u"徇", u"侶": u"侣", u"侷": u"局", u"俁": u"俣",
	u"係": u"系", u"俠": u"侠", u"倀": u"伥", u"倆": u"俩",
	u"倉": u"仓", u"個": u"个", u"們": u"们", u"倖": u"幸",
	u"倣": u"仿", u"倫": u"伦", u"偉": u"伟", u"偪": u"逼",
	u"側": u"侧", u"偵": u"侦", u"偺": u"咱", u"偽": u"伪",
	u"傑": u"杰", u"傖": u"伧", u"傘": u"伞", u"備": u"备",
	u"傚": u"效", u"傢": u"家", u"傭": u"佣", u"傯": u"偬",
	u"傳": u"传", u"傴": u"伛", u"債": u"债", u"傷": u"伤",
	u"傾": u"倾", u"僂": u"偻", u"僅": u"仅", u"僉": u"佥",
	u"僊": u"仙", u"僑": u"侨", u"僕": u"仆", u"僣": u"僭",
	u"僥": u"侥", u"僨": u"偾", u"僱": u"雇", u"價": u"价",
	u"儀": u"仪", u"儂": u"侬", u"億": u"亿", u"儅": u"当",
	u"儈": u"侩", u"儉": u"俭", u"儐": u"傧", u"儔": u"俦",
	u"儕": u"侪", u"儘": u"尽", u"償": u"偿", u"優": u"优",
	u"儲": u"储", u"儷": u"俪", u"儸": u"罗", u"儺": u"傩",
	u"儻": u"傥", u"儼": u"俨", u"兇": u"凶", u"兌": u"兑",
	u"兒": u"儿", u"兗": u"兖", u"內": u"内", u"兩": u"两",
	u"冊": u"册", u"冑": u"胄", u"冪": u"幂", u"凅": u"涸",
	u"凈": u"净", u"凍": u"冻", u"凜": u"凛", u"凱": u"凯",
	u"別": u"别", u"刪": u"删", u"剄": u"刭", u"則": u"则",
	u"剉": u"锉", u"剋": u"克", u"剎": u"刹", u"剛": u"刚",
	u"剝": u"剥", u"剮": u"剐", u"剴": u"剀", u"創": u"创",
	u"剷": u"铲", u"劃": u"划", u"劄": u"札", u"劇": u"剧",
	u"劉": u"刘", u"劊": u"刽", u"劌": u"刿", u"劍": u"剑",
	u"劑": u"剂", u"劻": u"匡", u"勁": u"劲", u"動": u"动",
	u"勗": u"勖", u"務": u"务", u"勛": u"勋", u"勝": u"胜",
	u"勞": u"劳", u"勢": u"势", u"勣": u"绩", u"勦": u"剿",
	u"勱": u"劢", u"勳": u"勋", u"勵": u"励", u"勸": u"劝",
	u"勻": u"匀", u"匋": u"陶", u"匭": u"匦", u"匯": u"汇",
	u"匱": u"匮", u"區": u"区", u"卄": u"廿", u"協": u"协",
	u"卬": u"昂", u"卹": u"恤", u"卻": u"却", u"厙": u"厍",
	u"厭": u"厌", u"厲": u"厉", u"厴": u"厣", u"參": u"参",
	u"叡": u"睿", u"叢": u"丛", u"吋": u"寸", u"吳": u"吴",
	u"吶": u"呐", u"呂": u"吕", u"呎": u"尺", u"咷": u"啕",
	u"咼": u"呙", u"員": u"员", u"唄": u"呗", u"唸": u"念",
	u"問": u"问", u"啗": u"啖", u"啞": u"哑", u"啟": u"启",
	u"啣": u"衔", u"喚": u"唤", u"喪": u"丧", u"喫": u"吃",
	u"喬": u"乔", u"單": u"单", u"喲": u"哟", u"嗆": u"呛",
	u"嗇": u"啬", u"嗎": u"吗", u"嗚": u"呜", u"嗩": u"唢",
	u"嗶": u"哔", u"嘆": u"叹", u"嘍": u"喽", u"嘔": u"呕",
	u"嘖": u"啧", u"嘗": u"尝", u"嘜": u"唛", u"嘩": u"哗",
	u"嘮": u"唠", u"嘯": u"啸", u"嘰": u"叽", u"嘵": u"哓",
	u"嘸": u"呒", u"噁": u"恶", u"噓": u"嘘", u"噠": u"哒",
	u"噥": u"哝", u"噦": u"哕", u"噯": u"嗳", u"噲": u"哙",
	u"噴": u"喷", u"噸": u"吨", u"噹": u"当", u"嚀": u"咛",
	u"嚇": u"吓", u"嚌": u"哜", u"嚐": u"尝", u"嚕": u"噜",
	u"嚙": u"啮", u"嚥": u"咽", u"嚦": u"呖", u"嚨": u"咙",
	u"嚮": u"向", u"嚳": u"喾", u"嚴": u"严", u"嚶": u"嘤",
	u"囀": u"啭", u"囁": u"嗫", u"囂": u"嚣", u"囅": u"冁",
	u"囈": u"呓", u"囉": u"罗", u"囌": u"苏", u"囑": u"嘱",
	u"囓": u"啮", u"囪": u"囱", u"圇": u"囵", u"國": u"国",
	u"圍": u"围", u"園": u"园", u"圓": u"圆", u"圖": u"图",
	u"團": u"团", u"坵": u"丘", u"埜": u"野", u"埡": u"垭",
	u"執": u"执", u"埼": u"崎", u"堅": u"坚", u"堊": u"垩",
	u"堝": u"埚", u"堯": u"尧", u"報": u"报", u"場": u"场",
	u"堿": u"碱", u"塊": u"块", u"塋": u"茔", u"塏": u"垲",
	u"塒": u"埘", u"塗": u"涂", u"塚": u"冢", u"塢": u"坞",
	u"塤": u"埙", u"塵": u"尘", u"塹": u"堑", u"墊": u"垫",
	u"墑": u"墒", u"墜": u"坠", u"墫": u"樽", u"墮": u"堕",
	u"墳": u"坟", u"墻": u"墙", u"墾": u"垦", u"壇": u"坛",
	u"壎": u"埙", u"壓": u"压", u"壘": u"垒", u"壙": u"圹",
	u"壚": u"垆", u"壞": u"坏", u"壟": u"垄", u"壢": u"坜",
	u"壩": u"坝", u"壯": u"壮", u"壺": u"壶", u"壽": u"寿",
	u"夠": u"够", u"夢": u"梦", u"夥": u"伙", u"夾": u"夹",
	u"奐": u"奂", u"奧": u"奥", u"奩": u"奁", u"奪": u"夺",
	u"奮": u"奋", u"妝": u"妆", u"妳": u"你", u"姍": u"姗",
	u"姦": u"奸", u"姪": u"侄", u"娛": u"娱", u"婁": u"娄",
	u"婦": u"妇", u"婬": u"淫", u"婭": u"娅", u"媧": u"娲",
	u"媮": u"偷", u"媯": u"妫", u"媼": u"媪", u"媽": u"妈",
	u"媿": u"愧", u"嫋": u"袅", u"嫗": u"妪", u"嫵": u"妩",
	u"嫻": u"娴", u"嬈": u"娆", u"嬋": u"婵", u"嬌": u"娇",
	u"嬙": u"嫱", u"嬝": u"袅", u"嬡": u"嫒", u"嬤": u"嬷",
	u"嬪": u"嫔", u"嬭": u"奶", u"嬰": u"婴", u"嬸": u"婶",
	u"孃": u"娘", u"孌": u"娈", u"孫": u"孙", u"學": u"学",
	u"孿": u"孪", u"宮": u"宫", u"寘": u"置", u"寢": u"寝",
	u"實": u"实", u"寧": u"宁", u"審": u"审", u"寫": u"写",
	u"寬": u"宽", u"寵": u"宠", u"寶": u"宝", u"將": u"将",
	u"專": u"专", u"尋": u"寻", u"對": u"对", u"導": u"导",
	u"尷": u"尴", u"屆": u"届", u"屍": u"尸", u"屜": u"屉",
	u"屝": u"扉", u"屢": u"屡", u"層": u"层", u"屨": u"屦",
	u"屬": u"属", u"岡": u"冈", u"峴": u"岘", u"島": u"岛",
	u"峽": u"峡", u"崍": u"崃", u"崑": u"昆", u"崗": u"岗",
	u"崙": u"仑", u"崠": u"岽", u"崢": u"峥", u"崳": u"嵛",
	u"嵐": u"岚", u"嵒": u"岩", u"嶁": u"嵝", u"嶄": u"崭",
	u"嶇": u"岖", u"嶗": u"崂", u"嶠": u"峤", u"嶧": u"峄",
	u"嶸": u"嵘", u"嶺": u"岭", u"嶼": u"屿", u"嶽": u"岳",
	u"巋": u"岿", u"巒": u"峦", u"巔": u"巅", u"巖": u"岩",
	u"巰": u"巯", u"巹": u"卺", u"帥": u"帅", u"師": u"师",
	u"帳": u"帐", u"帶": u"带", u"幀": u"帧", u"幃": u"帏",
	u"幗": u"帼", u"幘": u"帻", u"幟": u"帜", u"幣": u"币",
	u"幫": u"帮", u"幬": u"帱", u"幵": u"开", u"幹": u"干",
	u"幾": u"几", u"庂": u"仄", u"庫": u"库", u"廁": u"厕",
	u"廂": u"厢", u"廄": u"厩", u"廈": u"厦", u"廚": u"厨",
	u"廝": u"厮", u"廟": u"庙", u"廠": u"厂", u"廡": u"庑",
	u"廢": u"废", u"廣": u"广", u"廩": u"廪", u"廬": u"庐",
	u"廱": u"痈", u"廳": u"厅", u"弒": u"弑", u"弔": u"吊",
	u"弳": u"弪", u"張": u"张", u"強": u"强", u"彆": u"别",
	u"彈": u"弹", u"彊": u"强", u"彌": u"弥", u"彎": u"弯",
	u"彙": u"汇", u"彥": u"彦", u"彫": u"雕", u"彿": u"佛",
	u"後": u"后", u"徑": u"径", u"從": u"从", u"徠": u"徕",
	u"復": u"复", u"徬": u"旁", u"徹": u"彻", u"恆": u"恒",
	u"恥": u"耻", u"悅": u"悦", u"悵": u"怅", u"悶": u"闷",
	u"悽": u"凄", u"惇": u"敦", u"惡": u"恶", u"惱": u"恼",
	u"惲": u"恽", u"惷": u"蠢", u"惻": u"恻", u"愛": u"爱",
	u"愜": u"惬", u"愨": u"悫", u"愴": u"怆", u"愷": u"恺",
	u"愾": u"忾", u"慄": u"栗", u"慇": u"殷", u"態": u"态",
	u"慍": u"愠", u"慘": u"惨", u"慚": u"惭", u"慟": u"恸",
	u"慣": u"惯", u"慪": u"怄", u"慫": u"怂", u"慮": u"虑",
	u"慳": u"悭", u"慶": u"庆", u"慼": u"戚", u"慾": u"欲",
	u"憂": u"忧", u"憊": u"惫", u"憐": u"怜", u"憑": u"凭",
	u"憒": u"愦", u"憚": u"惮", u"憤": u"愤", u"憫": u"悯",
	u"憮": u"怃", u"憲": u"宪", u"憶": u"忆", u"懃": u"勤",
	u"懇": u"恳", u"應": u"应", u"懌": u"怿", u"懍": u"懔",
	u"懞": u"蒙", u"懟": u"怼", u"懣": u"懑", u"懨": u"恹",
	u"懲": u"惩", u"懶": u"懒", u"懷": u"怀", u"懸": u"悬",
	u"懺": u"忏", u"懼": u"惧", u"懾": u"慑", u"戀": u"恋",
	u"戇": u"戆", u"戉": u"钺", u"戔": u"戋", u"戧": u"戗",
	u"戩": u"戬", u"戰": u"战", u"戲": u"戏", u"戶": u"户",
	u"扐": u"仂", u"扞": u"捍", u"扱": u"插", u"扺": u"抵",
	u"抃": u"拚", u"抔": u"抱", u"抴": u"曳", u"拋": u"抛",
	u"拑": u"钳", u"挌": u"格", u"挶": u"局", u"挾": u"挟",
	u"捨": u"舍", u"捫": u"扪", u"捲": u"卷", u"掃": u"扫",
	u"掄": u"抡", u"掙": u"挣", u"掛": u"挂", u"採": u"采",
	u"揀": u"拣", u"揚": u"扬", u"換": u"换", u"揮": u"挥",
	u"揹": u"背", u"搆": u"构", u"損": u"损", u"搖": u"摇",
	u"搗": u"捣", u"搟": u"擀", u"搥": u"捶", u"搨": u"打",
	u"搯": u"掏", u"搶": u"抢", u"搾": u"榨", u"摀": u"捂",
	u"摃": u"扛", u"摑": u"掴", u"摜": u"掼", u"摟": u"搂",
	u"摯": u"挚", u"摳": u"抠", u"摶": u"抟", u"摻": u"掺",
	u"撈": u"捞", u"撐": u"撑", u"撓": u"挠", u"撚": u"捻",
	u"撟": u"挢", u"撢": u"掸", u"撣": u"掸", u"撥": u"拨",
	u"撦": u"扯", u"撫": u"抚", u"撲": u"扑", u"撳": u"揿",
	u"撻": u"挞", u"撾": u"挝", u"撿": u"捡", u"擁": u"拥",
	u"擄": u"掳", u"擇": u"择", u"擊": u"击", u"擋": u"挡",
	u"擔": u"担", u"據": u"据", u"擠": u"挤", u"擣": u"捣",
	u"擬": u"拟", u"擯": u"摈", u"擰": u"拧", u"擱": u"搁",
	u"擲": u"掷", u"擴": u"扩", u"擷": u"撷", u"擺": u"摆",
	u"擻": u"擞", u"擼": u"撸", u"擾": u"扰", u"攄": u"摅",
	u"攆": u"撵", u"攏": u"拢", u"攔": u"拦", u"攖": u"撄",
	u"攙": u"搀", u"攛": u"撺", u"攜": u"携", u"攝": u"摄",
	u"攢": u"攒", u"攣": u"挛", u"攤": u"摊", u"攪": u"搅",
	u"攬": u"揽", u"攷": u"考", u"敗": u"败", u"敘": u"叙",
	u"敵": u"敌", u"數": u"数", u"斂": u"敛", u"斃": u"毙",
	u"斕": u"斓", u"斬": u"斩", u"斷": u"断", u"旂": u"旗",
	u"旛": u"幡", u"昇": u"升", u"時": u"时", u"晉": u"晋",
	u"晝": u"昼", u"晞": u"曦", u"晢": u"晰", u"晻": u"暗",
	u"暈": u"晕", u"暉": u"晖", u"暘": u"阳", u"暢": u"畅",
	u"暫": u"暂", u"暱": u"昵", u"暸": u"了", u"曄": u"晔",
	u"曆": u"历", u"曇": u"昙", u"曉": u"晓", u"曏": u"向",
	u"曖": u"暧", u"曠": u"旷", u"曬": u"晒", u"書": u"书",
	u"會": u"会", u"朢": u"望", u"朧": u"胧", u"朮": u"术",
	u"杇": u"圬", u"東": u"东", u"枴": u"拐", u"柵": u"栅",
	u"柺": u"拐", u"栒": u"旬", u"桮": u"杯", u"桿": u"杆",
	u"梔": u"栀", u"條": u"条", u"梟": u"枭", u"梱": u"捆",
	u"棄": u"弃", u"棖": u"枨", u"棗": u"枣", u"棟": u"栋",
	u"棧": u"栈", u"棲": u"栖", u"椏": u"桠", u"楄": u"匾",
	u"楊": u"杨", u"楓": u"枫", u"楙": u"茂", u"楜": u"胡",
	u"楨": u"桢", u"業": u"业", u"極": u"极", u"榦": u"干",
	u"榪": u"杩", u"榮": u"荣", u"榿": u"桤", u"槃": u"盘",
	u"構": u"构", u"槍": u"枪", u"槓": u"杠", u"槧": u"椠",
	u"槨": u"椁", u"槳": u"桨", u"樁": u"桩", u"樂": u"乐",
	u"樅": u"枞", u"樑": u"梁", u"樓": u"楼", u"標": u"标",
	u"樞": u"枢", u"樣": u"样", u"樸": u"朴", u"樹": u"树",
	u"樺": u"桦", u"橈": u"桡", u"橋": u"桥", u"機": u"机",
	u"橢": u"椭", u"橦": u"幢", u"橫": u"横", u"檁": u"檩",
	u"檉": u"柽", u"檔": u"档", u"檜": u"桧", u"檢": u"检",
	u"檣": u"樯", u"檯": u"台", u"檳": u"槟", u"檸": u"柠",
	u"檻": u"槛", u"櫂": u"棹", u"櫃": u"柜", u"櫐": u"累",
	u"櫓": u"橹", u"櫚": u"榈", u"櫛": u"栉", u"櫝": u"椟",
	u"櫞": u"橼", u"櫟": u"栎", u"櫥": u"橱", u"櫧": u"槠",
	u"櫨": u"栌", u"櫪": u"枥", u"櫫": u"橥", u"櫬": u"榇",
	u"櫳": u"栊", u"櫸": u"榉", u"櫺": u"棂", u"櫻": u"樱",
	u"欄": u"栏", u"權": u"权", u"欏": u"椤", u"欒": u"栾",
	u"欖": u"榄", u"欞": u"棂", u"欸": u"唉", u"欽": u"钦",
	u"歎": u"叹", u"歐": u"欧", u"歟": u"欤", u"歡": u"欢",
	u"歲": u"岁", u"歷": u"历", u"歸": u"归", u"歿": u"殁",
	u"殀": u"夭", u"殘": u"残", u"殞": u"殒", u"殤": u"殇",
	u"殫": u"殚", u"殭": u"僵", u"殮": u"殓", u"殯": u"殡",
	u"殲": u"歼", u"殺": u"杀", u"殼": u"壳", u"殽": u"肴",
	u"毀": u"毁", u"毆": u"殴", u"毌": u"毋", u"毘": u"毗",
	u"毬": u"球", u"毿": u"毵", u"氈": u"毡", u"氌": u"氇",
	u"氣": u"气", u"氫": u"氢", u"氬": u"氩", u"氳": u"氲",
	u"氾": u"泛", u"汆": u"氽", u"汍": u"丸", u"汎": u"泛",
	u"汙": u"污", u"決": u"决", u"沍": u"冱", u"沒": u"没",
	u"沖": u"冲", u"況": u"况", u"泝": u"溯", u"洟": u"涕",
	u"洩": u"泄", u"洶": u"汹", u"浬": u"里", u"浹": u"浃",
	u"涇": u"泾", u"涼": u"凉", u"淒": u"凄", u"淚": u"泪",
	u"淥": u"渌", u"淨": u"净", u"淪": u"沦", u"淵": u"渊",
	u"淶": u"涞", u"淺": u"浅", u"渙": u"涣", u"減": u"减",
	u"渦": u"涡", u"測": u"测", u"渾": u"浑", u"湊": u"凑",
	u"湞": u"浈", u"湣": u"闵", u"湧": u"涌", u"湯": u"汤",
	u"溈": u"沩", u"準": u"准", u"溝": u"沟", u"溫": u"温",
	u"溼": u"湿", u"滄": u"沧", u"滅": u"灭", u"滌": u"涤",
	u"滎": u"荥", u"滬": u"沪", u"滯": u"滞", u"滲": u"渗",
	u"滷": u"卤", u"滸": u"浒", u"滾": u"滚", u"滿": u"满",
	u"漁": u"渔", u"漚": u"沤", u"漢": u"汉", u"漣": u"涟",
	u"漬": u"渍", u"漲": u"涨", u"漵": u"溆", u"漸": u"渐",
	u"漿": u"浆", u"潁": u"颍", u"潑": u"泼", u"潔": u"洁",
	u"潛": u"潜", u"潟": u"舄", u"潤": u"润", u"潯": u"浔",
	u"潰": u"溃", u"潷": u"滗", u"潿": u"涠", u"澀": u"涩",
	u"澂": u"澄", u"澆": u"浇", u"澇": u"涝", u"澔": u"浩",
	u"澗": u"涧", u"澠": u"渑", u"澤": u"泽", u"澩": u"泶",
	u"澮": u"浍", u"澱": u"淀", u"濁": u"浊", u"濃": u"浓",
	u"濕": u"湿", u"濘": u"泞", u"濛": u"蒙", u"濟": u"济",
	u"濤": u"涛", u"濫": u"滥", u"濬": u"浚", u"濰": u"潍",
	u"濱": u"滨", u"濺": u"溅", u"濼": u"泺", u"濾": u"滤",
	u"瀁": u"漾", u"瀅": u"滢", u"瀆": u"渎", u"瀉": u"泻",
	u"瀋": u"沈", u"瀏": u"浏", u"瀕": u"濒", u"瀘": u"泸",
	u"瀝": u"沥", u"瀟": u"潇", u"瀠": u"潆", u"瀦": u"潴",
	u"瀧": u"泷", u"瀨": u"濑", u"瀰": u"弥", u"瀲": u"潋",
	u"瀾": u"澜", u"灃": u"沣", u"灄": u"滠", u"灑": u"洒",
	u"灕": u"漓", u"灘": u"滩", u"灝": u"灏", u"灣": u"湾",
	u"灤": u"滦", u"灩": u"滟", u"災": u"灾", u"炤": u"照",
	u"炰": u"炮", u"為": u"为", u"烏": u"乌", u"烴": u"烃",
	u"無": u"无", u"煉": u"炼", u"煒": u"炜", u"煖": u"暖",
	u"煙": u"烟", u"煢": u"茕", u"煥": u"焕", u"煩": u"烦",
	u"煬": u"炀", u"熒": u"荧", u"熗": u"炝", u"熱": u"热",
	u"熾": u"炽", u"燁": u"烨", u"燄": u"焰", u"燈": u"灯",
	u"燉": u"炖", u"燐": u"磷", u"燒": u"烧", u"燙": u"烫",
	u"燜": u"焖", u"營": u"营", u"燦": u"灿", u"燬": u"毁",
	u"燭": u"烛", u"燴": u"烩", u"燻": u"熏", u"燼": u"烬",
	u"燾": u"焘", u"燿": u"耀", u"爍": u"烁", u"爐": u"炉",
	u"爛": u"烂", u"爭": u"争", u"爺": u"爷", u"爾": u"尔",
	u"牆": u"墙", u"牘": u"牍", u"牠": u"它", u"牴": u"抵",
	u"牽": u"牵", u"犖": u"荦", u"犛": u"牦", u"犢": u"犊",
	u"犧": u"牺", u"狀": u"状", u"狚": u"旦", u"狹": u"狭",
	u"狽": u"狈", u"猙": u"狰", u"猶": u"犹", u"猻": u"狲",
	u"獃": u"呆", u"獄": u"狱", u"獅": u"狮", u"獎": u"奖",
	u"獨": u"独", u"獪": u"狯", u"獫": u"猃", u"獰": u"狞",
	u"獲": u"获", u"獵": u"猎", u"獷": u"犷", u"獸": u"兽",
	u"獺": u"獭", u"獻": u"献", u"獼": u"猕", u"玀": u"猡",
	u"玅": u"妙", u"玆": u"兹", u"玨": u"珏", u"珪": u"圭",
	u"珮": u"佩", u"現": u"现", u"琱": u"雕", u"琺": u"珐",
	u"琿": u"珲", u"瑋": u"玮", u"瑣": u"琐", u"瑤": u"瑶",
	u"瑩": u"莹", u"瑪": u"玛", u"瑯": u"琅", u"璉": u"琏",
	u"璣": u"玑", u"璦": u"瑷", u"環": u"环", u"璽": u"玺",
	u"璿": u"璇", u"瓊": u"琼", u"瓏": u"珑", u"瓔": u"璎",
	u"瓖": u"镶", u"瓚": u"瓒", u"甌": u"瓯", u"甕": u"瓮",
	u"產": u"产", u"甦": u"苏", u"甪": u"角", u"甯": u"宁",
	u"畝": u"亩", u"畢": u"毕", u"畫": u"画", u"畬": u"畲",
	u"異": u"异", u"當": u"当", u"疇": u"畴", u"疊": u"叠",
	u"疿": u"痱", u"痙": u"痉", u"痠": u"酸", u"痲": u"麻",
	u"痳": u"麻", u"痺": u"痹", u"痾": u"疴", u"瘉": u"愈",
	u"瘋": u"疯", u"瘍": u"疡", u"瘓": u"痪", u"瘞": u"瘗",
	u"瘡": u"疮", u"瘧": u"疟", u"瘺": u"瘘", u"療": u"疗",
	u"癆": u"痨", u"癇": u"痫", u"癉": u"瘅", u"癒": u"愈",
	u"癘": u"疠", u"癟": u"瘪", u"癡": u"痴", u"癢": u"痒",
	u"癤": u"疖", u"癥": u"症", u"癩": u"癞", u"癬": u"癣",
	u"癭": u"瘿", u"癮": u"瘾", u"癰": u"痈", u"癱": u"瘫",
	u"癲": u"癫", u"發": u"发", u"皁": u"皂", u"皚": u"皑",
	u"皰": u"疱", u"皸": u"皲", u"皺": u"皱", u"盃": u"杯",
	u"盜": u"盗", u"盞": u"盏", u"盡": u"尽", u"監": u"监",
	u"盤": u"盘", u"盧": u"卢", u"盪": u"荡", u"眥": u"眦",
	u"眾": u"众", u"睏": u"困", u"睜": u"睁", u"睞": u"睐",
	u"睪": u"睾", u"瞇": u"眯", u"瞞": u"瞒", u"瞭": u"了",
	u"瞼": u"睑", u"矇": u"蒙", u"矓": u"胧", u"矚": u"瞩",
	u"矯": u"矫", u"砲": u"炮", u"硃": u"朱", u"硤": u"硖",
	u"硨": u"砗", u"硯": u"砚", u"碁": u"棋", u"碕": u"崎",
	u"碩": u"硕", u"碪": u"砧", u"碭": u"砀", u"確": u"确",
	u"碼": u"码", u"磚": u"砖", u"磣": u"碜", u"磧": u"碛",
	u"磯": u"矶", u"磽": u"硗", u"礎": u"础", u"礙": u"碍",
	u"礡": u"礴", u"礦": u"矿", u"礪": u"砺", u"礫": u"砾",
	u"礬": u"矾", u"礱": u"砻", u"祂": u"他", u"祅": u"祆",
	u"祇": u"只", u"祐": u"佑", u"祕": u"秘", u"祼": u"裸",
	u"祿": u"禄", u"禍": u"祸", u"禎": u"祯", u"禦": u"御",
	u"禪": u"禅", u"禮": u"礼", u"禰": u"祢", u"禱": u"祷",
	u"禿": u"秃", u"秈": u"籼", u"秏": u"耗", u"稅": u"税",
	u"稈": u"秆", u"稜": u"棱", u"稟": u"禀", u"稨": u"扁",
	u"種": u"种", u"稱": u"称", u"穀": u"谷", u"穌": u"稣",
	u"積": u"积", u"穎": u"颖", u"穡": u"穑", u"穢": u"秽",
	u"穨": u"颓", u"穩": u"稳", u"穫": u"获", u"窩": u"窝",
	u"窪": u"洼", u"窮": u"穷", u"窯": u"窑", u"窶": u"窭",
	u"窺": u"窥", u"竄": u"窜", u"竅": u"窍", u"竇": u"窦",
	u"竊": u"窃", u"競": u"竞", u"笻": u"筇", u"筆": u"笔",
	u"筍": u"笋", u"筧": u"笕", u"筴": u"策", u"箄": u"箅",
	u"箇": u"个", u"箋": u"笺", u"箏": u"筝", u"箠": u"棰",
	u"節": u"节", u"範": u"范", u"築": u"筑", u"篋": u"箧",
	u"篛": u"箬", u"篠": u"筱", u"篤": u"笃", u"篩": u"筛",
	u"篲": u"彗", u"篳": u"筚", u"簀": u"箦", u"簍": u"篓",
	u"簑": u"蓑", u"簞": u"箪", u"簡": u"简", u"簣": u"篑",
	u"簫": u"箫", u"簷": u"檐", u"簽": u"签", u"簾": u"帘",
	u"籃": u"篮", u"籌": u"筹", u"籐": u"藤", u"籜": u"箨",
	u"籟": u"籁", u"籠": u"笼", u"籤": u"签", u"籥": u"龠",
	u"籩": u"笾", u"籪": u"簖", u"籬": u"篱", u"籮": u"箩",
	u"籲": u"吁", u"粧": u"妆", u"粵": u"粤", u"糝": u"糁",
	u"糞": u"粪", u"糢": u"馍", u"糧": u"粮", u"糰": u"团",
	u"糲": u"粝", u"糴": u"籴", u"糶": u"粜", u"糾": u"纠",
	u"紀": u"纪", u"紂": u"纣", u"約": u"约", u"紅": u"红",
	u"紆": u"纡", u"紇": u"纥", u"紈": u"纨", u"紉": u"纫",
	u"紋": u"纹", u"納": u"纳", u"紐": u"纽", u"紓": u"纾",
	u"純": u"纯", u"紕": u"纰", u"紗": u"纱", u"紙": u"纸",
	u"級": u"级", u"紛": u"纷", u"紜": u"纭", u"紡": u"纺",
	u"紮": u"扎", u"細": u"细", u"紱": u"绂", u"紲": u"绁",
	u"紳": u"绅", u"紹": u"绍", u"紺": u"绀", u"紼": u"绋",
	u"紿": u"绐", u"絀": u"绌", u"終": u"终", u"絃": u"弦",
	u"組": u"组", u"絆": u"绊", u"絎": u"绗", u"結": u"结",
	u"絕": u"绝", u"絛": u"绦", u"絞": u"绞", u"絡": u"络",
	u"絢": u"绚", u"給": u"给", u"絨": u"绒", u"統": u"统",
	u"絲": u"丝", u"絳": u"绛", u"絹": u"绢", u"綁": u"绑",
	u"綃": u"绡", u"綆": u"绠", u"綈": u"绨", u"綏": u"绥",
	u"綑": u"捆", u"經": u"经", u"綜": u"综", u"綞": u"缍",
	u"綠": u"绿", u"綢": u"绸", u"綣": u"绻", u"綬": u"绶",
	u"維": u"维", u"綰": u"绾", u"綱": u"纲", u"網": u"网",
	u"綴": u"缀", u"綵": u"彩", u"綸": u"纶", u"綹": u"绺",
	u"綺": u"绮", u"綻": u"绽", u"綽": u"绰", u"綾": u"绫",
	u"綿": u"绵", u"緄": u"绲", u"緇": u"缁", u"緊": u"紧",
	u"緋": u"绯", u"緒": u"绪", u"緗": u"缃", u"緘": u"缄",
	u"緙": u"缂", u"線": u"线", u"緝": u"缉", u"緞": u"缎",
	u"締": u"缔", u"緡": u"缗", u"緣": u"缘", u"緦": u"缌",
	u"編": u"编", u"緩": u"缓", u"緬": u"缅", u"緯": u"纬",
	u"緱": u"缑", u"緲": u"缈", u"練": u"练", u"緶": u"缏",
	u"緹": u"缇", u"緻": u"致", u"縈": u"萦", u"縉": u"缙",
	u"縊": u"缢", u"縋": u"缒", u"縐": u"绉", u"縑": u"缣",
	u"縚": u"绦", u"縛": u"缚", u"縝": u"缜", u"縞": u"缟",
	u"縟": u"缛", u"縣": u"县", u"縫": u"缝", u"縭": u"缡",
	u"縮": u"缩", u"縯": u"演", u"縱": u"纵", u"縲": u"缧",
	u"縳": u"缚", u"縴": u"纤", u"縵": u"缦", u"縶": u"絷",
	u"縷": u"缕", u"縹": u"缥", u"總": u"总", u"績": u"绩",
	u"繃": u"绷", u"繅": u"缫", u"繆": u"缪", u"繈": u"襁",
	u"繒": u"缯", u"織": u"织", u"繕": u"缮", u"繙": u"翻",
	u"繚": u"缭", u"繞": u"绕", u"繡": u"绣", u"繢": u"缋",
	u"繩": u"绳", u"繪": u"绘", u"繫": u"系", u"繭": u"茧",
	u"繯": u"缳", u"繰": u"缲", u"繳": u"缴", u"繹": u"绎",
	u"繼": u"继", u"繽": u"缤", u"繾": u"缱", u"纈": u"缬",
	u"纊": u"纩", u"續": u"续", u"纍": u"累", u"纏": u"缠",
	u"纓": u"缨", u"纔": u"才", u"纖": u"纤", u"纘": u"缵",
	u"纜": u"缆", u"缽": u"钵", u"缾": u"瓶", u"罈": u"坛",
	u"罌": u"罂", u"罦": u"罘", u"罰": u"罚", u"罵": u"骂",
	u"罷": u"罢", u"羅": u"罗", u"羆": u"罴", u"羈": u"羁",
	u"羋": u"芈", u"羥": u"羟", u"羨": u"羡", u"義": u"义",
	u"羶": u"膻", u"習": u"习", u"翹": u"翘", u"耑": u"端",
	u"耡": u"助", u"耤": u"藉", u"耬": u"耧", u"聖": u"圣",
	u"聞": u"闻", u"聯": u"联", u"聰": u"聪", u"聲": u"声",
	u"聳": u"耸", u"聵": u"聩", u"聶": u"聂", u"職": u"职",
	u"聹": u"聍", u"聽": u"听", u"聾": u"聋", u"肅": u"肃",
	u"肏": u"操", u"肐": u"胳", u"胇": u"肺", u"胊": u"朐",
	u"脅": u"胁", u"脈": u"脉", u"脛": u"胫", u"脣": u"唇",
	u"脩": u"修", u"脫": u"脱", u"脹": u"胀", u"腎": u"肾",
	u"腡": u"脶", u"腦": u"脑", u"腫": u"肿", u"腳": u"脚",
	u"腸": u"肠", u"膃": u"腽", u"膆": u"嗉", u"膚": u"肤",
	u"膠": u"胶", u"膩": u"腻", u"膽": u"胆", u"膾": u"脍",
	u"膿": u"脓", u"臉": u"脸", u"臍": u"脐", u"臏": u"膑",
	u"臕": u"膘", u"臘": u"腊", u"臙": u"胭", u"臚": u"胪",
	u"臟": u"脏", u"臠": u"脔", u"臥": u"卧", u"臨": u"临",
	u"臺": u"台", u"與": u"与", u"興": u"兴", u"舉": u"举",
	u"舊": u"旧", u"舋": u"衅", u"舖": u"铺", u"艙": u"舱",
	u"艣": u"橹", u"艤": u"舣", u"艦": u"舰", u"艫": u"舻",
	u"艱": u"艰", u"艷": u"艳", u"艸": u"艹", u"芻": u"刍",
	u"苧": u"苎", u"苺": u"莓", u"茍": u"苟", u"茲": u"兹",
	u"荅": u"答", u"荊": u"荆", u"荳": u"豆", u"莊": u"庄",
	u"莖": u"茎", u"莢": u"荚", u"莧": u"苋", u"菫": u"堇",
	u"華": u"华", u"菴": u"庵", u"萇": u"苌", u"萊": u"莱",
	u"萬": u"万", u"萵": u"莴", u"葉": u"叶", u"葒": u"荭",
	u"葦": u"苇", u"葯": u"药", u"葷": u"荤", u"蒐": u"搜",
	u"蒔": u"莳", u"蒞": u"莅", u"蒼": u"苍", u"蓀": u"荪",
	u"蓆": u"席", u"蓋": u"盖", u"蓮": u"莲", u"蓯": u"苁",
	u"蓴": u"莼", u"蓽": u"荜", u"蔆": u"菱", u"蔔": u"卜",
	u"蔞": u"蒌", u"蔣": u"蒋", u"蔥": u"葱", u"蔦": u"茑",
	u"蔭": u"荫", u"蕁": u"荨", u"蕆": u"蒇", u"蕎": u"荞",
	u"蕓": u"芸", u"蕕": u"莸", u"蕘": u"荛", u"蕢": u"蒉",
	u"蕩": u"荡", u"蕪": u"芜", u"蕭": u"萧", u"蕷": u"蓣",
	u"薈": u"荟", u"薊": u"蓟", u"薌": u"芗", u"薑": u"姜",
	u"薔": u"蔷", u"薙": u"剃", u"薟": u"莶", u"薦": u"荐",
	u"薩": u"萨", u"薺": u"荠", u"藍": u"蓝", u"藎": u"荩",
	u"藚": u"荬", u"藝": u"艺", u"藥": u"药", u"藪": u"薮",
	u"藶": u"苈", u"藷": u"薯", u"藹": u"蔼", u"藺": u"蔺",
	u"蘄": u"蕲", u"蘆": u"芦", u"蘇": u"苏", u"蘊": u"蕴",
	u"蘋": u"苹", u"蘗": u"蘖", u"蘚": u"藓", u"蘞": u"蔹",
	u"蘢": u"茏", u"蘭": u"兰", u"蘺": u"蓠", u"蘿": u"萝",
	u"處": u"处", u"虖": u"呼", u"虛": u"虚", u"虜": u"虏",
	u"號": u"号", u"虧": u"亏", u"虯": u"虬", u"蛺": u"蛱",
	u"蛻": u"蜕", u"蜆": u"蚬", u"蜺": u"霓", u"蝕": u"蚀",
	u"蝟": u"猬", u"蝦": u"虾", u"蝨": u"虱", u"蝸": u"蜗",
	u"螄": u"蛳", u"螞": u"蚂", u"螢": u"萤", u"螻": u"蝼",
	u"蟄": u"蛰", u"蟈": u"蝈", u"蟣": u"虮", u"蟬": u"蝉",
	u"蟯": u"蛲", u"蟲": u"虫", u"蟶": u"蛏", u"蟺": u"蟮",
	u"蟻": u"蚁", u"蠅": u"蝇", u"蠆": u"虿", u"蠍": u"蝎",
	u"蠐": u"蛴", u"蠑": u"蝾", u"蠔": u"蚝", u"蠟": u"蜡",
	u"蠣": u"蛎", u"蠱": u"蛊", u"蠶": u"蚕", u"蠷": u"蠼",
	u"蠻": u"蛮", u"衊": u"蔑", u"衒": u"炫", u"術": u"术",
	u"衚": u"胡", u"衛": u"卫", u"衝": u"冲", u"衹": u"只",
	u"袞": u"衮", u"袪": u"祛", u"裊": u"袅", u"裏": u"里",
	u"補": u"补", u"裝": u"装", u"裡": u"里", u"製": u"制",
	u"複": u"复", u"褎": u"袖", u"褲": u"裤", u"褳": u"裢",
	u"褸": u"褛", u"褻": u"亵", u"襉": u"裥", u"襖": u"袄",
	u"襝": u"裣", u"襠": u"裆", u"襤": u"褴", u"襪": u"袜",
	u"襬": u"摆", u"襯": u"衬", u"襲": u"袭", u"襾": u"西",
	u"覈": u"核", u"見": u"见", u"規": u"规", u"覓": u"觅",
	u"視": u"视", u"覘": u"觇", u"覜": u"眺", u"覡": u"觋",
	u"覦": u"觎", u"親": u"亲", u"覬": u"觊", u"覯": u"觏",
	u"覲": u"觐", u"覷": u"觑", u"覺": u"觉", u"覽": u"览",
	u"覿": u"觌", u"觀": u"观", u"觔": u"筋", u"觝": u"抵",
	u"觴": u"觞", u"觶": u"觯", u"觸": u"触", u"訂": u"订",
	u"訃": u"讣", u"計": u"计", u"訊": u"讯", u"訌": u"讧",
	u"討": u"讨", u"訐": u"讦", u"訓": u"训", u"訕": u"讪",
	u"訖": u"讫", u"託": u"托", u"記": u"记", u"訛": u"讹",
	u"訝": u"讶", u"訟": u"讼", u"訢": u"欣", u"訣": u"诀",
	u"訥": u"讷", u"訪": u"访", u"設": u"设", u"許": u"许",
	u"訴": u"诉", u"訶": u"诃", u"診": u"诊", u"註": u"注",
	u"証": u"证", u"詁": u"诂", u"詆": u"诋", u"詎": u"讵",
	u"詐": u"诈", u"詒": u"诒", u"詔": u"诏", u"評": u"评",
	u"詘": u"诎", u"詛": u"诅", u"詞": u"词", u"詠": u"咏",
	u"詡": u"诩", u"詢": u"询", u"詣": u"诣", u"試": u"试",
	u"詩": u"诗", u"詫": u"诧", u"詬": u"诟", u"詭": u"诡",
	u"詮": u"诠", u"詰": u"诘", u"話": u"话", u"該": u"该",
	u"詳": u"详", u"詵": u"诜", u"詶": u"酬", u"詻": u"咯",
	u"詼": u"诙", u"詿": u"诖", u"誄": u"诔", u"誅": u"诛",
	u"誆": u"诓", u"誇": u"夸", u"誌": u"志", u"認": u"认",
	u"誑": u"诳", u"誒": u"诶", u"誕": u"诞", u"誘": u"诱",
	u"誚": u"诮", u"語": u"语", u"誠": u"诚", u"誡": u"诫",
	u"誣": u"诬", u"誤": u"误", u"誥": u"诰", u"誦": u"诵",
	u"誨": u"诲", u"說": u"说", u"誰": u"谁", u"課": u"课",
	u"誶": u"谇", u"誹": u"诽", u"誼": u"谊", u"調": u"调",
	u"諂": u"谄", u"諄": u"谆", u"談": u"谈", u"諉": u"诿",
	u"請": u"请", u"諍": u"诤", u"諏": u"诹", u"諑": u"诼",
	u"諒": u"谅", u"論": u"论", u"諗": u"谂", u"諛": u"谀",
	u"諜": u"谍", u"諞": u"谝", u"諠": u"喧", u"諢": u"诨",
	u"諤": u"谔", u"諦": u"谛", u"諧": u"谐", u"諫": u"谏",
	u"諭": u"谕", u"諮": u"谘", u"諱": u"讳", u"諳": u"谙",
	u"諶": u"谌", u"諷": u"讽", u"諸": u"诸", u"諺": u"谚",
	u"諼": u"谖", u"諾": u"诺", u"謀": u"谋", u"謁": u"谒",
	u"謂": u"谓", u"謄": u"誊", u"謅": u"诌", u"謊": u"谎",
	u"謎": u"谜", u"謐": u"谧", u"謔": u"谑", u"謖": u"谡",
	u"謗": u"谤", u"謙": u"谦", u"謚": u"谥", u"講": u"讲",
	u"謝": u"谢", u"謠": u"谣", u"謨": u"谟", u"謫": u"谪",
	u"謬": u"谬", u"謳": u"讴", u"謹": u"谨", u"謼": u"呼",
	u"謾": u"谩", u"譁": u"哗", u"譆": u"嘻", u"證": u"证",
	u"譎": u"谲", u"譏": u"讥", u"譔": u"撰", u"譖": u"谮",
	u"識": u"识", u"譙": u"谯", u"譚": u"谭", u"譜": u"谱",
	u"譟": u"噪", u"譫": u"谵", u"譭": u"毁", u"譯": u"译",
	u"議": u"议", u"譴": u"谴", u"護": u"护", u"譽": u"誉",
	u"譾": u"谫", u"讀": u"读", u"變": u"变", u"讌": u"宴",
	u"讎": u"雠", u"讒": u"谗", u"讓": u"让", u"讕": u"谰",
	u"讖": u"谶", u"讚": u"赞", u"讜": u"谠", u"讞": u"谳",
	u"谿": u"溪", u"豈": u"岂", u"豎": u"竖", u"豐": u"丰",
	u"豔": u"艳", u"豖": u"亍", u"豬": u"猪", u"貍": u"狸",
	u"貓": u"猫", u"貝": u"贝", u"貞": u"贞", u"負": u"负",
	u"財": u"财", u"貢": u"贡", u"貧": u"贫", u"貨": u"货",
	u"販": u"贩", u"貪": u"贪", u"貫": u"贯", u"責": u"责",
	u"貯": u"贮", u"貰": u"贳", u"貲": u"赀", u"貳": u"贰",
	u"貴": u"贵", u"貶": u"贬", u"買": u"买", u"貸": u"贷",
	u"貺": u"贶", u"費": u"费", u"貼": u"贴", u"貽": u"贻",
	u"貿": u"贸", u"賀": u"贺", u"賁": u"贲", u"賂": u"赂",
	u"賃": u"赁", u"賄": u"贿", u"賅": u"赅", u"資": u"资",
	u"賈": u"贾", u"賊": u"贼", u"賑": u"赈", u"賒": u"赊",
	u"賓": u"宾", u"賕": u"赇", u"賙": u"周", u"賚": u"赉",
	u"賜": u"赐", u"賞": u"赏", u"賠": u"赔", u"賡": u"赓",
	u"賢": u"贤", u"賣": u"卖", u"賤": u"贱", u"賦": u"赋",
	u"賧": u"赕", u"質": u"质", u"賬": u"账", u"賭": u"赌",
	u"賴": u"赖", u"賸": u"剩", u"賺": u"赚", u"賻": u"赙",
	u"購": u"购", u"賽": u"赛", u"賾": u"赜", u"贄": u"贽",
	u"贅": u"赘", u"贈": u"赠", u"贊": u"赞", u"贍": u"赡",
	u"贏": u"赢", u"贐": u"赆", u"贓": u"赃", u"贖": u"赎",
	u"贗": u"赝", u"贛": u"赣", u"趕": u"赶", u"趙": u"赵",
	u"趨": u"趋", u"趲": u"趱", u"跡": u"迹", u"跼": u"局",
	u"踐": u"践", u"踡": u"蜷", u"踫": u"碰", u"踰": u"逾",
	u"踴": u"踊", u"蹌": u"跄", u"蹕": u"跸", u"蹟": u"迹",
	u"蹠": u"跖", u"蹣": u"蹒", u"蹤": u"踪", u"蹧": u"糟",
	u"蹺": u"跷", u"躉": u"趸", u"躊": u"踌", u"躋": u"跻",
	u"躍": u"跃", u"躑": u"踯", u"躒": u"跞", u"躓": u"踬",
	u"躕": u"蹰", u"躚": u"跹", u"躡": u"蹑", u"躥": u"蹿",
	u"躦": u"躜", u"躪": u"躏", u"軀": u"躯", u"車": u"车",
	u"軋": u"轧", u"軌": u"轨", u"軍": u"军", u"軒": u"轩",
	u"軔": u"轫", u"軛": u"轭", u"軟": u"软", u"軫": u"轸",
	u"軸": u"轴", u"軹": u"轵", u"軺": u"轺", u"軻": u"轲",
	u"軼": u"轶", u"軾": u"轼", u"較": u"较", u"輅": u"辂",
	u"輇": u"辁", u"載": u"载", u"輊": u"轾", u"輒": u"辄",
	u"輓": u"挽", u"輔": u"辅", u"輕": u"轻", u"輛": u"辆",
	u"輜": u"辎", u"輝": u"辉", u"輞": u"辋", u"輟": u"辍",
	u"輥": u"辊", u"輦": u"辇", u"輩": u"辈", u"輪": u"轮",
	u"輯": u"辑", u"輳": u"辏", u"輸": u"输", u"輻": u"辐",
	u"輾": u"辗", u"輿": u"舆", u"轂": u"毂", u"轄": u"辖",
	u"轅": u"辕", u"轆": u"辘", u"轉": u"转", u"轍": u"辙",
	u"轎": u"轿", u"轔": u"辚", u"轟": u"轰", u"轡": u"辔",
	u"轢": u"轹", u"轤": u"轳", u"辦": u"办", u"辭": u"辞",
	u"辮": u"辫", u"辯": u"辩", u"農": u"农", u"迆": u"迤",
	u"迴": u"回", u"迺": u"乃", u"逕": u"迳", u"這": u"这",
	u"連": u"连", u"週": u"周", u"進": u"进", u"遊": u"游",
	u"運": u"运", u"過": u"过", u"達": u"达", u"違": u"违",
	u"遙": u"遥", u"遜": u"逊", u"遞": u"递", u"遠": u"远",
	u"適": u"适", u"遲": u"迟", u"遷": u"迁", u"選": u"选",
	u"遺": u"遗", u"遼": u"辽", u"邁": u"迈", u"還": u"还",
	u"邇": u"迩", u"邊": u"边", u"邏": u"逻", u"邐": u"逦",
	u"郟": u"郏", u"郵": u"邮", u"鄆": u"郓", u"鄉": u"乡",
	u"鄒": u"邹", u"鄔": u"邬", u"鄖": u"郧", u"鄧": u"邓",
	u"鄭": u"郑", u"鄰": u"邻", u"鄲": u"郸", u"鄴": u"邺",
	u"鄶": u"郐", u"鄺": u"邝", u"酈": u"郦", u"酖": u"鸩",
	u"醃": u"腌", u"醆": u"盏", u"醜": u"丑", u"醞": u"酝",
	u"醫": u"医", u"醬": u"酱", u"醱": u"发", u"醼": u"宴",
	u"釀": u"酿", u"釁": u"衅", u"釃": u"酾", u"釅": u"酽",
	u"釆": u"采", u"釋": u"释", u"釐": u"厘", u"釓": u"钆",
	u"釔": u"钇", u"釕": u"钌", u"釗": u"钊", u"釘": u"钉",
	u"釙": u"钋", u"針": u"针", u"釣": u"钓", u"釤": u"钐",
	u"釦": u"扣", u"釧": u"钏", u"釩": u"钒", u"釬": u"钎",
	u"釵": u"钗", u"釷": u"钍", u"釹": u"钕", u"鈀": u"钯",
	u"鈁": u"钫", u"鈄": u"钭", u"鈉": u"钠", u"鈍": u"钝",
	u"鈐": u"钤", u"鈑": u"钣", u"鈔": u"钞", u"鈕": u"钮",
	u"鈞": u"钧", u"鈣": u"钙", u"鈥": u"钬", u"鈦": u"钛",
	u"鈧": u"钪", u"鈮": u"铌", u"鈰": u"铈", u"鈳": u"钶",
	u"鈴": u"铃", u"鈷": u"钴", u"鈸": u"钹", u"鈹": u"铍",
	u"鈺": u"钰", u"鈽": u"钸", u"鈾": u"铀", u"鈿": u"钿",
	u"鉀": u"钾", u"鉅": u"巨", u"鉆": u"钻", u"鉈": u"铊",
	u"鉉": u"铉", u"鉋": u"刨", u"鉍": u"铋", u"鉑": u"铂",
	u"鉗": u"钳", u"鉚": u"铆", u"鉛": u"铅", u"鉞": u"钺",
	u"鉤": u"钩", u"鉦": u"钲", u"鉬": u"钼", u"鉭": u"钽",
	u"鉸": u"铰", u"鉺": u"铒", u"鉻": u"铬", u"鉿": u"铪",
	u"銀": u"银", u"銃": u"铳", u"銅": u"铜", u"銑": u"铣",
	u"銓": u"铨", u"銖": u"铢", u"銘": u"铭", u"銚": u"铫",
	u"銜": u"衔", u"銠": u"铑", u"銣": u"铷", u"銥": u"铱",
	u"銦": u"铟", u"銨": u"铵", u"銩": u"铥", u"銪": u"铕",
	u"銫": u"铯", u"銬": u"铐", u"銲": u"焊", u"銳": u"锐",
	u"銷": u"销", u"銹": u"锈", u"銻": u"锑", u"銼": u"锉",
	u"鋁": u"铝", u"鋃": u"锒", u"鋅": u"锌", u"鋇": u"钡",
	u"鋌": u"铤", u"鋏": u"铗", u"鋒": u"锋", u"鋝": u"锊",
	u"鋟": u"锓", u"鋤": u"锄", u"鋦": u"锔", u"鋨": u"锇",
	u"鋪": u"铺", u"鋮": u"铖", u"鋯": u"锆", u"鋰": u"锂",
	u"鋱": u"铽", u"鋸": u"锯", u"鋻": u"鉴", u"鋼": u"钢",
	u"錁": u"锞", u"錄": u"录", u"錆": u"锖", u"錈": u"锩",
	u"錐": u"锥", u"錒": u"锕", u"錕": u"锟", u"錘": u"锤",
	u"錙": u"锱", u"錚": u"铮", u"錛": u"锛", u"錟": u"锬",
	u"錠": u"锭", u"錢": u"钱", u"錦": u"锦", u"錨": u"锚",
	u"錫": u"锡", u"錮": u"锢", u"錯": u"错", u"錳": u"锰",
	u"錶": u"表", u"錸": u"铼", u"鍆": u"钔", u"鍇": u"锴",
	u"鍊": u"炼", u"鍋": u"锅", u"鍍": u"镀", u"鍔": u"锷",
	u"鍘": u"铡", u"鍛": u"锻", u"鍤": u"锸", u"鍥": u"锲",
	u"鍬": u"锹", u"鍰": u"锾", u"鍵": u"键", u"鍶": u"锶",
	u"鍺": u"锗", u"鍼": u"针", u"鍾": u"钟", u"鎂": u"镁",
	u"鎊": u"镑", u"鎌": u"镰", u"鎔": u"熔", u"鎖": u"锁",
	u"鎗": u"枪", u"鎘": u"镉", u"鎚": u"锤", u"鎢": u"钨",
	u"鎣": u"蓥", u"鎦": u"镏", u"鎧": u"铠", u"鎩": u"铩",
	u"鎪": u"锼", u"鎬": u"镐", u"鎮": u"镇", u"鎰": u"镒",
	u"鎳": u"镍", u"鎵": u"镓", u"鏃": u"镞", u"鏇": u"镟",
	u"鏈": u"链", u"鏌": u"镆", u"鏍": u"镙", u"鏑": u"镝",
	u"鏗": u"铿", u"鏘": u"锵", u"鏜": u"镗", u"鏝": u"镘",
	u"鏞": u"镛", u"鏟": u"铲", u"鏡": u"镜", u"鏢": u"镖",
	u"鏤": u"镂", u"鏨": u"錾", u"鏵": u"铧", u"鏷": u"镤",
	u"鏹": u"镪", u"鏽": u"锈", u"鐃": u"铙", u"鐉": u"铣",
	u"鐋": u"铴", u"鐐": u"镣", u"鐒": u"铹", u"鐓": u"镦",
	u"鐔": u"镡", u"鐘": u"钟", u"鐙": u"镫", u"鐠": u"镨",
	u"鐨": u"镄", u"鐫": u"镌", u"鐮": u"镰", u"鐲": u"镯",
	u"鐳": u"镭", u"鐵": u"铁", u"鐶": u"环", u"鐸": u"铎",
	u"鐺": u"铛", u"鐿": u"镱", u"鑄": u"铸", u"鑊": u"镬",
	u"鑌": u"镔", u"鑑": u"鉴", u"鑒": u"鉴", u"鑠": u"铄",
	u"鑣": u"镳", u"鑤": u"刨", u"鑪": u"炉", u"鑭": u"镧",
	u"鑰": u"钥", u"鑲": u"镶", u"鑵": u"罐", u"鑷": u"镊",
	u"鑼": u"锣", u"鑽": u"钻", u"鑾": u"銮", u"鑿": u"凿",
	u"長": u"长", u"門": u"门", u"閂": u"闩", u"閃": u"闪",
	u"閆": u"闫", u"閉": u"闭", u"開": u"开", u"閌": u"闶",
	u"閎": u"闳", u"閏": u"闰", u"閑": u"闲", u"閒": u"闲",
	u"間": u"间", u"閔": u"闵", u"閘": u"闸", u"閡": u"阂",
	u"閣": u"阁", u"閤": u"合", u"閥": u"阀", u"閨": u"闺",
	u"閩": u"闽", u"閫": u"阃", u"閬": u"阆", u"閭": u"闾",
	u"閱": u"阅", u"閶": u"阊", u"閹": u"阉", u"閻": u"阎",
	u"閼": u"阏", u"閽": u"阍", u"閾": u"阈", u"閿": u"阌",
	u"闃": u"阒", u"闆": u"板", u"闇": u"暗", u"闈": u"闱",
	u"闊": u"阔", u"闋": u"阕", u"闌": u"阑", u"闐": u"阗",
	u"闔": u"阖", u"闕": u"阙", u"闖": u"闯", u"關": u"关",
	u"闞": u"阚", u"闡": u"阐", u"闢": u"辟", u"闥": u"闼",
	u"阨": u"厄", u"阬": u"坑", u"阯": u"址", u"陏": u"隋",
	u"陘": u"陉", u"陝": u"陕", u"陞": u"升", u"陣": u"阵",
	u"陰": u"阴", u"陳": u"陈", u"陸": u"陆", u"陽": u"阳",
	u"隄": u"堤", u"隉": u"陧", u"隊": u"队", u"階": u"阶",
	u"隕": u"陨", u"際": u"际", u"隤": u"颓", u"隨": u"随",
	u"險": u"险", u"隱": u"隐", u"隴": u"陇", u"隸": u"隶",
	u"隻": u"只", u"雋": u"隽", u"雖": u"虽", u"雙": u"双",
	u"雛": u"雏", u"雜": u"杂", u"雞": u"鸡", u"離": u"离",
	u"難": u"难", u"雲": u"云", u"電": u"电", u"霑": u"沾",
	u"霤": u"溜", u"霧": u"雾", u"霽": u"霁", u"靂": u"雳",
	u"靄": u"霭", u"靈": u"灵", u"靚": u"靓", u"靜": u"静",
	u"靦": u"腼", u"靨": u"靥", u"鞏": u"巩", u"鞦": u"秋",
	u"韁": u"缰", u"韃": u"鞑", u"韆": u"千", u"韉": u"鞯",
	u"韋": u"韦", u"韌": u"韧", u"韓": u"韩", u"韙": u"韪",
	u"韜": u"韬", u"韞": u"韫", u"韻": u"韵", u"響": u"响",
	u"頁": u"页", u"頂": u"顶", u"頃": u"顷", u"項": u"项",
	u"順": u"顺", u"頇": u"顸", u"須": u"须", u"頊": u"顼",
	u"頌": u"颂", u"頎": u"颀", u"頏": u"颃", u"預": u"预",
	u"頑": u"顽", u"頒": u"颁", u"頓": u"顿", u"頗": u"颇",
	u"領": u"领", u"頜": u"颌", u"頡": u"颉", u"頤": u"颐",
	u"頦": u"颏", u"頫": u"俯", u"頭": u"头", u"頰": u"颊",
	u"頷": u"颔", u"頸": u"颈", u"頹": u"颓", u"頻": u"频",
	u"顆": u"颗", u"題": u"题", u"額": u"额", u"顎": u"颚",
	u"顏": u"颜", u"顓": u"颛", u"願": u"愿", u"顙": u"颡",
	u"顛": u"颠", u"類": u"类", u"顢": u"颟", u"顥": u"颢",
	u"顧": u"顾", u"顫": u"颤", u"顯": u"显", u"顰": u"颦",
	u"顱": u"颅", u"顳": u"颞", u"顴": u"颧", u"風": u"风",
	u"颮": u"飑", u"颯": u"飒", u"颱": u"台", u"颳": u"刮",
	u"颶": u"飓", u"颺": u"扬", u"颼": u"飕", u"飄": u"飘",
	u"飆": u"飙", u"飛": u"飞", u"飢": u"饥", u"飩": u"饨",
	u"飪": u"饪", u"飫": u"饫", u"飭": u"饬", u"飯": u"饭",
	u"飲": u"饮", u"飴": u"饴", u"飼": u"饲", u"飽": u"饱",
	u"飾": u"饰", u"餃": u"饺", u"餅": u"饼", u"餈": u"糍",
	u"餉": u"饷", u"養": u"养", u"餌": u"饵", u"餑": u"饽",
	u"餒": u"馁", u"餓": u"饿", u"餔": u"哺", u"餘": u"余",
	u"餚": u"肴", u"餛": u"馄", u"餞": u"饯", u"餡": u"馅",
	u"館": u"馆", u"餬": u"糊", u"餱": u"糇", u"餳": u"饧",
	u"餵": u"喂", u"餼": u"饩", u"餽": u"馈", u"餾": u"馏",
	u"餿": u"馊", u"饃": u"馍", u"饅": u"馒", u"饈": u"馐",
	u"饉": u"馑", u"饋": u"馈", u"饌": u"馔", u"饑": u"饥",
	u"饒": u"饶", u"饗": u"飨", u"饜": u"餍", u"饞": u"馋",
	u"饟": u"饷", u"馬": u"马", u"馭": u"驭", u"馮": u"冯",
	u"馱": u"驮", u"馳": u"驰", u"馴": u"驯", u"駁": u"驳",
	u"駐": u"驻", u"駑": u"驽", u"駒": u"驹", u"駔": u"驵",
	u"駕": u"驾", u"駘": u"骀", u"駙": u"驸", u"駛": u"驶",
	u"駝": u"驼", u"駟": u"驷", u"駢": u"骈", u"駭": u"骇",
	u"駮": u"驳", u"駱": u"骆", u"駿": u"骏", u"騁": u"骋",
	u"騃": u"呆", u"騅": u"骓", u"騍": u"骒", u"騎": u"骑",
	u"騏": u"骐", u"騖": u"骛", u"騙": u"骗", u"騣": u"鬃",
	u"騫": u"骞", u"騭": u"骘", u"騮": u"骝", u"騰": u"腾",
	u"騶": u"驺", u"騷": u"骚", u"騸": u"骟", u"騾": u"骡",
	u"驀": u"蓦", u"驁": u"骜", u"驂": u"骖", u"驃": u"骠",
	u"驄": u"骢", u"驅": u"驱", u"驊": u"骅", u"驍": u"骁",
	u"驏": u"骣", u"驕": u"骄", u"驗": u"验", u"驚": u"惊",
	u"驛": u"驿", u"驟": u"骤", u"驢": u"驴", u"驤": u"骧",
	u"驥": u"骥", u"驪": u"骊", u"骯": u"肮", u"髏": u"髅",
	u"髒": u"脏", u"體": u"体", u"髕": u"髌", u"髖": u"髋",
	u"髣": u"仿", u"髮": u"发", u"鬆": u"松", u"鬍": u"胡",
	u"鬚": u"须", u"鬢": u"鬓", u"鬥": u"斗", u"鬧": u"闹",
	u"鬨": u"哄", u"鬩": u"阋", u"鬮": u"阄", u"鬱": u"郁",
	u"魎": u"魉", u"魘": u"魇", u"魚": u"鱼", u"魨": u"豚",
	u"魯": u"鲁", u"魴": u"鲂", u"魷": u"鱿", u"鮐": u"鲐",
	u"鮑": u"鲍", u"鮒": u"鲋", u"鮚": u"鲒", u"鮞": u"鲕",
	u"鮪": u"鲔", u"鮫": u"鲛", u"鮭": u"鲑", u"鮮": u"鲜",
	u"鯀": u"鲧", u"鯁": u"鲠", u"鯇": u"鲩", u"鯉": u"鲤",
	u"鯊": u"鲨", u"鯔": u"鲻", u"鯖": u"鲭", u"鯗": u"鲞",
	u"鯛": u"鲷", u"鯡": u"鲱", u"鯢": u"鲵", u"鯤": u"鲲",
	u"鯧": u"鲳", u"鯨": u"鲸", u"鯪": u"鲮", u"鯫": u"鲰",
	u"鯰": u"鲇", u"鯽": u"鲫", u"鰈": u"鲽", u"鰉": u"鳇",
	u"鰍": u"鳅", u"鰒": u"鳆", u"鰓": u"鳃", u"鰣": u"鲥",
	u"鰥": u"鳏", u"鰨": u"鳎", u"鰩": u"鳐", u"鰭": u"鳍",
	u"鰱": u"鲢", u"鰲": u"鳌", u"鰳": u"鳓", u"鰷": u"鲦",
	u"鰹": u"鲣", u"鰻": u"鳗", u"鰾": u"鳔", u"鱈": u"鳕",
	u"鱉": u"鳖", u"鱒": u"鳟", u"鱔": u"鳝", u"鱖": u"鳜",
	u"鱗": u"鳞", u"鱘": u"鲟", u"鱟": u"鲎", u"鱧": u"鳢",
	u"鱭": u"鲚", u"鱷": u"鳄", u"鱸": u"鲈", u"鱺": u"鲡",
	u"鳥": u"鸟", u"鳧": u"凫", u"鳩": u"鸠", u"鳳": u"凤",
	u"鳴": u"鸣", u"鳶": u"鸢", u"鴆": u"鸩", u"鴇": u"鸨",
	u"鴈": u"雁", u"鴉": u"鸦", u"鴕": u"鸵", u"鴛": u"鸳",
	u"鴝": u"鸲", u"鴟": u"鸱", u"鴣": u"鸪", u"鴦": u"鸯",
	u"鴨": u"鸭", u"鴯": u"鸸", u"鴰": u"鸹", u"鴻": u"鸿",
	u"鴿": u"鸽", u"鵂": u"鸺", u"鵑": u"鹃", u"鵒": u"鹆",
	u"鵓": u"鹁", u"鵜": u"鹈", u"鵝": u"鹅", u"鵠": u"鹄",
	u"鵡": u"鹉", u"鵪": u"鹌", u"鵬": u"鹏", u"鵯": u"鹎",
	u"鵰": u"雕", u"鵲": u"鹊", u"鶇": u"鸫", u"鶉": u"鹑",
	u"鶘": u"鹕", u"鶚": u"鹗", u"鶩": u"鹜", u"鶯": u"莺",
	u"鶱": u"骞", u"鶴": u"鹤", u"鶻": u"鹘", u"鶼": u"鹣",
	u"鶿": u"鹚", u"鷂": u"鹞", u"鷓": u"鹧", u"鷗": u"鸥",
	u"鷙": u"鸷", u"鷚": u"鹨", u"鷥": u"鸶", u"鷦": u"鹪",
	u"鷯": u"鹩", u"鷰": u"燕", u"鷲": u"鹫", u"鷳": u"鹇",
	u"鷴": u"鹇", u"鷸": u"鹬", u"鷹": u"鹰", u"鷺": u"鹭",
	u"鸕": u"鸬", u"鸚": u"鹦", u"鸛": u"鹳", u"鸝": u"鹂",
	u"鸞": u"鸾", u"鹵": u"卤", u"鹹": u"咸", u"鹺": u"鹾",
	u"鹼": u"硷", u"鹽": u"盐", u"麗": u"丽", u"麥": u"麦",
	u"麩": u"麸", u"麵": u"面", u"麼": u"么", u"黃": u"黄",
	u"黌": u"黉", u"點": u"点", u"黨": u"党", u"黲": u"黪",
	u"黴": u"霉", u"黷": u"黩", u"黽": u"黾", u"黿": u"鼋",
	u"鼇": u"鳌", u"鼉": u"鼍", u"鼕": u"冬", u"鼴": u"鼹",
	u"齊": u"齐", u"齋": u"斋", u"齎": u"赍", u"齏": u"齑",
	u"齒": u"齿", u"齔": u"龀", u"齙": u"龅", u"齜": u"龇",
	u"齟": u"龃", u"齠": u"龆", u"齡": u"龄", u"齣": u"出",
	u"齦": u"龈", u"齧": u"啮", u"齪": u"龊", u"齬": u"龉",
	u"齲": u"龋", u"齶": u"腭", u"齷": u"龌", u"龍": u"龙",
	u"龐": u"庞", u"龔": u"龚", u"龕": u"龛", u"龜": u"龟",
	u"龢": u"和", u"兀": u"兀", u"︰": u"∶", u"︱": u"｜",
	u"︳": u"｜", u"︿": u"∧", u"﹀": u"∨", u"﹐": u"，",
	u"﹑": u"、", u"﹒": u"．", u"﹔": u"；", u"﹕": u"：",
	u"﹖": u"？", u"﹗": u"！", u"﹙": u"（", u"﹚": u"）",
	u"﹛": u"｛", u"﹜": u"｝", u"﹝": u"［", u"﹞": u"］",
	u"﹟": u"＃", u"﹠": u"＆", u"﹡": u"＊", u"﹢": u"＋",
	u"﹣": u"－", u"﹤": u"＜", u"﹥": u"＞", u"﹦": u"＝",
	u"﹩": u"＄", u"﹪": u"％", u"﹫": u"＠", 
}

def sc_to_tc (s):
	conv = lambda x: SC_TO_TC_DICT.get (x, x)
	return "".join (map (conv, s))

def tc_to_sc (s):
	conv = lambda x: TC_TO_SC_DICT.get (x, x)
	return "".join (map (conv, s))

def is_tcstring (s):
	for c in s:
		if c in TC_TO_SC_DICT:
			return True
	return False

def is_scstring (s):
	for c in s:
		if c in TC_TO_SC_DICT:
			return False
	return True

if __name__ == "__main__":
	print sc_to_tc (u"高档房开发商的冬天就要来了。")
