/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_LAYER_H__
#define __SG_LAYER_H__

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_dataset.h"
#include "sg_worksheet.h"

#define SG_LAYER(obj)        GTK_CHECK_CAST (obj, sg_layer_get_type (), SGlayer)
#define GTK_TYPE_SG_LAYER   (sg_layer_get_type ())

#define SG_LAYER_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_layer_get_type(), SGlayerClass)
#define GTK_IS_SG_LAYER(obj)     GTK_CHECK_TYPE (obj, sg_layer_get_type ())


typedef struct _SGlayer SGlayer;
typedef struct _SGlayerClass SGlayerClass;
typedef struct _SGtick SGtick;

typedef enum{
	SG_LAYER_2D,
	SG_LAYER_3D,
	SG_LAYER_POLAR,
} SGlayerType;

struct _SGtick 
{
  gdouble value;
  gchar *label;
};

struct _SGlayer 
{
  GtkObject object;

  gpointer parent;

  gint rescale;

  SGlayerType type;

  GtkWidget *button;

  GList *datasets;

  GtkWidget *real_plot;

  GtkPlotData *active_data;

  SGworksheet *left_labels_worksheet;
  gint left_values_column, left_labels_column;
  SGworksheet *right_labels_worksheet;
  gint right_values_column, right_labels_column;
  SGworksheet *top_labels_worksheet;
  gint top_values_column, top_labels_column;
  SGworksheet *bottom_labels_worksheet;
  gint bottom_values_column, bottom_labels_column;

  /* Automatic symbols */
  gint symbol;
  gint symbol_style;
  gint line_style;
  gint connector;
  GdkColor symbol_color;
  GdkColor line_color;
};

struct _SGlayerClass
{
   GtkObjectClass parent_class;
};

GtkType		sg_layer_get_type		(void);
SGlayer 	*sg_layer_new			(SGlayerType layer_type,
                                                 gdouble width,
						 gdouble height);
SGlayer 	*sg_layer_clone			(SGlayer *layer);
void		sg_layer_set_tick_labels	(SGlayer *layer,
						 gint axis_pos,
						 SGworksheet *worksheet,
						 gint values_column,
						 gint labels_column);
void		sg_layer_add_dataset		(SGlayer *layer,
						 SGdataset *dataset);
void		sg_layer_add_dataset_default	(SGlayer *layer,
						 SGdataset *dataset);
void		sg_layer_remove_dataset		(SGlayer *layer,
						 SGdataset *dataset);
void		sg_layer_clear			(SGlayer *layer);
void		sg_layer_button_set_label	(SGlayer *layer,
						 gint label);
void		sg_layer_remove_markers		(SGlayer *layer);
void		sg_layer_show_markers		(SGlayer *layer, gboolean show);
void		sg_layer_refresh_datasets	(SGlayer *layer);
gint		sg_layer_min_max		(SGlayer *layer, 
						 gdouble *xmin, gdouble *xmax, 
						 gdouble *ymin, gdouble *ymax);
void		sg_layer_autoscale		(SGlayer *layer,
						 gint left_offset,
						 gint right_offset, 
						 gint top_offset,
						 gint bottom_offset);
#endif /* __SG_LAYER_H__ */

