/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_dialogs.h"

gchar *file_path;
gchar *line_styles[] = {
					"None",
					"Solid",
					"Dotted",
					"Dashed",
					"Dot-dash",
					"Dot-dot-dash",
					"Dot-dash-dash",
					NULL
};
gchar *border_styles[] = {
					"None",
					"Line",
					"Shadow",
					NULL
};

gchar *connectors[] = {
					"None",
					"Straight",
					"Spline",
					"H-V step",
					"V-H step",
					"Middle step",
					NULL
};

gchar *symbol_styles[] = {
					"Empty",
					"Filled",
					"Opaque",
					NULL
};

static GList *dialogs;

void
sg_dialog_new(GtkWidget *widget)
{
  dialogs = g_list_append(dialogs, widget);

  gtk_widget_realize(widget);
  gdk_window_set_icon(widget->window, NULL, icon_pixmap, icon_mask);       
}

void
sg_dialog_kill(GtkWidget *widget)
{
  GList *list;

  if(!widget) return;

  list = g_list_find(dialogs, widget);
  if(list){
      dialogs = g_list_remove_link(dialogs, list);
      g_list_free_1(list);
      gtk_grab_remove(widget);
  }
}

void
sg_dialogs_init()
{
  dialogs = NULL;
}

void
sg_dialogs_destroy(GtkWidget *widget)
{/* the widget is needed to use this func as a callback */

  GList *list;
  list = dialogs;

  while(list){
    if(list->data && GTK_IS_WIDGET(list->data))
              gtk_widget_destroy(GTK_WIDGET(list->data));
    dialogs = g_list_remove_link(dialogs, list);
    g_list_free_1(list);
    list = dialogs;
  }

  sg_dialogs_init();
}
