# encoding: utf-8

$: << File.expand_path('../lib', __FILE__)
require 'schleuder/version'

Gem::Specification.new do |s|
  s.name         = "schleuder"
  s.version      = Schleuder::VERSION
  s.authors      = %w(paz ng)
  s.email        = "schleuder2@nadir.org"
  s.homepage     = "http://schleuder2.nadir.org"
  s.summary      = "Schleuder is a group's gateway: a gpg-enabled mailinglist with remailing-capabilities."
  s.description  = "Schleuder is a group's gateway: subscribers can communicate encrypted (and pseudonymously) among themselves, receive emails from non-subscribers and send emails to non-subscribers via the list.\n\nSchleuder takes care of all decryption and encryption, stripping of headers, formatting conversions, etc. Schleuder can also send out its own public key upon request and process administrative commands by email."
  s.files        = `git ls-files lib plugins ext contrib`.split("\n") + %w(README LICENSE man/schleuder.8 man/schleuder-newlist.8)
  s.executables =  %w(schleuder schleuder-newlist schleuder-fix-gem-dependencies schleuder-init-setup schleuder-migrate-v2.1-to-v2.2)
  s.platform     = Gem::Platform::RUBY
  s.require_path = 'lib'
  s.rubyforge_project = '[none]'
  s.signing_key = '../schleuder-signingkey-gem-private_key.pem'
  s.cert_chain  = ['gem-public_cert.pem']
  s.add_dependency('gpgme', '= 1.0.8')
  s.add_dependency('highline', '>= 1.6.1')
  s.add_dependency('log4r', '>= 1.1.9')
  s.add_dependency('ruby-filemagic', '>= 0.4.2')
  s.post_install_message = "

    Note: There's still one dependency missing, which we can't install in
    this run of rubygems.  Please execute schleuder-fix-gem-dependencies to
    complete the installation!

"
end
