module Schleuder
  class MetaEmailOutputter < EmailOutputter
    # TODO: refactor (merge?) with EmailOutputter
    def send_mail
      if @send_mail_lock
        self.level = Log4r::OFF # it's possible that the loglevel haven't yet been changed
        Schleuder.log.warn 'This is a loop in sending a mail in the MetaEmailOutputter, breaking!'
        return false
      end
      @send_mail_lock = true
      Schleuder.log.info { 'notifying superadmin' }
      begin
        mail = makeemail
        mail.to = Schleuder.config.superadminaddr
        r = Member.new('email' => Schleuder.config.superadminaddr)
        m = mail.individualize(r)
        if ! Processor.send(m, r, true, Schleuder.config.superadminaddr).first
          m.body = @altmsg
          m.content_type = 'text/plain'
          Processor.send(m, r, false, Schleuder.config.superadminaddr)
        end
      rescue => e
        Schleuder.log.warn "An error occurred while reporting an error: #{e.message}\n#{e.backtrace[0..3].join("\n")}"
        Schleuder.log.warn "Sending emergency notice to superadmin"
        mail = "From: root@localhost
To: #{Schleuder.config.superadminaddr}
Date: #{Time.now.strftime('%a, %d %b %Y %H:%M:%S %z')}
Subject: Error

Serious errors happened working for list #{Schleuder.listname}. 
Please check the logs!
"
        Mailer.send mail, Schleuder.config.superadminaddr, 'root@localhost', true
      end
      Schleuder.log.info { 'Notifying done' }
    rescue => e
      # switch off logging per email, else we create loops here!
      self.level = Log4r::OFF
      if e.message.frozen?
        Schleuder.log.warn "A problematic error happened. I'll better dump the original message to preserve it:\n\n#{Schleuder.origmsg}"
      else
        e.message << "\nThis is very problematic, I'll better dump the original message to preserve it:\n\n#{Schleuder.origmsg}"
      end
      Schleuder.log.fatal { e }
    ensure
      @send_mail_lock = false
      @buff.clear
    end
  end
end
