      SUBROUTINE PBDLACP1( ICONTXT, UPLO, FORM, DIAG, M, N, NZ, A, LDA,
     $                     B, LDB, MINT, NINT, MEN, NEN )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     .. Scalar Arguments ..
      CHARACTER*1        UPLO, FORM, DIAG
      INTEGER            ICONTXT, LDA, LDB, M, MEN, MINT, N, NEN, NINT,
     $                   NZ
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION   A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  PBDLACP1 copies part of a two-dimensional upper (or lower) triangular
*  matrix A to another matrix B with forced zeros in the other part.
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            NOUNIT
      INTEGER            I, J, JJ, JP, KZ, MN, MX
      DOUBLE PRECISION   DUMMY
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           DCOPY, PBDMATADD, PBDVECADD
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*     ..
*     .. Executable Statements ..
*
      NOUNIT = LSAME( DIAG, 'N' )
      JP = 0
      MN = M
*
      IF( LSAME( UPLO, 'U' ) ) THEN
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is upper triangular
*
            DO 10 J = 1, MIN( N-NZ, NEN-JP )
               JJ = JP + J
               MX = MN + J
               IF( NOUNIT ) THEN
                  CALL DCOPY( MX, A( 1, JJ ), 1, B( 1, JJ ), 1 )
               ELSE
                  CALL DCOPY( MX-1, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                  B( MX, JJ ) = ONE
               END IF
               CALL PBDVECADD( ICONTXT, 'G', MEN-MX, ZERO, DUMMY, 1,
     $                         ZERO, B( MX+1, JJ ), 1 )
   10       CONTINUE
            MN = MN + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 30 I = 2, ICEIL( NEN+NZ, NINT )
               DO 20 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  IF( NOUNIT ) THEN
                     CALL DCOPY( MX, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                  ELSE
                     CALL DCOPY( MX-1, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                     B( MX, JJ ) = ONE
                  END IF
                  CALL PBDVECADD( ICONTXT, 'G', MEN-MX, ZERO, DUMMY, 1,
     $                            ZERO, B( MX+1, JJ ), 1 )
   20          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
   30       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            KZ = NZ
            DO 40 I = 1, ICEIL( NEN+NZ, NINT )
               MX = MIN( N-KZ, NEN-JP )
               CALL PBDMATADD( ICONTXT, 'V', MN, MX, ONE, A( 1, JP+1 ),
     $                         LDA, ZERO, B( 1, JP+1 ), LDB )
               CALL PBDMATADD( ICONTXT, 'G', MEN-MN, MX, ZERO, DUMMY, 1,
     $                         ZERO, B( MN+1, JP+1 ), LDB )
               MN = MN + MINT
               JP = JP + NINT - KZ
               KZ = 0
   40       CONTINUE
         END IF
*
      ELSE
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is lower triangular
*
            MN = M - 1
            DO 50 J = 1, MIN( N-NZ, NEN-JP )
               JJ = JP + J
               MX = MN + J
               CALL PBDVECADD( ICONTXT, 'G', MX, ZERO, DUMMY, 1, ZERO,
     $                         B( 1, JJ ), 1 )
               IF( NOUNIT ) THEN
                  CALL DCOPY( MEN-MX, A( MX+1, JJ ), 1, B( MX+1, JJ ),
     $                        1 )
               ELSE
                  B( MX+1, JJ ) = ONE
                  CALL DCOPY( MEN-MX-1, A( MX+2, JJ ),1, B( MX+2, JJ ),
     $                        1 )
               END IF
   50       CONTINUE
            MN = MN + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 70 I = 2, ICEIL( NEN+NZ, NINT )
               DO 60 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  CALL PBDVECADD( ICONTXT, 'G', MX, ZERO, DUMMY, 1,
     $                            ZERO, B( 1, JJ ), 1 )
                  IF( NOUNIT ) THEN
                     CALL DCOPY( MEN-MX, A( MX+1, JJ ), 1,
     $                           B( MX+1, JJ ), 1 )
                  ELSE
                     B( MX+1, JJ ) = ONE
                     CALL DCOPY( MEN-MX-1, A( MX+2, JJ ), 1,
     $                           B( MX+2, JJ ), 1 )
                  END IF
   60          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
   70       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            KZ = NZ
            DO 80 I = 1, ICEIL( NEN+NZ, NINT )
               MX = MIN( N-KZ, NEN-JP )
               CALL PBDMATADD( ICONTXT, 'G', MN, MX, ZERO, DUMMY, 1,
     $                         ZERO, B( 1, JP+1 ), LDB )
               CALL PBDMATADD( ICONTXT, 'V', MEN-MN, MX, ONE,
     $                         A( MN+1, JP+1 ), LDA, ZERO,
     $                         B( MN+1, JP+1 ), LDB )
               MN = MN + MINT
               JP = JP + NINT - KZ
               KZ = 0
   80       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of PBDLACP1
*
      END
