/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp;

import com.sun.midp.CommandProcessor;
import com.sun.midp.CommandState;
import com.sun.midp.dev.DevMIDletSuiteImpl;
import com.sun.midp.dev.Manager;
import com.sun.midp.midlet.MIDletInfo;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.rms.RecordStoreFile;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.SecurityDomain;
import java.io.IOException;

public class Main {
    public static void main(String[] args) {
        CommandState state = new CommandState();
        try {
            Main.initializeInternalSecurity();
            Main.restoreCommandState(state);
            switch (state.nextCommand) {
                case 8: {
                    Main.runLocalClass(state);
                    state.nextCommand = 1;
                    break;
                }
                case 2: {
                    Main.manage(state);
                    break;
                }
                case 7: 
                case 9: {
                    Main.list(state);
                    state.nextCommand = 1;
                    break;
                }
                default: {
                    CommandProcessor.perform(state);
                    if (state.status == -2) {
                        System.out.println("The MIDlet suite was not found.");
                    }
                    if (state.initialCommand == 3 && state.status == 0) {
                        System.out.println("Storage name: " + state.suiteStorageName);
                    }
                    break;
                }
            }
        }
        catch (InvalidJadException ije) {
            System.out.println("** Error installing suite (" + ije.getReason() + "): " + Main.messageForInvalidJadException(ije));
        }
        catch (IOException ioe) {
            System.out.println("** Error installing suite: " + ioe.getMessage());
        }
        catch (ClassNotFoundException ex) {
            System.out.println("MIDlet class(s) not found: " + ex.getMessage());
        }
        catch (InstantiationException ex) {
            System.out.println("MIDlet instance(s) could not be created: " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            System.out.println("MIDlet class(s) could not be accessed: " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Throwable t) {
            System.out.println("Exception caught in main:");
            t.printStackTrace();
        }
        Main.saveCommandState(state);
        Main.exitInternal(2001);
    }

    private static void initializeInternalSecurity() {
        SecurityDomain internalSecurityDomain = new SecurityDomain(null, null);
        Installer.initSecurityDomain(internalSecurityDomain);
        Manager.initSecurityDomain(internalSecurityDomain);
        RecordStoreFile.initSecurityDomain(internalSecurityDomain);
        try {
            ImplicitlyTrustedClass trustedClass = (ImplicitlyTrustedClass)Class.forName("com.sun.midp.io.j2me.https.Protocol").newInstance();
            trustedClass.initSecurityDomain(internalSecurityDomain);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    private static void manage(CommandState state) {
        Installer installer = Installer.getInstaller();
        Manager.initialize(state.logoDisplayed);
        state.logoDisplayed = true;
        try {
            DevMIDletSuiteImpl midletSuite = new DevMIDletSuiteImpl(null, "com.sun.midp.dev.Manager", "manager_storage_");
            midletSuite.schedule();
            String nextMidletSuiteToRun = installer.getNextMIDletSuiteToRun();
            if (nextMidletSuiteToRun != null) {
                state.nextCommand = 5;
                state.suiteStorageName = nextMidletSuiteToRun;
                state.midletName = installer.getNextMIDletToRun();
            }
            state.status = 0;
            return;
        }
        catch (Throwable e) {
            state.status = -1;
            e.printStackTrace();
            return;
        }
    }

    private static void list(CommandState state) {
        Installer installer = Installer.getInstaller();
        String[] appList = installer.list();
        if (appList == null || appList.length == 0) {
            System.out.println("** No MIDlet Suites installed on phone");
        } else {
            int i = 0;
            while (i < appList.length) {
                MIDletSuite midletSuite = installer.getMIDletSuite(appList[i]);
                if (midletSuite == null) {
                    System.out.println(i + 1 + ": suite corrupted");
                } else if (state.nextCommand == 9) {
                    System.out.println(appList[i]);
                } else {
                    String temp;
                    System.out.println("[" + (i + 1) + "]");
                    System.out.println("  Name: " + midletSuite.getProperty("MIDlet-Name"));
                    System.out.println("  Vendor: " + midletSuite.getProperty("MIDlet-Vendor"));
                    System.out.println("  Version: " + midletSuite.getProperty("MIDlet-Version"));
                    System.out.println("  Storage name: " + appList[i]);
                    System.out.println("  Size: " + (midletSuite.getStorageUsed() + 1023) / 1024 + "K");
                    System.out.println("  Installed From: " + midletSuite.getJadUrl());
                    System.out.println("  MIDlets:");
                    int j = 1;
                    while ((temp = midletSuite.getProperty("MIDlet-" + j)) != null) {
                        MIDletInfo midletInfo = new MIDletInfo(temp);
                        System.out.println("    " + midletInfo.name);
                        ++j;
                    }
                }
                ++i;
            }
        }
        state.status = 0;
    }

    private static void runLocalClass(CommandState state) {
        try {
            DevMIDletSuiteImpl midletSuite = new DevMIDletSuiteImpl(state.descriptorName, state.midletClassName);
            do {
                midletSuite.schedule();
            } while (state.midletClassName == null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static String messageForInvalidJadException(InvalidJadException ije) {
        switch (ije.getReason()) {
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 41: 
            case 42: {
                return "A required attribute is missing";
            }
            case 25: 
            case 26: 
            case 27: {
                return "A required attribute in the JAR manifest do not match the one in the JAD";
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 23: 
            case 24: {
                return "Error authenticating the application suite";
            }
            case 31: {
                return "The Jar downloaded was not the size in the JAD";
            }
            case 17: {
                return "The application is an older version of one that is already installed";
            }
            case 32: {
                return "The application is an newer version of one that is already installed";
            }
            case 1: {
                return "JAD server not found";
            }
            case 2: {
                return "JAD not found";
            }
            case 19: {
                return "JAR server not found";
            }
            case 20: {
                return "JAR not found";
            }
            case 36: {
                return "JAR is corrupt";
            }
            case 38: {
                if (ije.getExtraData() != null) {
                    return "JAR did not have the correct media type, it had " + ije.getExtraData();
                }
                return "The server did not have a resource with an acceptable media type for the JAR URL. (code 406)";
            }
            case 37: {
                if (ije.getExtraData() != null) {
                    return "JAD did not have the correct media type, it had " + ije.getExtraData();
                }
                return "The server did not have a resource with an acceptable media type for the JAD URL. (code 406)";
            }
            case 28: 
            case 29: {
                return "A key or value is not in the proper format";
            }
            case 30: {
                return "There is insuffient storage to install this suite";
            }
            case 33: {
                return "Authentication required or failed";
            }
            case 34: {
                return "The JAD to be installed is for an existing suite, but not from the same domain as the existing one.";
            }
            case 35: {
                return "Cannot authenticate with the server, unsupported scheme";
            }
            case 40: {
                return "Either the configuration or profile is not supported.";
            }
        }
        return ije.getMessage();
    }

    private static native void saveCommandState(CommandState var0);

    private static native void restoreCommandState(CommandState var0);

    private static native void exitInternal(int var0);

    private Main() {
    }
}

